/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.gax.util.TimeConversionUtils;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.v2.StreamContinuationToken;
import com.google.bigtable.v2.TimestampRange;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamMutation;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecordAdapter;
import com.google.cloud.bigtable.data.v2.models.CloseStream;
import com.google.cloud.bigtable.data.v2.models.DefaultChangeStreamRecordAdapter;
import com.google.cloud.bigtable.data.v2.models.Heartbeat;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DefaultChangeStreamRecordAdapterTest {
    private final DefaultChangeStreamRecordAdapter adapter = new DefaultChangeStreamRecordAdapter();
    private ChangeStreamRecordAdapter.ChangeStreamRecordBuilder<ChangeStreamRecord> changeStreamRecordBuilder;
    private static final Instant FAKE_COMMIT_TIMESTAMP = Instant.ofEpochSecond(0L, 1000L);
    private static final Instant FAKE_LOW_WATERMARK = Instant.ofEpochSecond(0L, 2000L);
    private static final org.threeten.bp.Instant FAKE_LOW_WATERMARK_THREETEN = TimeConversionUtils.toThreetenInstant((Instant)FAKE_LOW_WATERMARK);
    @Rule
    public ExpectedException expect = ExpectedException.none();

    @Before
    public void setUp() {
        this.changeStreamRecordBuilder = this.adapter.createChangeStreamRecordBuilder();
    }

    @Test
    public void isHeartbeatTest() {
        Heartbeat heartbeatRecord = Heartbeat.fromProto((ReadChangeStreamResponse.Heartbeat)ReadChangeStreamResponse.Heartbeat.getDefaultInstance());
        CloseStream closeStreamRecord = CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)ReadChangeStreamResponse.CloseStream.getDefaultInstance());
        ChangeStreamMutation changeStreamMutationRecord = ChangeStreamMutation.createGcMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).setToken("token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        Assert.assertTrue((boolean)this.adapter.isHeartbeat((ChangeStreamRecord)heartbeatRecord));
        Assert.assertFalse((boolean)this.adapter.isHeartbeat((ChangeStreamRecord)closeStreamRecord));
        Assert.assertFalse((boolean)this.adapter.isHeartbeat((ChangeStreamRecord)changeStreamMutationRecord));
    }

    @Test
    public void getTokenFromHeartbeatTest() {
        Heartbeat heartbeatRecord = Heartbeat.fromProto((ReadChangeStreamResponse.Heartbeat)ReadChangeStreamResponse.Heartbeat.newBuilder().setEstimatedLowWatermark(Timestamp.newBuilder().setSeconds(FAKE_LOW_WATERMARK_THREETEN.getEpochSecond()).setNanos(FAKE_LOW_WATERMARK_THREETEN.getNano())).setContinuationToken(StreamContinuationToken.newBuilder().setToken("heartbeat-token").build()).build());
        Assert.assertEquals((Object)this.adapter.getTokenFromHeartbeat((ChangeStreamRecord)heartbeatRecord), (Object)"heartbeat-token");
    }

    @Test(expected=IllegalArgumentException.class)
    public void getTokenFromHeartbeatInvalidTypeTest() {
        CloseStream closeStreamRecord = CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)ReadChangeStreamResponse.CloseStream.getDefaultInstance());
        this.adapter.getTokenFromHeartbeat((ChangeStreamRecord)closeStreamRecord);
        this.expect.expectMessage("record is not a Heartbeat.");
    }

    @Test
    public void isChangeStreamMutationTest() {
        Heartbeat heartbeatRecord = Heartbeat.fromProto((ReadChangeStreamResponse.Heartbeat)ReadChangeStreamResponse.Heartbeat.getDefaultInstance());
        CloseStream closeStreamRecord = CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)ReadChangeStreamResponse.CloseStream.getDefaultInstance());
        ChangeStreamMutation changeStreamMutationRecord = ChangeStreamMutation.createGcMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).setToken("token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        Assert.assertFalse((boolean)this.adapter.isChangeStreamMutation((ChangeStreamRecord)heartbeatRecord));
        Assert.assertFalse((boolean)this.adapter.isChangeStreamMutation((ChangeStreamRecord)closeStreamRecord));
        Assert.assertTrue((boolean)this.adapter.isChangeStreamMutation((ChangeStreamRecord)changeStreamMutationRecord));
    }

    @Test
    public void getTokenFromChangeStreamMutationTest() {
        ChangeStreamMutation changeStreamMutationRecord = ChangeStreamMutation.createGcMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).setToken("change-stream-mutation-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        Assert.assertEquals((Object)this.adapter.getTokenFromChangeStreamMutation((ChangeStreamRecord)changeStreamMutationRecord), (Object)"change-stream-mutation-token");
    }

    @Test(expected=IllegalArgumentException.class)
    public void getTokenFromChangeStreamMutationInvalidTypeTest() {
        CloseStream closeStreamRecord = CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)ReadChangeStreamResponse.CloseStream.getDefaultInstance());
        this.adapter.getTokenFromChangeStreamMutation((ChangeStreamRecord)closeStreamRecord);
        this.expect.expectMessage("record is not a ChangeStreamMutation.");
    }

    @Test
    public void heartbeatTest() {
        ReadChangeStreamResponse.Heartbeat expectedHeartbeat = ReadChangeStreamResponse.Heartbeat.newBuilder().setEstimatedLowWatermark(Timestamp.newBuilder().setSeconds(FAKE_LOW_WATERMARK_THREETEN.getEpochSecond()).setNanos(FAKE_LOW_WATERMARK_THREETEN.getNano()).build()).setContinuationToken(StreamContinuationToken.newBuilder().setToken("random-token").build()).build();
        Truth.assertThat((Object)this.changeStreamRecordBuilder.onHeartbeat(expectedHeartbeat)).isEqualTo((Object)Heartbeat.fromProto((ReadChangeStreamResponse.Heartbeat)expectedHeartbeat));
        Truth.assertThat((Object)this.changeStreamRecordBuilder.onHeartbeat(expectedHeartbeat)).isEqualTo((Object)Heartbeat.fromProto((ReadChangeStreamResponse.Heartbeat)expectedHeartbeat));
    }

    @Test
    public void closeStreamTest() {
        ReadChangeStreamResponse.CloseStream expectedCloseStream = ReadChangeStreamResponse.CloseStream.newBuilder().setStatus(Status.newBuilder().setCode(0).build()).build();
        Truth.assertThat((Object)this.changeStreamRecordBuilder.onCloseStream(expectedCloseStream)).isEqualTo((Object)CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)expectedCloseStream));
        Truth.assertThat((Object)this.changeStreamRecordBuilder.onCloseStream(expectedCloseStream)).isEqualTo((Object)CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)expectedCloseStream));
    }

    @Test(expected=IllegalStateException.class)
    public void createHeartbeatWithExistingMutationShouldFailTest() {
        this.changeStreamRecordBuilder.startGcMutation(ByteString.copyFromUtf8((String)"key"), FAKE_COMMIT_TIMESTAMP, 0);
        this.changeStreamRecordBuilder.onHeartbeat(ReadChangeStreamResponse.Heartbeat.getDefaultInstance());
    }

    @Test(expected=IllegalStateException.class)
    public void createCloseStreamWithExistingMutationShouldFailTest() {
        this.changeStreamRecordBuilder.startGcMutation(ByteString.copyFromUtf8((String)"key"), FAKE_COMMIT_TIMESTAMP, 0);
        this.changeStreamRecordBuilder.onCloseStream(ReadChangeStreamResponse.CloseStream.getDefaultInstance());
    }

    @Test
    public void singleDeleteFamilyTest() {
        Mutation.DeleteFromFamily deleteFromFamily = Mutation.DeleteFromFamily.newBuilder().setFamilyName("fake-family").build();
        ChangeStreamMutation expectedChangeStreamMutation = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).deleteFamily("fake-family").setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        this.changeStreamRecordBuilder.startUserMutation(ByteString.copyFromUtf8((String)"key"), "fake-source-cluster-id", FAKE_COMMIT_TIMESTAMP, 0);
        this.changeStreamRecordBuilder.deleteFamily(deleteFromFamily.getFamilyName());
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutation);
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutation);
    }

    @Test
    public void singleDeleteCellTest() {
        Mutation.DeleteFromColumn deleteFromColumn = Mutation.DeleteFromColumn.newBuilder().setFamilyName("fake-family").setColumnQualifier(ByteString.copyFromUtf8((String)"fake-qualifier")).setTimeRange(TimestampRange.newBuilder().setStartTimestampMicros(1000L).setEndTimestampMicros(2000L).build()).build();
        ChangeStreamMutation expectedChangeStreamMutation = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).deleteCells("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), Range.TimestampRange.create((long)1000L, (long)2000L)).setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        this.changeStreamRecordBuilder.startUserMutation(ByteString.copyFromUtf8((String)"key"), "fake-source-cluster-id", FAKE_COMMIT_TIMESTAMP, 0);
        this.changeStreamRecordBuilder.deleteCells(deleteFromColumn.getFamilyName(), deleteFromColumn.getColumnQualifier(), Range.TimestampRange.create((long)deleteFromColumn.getTimeRange().getStartTimestampMicros(), (long)deleteFromColumn.getTimeRange().getEndTimestampMicros()));
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutation);
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutation);
    }

    @Test
    public void singleNonChunkedCellTest() {
        ChangeStreamMutation expectedChangeStreamMutation = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 100L, ByteString.copyFromUtf8((String)"fake-value")).setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        this.changeStreamRecordBuilder.startUserMutation(ByteString.copyFromUtf8((String)"key"), "fake-source-cluster-id", FAKE_COMMIT_TIMESTAMP, 0);
        this.changeStreamRecordBuilder.startCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 100L);
        this.changeStreamRecordBuilder.cellValue(ByteString.copyFromUtf8((String)"fake-value"));
        this.changeStreamRecordBuilder.finishCell();
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutation);
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutation);
    }

    @Test
    public void singleChunkedCellTest() {
        ChangeStreamMutation expectedChangeStreamMutation = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 100L, ByteString.copyFromUtf8((String)"fake-value1-value2")).setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        this.changeStreamRecordBuilder.startUserMutation(ByteString.copyFromUtf8((String)"key"), "fake-source-cluster-id", FAKE_COMMIT_TIMESTAMP, 0);
        this.changeStreamRecordBuilder.startCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 100L);
        this.changeStreamRecordBuilder.cellValue(ByteString.copyFromUtf8((String)"fake-value1"));
        this.changeStreamRecordBuilder.cellValue(ByteString.copyFromUtf8((String)"-value2"));
        this.changeStreamRecordBuilder.finishCell();
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutation);
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutation);
    }

    @Test
    public void multipleChunkedCellsTest() {
        int i;
        ChangeStreamMutation.Builder expectedChangeStreamMutationBuilder = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0);
        for (i = 0; i < 10; ++i) {
            expectedChangeStreamMutationBuilder.setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 100L, ByteString.copyFromUtf8((String)(i + "-fake-value1-value2-value3")));
        }
        expectedChangeStreamMutationBuilder.setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK);
        this.changeStreamRecordBuilder.startUserMutation(ByteString.copyFromUtf8((String)"key"), "fake-source-cluster-id", FAKE_COMMIT_TIMESTAMP, 0);
        for (i = 0; i < 10; ++i) {
            this.changeStreamRecordBuilder.startCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 100L);
            this.changeStreamRecordBuilder.cellValue(ByteString.copyFromUtf8((String)(i + "-fake-value1")));
            this.changeStreamRecordBuilder.cellValue(ByteString.copyFromUtf8((String)"-value2"));
            this.changeStreamRecordBuilder.cellValue(ByteString.copyFromUtf8((String)"-value3"));
            this.changeStreamRecordBuilder.finishCell();
        }
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutationBuilder.build());
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutationBuilder.build());
    }

    @Test
    public void multipleDifferentModsTest() {
        ChangeStreamMutation.Builder expectedChangeStreamMutationBuilder = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).deleteFamily("fake-family").setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 100L, ByteString.copyFromUtf8((String)"non-chunked-value")).setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 100L, ByteString.copyFromUtf8((String)"chunked-value")).setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK);
        this.changeStreamRecordBuilder.startUserMutation(ByteString.copyFromUtf8((String)"key"), "fake-source-cluster-id", FAKE_COMMIT_TIMESTAMP, 0);
        this.changeStreamRecordBuilder.deleteFamily("fake-family");
        this.changeStreamRecordBuilder.startCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 100L);
        this.changeStreamRecordBuilder.cellValue(ByteString.copyFromUtf8((String)"non-chunked-value"));
        this.changeStreamRecordBuilder.finishCell();
        this.changeStreamRecordBuilder.startCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 100L);
        this.changeStreamRecordBuilder.cellValue(ByteString.copyFromUtf8((String)"chunked"));
        this.changeStreamRecordBuilder.cellValue(ByteString.copyFromUtf8((String)"-value"));
        this.changeStreamRecordBuilder.finishCell();
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutationBuilder.build());
    }

    @Test
    public void resetTest() {
        ReadChangeStreamResponse.Heartbeat expectedHeartbeat = ReadChangeStreamResponse.Heartbeat.getDefaultInstance();
        Truth.assertThat((Object)this.changeStreamRecordBuilder.onHeartbeat(expectedHeartbeat)).isEqualTo((Object)Heartbeat.fromProto((ReadChangeStreamResponse.Heartbeat)expectedHeartbeat));
        this.changeStreamRecordBuilder.reset();
        ReadChangeStreamResponse.CloseStream expectedCloseStream = ReadChangeStreamResponse.CloseStream.getDefaultInstance();
        Truth.assertThat((Object)this.changeStreamRecordBuilder.onCloseStream(expectedCloseStream)).isEqualTo((Object)CloseStream.fromProto((ReadChangeStreamResponse.CloseStream)expectedCloseStream));
        this.changeStreamRecordBuilder.reset();
        Mutation deleteFromFamily = Mutation.newBuilder().setDeleteFromFamily(Mutation.DeleteFromFamily.newBuilder().setFamilyName("fake-family").build()).build();
        ChangeStreamMutation expectedChangeStreamMutation = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).deleteFamily("fake-family").setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        this.changeStreamRecordBuilder.startUserMutation(ByteString.copyFromUtf8((String)"key"), "fake-source-cluster-id", FAKE_COMMIT_TIMESTAMP, 0);
        this.changeStreamRecordBuilder.deleteFamily(deleteFromFamily.getDeleteFromFamily().getFamilyName());
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutation);
        this.changeStreamRecordBuilder.reset();
        expectedChangeStreamMutation = ChangeStreamMutation.createUserMutation((ByteString)ByteString.copyFromUtf8((String)"key"), (String)"fake-source-cluster-id", (Instant)FAKE_COMMIT_TIMESTAMP, (int)0).setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 100L, ByteString.copyFromUtf8((String)"fake-value1-value2")).setToken("fake-token").setEstimatedLowWatermarkTime(FAKE_LOW_WATERMARK).build();
        this.changeStreamRecordBuilder.startUserMutation(ByteString.copyFromUtf8((String)"key"), "fake-source-cluster-id", FAKE_COMMIT_TIMESTAMP, 0);
        this.changeStreamRecordBuilder.startCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 100L);
        this.changeStreamRecordBuilder.cellValue(ByteString.copyFromUtf8((String)"fake-value1"));
        this.changeStreamRecordBuilder.cellValue(ByteString.copyFromUtf8((String)"-value2"));
        this.changeStreamRecordBuilder.finishCell();
        Truth.assertThat((Object)this.changeStreamRecordBuilder.finishChangeStreamMutation("fake-token", FAKE_LOW_WATERMARK)).isEqualTo((Object)expectedChangeStreamMutation);
    }
}

