/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Column;
import com.google.bigtable.v2.Family;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DefaultRowAdapterTest {
    private final DefaultRowAdapter adapter = new DefaultRowAdapter();
    private RowAdapter.RowBuilder<Row> rowBuilder;

    @Before
    public void setUp() {
        this.rowBuilder = this.adapter.createRowBuilder();
    }

    @Test
    public void singleCellRowTest() {
        ByteString value = ByteString.copyFromUtf8((String)"my-value");
        this.rowBuilder.startRow(ByteString.copyFromUtf8((String)"my-key"));
        this.rowBuilder.startCell("my-family", ByteString.copyFromUtf8((String)"my-qualifier"), 100L, (List)ImmutableList.of((Object)"my-label"), (long)value.size());
        this.rowBuilder.cellValue(value);
        this.rowBuilder.finishCell();
        Truth.assertThat((Object)this.rowBuilder.finishRow()).isEqualTo((Object)Row.create((ByteString)ByteString.copyFromUtf8((String)"my-key"), (List)ImmutableList.of((Object)RowCell.create((String)"my-family", (ByteString)ByteString.copyFromUtf8((String)"my-qualifier"), (long)100L, (List)ImmutableList.of((Object)"my-label"), (ByteString)value))));
    }

    @Test
    public void multiCellTest() {
        ArrayList expectedCells = Lists.newArrayList();
        this.rowBuilder.startRow(ByteString.copyFromUtf8((String)"my-key"));
        for (int i = 0; i < 10; ++i) {
            ByteString value = ByteString.copyFromUtf8((String)("value-" + i));
            ByteString qualifier = ByteString.copyFromUtf8((String)("qualifier-" + i));
            this.rowBuilder.startCell("family", qualifier, 1000L, (List)ImmutableList.of((Object)"my-label"), (long)value.size());
            this.rowBuilder.cellValue(value);
            this.rowBuilder.finishCell();
            expectedCells.add(RowCell.create((String)"family", (ByteString)qualifier, (long)1000L, (List)ImmutableList.of((Object)"my-label"), (ByteString)value));
        }
        Truth.assertThat((Object)this.rowBuilder.finishRow()).isEqualTo((Object)Row.create((ByteString)ByteString.copyFromUtf8((String)"my-key"), (List)expectedCells));
    }

    @Test
    public void splitCellTest() {
        ByteString part1 = ByteString.copyFromUtf8((String)"part1");
        ByteString part2 = ByteString.copyFromUtf8((String)"part2");
        this.rowBuilder.startRow(ByteString.copyFromUtf8((String)"my-key"));
        this.rowBuilder.startCell("family", ByteString.copyFromUtf8((String)"qualifier"), 1000L, (List)ImmutableList.of((Object)"my-label"), (long)(part1.size() + part2.size()));
        this.rowBuilder.cellValue(part1);
        this.rowBuilder.cellValue(part2);
        this.rowBuilder.finishCell();
        Truth.assertThat((Object)this.rowBuilder.finishRow()).isEqualTo((Object)Row.create((ByteString)ByteString.copyFromUtf8((String)"my-key"), (List)ImmutableList.of((Object)RowCell.create((String)"family", (ByteString)ByteString.copyFromUtf8((String)"qualifier"), (long)1000L, (List)ImmutableList.of((Object)"my-label"), (ByteString)ByteString.copyFromUtf8((String)"part1part2")))));
    }

    @Test
    public void markerRowTest() {
        Row markerRow = (Row)this.rowBuilder.createScanMarkerRow(ByteString.copyFromUtf8((String)"key"));
        Truth.assertThat((Boolean)this.adapter.isScanMarkerRow(markerRow)).isTrue();
        ByteString value = ByteString.copyFromUtf8((String)"value");
        this.rowBuilder.startRow(ByteString.copyFromUtf8((String)"key"));
        this.rowBuilder.startCell("family", ByteString.EMPTY, 1000L, (List)ImmutableList.of(), (long)value.size());
        this.rowBuilder.cellValue(value);
        this.rowBuilder.finishCell();
        Truth.assertThat((Boolean)this.adapter.isScanMarkerRow((Row)this.rowBuilder.finishRow())).isFalse();
    }

    @Test
    public void sortFamiliesAreSorted() {
        ByteString col1 = ByteString.copyFromUtf8((String)"col1");
        ByteString col2 = ByteString.copyFromUtf8((String)"col2");
        ImmutableList labels = ImmutableList.of();
        ByteString value1 = ByteString.copyFromUtf8((String)"my-value1");
        ByteString value2 = ByteString.copyFromUtf8((String)"my-value2");
        ByteString value3 = ByteString.copyFromUtf8((String)"my-value3");
        ByteString value4 = ByteString.copyFromUtf8((String)"my-value4");
        this.rowBuilder.startRow(ByteString.copyFromUtf8((String)"key1"));
        this.rowBuilder.startCell("family2", col1, 1000L, (List)labels, (long)value1.size());
        this.rowBuilder.cellValue(value1);
        this.rowBuilder.finishCell();
        this.rowBuilder.startCell("family2", col2, 1000L, (List)labels, (long)value2.size());
        this.rowBuilder.cellValue(value2);
        this.rowBuilder.finishCell();
        this.rowBuilder.startCell("family1", col1, 1000L, (List)ImmutableList.of(), (long)value3.size());
        this.rowBuilder.cellValue(value3);
        this.rowBuilder.finishCell();
        this.rowBuilder.startCell("family1", col2, 1000L, (List)ImmutableList.of(), (long)value4.size());
        this.rowBuilder.cellValue(value4);
        this.rowBuilder.finishCell();
        Row actualRow = (Row)this.rowBuilder.finishRow();
        Truth.assertThat((Iterable)actualRow.getCells()).containsExactlyElementsIn((Iterable)ImmutableList.of((Object)RowCell.create((String)"family1", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value3), (Object)RowCell.create((String)"family1", (ByteString)col2, (long)1000L, (List)labels, (ByteString)value4), (Object)RowCell.create((String)"family2", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value1), (Object)RowCell.create((String)"family2", (ByteString)col2, (long)1000L, (List)labels, (ByteString)value2))).inOrder();
    }

    @Test
    public void protoTest() {
        ByteString key = ByteString.copyFromUtf8((String)"key");
        String family1 = "family1";
        ByteString col1 = ByteString.copyFromUtf8((String)"col1");
        ByteString value1 = ByteString.copyFromUtf8((String)"value1");
        String family2 = "family2";
        ByteString col2 = ByteString.copyFromUtf8((String)"col2");
        ByteString value2 = ByteString.copyFromUtf8((String)"value2");
        ImmutableList labels = ImmutableList.of();
        com.google.bigtable.v2.Row proto = com.google.bigtable.v2.Row.newBuilder().setKey(key).addFamilies(Family.newBuilder().setName(family2).addColumns(Column.newBuilder().setQualifier(col1).addCells(Cell.newBuilder().setTimestampMicros(2000L).setValue(value2))).addColumns(Column.newBuilder().setQualifier(col2).addCells(Cell.newBuilder().setTimestampMicros(2000L).setValue(value2)))).addFamilies(Family.newBuilder().setName(family1).addColumns(Column.newBuilder().setQualifier(col1).addCells(Cell.newBuilder().setTimestampMicros(1000L).setValue(value1))).addColumns(Column.newBuilder().setQualifier(col2).addCells(Cell.newBuilder().setTimestampMicros(1000L).setValue(value1)))).build();
        Row row = this.adapter.createRowFromProto(proto);
        Truth.assertThat((Object)row).isEqualTo((Object)Row.create((ByteString)key, (List)ImmutableList.of((Object)RowCell.create((String)family1, (ByteString)col1, (long)1000L, (List)labels, (ByteString)value1), (Object)RowCell.create((String)family1, (ByteString)col2, (long)1000L, (List)labels, (ByteString)value1), (Object)RowCell.create((String)family2, (ByteString)col1, (long)2000L, (List)labels, (ByteString)value2), (Object)RowCell.create((String)family2, (ByteString)col2, (long)2000L, (List)labels, (ByteString)value2))));
    }
}

