/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.cloud.bigtable.data.v2.models.DeleteCells;
import com.google.cloud.bigtable.data.v2.models.DeleteFamily;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.SetCell;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class EntryTest {
    private void validateSerializationRoundTrip(Object obj) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        Truth.assertThat((Object)ois.readObject()).isEqualTo(obj);
    }

    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        DeleteFamily deleteFamilyEntry = DeleteFamily.create((String)"fake-family");
        this.validateSerializationRoundTrip(deleteFamilyEntry);
        DeleteCells deleteCellsEntry = DeleteCells.create((String)"fake-family", (ByteString)ByteString.copyFromUtf8((String)"fake-qualifier"), (Range.TimestampRange)Range.TimestampRange.create((long)1000L, (long)2000L));
        this.validateSerializationRoundTrip(deleteCellsEntry);
        SetCell setCellEntry = SetCell.create((String)"fake-family", (ByteString)ByteString.copyFromUtf8((String)"fake-qualifier"), (long)1000L, (ByteString)ByteString.copyFromUtf8((String)"fake-value"));
        this.validateSerializationRoundTrip(setCellEntry);
    }

    @Test
    public void deleteFamilyTest() {
        DeleteFamily deleteFamilyEntry;
        DeleteFamily deleteFamily = deleteFamilyEntry = DeleteFamily.create((String)"fake-family");
        Truth.assertThat((String)"fake-family").isEqualTo((Object)deleteFamily.getFamilyName());
    }

    @Test
    public void deleteCellsTest() {
        DeleteCells deleteCellEntry;
        DeleteCells deleteCells = deleteCellEntry = DeleteCells.create((String)"fake-family", (ByteString)ByteString.copyFromUtf8((String)"fake-qualifier"), (Range.TimestampRange)Range.TimestampRange.create((long)1000L, (long)2000L));
        Truth.assertThat((String)"fake-family").isEqualTo((Object)deleteCells.getFamilyName());
        Truth.assertThat((Iterable)ByteString.copyFromUtf8((String)"fake-qualifier")).isEqualTo((Object)deleteCells.getQualifier());
        Truth.assertThat((Object)Range.TimestampRange.create((long)1000L, (long)2000L)).isEqualTo((Object)deleteCells.getTimestampRange());
    }

    @Test
    public void setSellTest() {
        SetCell setCellEntry;
        SetCell setCell = setCellEntry = SetCell.create((String)"fake-family", (ByteString)ByteString.copyFromUtf8((String)"fake-qualifier"), (long)1000L, (ByteString)ByteString.copyFromUtf8((String)"fake-value"));
        Truth.assertThat((String)"fake-family").isEqualTo((Object)setCell.getFamilyName());
        Truth.assertThat((Iterable)ByteString.copyFromUtf8((String)"fake-qualifier")).isEqualTo((Object)setCell.getQualifier());
        Truth.assertThat((Integer)1000).isEqualTo((Object)setCell.getTimestamp());
        Truth.assertThat((Iterable)ByteString.copyFromUtf8((String)"fake-value")).isEqualTo((Object)setCell.getValue());
    }
}

