/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.ColumnRange;
import com.google.bigtable.v2.RowFilter;
import com.google.bigtable.v2.TimestampRange;
import com.google.bigtable.v2.ValueRange;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FiltersTest {
    @Test
    public void chainTest() {
        RowFilter actualProto = Filters.FILTERS.chain().filter(Filters.FILTERS.key().regex(".*")).filter(Filters.FILTERS.key().sample(0.5)).filter((Filters.Filter)Filters.FILTERS.chain().filter(Filters.FILTERS.family().regex("hi$")).filter(Filters.FILTERS.pass())).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setChain(RowFilter.Chain.newBuilder().addFilters(RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)".*"))).addFilters(RowFilter.newBuilder().setRowSampleFilter(0.5)).addFilters(RowFilter.newBuilder().setChain(RowFilter.Chain.newBuilder().addFilters(RowFilter.newBuilder().setFamilyNameRegexFilter("hi$")).addFilters(RowFilter.newBuilder().setPassAllFilter(true))))).build();
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void chainEmptyTest() {
        RowFilter actualProto = Filters.FILTERS.chain().toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setPassAllFilter(true).build();
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void chainSingleTest() {
        RowFilter actualProto = Filters.FILTERS.chain().filter(Filters.FILTERS.key().regex(".*")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)".*")).build();
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void interleaveTest() {
        RowFilter actualProto = Filters.FILTERS.interleave().filter(Filters.FILTERS.key().regex(".*")).filter(Filters.FILTERS.key().sample(0.5)).filter((Filters.Filter)Filters.FILTERS.interleave().filter(Filters.FILTERS.family().regex("hi$")).filter(Filters.FILTERS.pass())).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setInterleave(RowFilter.Interleave.newBuilder().addFilters(RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)".*"))).addFilters(RowFilter.newBuilder().setRowSampleFilter(0.5)).addFilters(RowFilter.newBuilder().setInterleave(RowFilter.Interleave.newBuilder().addFilters(RowFilter.newBuilder().setFamilyNameRegexFilter("hi$")).addFilters(RowFilter.newBuilder().setPassAllFilter(true).build())))).build();
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void interleaveEmptyTest() {
        RowFilter actualProto = Filters.FILTERS.chain().toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setPassAllFilter(true).build();
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void interleaveSingleTest() {
        RowFilter actualProto = Filters.FILTERS.interleave().filter(Filters.FILTERS.key().regex(".*")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)".*")).build();
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void conditionTest() {
        RowFilter actualFilter = Filters.FILTERS.condition(Filters.FILTERS.key().regex(".*")).then(Filters.FILTERS.label("true")).otherwise(Filters.FILTERS.label("false")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setCondition(RowFilter.Condition.newBuilder().setPredicateFilter(RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)".*"))).setTrueFilter(RowFilter.newBuilder().setApplyLabelTransformer("true")).setFalseFilter(RowFilter.newBuilder().setApplyLabelTransformer("false"))).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void keyRegexTest() {
        RowFilter actualFilter = Filters.FILTERS.key().regex(ByteString.copyFromUtf8((String)".*")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)".*")).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void keyRegexStringTest() {
        RowFilter actualFilter = Filters.FILTERS.key().regex(".*").toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)".*")).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void keyExactMatchTest() {
        RowFilter actualFilter = Filters.FILTERS.key().exactMatch(ByteString.copyFromUtf8((String)".*")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)"\\.\\*")).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void keyExactMatchStringTest() {
        RowFilter actualFilter = Filters.FILTERS.key().exactMatch(".*").toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)"\\.\\*")).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void keySampleTest() {
        RowFilter actualFilter = Filters.FILTERS.key().sample(0.3).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setRowSampleFilter(0.3).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void familyRegexTest() {
        RowFilter actualFilter = Filters.FILTERS.family().regex("^hi").toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setFamilyNameRegexFilter("^hi").build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void familyExactMatchTest() {
        RowFilter actualFilter = Filters.FILTERS.family().exactMatch("^hi").toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setFamilyNameRegexFilter("\\^hi").build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void qualifierRegexTest() {
        RowFilter actualFilter = Filters.FILTERS.qualifier().regex(ByteString.copyFromUtf8((String)"^hi")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setColumnQualifierRegexFilter(ByteString.copyFromUtf8((String)"^hi")).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void qualifierRegexStringTest() {
        RowFilter actualFilter = Filters.FILTERS.qualifier().regex("^hi").toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setColumnQualifierRegexFilter(ByteString.copyFromUtf8((String)"^hi")).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void qualifierExactMatchTest() {
        RowFilter actualFilter = Filters.FILTERS.qualifier().exactMatch(ByteString.copyFromUtf8((String)"^hi")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setColumnQualifierRegexFilter(ByteString.copyFromUtf8((String)"\\^hi")).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void qualifierExactStringMatchTest() {
        RowFilter actualFilter = Filters.FILTERS.qualifier().exactMatch("^hi").toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setColumnQualifierRegexFilter(ByteString.copyFromUtf8((String)"\\^hi")).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void qualifierRangeInFamilyClosedOpen() {
        RowFilter actualFilter = ((Filters.QualifierRangeFilter)((Filters.QualifierRangeFilter)Filters.FILTERS.qualifier().rangeWithinFamily("family").startClosed("begin")).endOpen("end")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setColumnRangeFilter(ColumnRange.newBuilder().setFamilyName("family").setStartQualifierClosed(ByteString.copyFromUtf8((String)"begin")).setEndQualifierOpen(ByteString.copyFromUtf8((String)"end"))).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void qualifierRangeInFamilyOpenClosed() {
        RowFilter actualFilter = ((Filters.QualifierRangeFilter)((Filters.QualifierRangeFilter)Filters.FILTERS.qualifier().rangeWithinFamily("family").startOpen("begin")).endClosed("end")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setColumnRangeFilter(ColumnRange.newBuilder().setFamilyName("family").setStartQualifierOpen(ByteString.copyFromUtf8((String)"begin")).setEndQualifierClosed(ByteString.copyFromUtf8((String)"end"))).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void qualifierRangeRange() {
        RowFilter actualFilter = ((Filters.QualifierRangeFilter)((Filters.QualifierRangeFilter)Filters.FILTERS.qualifier().rangeWithinFamily("family").startClosed("begin")).endOpen("end")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setColumnRangeFilter(ColumnRange.newBuilder().setFamilyName("family").setStartQualifierClosed(ByteString.copyFromUtf8((String)"begin")).setEndQualifierOpen(ByteString.copyFromUtf8((String)"end"))).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void timestampRange() {
        RowFilter actualFilter = ((Filters.TimestampRangeFilter)((Filters.TimestampRangeFilter)Filters.FILTERS.timestamp().range().startClosed((Object)1000L)).endOpen((Object)30000L)).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setTimestampRangeFilter(TimestampRange.newBuilder().setStartTimestampMicros(1000L).setEndTimestampMicros(30000L)).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void timestampAtExactTime() {
        RowFilter actualFilter = Filters.FILTERS.timestamp().exact(Long.valueOf(20000L)).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setTimestampRangeFilter(TimestampRange.newBuilder().setStartTimestampMicros(20000L).setEndTimestampMicros(20001L)).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void timestampOpenClosedFakeRange() {
        RowFilter actualFilter = ((Filters.TimestampRangeFilter)((Filters.TimestampRangeFilter)Filters.FILTERS.timestamp().range().startOpen((Object)1000L)).endClosed((Object)30000L)).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setTimestampRangeFilter(TimestampRange.newBuilder().setStartTimestampMicros(1001L).setEndTimestampMicros(30001L)).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void valueRegex() {
        RowFilter actualFilter = Filters.FILTERS.value().regex("some[0-9]regex").toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setValueRegexFilter(ByteString.copyFromUtf8((String)"some[0-9]regex")).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void valueExactMatch() {
        RowFilter actualFilter = Filters.FILTERS.value().exactMatch(ByteString.copyFromUtf8((String)"some[0-9]regex")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setValueRegexFilter(ByteString.copyFromUtf8((String)"some\\[0\\-9\\]regex")).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void valueExactStringMatch() {
        RowFilter actualFilter = Filters.FILTERS.value().exactMatch("some[0-9]regex").toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setValueRegexFilter(ByteString.copyFromUtf8((String)"some\\[0\\-9\\]regex")).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void valueRangeClosedOpen() {
        RowFilter actualFilter = ((Filters.ValueRangeFilter)((Filters.ValueRangeFilter)Filters.FILTERS.value().range().startClosed("begin")).endOpen("end")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setValueRangeFilter(ValueRange.newBuilder().setStartValueClosed(ByteString.copyFromUtf8((String)"begin")).setEndValueOpen(ByteString.copyFromUtf8((String)"end"))).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void valueRangeOpenClosed() {
        RowFilter actualFilter = ((Filters.ValueRangeFilter)((Filters.ValueRangeFilter)Filters.FILTERS.value().range().startOpen("begin")).endClosed("end")).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setValueRangeFilter(ValueRange.newBuilder().setStartValueOpen(ByteString.copyFromUtf8((String)"begin")).setEndValueClosed(ByteString.copyFromUtf8((String)"end"))).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void valueStripTest() {
        RowFilter actualFilter = Filters.FILTERS.value().strip().toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setStripValueTransformer(true).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void offsetCellsPerRowTest() {
        RowFilter actualFilter = Filters.FILTERS.offset().cellsPerRow(10).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setCellsPerRowOffsetFilter(10).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void limitCellsPerRowTest() {
        RowFilter actualFilter = Filters.FILTERS.limit().cellsPerRow(10).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setCellsPerRowLimitFilter(10).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void limitCellsPerColumnTest() {
        RowFilter actualFilter = Filters.FILTERS.limit().cellsPerColumn(10).toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setCellsPerColumnLimitFilter(10).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void fromProtoTest() {
        RowFilter inner = RowFilter.newBuilder().setRowSampleFilter(0.5).build();
        RowFilter actualFilter = Filters.FILTERS.fromProto(inner).toProto();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)inner);
    }

    @Test
    public void passTest() {
        RowFilter actualFilter = Filters.FILTERS.pass().toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setPassAllFilter(true).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void blockTest() {
        RowFilter actualFilter = Filters.FILTERS.block().toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setBlockAllFilter(true).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void sinkTest() {
        RowFilter actualFilter = Filters.FILTERS.sink().toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setSink(true).build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void labelTest() {
        RowFilter actualFilter = Filters.FILTERS.label("my-label").toProto();
        RowFilter expectedFilter = RowFilter.newBuilder().setApplyLabelTransformer("my-label").build();
        Truth.assertThat((Object)actualFilter).isEqualTo((Object)expectedFilter);
    }

    @Test
    public void serializationTest() throws InvocationTargetException, IllegalAccessException {
        block10: for (Method m : Filters.class.getDeclaredMethods()) {
            String name = m.getName();
            if (!Modifier.isPublic(m.getModifiers())) continue;
            switch (name) {
                case "condition": {
                    FiltersTest.checkSerialization(name, Filters.FILTERS.condition((Filters.Filter)Filters.FILTERS.chain().filter(Filters.FILTERS.qualifier().exactMatch("data_plan_10gb")).filter(Filters.FILTERS.value().exactMatch("true"))).then(Filters.FILTERS.label("passed-filter")).otherwise(Filters.FILTERS.label("filtered-out")));
                    continue block10;
                }
                case "label": {
                    FiltersTest.checkSerialization(name, Filters.FILTERS.label("label"));
                    continue block10;
                }
                case "fromProto": {
                    FiltersTest.checkSerialization(name, Filters.FILTERS.label("label").toProto());
                    continue block10;
                }
                default: {
                    FiltersTest.checkSerialization(name, m.invoke((Object)Filters.FILTERS, new Object[0]));
                }
            }
        }
    }

    private static void checkSerialization(String name, Object filter) {
        try {
            Object deserialized = FiltersTest.serializeDeserialize(filter);
            FiltersTest.checkClassDeclaresSerialVersionUid(filter.getClass());
            if (filter instanceof Filters.Filter) {
                FiltersTest.checkFilters(name, (Filters.Filter)filter, (Filters.Filter)deserialized);
            } else if (filter instanceof RowFilter) {
                Truth.assertWithMessage((String)("'" + name + "' deserialized filter differs")).that(filter).isEqualTo(deserialized);
            } else {
                Class<?> cls = filter.getClass();
                FiltersTest.checkClassDoesNotContainNonStaticFields(cls, cls.getFields());
                FiltersTest.checkClassDoesNotContainNonStaticFields(cls, cls.getDeclaredFields());
                FiltersTest.checkSpawnedFilters(name, cls, filter, deserialized);
            }
        }
        catch (IOException | ClassNotFoundException e) {
            Assert.fail((String)(name + ": " + e));
        }
    }

    private static void checkFilters(String name, Filters.Filter original, Filters.Filter deserialized) {
        RowFilter protoBefore = original.toProto();
        RowFilter protoAfter = deserialized.toProto();
        Truth.assertWithMessage((String)("'" + name + "' filter protoBuf mismatches after deserialization")).that((Object)protoBefore).isEqualTo((Object)protoAfter);
    }

    private static void checkSpawnedFilters(String name, Class cls, Object original, Object deserialized) {
        int numberOfMethods = 0;
        for (Method m : cls.getDeclaredMethods()) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            ++numberOfMethods;
        }
        ByteString re = ByteString.copyFromUtf8((String)"some\\[0\\-9\\]regex");
        switch (name) {
            case "family": {
                Filters.FamilyFilter f1 = (Filters.FamilyFilter)original;
                Filters.FamilyFilter f2 = (Filters.FamilyFilter)deserialized;
                Truth.assertThat((Integer)numberOfMethods).isEqualTo((Object)2);
                FiltersTest.checkFilters(name + "/exactMatch", f1.exactMatch("abc"), f2.exactMatch("abc"));
                FiltersTest.checkFilters(name + "/regex", f1.regex("*"), f2.regex("*"));
                break;
            }
            case "qualifier": {
                Filters.FamilyFilter f1 = (Filters.QualifierFilter)original;
                Filters.QualifierFilter f2 = (Filters.QualifierFilter)deserialized;
                Truth.assertThat((Integer)numberOfMethods).isEqualTo((Object)5);
                FiltersTest.checkFilters(name + "/exactMatch", f1.exactMatch("abc"), f2.exactMatch("abc"));
                FiltersTest.checkFilters(name + "/exactMatch(ByteString)", f1.exactMatch(re), f2.exactMatch(re));
                FiltersTest.checkFilters(name + "/regex", f1.regex("*"), f2.regex("*"));
                FiltersTest.checkFilters(name + "/regex(ByteString)", f1.regex(re), f2.regex(re));
                FiltersTest.checkFilters(name + "/rangeWithinFamily", (Filters.Filter)f1.rangeWithinFamily("family"), (Filters.Filter)f2.rangeWithinFamily("family"));
                break;
            }
            case "limit": {
                Filters.FamilyFilter f1 = (Filters.LimitFilter)original;
                Filters.LimitFilter f2 = (Filters.LimitFilter)deserialized;
                Truth.assertThat((Integer)numberOfMethods).isEqualTo((Object)2);
                FiltersTest.checkFilters(name + "/cellsPerColumn", f1.cellsPerColumn(100500), f2.cellsPerColumn(100500));
                FiltersTest.checkFilters(name + "/cellsPerRow", f1.cellsPerRow(-10), f2.cellsPerRow(-10));
                break;
            }
            case "value": {
                Filters.FamilyFilter f1 = (Filters.ValueFilter)original;
                Filters.ValueFilter f2 = (Filters.ValueFilter)deserialized;
                Truth.assertThat((Integer)numberOfMethods).isEqualTo((Object)6);
                FiltersTest.checkFilters(name + "/exactMatch", f1.exactMatch("x"), f2.exactMatch("x"));
                FiltersTest.checkFilters(name + "/exactMatch(ByteString)", f1.exactMatch(re), f2.exactMatch(re));
                FiltersTest.checkFilters(name + "/range", (Filters.Filter)f1.range(), (Filters.Filter)f2.range());
                FiltersTest.checkFilters(name + "/regex", f1.regex("*"), f2.regex("*"));
                FiltersTest.checkFilters(name + "/regex(ByteString)", f1.regex(re), f2.regex(re));
                FiltersTest.checkFilters(name + "/strip", f1.strip(), f2.strip());
                break;
            }
            case "offset": {
                Filters.FamilyFilter f1 = (Filters.OffsetFilter)original;
                Filters.OffsetFilter f2 = (Filters.OffsetFilter)deserialized;
                Truth.assertThat((Integer)numberOfMethods).isEqualTo((Object)1);
                FiltersTest.checkFilters(name + "/cellsPerRow", f1.cellsPerRow(100500), f2.cellsPerRow(100500));
                break;
            }
            case "key": {
                Filters.FamilyFilter f1 = (Filters.KeyFilter)original;
                Filters.KeyFilter f2 = (Filters.KeyFilter)deserialized;
                Truth.assertThat((Integer)numberOfMethods).isEqualTo((Object)5);
                FiltersTest.checkFilters(name + "/exactMatch", f1.exactMatch("a"), f2.exactMatch("a"));
                FiltersTest.checkFilters(name + "/exactMatch(ByteString)", f1.exactMatch(re), f2.exactMatch(re));
                FiltersTest.checkFilters(name + "/regex", f1.regex("a"), f2.regex("a"));
                FiltersTest.checkFilters(name + "/regex(ByteString)", f1.regex(re), f2.regex(re));
                FiltersTest.checkFilters(name + "/sample", f1.sample(0.1), f2.sample(0.1));
                break;
            }
            case "timestamp": {
                Filters.FamilyFilter f1 = (Filters.TimestampFilter)original;
                Filters.TimestampFilter f2 = (Filters.TimestampFilter)deserialized;
                Truth.assertThat((Integer)numberOfMethods).isEqualTo((Object)2);
                FiltersTest.checkFilters(name + "/exact", (Filters.Filter)f1.exact(Long.valueOf(100500L)), (Filters.Filter)f2.exact(Long.valueOf(100500L)));
                FiltersTest.checkFilters(name + "/range", (Filters.Filter)f1.range(), (Filters.Filter)f2.range());
                break;
            }
            default: {
                Assert.fail((String)("Untested filter: " + name));
            }
        }
    }

    private static void checkClassDeclaresSerialVersionUid(Class cls) {
        String uid = "serialVersionUID";
        for (Field field : cls.getDeclaredFields()) {
            if (field.getName() != uid) continue;
            int modifiers = field.getModifiers();
            Truth.assertWithMessage((String)(field + " is not static")).that(Boolean.valueOf(Modifier.isStatic(modifiers))).isTrue();
            Truth.assertWithMessage((String)(field + " is not final")).that(Boolean.valueOf(Modifier.isFinal(modifiers))).isTrue();
            Truth.assertWithMessage((String)(field + " is not private")).that(Boolean.valueOf(Modifier.isPrivate(modifiers))).isTrue();
            Truth.assertWithMessage((String)(field + " must be long")).that(field.getType().getSimpleName()).isEqualTo((Object)"long");
            return;
        }
        Assert.fail((String)(cls + " does not declare serialVersionUID"));
    }

    private static void checkClassDoesNotContainNonStaticFields(Class cls, Field[] fields) {
        for (Field field : fields) {
            Truth.assertWithMessage((String)(cls + " has a non-static field '" + field + "'")).that(Boolean.valueOf(Modifier.isStatic(field.getModifiers()))).isTrue();
        }
    }

    private static Object serializeDeserialize(Object obj) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream outStream = new ObjectOutputStream(bos);){
            outStream.writeObject(obj);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        try (ObjectInputStream inStream = new ObjectInputStream(bis);){
            Object object = inStream.readObject();
            return object;
        }
    }
}

