/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.TimestampRange;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.common.collect.Range;
import com.google.common.primitives.Longs;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MutationTest {
    private Mutation mutation;

    @Before
    public void setUp() {
        this.mutation = Mutation.create();
    }

    @Test
    public void setCellTest() {
        long minTimestamp = System.currentTimeMillis() * 1000L;
        this.mutation.setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 1000L, ByteString.copyFromUtf8((String)"fake-value")).setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), ByteString.copyFromUtf8((String)"fake-value")).setCell("fake-family2", "fake-qualifier2", 1000L, "fake-value2").setCell("fake-family2", "fake-qualifier2", "fake-value2");
        List actual = this.mutation.getMutations();
        long maxTimestamp = System.currentTimeMillis() * 1000L;
        Range expectedTimestampRange = Range.closed((Comparable)Long.valueOf(minTimestamp), (Comparable)Long.valueOf(maxTimestamp));
        Truth.assertThat((Iterable)actual).hasSize(4);
        Truth.assertThat((String)((com.google.bigtable.v2.Mutation)actual.get(0)).getSetCell().getFamilyName()).isEqualTo((Object)"fake-family");
        Truth.assertThat((Iterable)((com.google.bigtable.v2.Mutation)actual.get(0)).getSetCell().getColumnQualifier()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-qualifier"));
        Truth.assertThat((Iterable)((com.google.bigtable.v2.Mutation)actual.get(0)).getSetCell().getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-value"));
        Truth.assertThat((Long)((com.google.bigtable.v2.Mutation)actual.get(0)).getSetCell().getTimestampMicros()).isEqualTo((Object)1000);
        Truth.assertThat((String)((com.google.bigtable.v2.Mutation)actual.get(1)).getSetCell().getFamilyName()).isEqualTo((Object)"fake-family");
        Truth.assertThat((Iterable)((com.google.bigtable.v2.Mutation)actual.get(1)).getSetCell().getColumnQualifier()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-qualifier"));
        Truth.assertThat((Iterable)((com.google.bigtable.v2.Mutation)actual.get(1)).getSetCell().getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-value"));
        Truth.assertThat((Long)((com.google.bigtable.v2.Mutation)actual.get(1)).getSetCell().getTimestampMicros()).isIn(expectedTimestampRange);
        Truth.assertThat((String)((com.google.bigtable.v2.Mutation)actual.get(2)).getSetCell().getFamilyName()).isEqualTo((Object)"fake-family2");
        Truth.assertThat((Iterable)((com.google.bigtable.v2.Mutation)actual.get(2)).getSetCell().getColumnQualifier()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-qualifier2"));
        Truth.assertThat((Iterable)((com.google.bigtable.v2.Mutation)actual.get(2)).getSetCell().getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-value2"));
        Truth.assertThat((Long)((com.google.bigtable.v2.Mutation)actual.get(2)).getSetCell().getTimestampMicros()).isEqualTo((Object)1000);
        Truth.assertThat((String)((com.google.bigtable.v2.Mutation)actual.get(3)).getSetCell().getFamilyName()).isEqualTo((Object)"fake-family2");
        Truth.assertThat((Iterable)((com.google.bigtable.v2.Mutation)actual.get(3)).getSetCell().getColumnQualifier()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-qualifier2"));
        Truth.assertThat((Iterable)((com.google.bigtable.v2.Mutation)actual.get(3)).getSetCell().getValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"fake-value2"));
        Truth.assertThat((Long)((com.google.bigtable.v2.Mutation)actual.get(3)).getSetCell().getTimestampMicros()).isIn(expectedTimestampRange);
        Truth.assertThat((Iterable)Mutation.fromProtoUnsafe((List)actual).getMutations()).isEqualTo((Object)actual);
    }

    @Test
    public void setCellWithServerSideTimestamp() {
        Mutation mutation = Mutation.createUnsafe();
        mutation.setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), -1L, ByteString.copyFromUtf8((String)"fake-value"));
        List actual = mutation.getMutations();
        Truth.assertThat((Long)((com.google.bigtable.v2.Mutation)actual.get(0)).getSetCell().getTimestampMicros()).isEqualTo((Object)-1L);
    }

    @Test
    public void deleteColumnTest() {
        this.mutation.deleteCells("fake-family", "fake-qualifier").deleteCells("fake-family2", ByteString.copyFromUtf8((String)"fake-qualifier2")).deleteCells("fake-family3", ByteString.copyFromUtf8((String)"fake-qualifier3"), Range.TimestampRange.create((long)1000L, (long)2000L));
        List actual = this.mutation.getMutations();
        Truth.assertThat((Iterable)actual).containsExactly(new Object[]{com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromColumn(Mutation.DeleteFromColumn.newBuilder().setFamilyName("fake-family").setColumnQualifier(ByteString.copyFromUtf8((String)"fake-qualifier"))).build(), com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromColumn(Mutation.DeleteFromColumn.newBuilder().setFamilyName("fake-family2").setColumnQualifier(ByteString.copyFromUtf8((String)"fake-qualifier2"))).build(), com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromColumn(Mutation.DeleteFromColumn.newBuilder().setFamilyName("fake-family3").setColumnQualifier(ByteString.copyFromUtf8((String)"fake-qualifier3")).setTimeRange(TimestampRange.newBuilder().setStartTimestampMicros(1000L).setEndTimestampMicros(2000L))).build()});
    }

    @Test
    public void deleteFamilyTest() {
        this.mutation.deleteFamily("fake-family1").deleteFamily("fake-family2");
        List actual = this.mutation.getMutations();
        Truth.assertThat((Iterable)actual).containsExactly(new Object[]{com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromFamily(Mutation.DeleteFromFamily.newBuilder().setFamilyName("fake-family1")).build(), com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromFamily(Mutation.DeleteFromFamily.newBuilder().setFamilyName("fake-family2")).build()});
    }

    @Test
    public void deleteRowTest() {
        this.mutation.deleteRow();
        List actual = this.mutation.getMutations();
        Truth.assertThat((Iterable)actual).containsExactly(new Object[]{com.google.bigtable.v2.Mutation.newBuilder().setDeleteFromRow(Mutation.DeleteFromRow.getDefaultInstance()).build()});
    }

    @Test
    public void addToCellTest() {
        this.mutation.addToCell("cf1", "q", 10000L, 1234L);
        List actual = this.mutation.getMutations();
        Mutation.Builder builder = com.google.bigtable.v2.Mutation.newBuilder();
        Mutation.AddToCell.Builder addToCellBuilder = builder.getAddToCellBuilder();
        addToCellBuilder.setFamilyName("cf1");
        addToCellBuilder.getColumnQualifierBuilder().setRawValue(ByteString.copyFromUtf8((String)"q"));
        addToCellBuilder.getTimestampBuilder().setRawTimestampMicros(10000L);
        addToCellBuilder.getInputBuilder().setIntValue(1234L);
        Truth.assertThat((Iterable)actual).containsExactly(new Object[]{builder.build()});
    }

    @Test
    public void mergeToCellTest() {
        this.mutation.mergeToCell("cf1", "q", 10000L, ByteString.copyFrom((byte[])Longs.toByteArray((long)1234L)));
        List actual = this.mutation.getMutations();
        Mutation.Builder builder = com.google.bigtable.v2.Mutation.newBuilder();
        Mutation.MergeToCell.Builder mergeToCellBuilder = builder.getMergeToCellBuilder();
        mergeToCellBuilder.setFamilyName("cf1");
        mergeToCellBuilder.getColumnQualifierBuilder().setRawValue(ByteString.copyFromUtf8((String)"q"));
        mergeToCellBuilder.getTimestampBuilder().setRawTimestampMicros(10000L);
        mergeToCellBuilder.getInputBuilder().setRawValue(ByteString.copyFrom((byte[])Longs.toByteArray((long)1234L)));
        Truth.assertThat((Iterable)actual).containsExactly(new Object[]{builder.build()});
    }

    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        Mutation expected = Mutation.create().setCell("cf", "q", "val");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        Mutation actual = (Mutation)ois.readObject();
        Truth.assertThat((Iterable)actual.getMutations()).isEqualTo((Object)expected.getMutations());
    }

    @Test
    public void tooManyMutationsTest() {
        Mutation mutation = Mutation.create();
        for (int i = 0; i < 100000; ++i) {
            mutation.setCell("f", "", "");
        }
        Exception actualError = null;
        try {
            mutation.setCell("f", "", "");
        }
        catch (Exception e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void tooLargeRequest() {
        Mutation mutation = Mutation.create();
        Exception actualError = null;
        try {
            mutation.setCell("f", ByteString.copyFromUtf8((String)""), ByteString.copyFrom((byte[])new byte[0xC800000]));
        }
        catch (Exception e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testWithLongValue() {
        Mutation mutation = Mutation.create().setCell("fake-family", "fake-qualifier", 100000L).setCell("fake-family", ByteString.copyFromUtf8((String)"test-qualifier"), 100000L).setCell("fake-family", "fake-qualifier", 30000L, 20000L);
        List mutations = mutation.getMutations();
        Truth.assertThat((Integer)mutations.size()).isEqualTo((Object)3);
        com.google.bigtable.v2.Mutation actualMutation = (com.google.bigtable.v2.Mutation)mutations.get(0);
        Truth.assertThat((Iterable)actualMutation.getSetCell().getValue()).isEqualTo((Object)ByteString.copyFrom((byte[])Longs.toByteArray((long)100000L)));
        Truth.assertThat((Object)((com.google.bigtable.v2.Mutation)mutations.get(2)).getSetCell()).isEqualTo((Object)Mutation.SetCell.newBuilder().setFamilyName("fake-family").setColumnQualifier(ByteString.copyFromUtf8((String)"fake-qualifier")).setTimestampMicros(30000L).setValue(ByteString.copyFrom((byte[])Longs.toByteArray((long)20000L))).build());
    }

    @Test
    public void fromProtoTest() {
        ((Mutation)this.mutation.setCell("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier"), 1000L, ByteString.copyFromUtf8((String)"fake-value")).deleteCells("fake-family", ByteString.copyFromUtf8((String)"fake-qualifier")).deleteFamily("fake-family2").addToCell("agg-family", "qual1", 1000L, 1234L)).mergeToCell("agg-family", "qual2", 1000L, ByteString.copyFrom((byte[])Longs.toByteArray((long)1234L)));
        List protoMutation = this.mutation.getMutations();
        Truth.assertThat((Iterable)Mutation.fromProto((List)protoMutation).getMutations()).isEqualTo((Object)protoMutation);
    }
}

