/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.RowFilter;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class QueryTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "fake-table";
    private static final String AUTHORIZED_VIEW_ID = "fake-authorized-view";
    private static final String APP_PROFILE_ID = "fake-profile-id";
    private RequestContext requestContext;
    @Rule
    public ExpectedException expect = ExpectedException.none();

    @Before
    public void setUp() {
        this.requestContext = RequestContext.create((String)PROJECT_ID, (String)INSTANCE_ID, (String)APP_PROFILE_ID);
    }

    @Test
    public void requestContextTest() {
        Query query = Query.create((String)TABLE_ID);
        ReadRowsRequest proto = query.toProto(this.requestContext);
        Truth.assertThat((Object)proto).isEqualTo((Object)QueryTest.expectedReadFromTableProtoBuilder().build());
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID));
        proto = query.toProto(this.requestContext);
        Truth.assertThat((Object)proto).isEqualTo((Object)QueryTest.expectedReadFromAuthorizedViewProtoBuilder().build());
    }

    @Test
    public void rowKeysTest() {
        Query query = Query.create((String)TABLE_ID).rowKey("simple-string").rowKey(ByteString.copyFromUtf8((String)"byte-string"));
        ReadRowsRequest.Builder expectedProto = QueryTest.expectedReadFromTableProtoBuilder();
        expectedProto.getRowsBuilder().addRowKeys(ByteString.copyFromUtf8((String)"simple-string")).addRowKeys(ByteString.copyFromUtf8((String)"byte-string"));
        ReadRowsRequest actualProto = query.toProto(this.requestContext);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedProto.build());
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).rowKey("simple-string").rowKey(ByteString.copyFromUtf8((String)"byte-string"));
        expectedProto = QueryTest.expectedReadFromAuthorizedViewProtoBuilder();
        expectedProto.getRowsBuilder().addRowKeys(ByteString.copyFromUtf8((String)"simple-string")).addRowKeys(ByteString.copyFromUtf8((String)"byte-string"));
        actualProto = query.toProto(this.requestContext);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedProto.build());
    }

    @Test
    public void rowRangeTest() {
        Query query = Query.create((String)TABLE_ID).range("simple-begin", "simple-end").range(ByteString.copyFromUtf8((String)"byte-begin"), ByteString.copyFromUtf8((String)"byte-end")).range(Range.ByteStringRange.create((String)"range-begin", (String)"range-end"));
        ReadRowsRequest.Builder expectedProto = QueryTest.expectedReadFromTableProtoBuilder();
        expectedProto.getRowsBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"simple-begin")).setEndKeyOpen(ByteString.copyFromUtf8((String)"simple-end"))).addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"byte-begin")).setEndKeyOpen(ByteString.copyFromUtf8((String)"byte-end"))).addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"range-begin")).setEndKeyOpen(ByteString.copyFromUtf8((String)"range-end")));
        ReadRowsRequest actualProto = query.toProto(this.requestContext);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedProto.build());
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).range("simple-begin", "simple-end").range(ByteString.copyFromUtf8((String)"byte-begin"), ByteString.copyFromUtf8((String)"byte-end")).range(Range.ByteStringRange.create((String)"range-begin", (String)"range-end"));
        expectedProto = QueryTest.expectedReadFromAuthorizedViewProtoBuilder();
        expectedProto.getRowsBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"simple-begin")).setEndKeyOpen(ByteString.copyFromUtf8((String)"simple-end"))).addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"byte-begin")).setEndKeyOpen(ByteString.copyFromUtf8((String)"byte-end"))).addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"range-begin")).setEndKeyOpen(ByteString.copyFromUtf8((String)"range-end")));
        actualProto = query.toProto(this.requestContext);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedProto.build());
    }

    @Test
    public void filterTestWithExceptions() {
        Exception actualException = null;
        try {
            Query.create((String)TABLE_ID).filter(null);
        }
        catch (Exception ex) {
            actualException = ex;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(NullPointerException.class);
        actualException = null;
        int maxFilterSize = 20480;
        ByteString largeValue = ByteString.copyFrom((byte[])new byte[maxFilterSize + 1]);
        try {
            Query.create((String)TABLE_ID).filter(Filters.FILTERS.value().exactMatch(largeValue));
        }
        catch (Exception ex) {
            actualException = ex;
        }
        Truth.assertThat((Throwable)actualException).hasMessageThat().contains((CharSequence)"filter size can't be more than 20KB");
        actualException = null;
        try {
            Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).filter(null);
        }
        catch (Exception ex) {
            actualException = ex;
        }
        Truth.assertThat((Throwable)actualException).isInstanceOf(NullPointerException.class);
        actualException = null;
        try {
            Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).filter(Filters.FILTERS.value().exactMatch(largeValue));
        }
        catch (Exception ex) {
            actualException = ex;
        }
        Truth.assertThat((Throwable)actualException).hasMessageThat().contains((CharSequence)"filter size can't be more than 20KB");
    }

    @Test
    public void filterTest() {
        Query query = Query.create((String)TABLE_ID).filter(Filters.FILTERS.key().regex(".*"));
        ReadRowsRequest.Builder expectedProto = QueryTest.expectedReadFromTableProtoBuilder().setFilter(RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)".*")));
        ReadRowsRequest actualProto = query.toProto(this.requestContext);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedProto.build());
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).filter(Filters.FILTERS.key().regex(".*"));
        expectedProto = QueryTest.expectedReadFromAuthorizedViewProtoBuilder().setFilter(RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)".*")));
        actualProto = query.toProto(this.requestContext);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedProto.build());
    }

    @Test
    public void limitTest() {
        Query query = Query.create((String)TABLE_ID).limit(10L);
        ReadRowsRequest.Builder expectedProto = QueryTest.expectedReadFromTableProtoBuilder().setRowsLimit(10L);
        ReadRowsRequest actualProto = query.toProto(this.requestContext);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedProto.build());
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).limit(10L);
        expectedProto = QueryTest.expectedReadFromAuthorizedViewProtoBuilder().setRowsLimit(10L);
        actualProto = query.toProto(this.requestContext);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedProto.build());
    }

    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        Query expected = Query.create((String)TABLE_ID).filter(Filters.FILTERS.key().regex(".*"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        Query actual = (Query)ois.readObject();
        Truth.assertThat((Object)actual.toProto(this.requestContext)).isEqualTo((Object)expected.toProto(this.requestContext));
        expected = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).filter(Filters.FILTERS.key().regex(".*"));
        bos = new ByteArrayOutputStream();
        oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        actual = (Query)ois.readObject();
        Truth.assertThat((Object)actual.toProto(this.requestContext)).isEqualTo((Object)expected.toProto(this.requestContext));
    }

    @Test
    public void shardTestSplitPoints() {
        Query query = Query.create((String)TABLE_ID).range("a", "z");
        ImmutableSortedSet splitPoints = ImmutableSortedSet.orderedBy((Comparator)ByteStringComparator.INSTANCE).add((Object)ByteString.copyFromUtf8((String)"j")).build();
        List subQueries = query.shard((SortedSet)splitPoints);
        Truth.assertThat((Iterable)subQueries).hasSize(2);
        Truth.assertThat((Object)((Query)subQueries.get(0)).toProto(this.requestContext)).isEqualTo((Object)ReadRowsRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID).setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"j")))).build());
        Truth.assertThat((Object)((Query)subQueries.get(1)).toProto(this.requestContext)).isEqualTo((Object)ReadRowsRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID).setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"j")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")))).build());
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).range("a", "z");
        subQueries = query.shard((SortedSet)splitPoints);
        Truth.assertThat((Iterable)subQueries).hasSize(2);
        Truth.assertThat((Object)((Query)subQueries.get(0)).toProto(this.requestContext)).isEqualTo((Object)ReadRowsRequest.newBuilder().setAuthorizedViewName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).setAppProfileId(APP_PROFILE_ID).setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"j")))).build());
        Truth.assertThat((Object)((Query)subQueries.get(1)).toProto(this.requestContext)).isEqualTo((Object)ReadRowsRequest.newBuilder().setAuthorizedViewName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).setAppProfileId(APP_PROFILE_ID).setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"j")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")))).build());
    }

    @Test
    public void shardTestKeyOffsets() {
        Query query = Query.create((String)TABLE_ID).range("a", "z");
        ImmutableList keyOffsets = ImmutableList.of((Object)KeyOffset.create((ByteString)ByteString.copyFromUtf8((String)"j"), (long)10L), (Object)KeyOffset.create((ByteString)ByteString.EMPTY, (long)100L));
        List subQueries = query.shard((List)keyOffsets);
        Truth.assertThat((Iterable)subQueries).hasSize(2);
        Truth.assertThat((Object)((Query)subQueries.get(0)).toProto(this.requestContext)).isEqualTo((Object)ReadRowsRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID).setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"j")))).build());
        Truth.assertThat((Object)((Query)subQueries.get(1)).toProto(this.requestContext)).isEqualTo((Object)ReadRowsRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID).setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"j")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")))).build());
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).range("a", "z");
        subQueries = query.shard((List)keyOffsets);
        Truth.assertThat((Iterable)subQueries).hasSize(2);
        Truth.assertThat((Object)((Query)subQueries.get(0)).toProto(this.requestContext)).isEqualTo((Object)ReadRowsRequest.newBuilder().setAuthorizedViewName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).setAppProfileId(APP_PROFILE_ID).setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"j")))).build());
        Truth.assertThat((Object)((Query)subQueries.get(1)).toProto(this.requestContext)).isEqualTo((Object)ReadRowsRequest.newBuilder().setAuthorizedViewName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).setAppProfileId(APP_PROFILE_ID).setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"j")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")))).build());
    }

    private static ReadRowsRequest.Builder expectedReadFromTableProtoBuilder() {
        return ReadRowsRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID);
    }

    private static ReadRowsRequest.Builder expectedReadFromAuthorizedViewProtoBuilder() {
        return ReadRowsRequest.newBuilder().setAuthorizedViewName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).setAppProfileId(APP_PROFILE_ID);
    }

    @Test
    public void testFromProto() {
        ReadRowsRequest request = ReadRowsRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID).setFilter(RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)".*"))).setRows(RowSet.newBuilder().addRowKeys(ByteString.copyFromUtf8((String)"row-key")).addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"j")).setEndKeyClosed(ByteString.copyFromUtf8((String)"z")))).build();
        Query query = Query.fromProto((ReadRowsRequest)request);
        Truth.assertThat((Object)query.toProto(this.requestContext)).isEqualTo((Object)request);
        request = ReadRowsRequest.newBuilder().setAuthorizedViewName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).setAppProfileId(APP_PROFILE_ID).setFilter(RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)".*"))).setRows(RowSet.newBuilder().addRowKeys(ByteString.copyFromUtf8((String)"row-key")).addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"j")).setEndKeyClosed(ByteString.copyFromUtf8((String)"z")))).build();
        query = Query.fromProto((ReadRowsRequest)request);
        Truth.assertThat((Object)query.toProto(this.requestContext)).isEqualTo((Object)request);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromProtoWithInvalidTableId() {
        Query.fromProto((ReadRowsRequest)ReadRowsRequest.getDefaultInstance().toBuilder().setTableName("invalid-name").build());
        this.expect.expect(IllegalArgumentException.class);
        this.expect.expectMessage("Invalid table name:");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromProtoWithInvalidAuthorizedViewId() {
        Query.fromProto((ReadRowsRequest)ReadRowsRequest.getDefaultInstance().toBuilder().setAuthorizedViewName("invalid-name").build());
        this.expect.expect(IllegalArgumentException.class);
        this.expect.expectMessage("Invalid authorized view name:");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromProtoWithEmptyTableAndAuthorizedViewId() {
        Query.fromProto((ReadRowsRequest)ReadRowsRequest.getDefaultInstance());
        this.expect.expect(IllegalArgumentException.class);
        this.expect.expectMessage("Either table name or authorized view name must be specified");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromProtoWithBothTableAndAuthorizedViewId() {
        Query.fromProto((ReadRowsRequest)ReadRowsRequest.getDefaultInstance().toBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAuthorizedViewName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).build());
        this.expect.expect(IllegalArgumentException.class);
        this.expect.expectMessage("Table name and authorized view name cannot be specified at the same time");
    }

    @Test
    public void testEquality() {
        Query request = Query.create((String)TABLE_ID).rowKey("row-key").range("a", "z").limit(3L).filter(Filters.FILTERS.family().exactMatch("test"));
        request.toProto(this.requestContext);
        Truth.assertThat((Object)request).isEqualTo((Object)Query.create((String)TABLE_ID).rowKey("row-key").range("a", "z").limit(3L).filter(Filters.FILTERS.family().exactMatch("test")));
        Truth.assertThat((Object)Query.create((String)TABLE_ID).rowKey("row-key")).isNotEqualTo((Object)Query.create((String)TABLE_ID).rowKey("row-key-1"));
        Truth.assertThat((Object)Query.create((String)TABLE_ID).range("a", "z")).isNotEqualTo((Object)Query.create((String)TABLE_ID).range("a", "s"));
        Truth.assertThat((Object)Query.create((String)TABLE_ID).filter(Filters.FILTERS.family().regex("test"))).isNotEqualTo((Object)Query.create((String)TABLE_ID).filter(Filters.FILTERS.family().exactMatch("test-one")));
        Truth.assertThat((Object)Query.create((String)TABLE_ID).limit(4L)).isNotEqualTo((Object)Query.create((String)TABLE_ID).limit(5L));
        request = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).rowKey("row-key").range("a", "z").limit(3L).filter(Filters.FILTERS.family().exactMatch("test"));
        request.toProto(this.requestContext);
        Truth.assertThat((Object)request).isEqualTo((Object)Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).rowKey("row-key").range("a", "z").limit(3L).filter(Filters.FILTERS.family().exactMatch("test")));
        Truth.assertThat((Object)Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).rowKey("row-key")).isNotEqualTo((Object)Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).rowKey("row-key-1"));
        Truth.assertThat((Object)Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).range("a", "z")).isNotEqualTo((Object)Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).range("a", "s"));
        Truth.assertThat((Object)Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).filter(Filters.FILTERS.family().regex("test"))).isNotEqualTo((Object)Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).filter(Filters.FILTERS.family().exactMatch("test-one")));
        Truth.assertThat((Object)Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).limit(4L)).isNotEqualTo((Object)Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).limit(5L));
        Truth.assertThat((Object)Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID))).isNotEqualTo((Object)Query.create((String)TABLE_ID));
    }

    @Test
    public void testClone() {
        Query query = Query.create((String)TABLE_ID).filter(Filters.FILTERS.key().regex("temp")).limit(10L);
        ReadRowsRequest request = ReadRowsRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID).setRowsLimit(10L).setFilter(RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)"temp")).build()).build();
        Query clonedReq = query.clone();
        Truth.assertThat((Object)clonedReq).isEqualTo((Object)query);
        Truth.assertThat((Object)clonedReq.toProto(this.requestContext)).isEqualTo((Object)request);
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).filter(Filters.FILTERS.key().regex("temp")).limit(10L);
        request = ReadRowsRequest.newBuilder().setAuthorizedViewName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).setAppProfileId(APP_PROFILE_ID).setRowsLimit(10L).setFilter(RowFilter.newBuilder().setRowKeyRegexFilter(ByteString.copyFromUtf8((String)"temp")).build()).build();
        clonedReq = query.clone();
        Truth.assertThat((Object)clonedReq).isEqualTo((Object)query);
        Truth.assertThat((Object)clonedReq.toProto(this.requestContext)).isEqualTo((Object)request);
    }

    @Test
    public void testQueryPaginatorRangeLimitReached() {
        int chunkSize = 10;
        int limit = 15;
        Query query = Query.create((String)TABLE_ID).range("a", "z").limit((long)limit);
        Query.QueryPaginator paginator = query.createPaginator(chunkSize);
        Query nextQuery = paginator.getNextQuery();
        ReadRowsRequest.Builder expectedProto = QueryTest.expectedReadFromTableProtoBuilder().setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")).build())).setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"c"))).isTrue();
        int expectedLimit = limit - chunkSize;
        nextQuery = paginator.getNextQuery();
        expectedProto = QueryTest.expectedReadFromTableProtoBuilder().setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyOpen(ByteString.copyFromUtf8((String)"c")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")).build())).setRowsLimit((long)expectedLimit);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"d"))).isFalse();
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).range("a", "z").limit((long)limit);
        paginator = query.createPaginator(chunkSize);
        nextQuery = paginator.getNextQuery();
        expectedProto = QueryTest.expectedReadFromAuthorizedViewProtoBuilder().setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")).build())).setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"c"))).isTrue();
        nextQuery = paginator.getNextQuery();
        expectedProto = QueryTest.expectedReadFromAuthorizedViewProtoBuilder().setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyOpen(ByteString.copyFromUtf8((String)"c")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")).build())).setRowsLimit((long)expectedLimit);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"d"))).isFalse();
    }

    @Test
    public void testQueryPaginatorRangeLimitMultiplyOfChunkSize() {
        int chunkSize = 10;
        int limit = 20;
        Query query = Query.create((String)TABLE_ID).range("a", "z").limit((long)limit);
        Query.QueryPaginator paginator = query.createPaginator(chunkSize);
        Query nextQuery = paginator.getNextQuery();
        ReadRowsRequest.Builder expectedProto = QueryTest.expectedReadFromTableProtoBuilder().setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")).build())).setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"c"))).isTrue();
        int expectedLimit = limit - chunkSize;
        nextQuery = paginator.getNextQuery();
        expectedProto = QueryTest.expectedReadFromTableProtoBuilder().setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyOpen(ByteString.copyFromUtf8((String)"c")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")).build())).setRowsLimit((long)expectedLimit);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"d"))).isFalse();
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).range("a", "z").limit((long)limit);
        paginator = query.createPaginator(chunkSize);
        nextQuery = paginator.getNextQuery();
        expectedProto = QueryTest.expectedReadFromAuthorizedViewProtoBuilder().setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")).build())).setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"c"))).isTrue();
        nextQuery = paginator.getNextQuery();
        expectedProto = QueryTest.expectedReadFromAuthorizedViewProtoBuilder().setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyOpen(ByteString.copyFromUtf8((String)"c")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")).build())).setRowsLimit((long)expectedLimit);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"d"))).isFalse();
    }

    @Test
    public void testQueryPaginatorRagneNoLimit() {
        int chunkSize = 10;
        Query query = Query.create((String)TABLE_ID).range("a", "z");
        Query.QueryPaginator paginator = query.createPaginator(chunkSize);
        Query nextQuery = paginator.getNextQuery();
        ReadRowsRequest.Builder expectedProto = QueryTest.expectedReadFromTableProtoBuilder().setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")).build())).setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"c"))).isTrue();
        nextQuery = paginator.getNextQuery();
        expectedProto.setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyOpen(ByteString.copyFromUtf8((String)"c")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")).build())).setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"z"))).isFalse();
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).range("a", "z");
        paginator = query.createPaginator(chunkSize);
        nextQuery = paginator.getNextQuery();
        expectedProto = QueryTest.expectedReadFromAuthorizedViewProtoBuilder().setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"a")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")).build())).setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"c"))).isTrue();
        nextQuery = paginator.getNextQuery();
        expectedProto.setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyOpen(ByteString.copyFromUtf8((String)"c")).setEndKeyOpen(ByteString.copyFromUtf8((String)"z")).build())).setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"z"))).isFalse();
    }

    @Test
    public void testQueryPaginatorRowsNoLimit() {
        int chunkSize = 10;
        Query query = Query.create((String)TABLE_ID).rowKey("a").rowKey("b").rowKey("c");
        Query.QueryPaginator paginator = query.createPaginator(chunkSize);
        Query nextQuery = paginator.getNextQuery();
        ReadRowsRequest.Builder expectedProto = QueryTest.expectedReadFromTableProtoBuilder();
        expectedProto.getRowsBuilder().addRowKeys(ByteString.copyFromUtf8((String)"a")).addRowKeys(ByteString.copyFromUtf8((String)"b")).addRowKeys(ByteString.copyFromUtf8((String)"c"));
        expectedProto.setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        paginator.advance(ByteString.copyFromUtf8((String)"b"));
        nextQuery = paginator.getNextQuery();
        expectedProto = QueryTest.expectedReadFromTableProtoBuilder();
        expectedProto.getRowsBuilder().addRowKeys(ByteString.copyFromUtf8((String)"c"));
        expectedProto.setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"c"))).isFalse();
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).rowKey("a").rowKey("b").rowKey("c");
        paginator = query.createPaginator(chunkSize);
        nextQuery = paginator.getNextQuery();
        expectedProto = QueryTest.expectedReadFromAuthorizedViewProtoBuilder();
        expectedProto.getRowsBuilder().addRowKeys(ByteString.copyFromUtf8((String)"a")).addRowKeys(ByteString.copyFromUtf8((String)"b")).addRowKeys(ByteString.copyFromUtf8((String)"c"));
        expectedProto.setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        paginator.advance(ByteString.copyFromUtf8((String)"b"));
        nextQuery = paginator.getNextQuery();
        expectedProto = QueryTest.expectedReadFromAuthorizedViewProtoBuilder();
        expectedProto.getRowsBuilder().addRowKeys(ByteString.copyFromUtf8((String)"c"));
        expectedProto.setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)nextQuery.toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)paginator.advance(ByteString.copyFromUtf8((String)"c"))).isFalse();
    }

    @Test
    public void testQueryPaginatorFullTableScan() {
        int chunkSize = 10;
        Query query = Query.create((String)TABLE_ID);
        Query.QueryPaginator queryPaginator = query.createPaginator(chunkSize);
        ReadRowsRequest.Builder expectedProto = QueryTest.expectedReadFromTableProtoBuilder().setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)queryPaginator.getNextQuery().toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)queryPaginator.advance(ByteString.copyFromUtf8((String)"a"))).isTrue();
        expectedProto.setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyOpen(ByteString.copyFromUtf8((String)"a")).build())).setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)queryPaginator.getNextQuery().toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)queryPaginator.advance(ByteString.copyFromUtf8((String)"a"))).isFalse();
        query = Query.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID));
        queryPaginator = query.createPaginator(chunkSize);
        expectedProto = QueryTest.expectedReadFromAuthorizedViewProtoBuilder().setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)queryPaginator.getNextQuery().toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)queryPaginator.advance(ByteString.copyFromUtf8((String)"a"))).isTrue();
        expectedProto.setRows(RowSet.newBuilder().addRowRanges(RowRange.newBuilder().setStartKeyOpen(ByteString.copyFromUtf8((String)"a")).build())).setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)queryPaginator.getNextQuery().toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)queryPaginator.advance(ByteString.copyFromUtf8((String)"a"))).isFalse();
    }

    @Test
    public void testQueryPaginatorEmptyTable() {
        int chunkSize = 10;
        Query query = Query.create((String)TABLE_ID);
        Query.QueryPaginator queryPaginator = query.createPaginator(chunkSize);
        ReadRowsRequest.Builder expectedProto = QueryTest.expectedReadFromTableProtoBuilder().setRowsLimit((long)chunkSize);
        Truth.assertThat((Object)queryPaginator.getNextQuery().toProto(this.requestContext)).isEqualTo((Object)expectedProto.build());
        Truth.assertThat((Boolean)queryPaginator.advance(ByteString.EMPTY)).isFalse();
    }

    @Test
    public void testQueryReversed() {
        Query query = Query.create((String)TABLE_ID).reversed(true);
        Truth.assertThat((Object)query.toProto(this.requestContext)).isEqualTo((Object)QueryTest.expectedReadFromTableProtoBuilder().setReversed(true).build());
    }
}

