/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RangeTest {
    @Test
    public void timestampUnboundedTest() {
        Range.TimestampRange range = Range.TimestampRange.unbounded();
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.UNBOUNDED);
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.UNBOUNDED);
        Throwable actualError = null;
        try {
            range.getStart();
        }
        catch (Throwable e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
        try {
            range.getEnd();
        }
        catch (Throwable e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void timestampOfTest() {
        Range.TimestampRange range = Range.TimestampRange.create((long)10L, (long)2000L);
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.CLOSED);
        Truth.assertThat((Long)((Long)range.getStart())).isEqualTo((Object)10);
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.OPEN);
        Truth.assertThat((Long)((Long)range.getEnd())).isEqualTo((Object)2000);
    }

    @Test
    public void timestampChangeStartTest() {
        Range.TimestampRange range = (Range.TimestampRange)Range.TimestampRange.create((long)10L, (long)2000L).startOpen((Object)20L);
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.OPEN);
        Truth.assertThat((Long)((Long)range.getEnd())).isEqualTo((Object)2000);
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.OPEN);
        Truth.assertThat((Long)((Long)range.getStart())).isEqualTo((Object)20);
        range = (Range.TimestampRange)range.startClosed((Object)30L);
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.CLOSED);
        Truth.assertThat((Long)((Long)range.getStart())).isEqualTo((Object)30);
    }

    @Test
    public void timestampChangeEndTest() {
        Range.TimestampRange range = (Range.TimestampRange)Range.TimestampRange.create((long)10L, (long)2000L).endClosed((Object)1000L);
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.CLOSED);
        Truth.assertThat((Long)((Long)range.getStart())).isEqualTo((Object)10);
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.CLOSED);
        Truth.assertThat((Long)((Long)range.getEnd())).isEqualTo((Object)1000);
        range = (Range.TimestampRange)range.endOpen((Object)3000L);
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.OPEN);
        Truth.assertThat((Long)((Long)range.getEnd())).isEqualTo((Object)3000);
    }

    @Test
    public void timestampCloneTest() {
        Range.TimestampRange range = Range.TimestampRange.create((long)10L, (long)2000L);
        Range.TimestampRange rangeSame = (Range.TimestampRange)range.endClosed((Object)3000L);
        Range.TimestampRange rangeClone = (Range.TimestampRange)((Range.TimestampRange)range.clone()).endClosed((Object)4000L);
        Truth.assertThat((Long)((Long)range.getEnd())).isEqualTo((Object)3000);
        Truth.assertThat((Long)((Long)rangeSame.getEnd())).isEqualTo((Object)3000);
        Truth.assertThat((Long)((Long)rangeClone.getEnd())).isEqualTo((Object)4000);
    }

    @Test
    public void timestampEqualsTest() {
        Range.TimestampRange r1 = Range.TimestampRange.create((long)1L, (long)10L);
        Range.TimestampRange r2 = Range.TimestampRange.create((long)1L, (long)10L);
        Range.TimestampRange r3 = Range.TimestampRange.create((long)2L, (long)20L);
        Truth.assertThat((Object)r1).isEqualTo((Object)r2);
        Truth.assertThat((Object)r2).isEqualTo((Object)r1);
        Truth.assertThat((Object)r1).isNotEqualTo((Object)r3);
    }

    @Test
    public void timestampSerializationTest() throws IOException, ClassNotFoundException {
        Range.TimestampRange expected = Range.TimestampRange.create((long)10L, (long)20L);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        Range.TimestampRange actual = (Range.TimestampRange)ois.readObject();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void byteStringUnboundedTest() {
        Range.ByteStringRange range = Range.ByteStringRange.unbounded();
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.UNBOUNDED);
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.UNBOUNDED);
        Throwable actualError = null;
        try {
            range.getStart();
        }
        catch (Throwable e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
        try {
            range.getEnd();
        }
        catch (Throwable e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void byteStringOfTest() {
        Range.ByteStringRange range = Range.ByteStringRange.create((ByteString)ByteString.copyFromUtf8((String)"a"), (ByteString)ByteString.copyFromUtf8((String)"b"));
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.CLOSED);
        Truth.assertThat((Iterable)((Iterable)range.getStart())).isEqualTo((Object)ByteString.copyFromUtf8((String)"a"));
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.OPEN);
        Truth.assertThat((Iterable)((Iterable)range.getEnd())).isEqualTo((Object)ByteString.copyFromUtf8((String)"b"));
    }

    @Test
    public void byteStringOfStringTest() {
        Range.ByteStringRange range = Range.ByteStringRange.create((String)"a", (String)"b");
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.CLOSED);
        Truth.assertThat((Iterable)((Iterable)range.getStart())).isEqualTo((Object)ByteString.copyFromUtf8((String)"a"));
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.OPEN);
        Truth.assertThat((Iterable)((Iterable)range.getEnd())).isEqualTo((Object)ByteString.copyFromUtf8((String)"b"));
    }

    @Test
    public void byteStringPrefixTest() {
        Truth.assertThat((Object)Range.ByteStringRange.prefix((String)"a")).isEqualTo((Object)Range.ByteStringRange.create((String)"a", (String)"b"));
        Truth.assertThat((Object)Range.ByteStringRange.prefix((String)"ab")).isEqualTo((Object)Range.ByteStringRange.create((String)"ab", (String)"ac"));
        ByteString prefix2 = ByteString.copyFrom((byte[])new byte[]{97, -1});
        Truth.assertThat((Object)Range.ByteStringRange.prefix((ByteString)prefix2)).isEqualTo((Object)Range.ByteStringRange.create((ByteString)prefix2, (ByteString)ByteString.copyFromUtf8((String)"b")));
        ByteString prefix3 = ByteString.copyFrom((byte[])new byte[]{-1, -1});
        Truth.assertThat((Object)Range.ByteStringRange.prefix((ByteString)prefix3)).isEqualTo((Object)Range.ByteStringRange.unbounded().startClosed(prefix3));
        Truth.assertThat((Object)Range.ByteStringRange.prefix((ByteString)ByteString.EMPTY)).isEqualTo((Object)Range.ByteStringRange.unbounded());
    }

    @Test
    public void byteStringChangeStartTest() {
        Range.ByteStringRange range = (Range.ByteStringRange)Range.ByteStringRange.create((ByteString)ByteString.copyFromUtf8((String)"a"), (ByteString)ByteString.copyFromUtf8((String)"z")).startOpen(ByteString.copyFromUtf8((String)"b"));
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.OPEN);
        Truth.assertThat((Iterable)((Iterable)range.getEnd())).isEqualTo((Object)ByteString.copyFromUtf8((String)"z"));
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.OPEN);
        Truth.assertThat((Iterable)((Iterable)range.getStart())).isEqualTo((Object)ByteString.copyFromUtf8((String)"b"));
        range = (Range.ByteStringRange)range.startClosed(ByteString.copyFromUtf8((String)"c"));
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.CLOSED);
        Truth.assertThat((Iterable)((Iterable)range.getStart())).isEqualTo((Object)ByteString.copyFromUtf8((String)"c"));
        Truth.assertThat((Comparable)((Range.ByteStringRange)range.startOpen(ByteString.EMPTY)).getStartBound()).isEqualTo((Object)Range.BoundType.UNBOUNDED);
        Truth.assertThat((Comparable)((Range.ByteStringRange)range.startClosed(ByteString.EMPTY)).getStartBound()).isEqualTo((Object)Range.BoundType.UNBOUNDED);
    }

    @Test
    public void byteStringChangeStartStringTest() {
        Range.ByteStringRange range = (Range.ByteStringRange)Range.ByteStringRange.create((String)"a", (String)"z").startOpen("b");
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.OPEN);
        Truth.assertThat((Iterable)((Iterable)range.getEnd())).isEqualTo((Object)ByteString.copyFromUtf8((String)"z"));
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.OPEN);
        Truth.assertThat((Iterable)((Iterable)range.getStart())).isEqualTo((Object)ByteString.copyFromUtf8((String)"b"));
        range = (Range.ByteStringRange)range.startClosed("c");
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.CLOSED);
        Truth.assertThat((Iterable)((Iterable)range.getStart())).isEqualTo((Object)ByteString.copyFromUtf8((String)"c"));
        Truth.assertThat((Comparable)((Range.ByteStringRange)range.startOpen("")).getStartBound()).isEqualTo((Object)Range.BoundType.UNBOUNDED);
        Truth.assertThat((Comparable)((Range.ByteStringRange)range.startClosed("")).getStartBound()).isEqualTo((Object)Range.BoundType.UNBOUNDED);
    }

    @Test
    public void byteStringChangeEndTest() {
        Range.ByteStringRange range = (Range.ByteStringRange)Range.ByteStringRange.create((ByteString)ByteString.copyFromUtf8((String)"a"), (ByteString)ByteString.copyFromUtf8((String)"z")).endClosed(ByteString.copyFromUtf8((String)"y"));
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.CLOSED);
        Truth.assertThat((Iterable)((Iterable)range.getStart())).isEqualTo((Object)ByteString.copyFromUtf8((String)"a"));
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.CLOSED);
        Truth.assertThat((Iterable)((Iterable)range.getEnd())).isEqualTo((Object)ByteString.copyFromUtf8((String)"y"));
        range = (Range.ByteStringRange)range.endOpen(ByteString.copyFromUtf8((String)"x"));
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.OPEN);
        Truth.assertThat((Iterable)((Iterable)range.getEnd())).isEqualTo((Object)ByteString.copyFromUtf8((String)"x"));
        Truth.assertThat((Comparable)((Range.ByteStringRange)range.endOpen(ByteString.EMPTY)).getEndBound()).isEqualTo((Object)Range.BoundType.UNBOUNDED);
        Truth.assertThat((Comparable)((Range.ByteStringRange)range.endClosed(ByteString.EMPTY)).getEndBound()).isEqualTo((Object)Range.BoundType.UNBOUNDED);
    }

    @Test
    public void byteStringChangeEndStringTest() {
        Range.ByteStringRange range = (Range.ByteStringRange)Range.ByteStringRange.create((String)"a", (String)"z").endClosed("y");
        Truth.assertThat((Comparable)range.getStartBound()).isEqualTo((Object)Range.BoundType.CLOSED);
        Truth.assertThat((Iterable)((Iterable)range.getStart())).isEqualTo((Object)ByteString.copyFromUtf8((String)"a"));
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.CLOSED);
        Truth.assertThat((Iterable)((Iterable)range.getEnd())).isEqualTo((Object)ByteString.copyFromUtf8((String)"y"));
        range = (Range.ByteStringRange)range.endOpen("x");
        Truth.assertThat((Comparable)range.getEndBound()).isEqualTo((Object)Range.BoundType.OPEN);
        Truth.assertThat((Iterable)((Iterable)range.getEnd())).isEqualTo((Object)ByteString.copyFromUtf8((String)"x"));
        Truth.assertThat((Comparable)((Range.ByteStringRange)range.endOpen("")).getEndBound()).isEqualTo((Object)Range.BoundType.UNBOUNDED);
        Truth.assertThat((Comparable)((Range.ByteStringRange)range.endClosed("")).getEndBound()).isEqualTo((Object)Range.BoundType.UNBOUNDED);
    }

    @Test
    public void byteStringCloneTest() {
        Range.ByteStringRange range = Range.ByteStringRange.create((String)"a", (String)"original");
        Range.ByteStringRange rangeSame = (Range.ByteStringRange)range.endClosed("sameInstance");
        Range.ByteStringRange rangeClone = (Range.ByteStringRange)((Range.ByteStringRange)range.clone()).endClosed("cloneInstance");
        Truth.assertThat((String)((ByteString)range.getEnd()).toStringUtf8()).isEqualTo((Object)"sameInstance");
        Truth.assertThat((String)((ByteString)rangeSame.getEnd()).toStringUtf8()).isEqualTo((Object)"sameInstance");
        Truth.assertThat((String)((ByteString)rangeClone.getEnd()).toStringUtf8()).isEqualTo((Object)"cloneInstance");
    }

    @Test
    public void byteStringEqualsTest() {
        Range.ByteStringRange r1 = Range.ByteStringRange.create((String)"a", (String)"c");
        Range.ByteStringRange r2 = Range.ByteStringRange.create((String)"a", (String)"c");
        Range.ByteStringRange r3 = Range.ByteStringRange.create((String)"q", (String)"z");
        Truth.assertThat((Object)r1).isEqualTo((Object)r2);
        Truth.assertThat((Object)r2).isEqualTo((Object)r1);
        Truth.assertThat((Object)r1).isNotEqualTo((Object)r3);
    }

    @Test
    public void byteStringSerializationTest() throws IOException, ClassNotFoundException {
        Range.ByteStringRange expected = Range.ByteStringRange.create((String)"a", (String)"z");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        Range.ByteStringRange actual = (Range.ByteStringRange)ois.readObject();
        Truth.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    public void byteStringRangeToByteStringTest() throws InvalidProtocolBufferException {
        Range.ByteStringRange expected = Range.ByteStringRange.create((String)"a", (String)"z");
        ByteString serialized = Range.ByteStringRange.serializeToByteString((Range.ByteStringRange)expected);
        Range.ByteStringRange deserialized = Range.ByteStringRange.toByteStringRange((ByteString)serialized);
        Truth.assertThat((Object)expected).isEqualTo((Object)deserialized);
    }
}

