/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.StreamContinuationToken;
import com.google.bigtable.v2.StreamContinuationTokens;
import com.google.bigtable.v2.StreamPartition;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.ReadChangeStreamQuery;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Instant;
import java.util.Collections;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadChangeStreamQueryTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "fake-table";
    private static final String APP_PROFILE_ID = "fake-profile-id";
    private RequestContext requestContext;
    private static final Instant FAKE_START_TIME = Instant.ofEpochSecond(1L, 1000L);
    private static final Instant FAKE_END_TIME = Instant.ofEpochSecond(1L, 2000L);
    @Rule
    public ExpectedException expect = ExpectedException.none();

    @Before
    public void setUp() {
        this.requestContext = RequestContext.create((String)PROJECT_ID, (String)INSTANCE_ID, (String)APP_PROFILE_ID);
    }

    @Test
    public void requestContextTest() {
        ReadChangeStreamQuery query = ReadChangeStreamQuery.create((String)TABLE_ID);
        ReadChangeStreamRequest proto = query.toProto(this.requestContext);
        Truth.assertThat((Object)proto).isEqualTo((Object)ReadChangeStreamQueryTest.expectedProtoBuilder().build());
    }

    @Test
    public void streamPartitionTest() {
        ReadChangeStreamQuery query1 = ReadChangeStreamQuery.create((String)TABLE_ID).streamPartition("simple-begin", "simple-end");
        ReadChangeStreamRequest actualProto1 = query1.toProto(this.requestContext);
        ReadChangeStreamRequest.Builder expectedProto1 = ReadChangeStreamQueryTest.expectedProtoBuilder();
        expectedProto1.setPartition(StreamPartition.newBuilder().setRowRange(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"simple-begin")).setEndKeyOpen(ByteString.copyFromUtf8((String)"simple-end")).build()).build());
        Truth.assertThat((Object)actualProto1).isEqualTo((Object)expectedProto1.build());
        ReadChangeStreamQuery query2 = ReadChangeStreamQuery.create((String)TABLE_ID).streamPartition(ByteString.copyFromUtf8((String)"byte-begin"), ByteString.copyFromUtf8((String)"byte-end"));
        ReadChangeStreamRequest actualProto2 = query2.toProto(this.requestContext);
        ReadChangeStreamRequest.Builder expectedProto2 = ReadChangeStreamQueryTest.expectedProtoBuilder();
        expectedProto2.setPartition(StreamPartition.newBuilder().setRowRange(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"byte-begin")).setEndKeyOpen(ByteString.copyFromUtf8((String)"byte-end")).build()).build());
        Truth.assertThat((Object)actualProto2).isEqualTo((Object)expectedProto2.build());
        ReadChangeStreamQuery query3 = ReadChangeStreamQuery.create((String)TABLE_ID).streamPartition(Range.ByteStringRange.create((String)"range-begin", (String)"range-end"));
        ReadChangeStreamRequest actualProto3 = query3.toProto(this.requestContext);
        ReadChangeStreamRequest.Builder expectedProto3 = ReadChangeStreamQueryTest.expectedProtoBuilder();
        expectedProto3.setPartition(StreamPartition.newBuilder().setRowRange(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"range-begin")).setEndKeyOpen(ByteString.copyFromUtf8((String)"range-end")).build()).build());
        Truth.assertThat((Object)actualProto3).isEqualTo((Object)expectedProto3.build());
    }

    @Test
    public void startTimeTest() {
        ReadChangeStreamQuery query = ReadChangeStreamQuery.create((String)TABLE_ID).startTime(FAKE_START_TIME);
        ReadChangeStreamRequest.Builder expectedProto = ReadChangeStreamQueryTest.expectedProtoBuilder().setStartTime(Timestamp.newBuilder().setSeconds(FAKE_START_TIME.getEpochSecond()).setNanos(FAKE_START_TIME.getNano()));
        ReadChangeStreamRequest actualProto = query.toProto(this.requestContext);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedProto.build());
    }

    @Test
    public void endTimeTest() {
        ReadChangeStreamQuery query = ReadChangeStreamQuery.create((String)TABLE_ID).endTime(FAKE_END_TIME);
        ReadChangeStreamRequest.Builder expectedProto = ReadChangeStreamQueryTest.expectedProtoBuilder().setEndTime(Timestamp.newBuilder().setSeconds(FAKE_END_TIME.getEpochSecond()).setNanos(FAKE_END_TIME.getNano()));
        ReadChangeStreamRequest actualProto = query.toProto(this.requestContext);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedProto.build());
    }

    @Test
    public void heartbeatDurationTest() {
        ReadChangeStreamQuery query = ReadChangeStreamQuery.create((String)TABLE_ID).heartbeatDuration(java.time.Duration.ofSeconds(5L));
        ReadChangeStreamRequest.Builder expectedProto = ReadChangeStreamQueryTest.expectedProtoBuilder().setHeartbeatDuration(Duration.newBuilder().setSeconds(5L).build());
        ReadChangeStreamRequest actualProto = query.toProto(this.requestContext);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedProto.build());
    }

    @Test
    public void continuationTokensTest() {
        StreamContinuationToken tokenProto = StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"start")).setEndKeyOpen(ByteString.copyFromUtf8((String)"end")).build()).build()).setToken("random-token").build();
        ChangeStreamContinuationToken token = ChangeStreamContinuationToken.fromProto((StreamContinuationToken)tokenProto);
        ReadChangeStreamQuery query = ReadChangeStreamQuery.create((String)TABLE_ID).continuationTokens(Collections.singletonList(token));
        ReadChangeStreamRequest.Builder expectedProto = ReadChangeStreamQueryTest.expectedProtoBuilder().setContinuationTokens(StreamContinuationTokens.newBuilder().addTokens(tokenProto).build());
        ReadChangeStreamRequest actualProto = query.toProto(this.requestContext);
        Truth.assertThat((Object)actualProto).isEqualTo((Object)expectedProto.build());
    }

    @Test(expected=IllegalStateException.class)
    public void createWithStartTimeAndContinuationTokensTest() {
        StreamContinuationToken tokenProto = StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"start")).setEndKeyOpen(ByteString.copyFromUtf8((String)"end")).build()).build()).setToken("random-token").build();
        ChangeStreamContinuationToken token = ChangeStreamContinuationToken.fromProto((StreamContinuationToken)tokenProto);
        ReadChangeStreamQuery query = ReadChangeStreamQuery.create((String)TABLE_ID).startTime(FAKE_START_TIME).continuationTokens(Collections.singletonList(token));
        this.expect.expect(IllegalArgumentException.class);
        this.expect.expectMessage("startTime and continuationTokens can't be specified together");
    }

    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        StreamContinuationToken tokenProto = StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"start")).setEndKeyOpen(ByteString.copyFromUtf8((String)"end")).build()).build()).setToken("random-token").build();
        ChangeStreamContinuationToken token = ChangeStreamContinuationToken.fromProto((StreamContinuationToken)tokenProto);
        ReadChangeStreamQuery expected = ReadChangeStreamQuery.create((String)TABLE_ID).streamPartition("simple-begin", "simple-end").continuationTokens(Collections.singletonList(token)).endTime(FAKE_END_TIME).heartbeatDuration(java.time.Duration.ofSeconds(5L));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        ReadChangeStreamQuery actual = (ReadChangeStreamQuery)ois.readObject();
        Truth.assertThat((Object)actual.toProto(this.requestContext)).isEqualTo((Object)expected.toProto(this.requestContext));
    }

    private static ReadChangeStreamRequest.Builder expectedProtoBuilder() {
        return ReadChangeStreamRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID);
    }

    @Test
    public void testFromProto() {
        StreamContinuationToken token = StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"")).setEndKeyOpen(ByteString.copyFromUtf8((String)"")).build()).build()).setToken("random-token").build();
        ReadChangeStreamRequest request = ReadChangeStreamRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID).setPartition(StreamPartition.newBuilder().setRowRange(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"")).setEndKeyClosed(ByteString.copyFromUtf8((String)"")).build())).setContinuationTokens(StreamContinuationTokens.newBuilder().addTokens(token).build()).setEndTime(Timestamp.newBuilder().setSeconds(FAKE_END_TIME.getEpochSecond()).setNanos(FAKE_END_TIME.getNano())).setHeartbeatDuration(Duration.newBuilder().setSeconds(5L).build()).build();
        ReadChangeStreamQuery query = ReadChangeStreamQuery.fromProto((ReadChangeStreamRequest)request);
        Truth.assertThat((Object)query.toProto(this.requestContext)).isEqualTo((Object)request);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromProtoWithEmptyTableId() {
        ReadChangeStreamQuery.fromProto((ReadChangeStreamRequest)ReadChangeStreamRequest.getDefaultInstance());
        this.expect.expect(IllegalArgumentException.class);
        this.expect.expectMessage("Invalid table name:");
    }

    @Test
    public void testEquality() {
        ReadChangeStreamQuery request = ReadChangeStreamQuery.create((String)TABLE_ID).streamPartition("simple-begin", "simple-end").startTime(FAKE_START_TIME).endTime(FAKE_END_TIME).heartbeatDuration(java.time.Duration.ofSeconds(5L));
        request.toProto(this.requestContext);
        Truth.assertThat((Object)request).isEqualTo((Object)ReadChangeStreamQuery.create((String)TABLE_ID).streamPartition("simple-begin", "simple-end").startTime(FAKE_START_TIME).endTime(FAKE_END_TIME).heartbeatDuration(java.time.Duration.ofSeconds(5L)));
        Truth.assertThat((Object)ReadChangeStreamQuery.create((String)TABLE_ID).streamPartition("begin-1", "end-1")).isNotEqualTo((Object)ReadChangeStreamQuery.create((String)TABLE_ID).streamPartition("begin-2", "end-1"));
        Truth.assertThat((Object)ReadChangeStreamQuery.create((String)TABLE_ID).startTime(FAKE_START_TIME)).isNotEqualTo((Object)ReadChangeStreamQuery.create((String)TABLE_ID).startTime(Instant.ofEpochSecond(1L, 1001L)));
        Truth.assertThat((Object)ReadChangeStreamQuery.create((String)TABLE_ID).endTime(FAKE_END_TIME)).isNotEqualTo((Object)ReadChangeStreamQuery.create((String)TABLE_ID).endTime(Instant.ofEpochSecond(1L, 1001L)));
        Truth.assertThat((Object)ReadChangeStreamQuery.create((String)TABLE_ID).heartbeatDuration(java.time.Duration.ofSeconds(5L))).isNotEqualTo((Object)ReadChangeStreamQuery.create((String)TABLE_ID).heartbeatDuration(java.time.Duration.ofSeconds(6L)));
    }

    @Test
    public void testClone() {
        StreamContinuationToken tokenProto = StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"start")).setEndKeyOpen(ByteString.copyFromUtf8((String)"end")).build()).build()).setToken("random-token").build();
        ChangeStreamContinuationToken token = ChangeStreamContinuationToken.fromProto((StreamContinuationToken)tokenProto);
        ReadChangeStreamQuery query = ReadChangeStreamQuery.create((String)TABLE_ID).streamPartition("begin", "end").continuationTokens(Collections.singletonList(token)).endTime(FAKE_END_TIME).heartbeatDuration(java.time.Duration.ofSeconds(5L));
        ReadChangeStreamRequest request = ReadChangeStreamRequest.newBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAppProfileId(APP_PROFILE_ID).setPartition(StreamPartition.newBuilder().setRowRange(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"begin")).setEndKeyOpen(ByteString.copyFromUtf8((String)"end")).build())).setContinuationTokens(StreamContinuationTokens.newBuilder().addTokens(tokenProto).build()).setEndTime(Timestamp.newBuilder().setSeconds(FAKE_END_TIME.getEpochSecond()).setNanos(FAKE_END_TIME.getNano())).setHeartbeatDuration(Duration.newBuilder().setSeconds(5L).build()).build();
        ReadChangeStreamQuery clonedReq = query.clone();
        Truth.assertThat((Object)clonedReq).isEqualTo((Object)query);
        Truth.assertThat((Object)clonedReq.toProto(this.requestContext)).isEqualTo((Object)request);
    }
}

