/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.LazyStringArrayList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RowCellTest {
    @Test
    public void compareTest() {
        ByteString col1 = ByteString.copyFromUtf8((String)"col1");
        long timestamp1 = 1000L;
        ImmutableList labels1 = ImmutableList.of((Object)"label1");
        ByteString value1 = ByteString.copyFromUtf8((String)"value1");
        ByteString col2 = ByteString.copyFromUtf8((String)"col2");
        long timestamp2 = 2000L;
        ImmutableList labels2 = ImmutableList.of((Object)"label2");
        ByteString value2 = ByteString.copyFromUtf8((String)"value2");
        Comparator c = RowCell.compareByNative();
        Truth.assertThat((Integer)c.compare(RowCell.create((String)"family1", (ByteString)col1, (long)timestamp1, (List)labels1, (ByteString)value1), RowCell.create((String)"family1", (ByteString)col1, (long)timestamp1, (List)labels1, (ByteString)value1))).isEqualTo((Object)0);
        Truth.assertThat((Integer)c.compare(RowCell.create((String)"family1", (ByteString)col1, (long)timestamp1, (List)labels1, (ByteString)value1), RowCell.create((String)"family1", (ByteString)col1, (long)timestamp1, (List)labels2, (ByteString)value2))).isEqualTo((Object)0);
        Truth.assertThat((Integer)c.compare(RowCell.create((String)"family1", (ByteString)col1, (long)timestamp1, (List)labels1, (ByteString)value1), RowCell.create((String)"family2", (ByteString)col1, (long)timestamp1, (List)labels1, (ByteString)value1))).isEqualTo((Object)-1);
        Truth.assertThat((Integer)c.compare(RowCell.create((String)"family2", (ByteString)col1, (long)timestamp1, (List)labels1, (ByteString)value1), RowCell.create((String)"family1", (ByteString)col1, (long)timestamp1, (List)labels1, (ByteString)value1))).isEqualTo((Object)1);
        Truth.assertThat((Integer)c.compare(RowCell.create((String)"family1", (ByteString)col1, (long)timestamp1, (List)labels1, (ByteString)value1), RowCell.create((String)"family1", (ByteString)col2, (long)timestamp1, (List)labels1, (ByteString)value1))).isEqualTo((Object)-1);
        Truth.assertThat((Integer)c.compare(RowCell.create((String)"family1", (ByteString)col2, (long)timestamp1, (List)labels1, (ByteString)value1), RowCell.create((String)"family1", (ByteString)col1, (long)timestamp1, (List)labels1, (ByteString)value1))).isEqualTo((Object)1);
        Truth.assertThat((Integer)c.compare(RowCell.create((String)"family1", (ByteString)col1, (long)timestamp2, (List)labels1, (ByteString)value1), RowCell.create((String)"family1", (ByteString)col1, (long)timestamp1, (List)labels1, (ByteString)value1))).isEqualTo((Object)-1);
        Truth.assertThat((Integer)c.compare(RowCell.create((String)"family1", (ByteString)col1, (long)timestamp1, (List)labels1, (ByteString)value1), RowCell.create((String)"family1", (ByteString)col1, (long)timestamp2, (List)labels1, (ByteString)value1))).isEqualTo((Object)1);
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        LazyStringArrayList lazyListNonEmpty = new LazyStringArrayList((List)ImmutableList.of((Object)"lazy", (Object)"very lazy"));
        lazyListNonEmpty.makeImmutable();
        LazyStringArrayList lazyListEmpty = LazyStringArrayList.emptyList();
        lazyListEmpty.makeImmutable();
        List[] labelLists = new List[]{Arrays.asList("str1", "str2", "str3"), ImmutableList.of((Object)"string1", (Object)"string2"), lazyListNonEmpty, lazyListEmpty};
        for (int i = 0; i < labelLists.length; ++i) {
            String family = "family_" + i;
            ByteString col = ByteString.copyFromUtf8((String)("col_" + i));
            long timestamp = 1000L * (long)(i + 1);
            List labels = labelLists[i];
            ByteString value = ByteString.copyFromUtf8((String)("value_" + i));
            RowCell cell = RowCell.create((String)family, (ByteString)col, (long)timestamp, (List)labels, (ByteString)value);
            RowCell deserialized = (RowCell)RowCellTest.serializeDeserialize(cell);
            Truth.assertThat((String)cell.getFamily()).isEqualTo((Object)deserialized.getFamily());
            Truth.assertThat((Iterable)cell.getQualifier()).isEqualTo((Object)deserialized.getQualifier());
            Truth.assertThat((Long)cell.getTimestamp()).isEqualTo((Object)deserialized.getTimestamp());
            Truth.assertThat((Iterable)cell.getLabels()).isEqualTo((Object)deserialized.getLabels());
            Truth.assertThat((Iterable)cell.getValue()).isEqualTo((Object)deserialized.getValue());
        }
    }

    private static Object serializeDeserialize(Object obj) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ObjectOutputStream outStream = new ObjectOutputStream(bos);){
            outStream.writeObject(obj);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        try (ObjectInputStream inStream = new ObjectInputStream(bis);){
            Object object = inStream.readObject();
            return object;
        }
    }
}

