/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RowTest {
    @Test
    public void compareTest() {
        Row row1 = Row.create((ByteString)ByteString.copyFromUtf8((String)"key1"), (List)ImmutableList.of((Object)RowCell.create((String)"family", (ByteString)ByteString.EMPTY, (long)1000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"value"))));
        Row row2 = Row.create((ByteString)ByteString.copyFromUtf8((String)"key2"), (List)ImmutableList.of((Object)RowCell.create((String)"family", (ByteString)ByteString.EMPTY, (long)1000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"value"))));
        Row row2b = Row.create((ByteString)ByteString.copyFromUtf8((String)"key2"), (List)ImmutableList.of((Object)RowCell.create((String)"family2", (ByteString)ByteString.EMPTY, (long)1000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"value"))));
        Truth.assertThat((Integer)Row.compareByKey().compare(row1, row2)).isEqualTo((Object)-1);
        Truth.assertThat((Integer)Row.compareByKey().compare(row2, row1)).isEqualTo((Object)1);
        Truth.assertThat((Integer)Row.compareByKey().compare(row2, row2b)).isEqualTo((Object)0);
    }

    @Test
    public void serializationTest() throws IOException, ClassNotFoundException {
        Row expected = Row.create((ByteString)ByteString.copyFromUtf8((String)"key1"), (List)ImmutableList.of((Object)RowCell.create((String)"family", (ByteString)ByteString.EMPTY, (long)1000L, (List)ImmutableList.of(), (ByteString)ByteString.copyFromUtf8((String)"value"))));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(expected);
        oos.close();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        Truth.assertThat((Object)ois.readObject()).isEqualTo((Object)expected);
    }

    @Test
    public void getFamilyCellsTest() {
        ByteString col1 = ByteString.copyFromUtf8((String)"col1");
        ByteString col2 = ByteString.copyFromUtf8((String)"col2");
        ImmutableList labels = ImmutableList.of();
        ByteString value = ByteString.EMPTY;
        Row row = Row.create((ByteString)ByteString.copyFromUtf8((String)"ignored-key"), (List)ImmutableList.of((Object)RowCell.create((String)"family1", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value), (Object)RowCell.create((String)"family1", (ByteString)col2, (long)1000L, (List)labels, (ByteString)value), (Object)RowCell.create((String)"family2", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value), (Object)RowCell.create((String)"family4", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value)));
        Truth.assertThat((Iterable)row.getCells("family1")).containsExactly(new Object[]{RowCell.create((String)"family1", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value), RowCell.create((String)"family1", (ByteString)col2, (long)1000L, (List)labels, (ByteString)value)}).inOrder();
        Truth.assertThat((Iterable)row.getCells("family2")).containsExactly(new Object[]{RowCell.create((String)"family2", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value)});
        Truth.assertThat((Iterable)row.getCells("family3")).isEmpty();
        Truth.assertThat((Iterable)row.getCells("family4")).containsExactly(new Object[]{RowCell.create((String)"family4", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value)});
    }

    @Test
    public void getQualifierCellsTest() {
        ByteString col1 = ByteString.copyFromUtf8((String)"col1");
        ByteString col2 = ByteString.copyFromUtf8((String)"col2");
        ImmutableList labels = ImmutableList.of();
        ByteString value = ByteString.EMPTY;
        Row row = Row.create((ByteString)ByteString.copyFromUtf8((String)"ignored-key"), (List)ImmutableList.of((Object)RowCell.create((String)"family1", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value), (Object)RowCell.create((String)"family1", (ByteString)col2, (long)2000L, (List)labels, (ByteString)value), (Object)RowCell.create((String)"family1", (ByteString)col2, (long)1000L, (List)labels, (ByteString)value), (Object)RowCell.create((String)"family2", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value), (Object)RowCell.create((String)"family4", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value)));
        Truth.assertThat((Iterable)row.getCells("family1", col1)).containsExactly(new Object[]{RowCell.create((String)"family1", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value)});
        Truth.assertThat((Iterable)row.getCells("family1", col2)).containsExactly(new Object[]{RowCell.create((String)"family1", (ByteString)col2, (long)1000L, (List)labels, (ByteString)value), RowCell.create((String)"family1", (ByteString)col2, (long)2000L, (List)labels, (ByteString)value)});
        Truth.assertThat((Iterable)row.getCells("family2", col1)).containsExactly(new Object[]{RowCell.create((String)"family2", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value)});
        Truth.assertThat((Iterable)row.getCells("family2", col2)).isEmpty();
        Truth.assertThat((Iterable)row.getCells("family3", col1)).isEmpty();
        Truth.assertThat((Iterable)row.getCells("family3", col2)).isEmpty();
        Truth.assertThat((Iterable)row.getCells("family4", col1)).containsExactly(new Object[]{RowCell.create((String)"family4", (ByteString)col1, (long)1000L, (List)labels, (ByteString)value)});
    }
}

