/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.SampleRowKeysRequest;
import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.common.truth.Truth;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SampleRowKeysRequestTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "fake-table";
    private static final String AUTHORIZED_VIEW_ID = "fake-authorized-view";
    private static final String APP_PROFILE_ID = "fake-profile";
    private static final RequestContext REQUEST_CONTEXT = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");
    @Rule
    public ExpectedException expect = ExpectedException.none();

    @Test
    public void toProtoTest() {
        SampleRowKeysRequest sampleRowKeysRequest = SampleRowKeysRequest.create((TargetId)TableId.of((String)TABLE_ID));
        com.google.bigtable.v2.SampleRowKeysRequest actualRequest = sampleRowKeysRequest.toProto(REQUEST_CONTEXT);
        Truth.assertThat((String)actualRequest.getTableName()).isEqualTo((Object)NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID));
        Truth.assertThat((String)actualRequest.getAuthorizedViewName()).isEmpty();
        Truth.assertThat((String)actualRequest.getAppProfileId()).isEqualTo((Object)APP_PROFILE_ID);
        sampleRowKeysRequest = SampleRowKeysRequest.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID));
        actualRequest = sampleRowKeysRequest.toProto(REQUEST_CONTEXT);
        Truth.assertThat((String)actualRequest.getTableName()).isEmpty();
        Truth.assertThat((String)actualRequest.getAuthorizedViewName()).isEqualTo((Object)NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID));
        Truth.assertThat((String)actualRequest.getAppProfileId()).isEqualTo((Object)APP_PROFILE_ID);
    }

    @Test
    public void fromProtoTest() {
        SampleRowKeysRequest sampleRowKeysRequest = SampleRowKeysRequest.create((TargetId)TableId.of((String)TABLE_ID));
        com.google.bigtable.v2.SampleRowKeysRequest protoRequest = sampleRowKeysRequest.toProto(REQUEST_CONTEXT);
        SampleRowKeysRequest actualRequest = SampleRowKeysRequest.fromProto((com.google.bigtable.v2.SampleRowKeysRequest)protoRequest);
        Truth.assertThat((Object)actualRequest.toProto(REQUEST_CONTEXT)).isEqualTo((Object)protoRequest);
        String projectId = "fresh-project";
        String instanceId = "fresh-instance";
        String appProfile = "fresh-app-profile";
        com.google.bigtable.v2.SampleRowKeysRequest overriddenRequest = actualRequest.toProto(RequestContext.create((String)projectId, (String)instanceId, (String)appProfile));
        Truth.assertThat((Object)overriddenRequest).isNotEqualTo((Object)protoRequest);
        Truth.assertThat((String)overriddenRequest.getTableName()).matches(NameUtil.formatTableName((String)projectId, (String)instanceId, (String)TABLE_ID));
        Truth.assertThat((String)overriddenRequest.getAuthorizedViewName()).isEmpty();
        Truth.assertThat((String)overriddenRequest.getAppProfileId()).matches(appProfile);
        sampleRowKeysRequest = SampleRowKeysRequest.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID));
        protoRequest = sampleRowKeysRequest.toProto(REQUEST_CONTEXT);
        actualRequest = SampleRowKeysRequest.fromProto((com.google.bigtable.v2.SampleRowKeysRequest)protoRequest);
        Truth.assertThat((Object)actualRequest.toProto(REQUEST_CONTEXT)).isEqualTo((Object)protoRequest);
        overriddenRequest = actualRequest.toProto(RequestContext.create((String)projectId, (String)instanceId, (String)appProfile));
        Truth.assertThat((Object)overriddenRequest).isNotEqualTo((Object)protoRequest);
        Truth.assertThat((String)overriddenRequest.getTableName()).isEmpty();
        Truth.assertThat((String)overriddenRequest.getAuthorizedViewName()).matches(NameUtil.formatAuthorizedViewName((String)projectId, (String)instanceId, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID));
        Truth.assertThat((String)overriddenRequest.getAppProfileId()).matches(appProfile);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromProtoWithInvalidTableId() {
        SampleRowKeysRequest.fromProto((com.google.bigtable.v2.SampleRowKeysRequest)com.google.bigtable.v2.SampleRowKeysRequest.getDefaultInstance().toBuilder().setTableName("invalid-name").build());
        this.expect.expect(IllegalArgumentException.class);
        this.expect.expectMessage("Invalid table name:");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromProtoWithInvalidAuthorizedViewId() {
        SampleRowKeysRequest.fromProto((com.google.bigtable.v2.SampleRowKeysRequest)com.google.bigtable.v2.SampleRowKeysRequest.getDefaultInstance().toBuilder().setAuthorizedViewName("invalid-name").build());
        this.expect.expect(IllegalArgumentException.class);
        this.expect.expectMessage("Invalid authorized view name:");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromProtoWithEmptyTableAndAuthorizedViewId() {
        SampleRowKeysRequest.fromProto((com.google.bigtable.v2.SampleRowKeysRequest)com.google.bigtable.v2.SampleRowKeysRequest.getDefaultInstance());
        this.expect.expect(IllegalArgumentException.class);
        this.expect.expectMessage("Either table name or authorized view name must be specified");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFromProtoWithBothTableAndAuthorizedViewId() {
        SampleRowKeysRequest.fromProto((com.google.bigtable.v2.SampleRowKeysRequest)com.google.bigtable.v2.SampleRowKeysRequest.getDefaultInstance().toBuilder().setTableName(NameUtil.formatTableName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID)).setAuthorizedViewName(NameUtil.formatAuthorizedViewName((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)).build());
        this.expect.expect(IllegalArgumentException.class);
        this.expect.expectMessage("Table name and authorized view name cannot be specified at the same time");
    }

    @Test
    public void testEquality() {
        Truth.assertThat((Object)SampleRowKeysRequest.create((TargetId)TableId.of((String)TABLE_ID))).isEqualTo((Object)SampleRowKeysRequest.create((TargetId)TableId.of((String)TABLE_ID)));
        Truth.assertThat((Object)SampleRowKeysRequest.create((TargetId)TableId.of((String)"another-table"))).isNotEqualTo((Object)SampleRowKeysRequest.create((TargetId)TableId.of((String)TABLE_ID)));
        Truth.assertThat((Object)SampleRowKeysRequest.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID))).isEqualTo((Object)SampleRowKeysRequest.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)));
        Truth.assertThat((Object)SampleRowKeysRequest.create((TargetId)AuthorizedViewId.of((String)"another-table", (String)AUTHORIZED_VIEW_ID))).isNotEqualTo((Object)SampleRowKeysRequest.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)));
        Truth.assertThat((Object)SampleRowKeysRequest.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)"another-authorized-view"))).isNotEqualTo((Object)SampleRowKeysRequest.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID)));
        Truth.assertThat((Object)SampleRowKeysRequest.create((TargetId)AuthorizedViewId.of((String)TABLE_ID, (String)AUTHORIZED_VIEW_ID))).isNotEqualTo((Object)SampleRowKeysRequest.create((TargetId)TableId.of((String)TABLE_ID)));
    }
}

