/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TableIdTest {
    private static final String PROJECT_ID = "my-project";
    private static final String INSTANCE_ID = "my-instance";
    private static final String TABLE_ID = "my-table";

    @Test
    public void testToResourceName() {
        TableId tableId = TableId.of((String)TABLE_ID);
        Truth.assertThat((String)tableId.toResourceName(PROJECT_ID, INSTANCE_ID)).isEqualTo((Object)"projects/my-project/instances/my-instance/tables/my-table");
    }

    @Test
    public void testEquality() {
        TableId tableId = TableId.of((String)TABLE_ID);
        Truth.assertThat((Object)tableId).isEqualTo((Object)TableId.of((String)TABLE_ID));
        Truth.assertThat((Object)tableId).isNotEqualTo((Object)TableId.of((String)"another-table"));
    }

    @Test
    public void testHashCode() {
        TableId tableId = TableId.of((String)TABLE_ID);
        Truth.assertThat((Integer)tableId.hashCode()).isEqualTo((Object)TableId.of((String)TABLE_ID).hashCode());
        Truth.assertThat((Integer)tableId.hashCode()).isNotEqualTo((Object)TableId.of((String)"another-table").hashCode());
    }

    @Test
    public void testToString() {
        TableId tableId = TableId.of((String)TABLE_ID);
        Truth.assertThat((String)tableId.toString()).isEqualTo((Object)"TableId{tableId=my-table}");
    }
}

