/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models.sql;

import com.google.bigtable.v2.Type;
import com.google.cloud.bigtable.common.Type;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SqlTypeTest {
    private HashMap<Type, SqlType<?>> protoToJavaMapping;

    @Before
    public void setUp() {
        this.protoToJavaMapping = new HashMap();
        this.protoToJavaMapping.put(SqlProtoFactory.bytesType(), SqlType.bytes());
        this.protoToJavaMapping.put(SqlProtoFactory.stringType(), SqlType.string());
        this.protoToJavaMapping.put(SqlProtoFactory.int64Type(), SqlType.int64());
        this.protoToJavaMapping.put(SqlProtoFactory.float32Type(), SqlType.float32());
        this.protoToJavaMapping.put(SqlProtoFactory.float64Type(), SqlType.float64());
        this.protoToJavaMapping.put(SqlProtoFactory.boolType(), SqlType.bool());
        this.protoToJavaMapping.put(SqlProtoFactory.timestampType(), SqlType.timestamp());
        this.protoToJavaMapping.put(SqlProtoFactory.dateType(), SqlType.date());
        this.protoToJavaMapping.put(SqlProtoFactory.structType(SqlProtoFactory.structField("foo", SqlProtoFactory.stringType()), SqlProtoFactory.structField("bar", SqlProtoFactory.int64Type())), (SqlType<?>)new Type.StructWithSchema(Arrays.asList(Type.StructWithSchema.Field.fromProto((Type.Struct.Field)SqlProtoFactory.structField("foo", SqlProtoFactory.stringType())), Type.StructWithSchema.Field.fromProto((Type.Struct.Field)SqlProtoFactory.structField("bar", SqlProtoFactory.int64Type())))));
        this.protoToJavaMapping.put(SqlProtoFactory.arrayType(SqlProtoFactory.stringType()), (SqlType<?>)SqlType.arrayOf((SqlType)SqlType.string()));
        this.protoToJavaMapping.put(SqlProtoFactory.mapType(SqlProtoFactory.bytesType(), SqlProtoFactory.stringType()), (SqlType<?>)SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.string()));
    }

    @Test
    public void fromProto_supportsAllTypes() {
        EnumSet<SqlType.Code> allCodes = EnumSet.allOf(SqlType.Code.class);
        for (Map.Entry<Type, SqlType<?>> entry : this.protoToJavaMapping.entrySet()) {
            SqlType converted = SqlType.fromProto((Type)entry.getKey());
            Truth.assertThat((Object)converted).isEqualTo(entry.getValue());
            allCodes.remove(converted.getCode());
        }
        Truth.assertThat(allCodes).isEmpty();
    }

    @Test
    public void typesMatch_supportsAllTypes() {
        EnumSet<SqlType.Code> allCodes = EnumSet.allOf(SqlType.Code.class);
        for (Map.Entry<Type, SqlType<?>> entry : this.protoToJavaMapping.entrySet()) {
            SqlType<?> type = entry.getValue();
            SqlType copyOfType = SqlType.fromProto((Type)entry.getKey());
            Truth.assertThat((Boolean)SqlType.typesMatch(type, (SqlType)copyOfType)).isTrue();
            SqlType otherType = type.getCode().equals((Object)SqlType.Code.STRING) ? SqlType.bytes() : SqlType.string();
            Truth.assertThat((Boolean)SqlType.typesMatch(type, (SqlType)otherType)).isFalse();
            allCodes.remove(type.getCode());
        }
        Truth.assertThat(allCodes).isEmpty();
    }

    @Test
    public void historicalMap_matchesProto() {
        SqlType expected = SqlType.fromProto((Type)SqlProtoFactory.mapType(SqlProtoFactory.bytesType(), SqlProtoFactory.arrayType(SqlProtoFactory.structType(SqlProtoFactory.structField("timestamp", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("value", SqlProtoFactory.bytesType())))));
        Truth.assertThat((Boolean)SqlType.typesMatch((SqlType)SqlType.historicalMap(), (SqlType)expected)).isTrue();
    }

    @Test
    public void typesMatch_ignoresStructSchema() {
        SqlType.Struct schemalessStruct = SqlType.struct();
        Type structProto = SqlProtoFactory.structType(SqlProtoFactory.structField("timestamp", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("value", SqlProtoFactory.bytesType()));
        Type.StructWithSchema structWithSchema = Type.StructWithSchema.fromProto((Type.Struct)structProto.getStructType());
        SqlType.Array arrayNestedSchemaless = SqlType.arrayOf((SqlType)SqlType.struct());
        SqlType arrayNestedSchema = SqlType.fromProto((Type)SqlProtoFactory.arrayType(structProto));
        SqlType.Map historicalMapSchemaless = SqlType.historicalMap();
        SqlType mapNestedSchema = SqlType.fromProto((Type)SqlProtoFactory.mapType(SqlProtoFactory.bytesType(), SqlProtoFactory.arrayType(structProto)));
        Truth.assertThat((Boolean)SqlType.typesMatch((SqlType)schemalessStruct, (SqlType)structWithSchema)).isTrue();
        Truth.assertThat((Boolean)SqlType.typesMatch((SqlType)arrayNestedSchema, (SqlType)arrayNestedSchemaless)).isTrue();
        Truth.assertThat((Boolean)SqlType.typesMatch((SqlType)historicalMapSchemaless, (SqlType)mapNestedSchema)).isTrue();
    }

    @Test
    public void typesMatch_checksArrayElements() {
        SqlType.Array stringArray = SqlType.arrayOf((SqlType)SqlType.string());
        SqlType.Array bytesArray = SqlType.arrayOf((SqlType)SqlType.bytes());
        SqlType.Array nestedStringArray = SqlType.arrayOf((SqlType)SqlType.arrayOf((SqlType)SqlType.string()));
        SqlType.Array nestedBytesArray = SqlType.arrayOf((SqlType)SqlType.arrayOf((SqlType)SqlType.bytes()));
        Truth.assertThat((Boolean)SqlType.typesMatch((SqlType)stringArray, (SqlType)bytesArray)).isFalse();
        Truth.assertThat((Boolean)SqlType.typesMatch((SqlType)nestedStringArray, (SqlType)nestedBytesArray)).isFalse();
    }

    @Test
    public void typesMatch_checksMapSchema() {
        SqlType.Map bytesBytesMap = SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.bytes());
        SqlType.Map bytesStringMap = SqlType.mapOf((SqlType)SqlType.string(), (SqlType)SqlType.bytes());
        SqlType.Map stringBytesMap = SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.string());
        Truth.assertThat((Boolean)SqlType.typesMatch((SqlType)bytesBytesMap, (SqlType)bytesStringMap)).isFalse();
        Truth.assertThat((Boolean)SqlType.typesMatch((SqlType)bytesBytesMap, (SqlType)stringBytesMap)).isFalse();
        Truth.assertThat((Boolean)SqlType.typesMatch((SqlType)SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)bytesBytesMap), (SqlType)SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)bytesStringMap))).isFalse();
    }

    @Test
    public void struct_getFields() {
        Type structProto = SqlProtoFactory.structType(SqlProtoFactory.structField("timestamp", SqlProtoFactory.timestampType()), SqlProtoFactory.structField("value", SqlProtoFactory.bytesType()));
        SqlType struct = SqlType.fromProto((Type)structProto);
        SqlType.Struct typedStruct = (SqlType.Struct)struct;
        SqlType.Struct.Field timestampField = (SqlType.Struct.Field)typedStruct.getFields().get(0);
        SqlType.Struct.Field valueField = (SqlType.Struct.Field)typedStruct.getFields().get(1);
        Truth.assertThat((String)timestampField.name()).isEqualTo((Object)"timestamp");
        Truth.assertThat((Object)timestampField.type()).isEqualTo((Object)SqlType.timestamp());
        Truth.assertThat((String)valueField.name()).isEqualTo((Object)"value");
        Truth.assertThat((Object)valueField.type()).isEqualTo((Object)SqlType.bytes());
    }

    @Test
    public void array_getElementType() {
        SqlType array = SqlType.fromProto((Type)SqlProtoFactory.arrayType(SqlProtoFactory.stringType()));
        SqlType.Array typedArray = (SqlType.Array)array;
        Truth.assertThat((Object)typedArray.getElementType()).isEqualTo((Object)SqlType.string());
    }

    @Test
    public void map_getKeyAndValueTypes() {
        SqlType.Map map;
        SqlType.Map typedMap = map = SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.string());
        Truth.assertThat((Object)typedMap.getKeyType()).isEqualTo((Object)SqlType.bytes());
        Truth.assertThat((Object)typedMap.getValueType()).isEqualTo((Object)SqlType.string());
    }
}

