/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models.sql;

import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.bigtable.v2.Value;
import com.google.cloud.Date;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.cloud.bigtable.data.v2.models.sql.Statement;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class StatementTest {
    private static final String EXPECTED_APP_PROFILE = "test-profile";
    private static final RequestContext REQUEST_CONTEXT = RequestContext.create((String)"test-project", (String)"test-instance", (String)"test-profile");
    private static final String EXPECTED_INSTANCE_NAME = "projects/test-project/instances/test-instance";

    @Test
    public void statementWithoutParameters() {
        Statement s = Statement.of((String)"SELECT * FROM table");
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table").setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithBytesParam() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE _key=@key").setBytesParam("key", ByteString.copyFromUtf8((String)"test")).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE _key=@key").putParams("key", Value.newBuilder().setType(SqlProtoFactory.bytesType()).setBytesValue(ByteString.copyFromUtf8((String)"test")).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithNullBytesParam() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE _key=@key").setBytesParam("key", null).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE _key=@key").putParams("key", Value.newBuilder().setType(SqlProtoFactory.bytesType()).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithStringParam() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE _key=@key").setStringParam("key", "test").build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE _key=@key").putParams("key", Value.newBuilder().setType(SqlProtoFactory.stringType()).setStringValue("test").build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithNullStringParam() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE _key=@key").setStringParam("key", null).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE _key=@key").putParams("key", Value.newBuilder().setType(SqlProtoFactory.stringType()).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithInt64Param() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE 1=@number").setLongParam("number", Long.valueOf(1L)).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE 1=@number").putParams("number", Value.newBuilder().setType(SqlProtoFactory.int64Type()).setIntValue(1L).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithNullInt64Param() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE 1=@number").setLongParam("number", null).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE 1=@number").putParams("number", Value.newBuilder().setType(SqlProtoFactory.int64Type()).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithBoolParam() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE @bool").setBooleanParam("bool", Boolean.valueOf(true)).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE @bool").putParams("bool", Value.newBuilder().setType(SqlProtoFactory.boolType()).setBoolValue(true).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithNullBoolParam() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE @bool").setBooleanParam("bool", null).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE @bool").putParams("bool", Value.newBuilder().setType(SqlProtoFactory.boolType()).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithTimestampParam() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE PARSE_TIMESTAMP(\"%Y/%m/%dT%H:%M:%S\", CAST(cf[\"ts\"] AS STRING)) < @timeParam").setTimestampParam("timeParam", Instant.ofEpochSecond(1000L, 100L)).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE PARSE_TIMESTAMP(\"%Y/%m/%dT%H:%M:%S\", CAST(cf[\"ts\"] AS STRING)) < @timeParam").putParams("timeParam", Value.newBuilder().setType(SqlProtoFactory.timestampType()).setTimestampValue(SqlProtoFactory.timestampValue(1000L, 100).getTimestampValue()).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithNullTimestampParam() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE PARSE_TIMESTAMP(\"%Y/%m/%dT%H:%M:%S\", CAST(cf[\"ts\"] AS STRING)) < @timeParam").setTimestampParam("timeParam", null).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE PARSE_TIMESTAMP(\"%Y/%m/%dT%H:%M:%S\", CAST(cf[\"ts\"] AS STRING)) < @timeParam").putParams("timeParam", Value.newBuilder().setType(SqlProtoFactory.timestampType()).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithDateParam() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE PARSE_DATE(\"%Y%m%d\", CAST(cf[\"date\"] AS STRING)) < @dateParam").setDateParam("dateParam", Date.fromYearMonthDay((int)2024, (int)6, (int)11)).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE PARSE_DATE(\"%Y%m%d\", CAST(cf[\"date\"] AS STRING)) < @dateParam").putParams("dateParam", Value.newBuilder().setType(SqlProtoFactory.dateType()).setDateValue(SqlProtoFactory.dateValue(2024, 6, 11).getDateValue()).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithNullDateParam() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE PARSE_DATE(\"%Y%m%d\", CAST(cf[\"date\"] AS STRING)) < @dateParam").setDateParam("dateParam", null).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE PARSE_DATE(\"%Y%m%d\", CAST(cf[\"date\"] AS STRING)) < @dateParam").putParams("dateParam", Value.newBuilder().setType(SqlProtoFactory.dateType()).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithBytesListParam() {
        Statement s = Statement.newBuilder((String)"SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").setListParam("listParam", Arrays.asList(ByteString.copyFromUtf8((String)"foo"), ByteString.copyFromUtf8((String)"bar")), SqlType.arrayOf((SqlType)SqlType.bytes())).setListParam("listWithNullElem", Arrays.asList(ByteString.copyFromUtf8((String)"foo"), null, ByteString.copyFromUtf8((String)"bar")), SqlType.arrayOf((SqlType)SqlType.bytes())).setListParam("emptyList", Collections.emptyList(), SqlType.arrayOf((SqlType)SqlType.bytes())).setListParam("nullList", null, SqlType.arrayOf((SqlType)SqlType.bytes())).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").putParams("listParam", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.bytesType())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.bytesValue("foo"), SqlProtoFactory.bytesValue("bar")).getArrayValue()).build()).putParams("listWithNullElem", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.bytesType())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.bytesValue("foo"), SqlProtoFactory.nullValue(), SqlProtoFactory.bytesValue("bar")).getArrayValue()).build()).putParams("emptyList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.bytesType())).setArrayValue(SqlProtoFactory.arrayValue(new Value[0]).getArrayValue()).build()).putParams("nullList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.bytesType())).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithStringListParam() {
        Statement s = Statement.newBuilder((String)"SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").setListParam("listParam", Arrays.asList("foo", "bar"), SqlType.arrayOf((SqlType)SqlType.string())).setListParam("listWithNullElem", Arrays.asList("foo", "bar", null), SqlType.arrayOf((SqlType)SqlType.string())).setListParam("emptyList", Collections.emptyList(), SqlType.arrayOf((SqlType)SqlType.string())).setListParam("nullList", null, SqlType.arrayOf((SqlType)SqlType.string())).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").putParams("listParam", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.stringType())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar")).getArrayValue()).build()).putParams("listWithNullElem", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.stringType())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar"), SqlProtoFactory.nullValue()).getArrayValue()).build()).putParams("emptyList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.stringType())).setArrayValue(SqlProtoFactory.arrayValue(new Value[0]).getArrayValue()).build()).putParams("nullList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.stringType())).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithInt64ListParam() {
        Statement s = Statement.newBuilder((String)"SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").setListParam("listParam", Arrays.asList(1L, 2L), SqlType.arrayOf((SqlType)SqlType.int64())).setListParam("listWithNullElem", Arrays.asList(null, 3L, 4L), SqlType.arrayOf((SqlType)SqlType.int64())).setListParam("emptyList", Collections.emptyList(), SqlType.arrayOf((SqlType)SqlType.int64())).setListParam("nullList", null, SqlType.arrayOf((SqlType)SqlType.int64())).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").putParams("listParam", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.int64Type())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.int64Value(1L), SqlProtoFactory.int64Value(2L)).getArrayValue()).build()).putParams("listWithNullElem", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.int64Type())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.nullValue(), SqlProtoFactory.int64Value(3L), SqlProtoFactory.int64Value(4L)).getArrayValue()).build()).putParams("emptyList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.int64Type())).setArrayValue(SqlProtoFactory.arrayValue(new Value[0]).getArrayValue()).build()).putParams("nullList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.int64Type())).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithFloat32ListParam() {
        Statement s = Statement.newBuilder((String)"SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").setListParam("listParam", Arrays.asList(Float.valueOf(1.1f), Float.valueOf(1.2f)), SqlType.arrayOf((SqlType)SqlType.float32())).setListParam("listWithNullElem", Arrays.asList(Float.valueOf(1.3f), Float.valueOf(1.4f), null), SqlType.arrayOf((SqlType)SqlType.float32())).setListParam("emptyList", Collections.emptyList(), SqlType.arrayOf((SqlType)SqlType.float32())).setListParam("nullList", null, SqlType.arrayOf((SqlType)SqlType.float32())).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").putParams("listParam", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.float32Type())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.floatValue(1.1f), SqlProtoFactory.floatValue(1.2f)).getArrayValue()).build()).putParams("listWithNullElem", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.float32Type())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.floatValue(1.3f), SqlProtoFactory.floatValue(1.4f), SqlProtoFactory.nullValue()).getArrayValue()).build()).putParams("emptyList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.float32Type())).setArrayValue(SqlProtoFactory.arrayValue(new Value[0]).getArrayValue()).build()).putParams("nullList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.float32Type())).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithFloat64ListParam() {
        Statement s = Statement.newBuilder((String)"SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").setListParam("listParam", Arrays.asList(1.1, 1.2), SqlType.arrayOf((SqlType)SqlType.float64())).setListParam("listWithNullElem", Arrays.asList(1.3, 1.4, null), SqlType.arrayOf((SqlType)SqlType.float64())).setListParam("emptyList", Collections.emptyList(), SqlType.arrayOf((SqlType)SqlType.float64())).setListParam("nullList", null, SqlType.arrayOf((SqlType)SqlType.float64())).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").putParams("listParam", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.float64Type())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.floatValue(1.1), SqlProtoFactory.floatValue(1.2)).getArrayValue()).build()).putParams("listWithNullElem", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.float64Type())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.floatValue(1.3), SqlProtoFactory.floatValue(1.4), SqlProtoFactory.nullValue()).getArrayValue()).build()).putParams("emptyList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.float64Type())).setArrayValue(SqlProtoFactory.arrayValue(new Value[0]).getArrayValue()).build()).putParams("nullList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.float64Type())).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithBooleanListParam() {
        Statement s = Statement.newBuilder((String)"SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").setListParam("listParam", Arrays.asList(true, false), SqlType.arrayOf((SqlType)SqlType.bool())).setListParam("listWithNullElem", Arrays.asList(true, false, null), SqlType.arrayOf((SqlType)SqlType.bool())).setListParam("emptyList", Collections.emptyList(), SqlType.arrayOf((SqlType)SqlType.bool())).setListParam("nullList", null, SqlType.arrayOf((SqlType)SqlType.bool())).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").putParams("listParam", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.boolType())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.boolValue(true), SqlProtoFactory.boolValue(false)).getArrayValue()).build()).putParams("listWithNullElem", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.boolType())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.boolValue(true), SqlProtoFactory.boolValue(false), SqlProtoFactory.nullValue()).getArrayValue()).build()).putParams("emptyList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.boolType())).setArrayValue(SqlProtoFactory.arrayValue(new Value[0]).getArrayValue()).build()).putParams("nullList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.boolType())).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithTimestampListParam() {
        Statement s = Statement.newBuilder((String)"SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").setListParam("listParam", Arrays.asList(Instant.ofEpochSecond(3000L, 100L), Instant.ofEpochSecond(4000L, 100L)), SqlType.arrayOf((SqlType)SqlType.timestamp())).setListParam("listWithNullElem", Arrays.asList(Instant.ofEpochSecond(1000L, 100L), Instant.ofEpochSecond(2000L, 100L), null), SqlType.arrayOf((SqlType)SqlType.timestamp())).setListParam("emptyList", Collections.emptyList(), SqlType.arrayOf((SqlType)SqlType.timestamp())).setListParam("nullList", null, SqlType.arrayOf((SqlType)SqlType.timestamp())).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").putParams("listParam", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.timestampType())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.timestampValue(3000L, 100), SqlProtoFactory.timestampValue(4000L, 100)).getArrayValue()).build()).putParams("listWithNullElem", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.timestampType())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.timestampValue(1000L, 100), SqlProtoFactory.timestampValue(2000L, 100), SqlProtoFactory.nullValue()).getArrayValue()).build()).putParams("emptyList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.timestampType())).setArrayValue(SqlProtoFactory.arrayValue(new Value[0]).getArrayValue()).build()).putParams("nullList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.timestampType())).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void statementWithDateListParam() {
        Statement s = Statement.newBuilder((String)"SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").setListParam("listParam", Arrays.asList(Date.fromYearMonthDay((int)2024, (int)6, (int)1), Date.fromYearMonthDay((int)2024, (int)7, (int)1)), SqlType.arrayOf((SqlType)SqlType.date())).setListParam("listWithNullElem", Arrays.asList(Date.fromYearMonthDay((int)2024, (int)8, (int)1), Date.fromYearMonthDay((int)2024, (int)8, (int)2), null), SqlType.arrayOf((SqlType)SqlType.date())).setListParam("emptyList", Collections.emptyList(), SqlType.arrayOf((SqlType)SqlType.date())).setListParam("nullList", null, SqlType.arrayOf((SqlType)SqlType.date())).build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT cf, @listParam, @listWithNullElem, @emptyList, @nullList FROM table").putParams("listParam", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.dateType())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.dateValue(2024, 6, 1), SqlProtoFactory.dateValue(2024, 7, 1)).getArrayValue()).build()).putParams("listWithNullElem", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.dateType())).setArrayValue(SqlProtoFactory.arrayValue(SqlProtoFactory.dateValue(2024, 8, 1), SqlProtoFactory.dateValue(2024, 8, 2), SqlProtoFactory.nullValue()).getArrayValue()).build()).putParams("emptyList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.dateType())).setArrayValue(SqlProtoFactory.arrayValue(new Value[0]).getArrayValue()).build()).putParams("nullList", Value.newBuilder().setType(SqlProtoFactory.arrayType(SqlProtoFactory.dateType())).build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void setListParamRejectsUnsupportedElementTypes() {
        Statement.Builder statement = Statement.newBuilder((String)"SELECT @param");
        Assert.assertThrows(IllegalArgumentException.class, () -> statement.setListParam("param", null, SqlType.arrayOf((SqlType)SqlType.struct())));
        Assert.assertThrows(IllegalArgumentException.class, () -> statement.setListParam("param", null, SqlType.arrayOf((SqlType)SqlType.arrayOf((SqlType)SqlType.string()))));
        Assert.assertThrows(IllegalArgumentException.class, () -> statement.setListParam("param", null, SqlType.arrayOf((SqlType)SqlType.mapOf((SqlType)SqlType.bytes(), (SqlType)SqlType.bytes()))));
    }

    @Test
    public void statementBuilderAllowsParamsToBeOverridden() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table WHERE _key=@key").setStringParam("key", "test1").setStringParam("key", "test2").setStringParam("key", "test3").setStringParam("key", "test4").build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table WHERE _key=@key").putParams("key", Value.newBuilder().setType(SqlProtoFactory.stringType()).setStringValue("test4").build()).setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }

    @Test
    public void builderWorksWithNoParams() {
        Statement s = Statement.newBuilder((String)"SELECT * FROM table").build();
        Truth.assertThat((Object)s.toProto(REQUEST_CONTEXT)).isEqualTo((Object)ExecuteQueryRequest.newBuilder().setQuery("SELECT * FROM table").setInstanceName(EXPECTED_INSTANCE_NAME).setAppProfileId(EXPECTED_APP_PROFILE).build());
    }
}

