/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFuture;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.cloud.bigtable.data.v2.stub.BigtableUnaryOperationCallable;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.cloud.bigtable.gaxx.testing.FakeStreamingApi;
import com.google.cloud.bigtable.gaxx.testing.MockStreamingApi;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BigtableUnaryOperationCallableTest {
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private ApiTracerFactory tracerFactory;
    @Mock
    private BigtableTracer tracer;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.tracerFactory.newTracer((ApiTracer)Mockito.any(), (SpanName)Mockito.any(), (ApiTracerFactory.OperationType)Mockito.any())).thenReturn((Object)this.tracer);
    }

    @Test
    public void testFutureResolve() throws Exception {
        BigtableUnaryOperationCallable callable = new BigtableUnaryOperationCallable(new FakeStreamingApi.ServerStreamingStashCallable(ImmutableList.of((Object)"value")), (ApiCallContext)GrpcCallContext.createDefault(), this.tracerFactory, SpanName.of((String)"Fake", (String)"method"), false);
        ApiFuture f = callable.futureCall((Object)"fake");
        Truth.assertThat((String)((String)f.get())).isEqualTo((Object)"value");
    }

    @Test
    public void testMultipleResponses() throws Exception {
        MockStreamingApi.MockServerStreamingCallable inner = new MockStreamingApi.MockServerStreamingCallable();
        BigtableUnaryOperationCallable callable = new BigtableUnaryOperationCallable(inner, (ApiCallContext)GrpcCallContext.createDefault(), this.tracerFactory, SpanName.of((String)"Fake", (String)"method"), false);
        callable.logger = (Logger)Mockito.mock(Logger.class);
        ApiFuture f = callable.futureCall((Object)"fake");
        MockStreamingApi.MockServerStreamingCall call = inner.popLastCall();
        call.getController().getObserver().onResponse((Object)"first");
        call.getController().getObserver().onResponse((Object)"second");
        ArgumentCaptor msgCaptor = ArgumentCaptor.forClass(String.class);
        ((Logger)Mockito.verify((Object)callable.logger)).log((Level)Mockito.any(), (String)msgCaptor.capture());
        Truth.assertThat((String)((String)msgCaptor.getValue())).isEqualTo((Object)"Received response after future is resolved for a Fake.method unary operation. previous: first, New response: second");
        Truth.assertThat((Boolean)call.getController().isCancelled()).isTrue();
    }

    @Test
    public void testCancel() {
        MockStreamingApi.MockServerStreamingCallable inner = new MockStreamingApi.MockServerStreamingCallable();
        BigtableUnaryOperationCallable callable = new BigtableUnaryOperationCallable(inner, (ApiCallContext)GrpcCallContext.createDefault(), this.tracerFactory, SpanName.of((String)"Fake", (String)"method"), false);
        ApiFuture f = callable.futureCall((Object)"req");
        f.cancel(true);
        MockStreamingApi.MockServerStreamingCall call = inner.popLastCall();
        Truth.assertThat((Boolean)call.getController().isCancelled()).isTrue();
    }

    @Test
    public void testMissingResponse() {
        MockStreamingApi.MockServerStreamingCallable inner = new MockStreamingApi.MockServerStreamingCallable();
        BigtableUnaryOperationCallable callable = new BigtableUnaryOperationCallable(inner, (ApiCallContext)GrpcCallContext.createDefault(), this.tracerFactory, SpanName.of((String)"Fake", (String)"method"), false);
        ApiFuture f = callable.futureCall((Object)"req");
        MockStreamingApi.MockServerStreamingCall call = inner.popLastCall();
        call.getController().getObserver().onComplete();
        Throwable cause = ((ExecutionException)Assert.assertThrows(ExecutionException.class, () -> f.get())).getCause();
        Truth.assertThat((Throwable)cause).hasMessageThat().isEqualTo((Object)"Fake.method unary operation completed without a response message");
    }

    @Test
    public void testTracing() throws Exception {
        MockStreamingApi.MockServerStreamingCallable inner = new MockStreamingApi.MockServerStreamingCallable();
        BigtableUnaryOperationCallable callable = new BigtableUnaryOperationCallable(inner, (ApiCallContext)GrpcCallContext.createDefault(), this.tracerFactory, SpanName.of((String)"Fake", (String)"method"), false);
        ApiFuture f = callable.futureCall((Object)"req");
        MockStreamingApi.MockServerStreamingCall call = inner.popLastCall();
        call.getController().getObserver().onResponse((Object)"value");
        call.getController().getObserver().onComplete();
        f.get();
        ((BigtableTracer)Mockito.verify((Object)this.tracer)).responseReceived();
        ((BigtableTracer)Mockito.verify((Object)this.tracer)).operationSucceeded();
        ((BigtableTracer)Mockito.verify((Object)this.tracer, (VerificationMode)Mockito.never())).afterResponse(Mockito.anyLong());
    }
}

