/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.bigtable.data.v2.stub.ConvertExceptionCallable;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConvertExceptionCallableTest {
    @Test
    public void rstStreamExceptionConvertedToRetryableTest() {
        InternalException originalException = new InternalException((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("INTERNAL: HTTP/2 error code: INTERNAL_ERROR\nReceived Rst Stream")), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        Assert.assertFalse((boolean)originalException.isRetryable());
        SettableExceptionCallable settableExceptionCallable = new SettableExceptionCallable((Throwable)originalException);
        ConvertExceptionCallable convertStreamExceptionCallable = new ConvertExceptionCallable(settableExceptionCallable);
        Throwable actualError = null;
        try {
            convertStreamExceptionCallable.all().call((Object)"fake-request");
        }
        catch (Throwable t) {
            actualError = t;
        }
        assert (actualError instanceof InternalException);
        InternalException actualException = (InternalException)actualError;
        Assert.assertTrue((boolean)actualException.isRetryable());
    }

    @Test
    public void retriableAuthExceptionConvertedToRetryableTest() {
        InternalException originalException = new InternalException((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("Authentication backend internal server error. Please retry")), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        Assert.assertFalse((boolean)originalException.isRetryable());
        SettableExceptionCallable settableExceptionCallable = new SettableExceptionCallable((Throwable)originalException);
        ConvertExceptionCallable convertStreamExceptionCallable = new ConvertExceptionCallable(settableExceptionCallable);
        Throwable actualError = null;
        try {
            convertStreamExceptionCallable.all().call((Object)"fake-request");
        }
        catch (Throwable t) {
            actualError = t;
        }
        assert (actualError instanceof InternalException);
        InternalException actualException = (InternalException)actualError;
        Assert.assertTrue((boolean)actualException.isRetryable());
    }

    private static final class SettableExceptionCallable<RequestT, ResponseT>
    extends ServerStreamingCallable<RequestT, ResponseT> {
        private final Throwable throwable;

        public SettableExceptionCallable(Throwable throwable) {
            this.throwable = throwable;
        }

        public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
            responseObserver.onError(this.throwable);
        }
    }
}

