/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsRequest;
import com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsResponse;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.bigtable.v2.StreamContinuationToken;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataClientFactory;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.MetadataSubject;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadChangeStreamQuery;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.common.truth.Truth;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class CookiesHolderTest {
    private static final Metadata.Key<String> ROUTING_COOKIE_1 = Metadata.Key.of((String)"x-goog-cbt-cookie-routing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> ROUTING_COOKIE_2 = Metadata.Key.of((String)"x-goog-cbt-cookie-random", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> ROUTING_COOKIE_HEADER = Metadata.Key.of((String)"x-goog-cbt-cookie-header", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> BAD_KEY = Metadata.Key.of((String)"x-goog-cbt-not-cookie", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final String testHeaderCookie = "header-cookie";
    private static final String testCookie = "test-routing-cookie";
    private static final String routingCookie1Header = "should-be-overridden";
    private Server server;
    private final FakeService fakeService = new FakeService();
    private BigtableDataSettings.Builder settings;
    private BigtableDataClient client;
    private final List<Metadata> serverMetadata = Collections.synchronizedList(new ArrayList());
    private final Set<String> methods = Collections.synchronizedSet(new HashSet());

    @Before
    public void setup() throws Exception {
        ServerInterceptor serverInterceptor = new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
                CookiesHolderTest.this.serverMetadata.add(metadata);
                if (metadata.containsKey(ROUTING_COOKIE_1)) {
                    CookiesHolderTest.this.methods.add(serverCall.getMethodDescriptor().getBareMethodName());
                }
                Metadata responseHeaders = new Metadata();
                responseHeaders.put(ROUTING_COOKIE_HEADER, (Object)CookiesHolderTest.testHeaderCookie);
                responseHeaders.put(ROUTING_COOKIE_1, (Object)CookiesHolderTest.routingCookie1Header);
                serverCall.sendHeaders(responseHeaders);
                return serverCallHandler.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(serverCall){

                    public void sendHeaders(Metadata responseHeaders) {
                    }
                }, metadata);
            }
        };
        this.server = FakeServiceBuilder.create(new BindableService[]{this.fakeService}).intercept(serverInterceptor).start();
        BigtableDataSettings.Builder settings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId("fake-project").setInstanceId("fake-instance");
        settings.stubSettings().checkAndMutateRowSettings().setRetrySettings(RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)10L)).setMaxRetryDelay(Duration.ofMinutes((long)1L)).setMaxAttempts(2).build()).setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE});
        settings.stubSettings().readModifyWriteRowSettings().setRetrySettings(RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)10L)).setMaxRetryDelay(Duration.ofMinutes((long)1L)).setMaxAttempts(2).build()).setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE});
        this.settings = settings;
        this.client = BigtableDataClient.create((BigtableDataSettings)settings.build());
    }

    @After
    public void tearDown() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    @Test
    public void testReadRows() {
        this.client.readRows(Query.create((String)"fake-table")).iterator().hasNext();
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), "readRows", ROUTING_COOKIE_2.name(), testCookie, ROUTING_COOKIE_HEADER.name(), testHeaderCookie);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(BAD_KEY.name());
        this.serverMetadata.clear();
    }

    @Test
    public void testReadRow() {
        this.client.readRow("fake-table", "key");
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), "readRows", ROUTING_COOKIE_2.name(), testCookie, ROUTING_COOKIE_HEADER.name(), testHeaderCookie);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(BAD_KEY.name());
        this.serverMetadata.clear();
    }

    @Test
    public void testMutateRows() {
        this.client.bulkMutateRows(BulkMutation.create((String)"fake-table").add(RowMutationEntry.create((String)"key").setCell("cf", "q", "v")));
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), "mutateRows", ROUTING_COOKIE_2.name(), testCookie, ROUTING_COOKIE_HEADER.name(), testHeaderCookie);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(BAD_KEY.name());
        this.serverMetadata.clear();
    }

    @Test
    public void testMutateRow() {
        this.client.mutateRow(RowMutation.create((String)"table", (String)"key").setCell("cf", "q", "v"));
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), "mutateRow", ROUTING_COOKIE_2.name(), testCookie, ROUTING_COOKIE_HEADER.name(), testHeaderCookie);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(BAD_KEY.name());
        this.serverMetadata.clear();
    }

    @Test
    public void testSampleRowKeys() {
        this.client.sampleRowKeys("fake-table");
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), "sampleRowKeys", ROUTING_COOKIE_2.name(), testCookie, ROUTING_COOKIE_HEADER.name(), testHeaderCookie);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(BAD_KEY.name());
        this.serverMetadata.clear();
    }

    @Test
    public void testReadChangeStream() {
        for (ChangeStreamRecord changeStreamRecord : this.client.readChangeStream(ReadChangeStreamQuery.create((String)"table"))) {
        }
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), "readChangeStream", ROUTING_COOKIE_2.name(), testCookie, ROUTING_COOKIE_HEADER.name(), testHeaderCookie);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(BAD_KEY.name());
        this.serverMetadata.clear();
    }

    @Test
    public void testGenerateInitialChangeStreamPartition() {
        this.client.generateInitialChangeStreamPartitions("table").iterator().hasNext();
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), "generateInitialChangeStreamPartitions", ROUTING_COOKIE_2.name(), testCookie);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(BAD_KEY.name());
        this.serverMetadata.clear();
    }

    @Test
    public void testNoCookieSucceedReadRows() {
        this.fakeService.returnCookie = false;
        this.client.readRows(Query.create((String)"fake-table")).iterator().hasNext();
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(ROUTING_COOKIE_2.name());
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), routingCookie1Header);
        this.serverMetadata.clear();
    }

    @Test
    public void testNoCookieSucceedReadRow() {
        this.fakeService.returnCookie = false;
        this.client.readRow("fake-table", "key");
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(ROUTING_COOKIE_2.name(), BAD_KEY.name());
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), routingCookie1Header);
        this.serverMetadata.clear();
    }

    @Test
    public void testNoCookieSucceedMutateRows() {
        this.fakeService.returnCookie = false;
        this.client.bulkMutateRows(BulkMutation.create((String)"fake-table").add(RowMutationEntry.create((String)"key").setCell("cf", "q", "v")));
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(ROUTING_COOKIE_2.name(), BAD_KEY.name());
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), routingCookie1Header);
        this.serverMetadata.clear();
    }

    @Test
    public void testNoCookieSucceedMutateRow() {
        this.fakeService.returnCookie = false;
        this.client.mutateRow(RowMutation.create((String)"fake-table", (String)"key").setCell("cf", "q", "v"));
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(ROUTING_COOKIE_2.name(), BAD_KEY.name());
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), routingCookie1Header);
        this.serverMetadata.clear();
    }

    @Test
    public void testNoCookieSucceedSampleRowKeys() {
        this.fakeService.returnCookie = false;
        this.client.sampleRowKeys("fake-table");
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(ROUTING_COOKIE_2.name(), BAD_KEY.name());
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), routingCookie1Header);
        this.serverMetadata.clear();
    }

    @Test
    public void testNoCookieSucceedReadChangeStream() {
        this.fakeService.returnCookie = false;
        for (ChangeStreamRecord changeStreamRecord : this.client.readChangeStream(ReadChangeStreamQuery.create((String)"table"))) {
        }
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(ROUTING_COOKIE_2.name(), BAD_KEY.name());
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), routingCookie1Header);
        this.serverMetadata.clear();
        this.serverMetadata.clear();
    }

    @Test
    public void testNoCookieSucceedGenerateInitialChangeStreamParition() {
        this.fakeService.returnCookie = false;
        this.client.generateInitialChangeStreamPartitions("table").iterator().hasNext();
        Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
        Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
        Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
        MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(ROUTING_COOKIE_2.name(), BAD_KEY.name());
        MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), routingCookie1Header);
        this.serverMetadata.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCookiesInHeaders() throws Exception {
        final Metadata.Key routingCookieKey = Metadata.Key.of((String)"x-goog-cbt-cookie-no-override", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        String routingCookieValue = "no-override";
        ServerInterceptor serverInterceptor = new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
                CookiesHolderTest.this.serverMetadata.add(metadata);
                metadata.put(routingCookieKey, (Object)"no-override");
                return serverCallHandler.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(serverCall){

                    public void sendHeaders(Metadata headers) {
                        headers.put(routingCookieKey, (Object)"no-override");
                        headers.put(ROUTING_COOKIE_2, (Object)"will-be-overridden");
                        super.sendHeaders(headers);
                    }
                }, metadata);
            }
        };
        Server newServer = null;
        try {
            newServer = FakeServiceBuilder.create(new BindableService[]{this.fakeService}).intercept(serverInterceptor).start();
            BigtableDataSettings.Builder settings = BigtableDataSettings.newBuilderForEmulator((int)newServer.getPort()).setProjectId("fake-project").setInstanceId("fake-instance");
            try (BigtableDataClient client = BigtableDataClient.create((BigtableDataSettings)settings.build());){
                client.readRows(Query.create((String)"table")).iterator().hasNext();
                Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
                MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_2.name(), testCookie, routingCookieKey.name(), "no-override");
            }
        }
        finally {
            if (newServer != null) {
                newServer.shutdown();
            }
        }
    }

    @Test
    public void testAllMethodsAreCalled() {
        this.client.readRows(Query.create((String)"fake-table")).iterator().hasNext();
        this.fakeService.count.set(0);
        this.client.mutateRow(RowMutation.create((String)"fake-table", (String)"key").setCell("cf", "q", "v"));
        this.fakeService.count.set(0);
        this.client.bulkMutateRows(BulkMutation.create((String)"fake-table").add(RowMutationEntry.create((String)"key").setCell("cf", "q", "v")));
        this.fakeService.count.set(0);
        this.client.sampleRowKeys("fake-table");
        this.fakeService.count.set(0);
        this.client.checkAndMutateRow(ConditionalRowMutation.create((String)"fake-table", (String)"key").then(Mutation.create().setCell("cf", "q", "v")));
        this.fakeService.count.set(0);
        this.client.readModifyWriteRow(ReadModifyWriteRow.create((String)"fake-table", (String)"key").append("cf", "q", "v"));
        this.fakeService.count.set(0);
        this.client.generateInitialChangeStreamPartitions("fake-table").iterator().hasNext();
        this.fakeService.count.set(0);
        for (ChangeStreamRecord changeStreamRecord : this.client.readChangeStream(ReadChangeStreamQuery.create((String)"fake-table"))) {
        }
        Set expected = BigtableGrpc.getServiceDescriptor().getMethods().stream().map(MethodDescriptor::getBareMethodName).collect(Collectors.toSet());
        this.methods.add("PingAndWarm");
        this.methods.add("ExecuteQuery");
        Truth.assertThat(this.methods).containsExactlyElementsIn(expected);
    }

    @Test
    public void testCookieSetWithBigtableClientFactory() throws Exception {
        try (BigtableDataClientFactory factory = BigtableDataClientFactory.create((BigtableDataSettings)this.settings.build());){
            BigtableDataClient client1 = factory.createDefault();
            BigtableDataClient client2 = factory.createForAppProfile("app-profile");
            client1.readRows(Query.create((String)"fake-table")).iterator().hasNext();
            Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
            Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
            Metadata lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
            MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), "readRows", ROUTING_COOKIE_2.name(), testCookie, ROUTING_COOKIE_HEADER.name(), testHeaderCookie);
            MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(BAD_KEY.name());
            this.fakeService.count.set(0);
            this.serverMetadata.clear();
            client2.readRows(Query.create((String)"fake-table")).iterator().hasNext();
            Truth.assertThat((Integer)this.fakeService.count.get()).isGreaterThan((Comparable)Integer.valueOf(1));
            Truth.assertThat(this.serverMetadata).hasSize(this.fakeService.count.get());
            lastMetadata = this.serverMetadata.get(this.fakeService.count.get() - 1);
            MetadataSubject.assertThat(lastMetadata).containsAtLeast(ROUTING_COOKIE_1.name(), "readRows", ROUTING_COOKIE_2.name(), testCookie, ROUTING_COOKIE_HEADER.name(), testHeaderCookie);
            MetadataSubject.assertThat(lastMetadata).doesNotContainKeys(BAD_KEY.name());
            this.serverMetadata.clear();
        }
    }

    @Test
    public void testDisableRoutingCookie() throws IOException {
        this.settings.stubSettings().setEnableRoutingCookie(false);
        try (BigtableDataClient client = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            client.readRows(Query.create((String)"fake-table")).iterator().hasNext();
            Truth.assertThat((Integer)this.fakeService.count.get()).isEqualTo((Object)2);
            this.fakeService.count.set(0);
            client.mutateRow(RowMutation.create((String)"fake-table", (String)"key").setCell("cf", "q", "v"));
            Truth.assertThat((Integer)this.fakeService.count.get()).isEqualTo((Object)2);
            this.fakeService.count.set(0);
            client.bulkMutateRows(BulkMutation.create((String)"fake-table").add(RowMutationEntry.create((String)"key").setCell("cf", "q", "v")));
            Truth.assertThat((Integer)this.fakeService.count.get()).isEqualTo((Object)2);
            this.fakeService.count.set(0);
            client.sampleRowKeys("fake-table");
            Truth.assertThat((Integer)this.fakeService.count.get()).isEqualTo((Object)2);
            this.fakeService.count.set(0);
            client.checkAndMutateRow(ConditionalRowMutation.create((String)"fake-table", (String)"key").then(Mutation.create().setCell("cf", "q", "v")));
            Truth.assertThat((Integer)this.fakeService.count.get()).isEqualTo((Object)2);
            this.fakeService.count.set(0);
            client.readModifyWriteRow(ReadModifyWriteRow.create((String)"fake-table", (String)"key").append("cf", "q", "v"));
            Truth.assertThat((Integer)this.fakeService.count.get()).isEqualTo((Object)2);
            this.fakeService.count.set(0);
            client.generateInitialChangeStreamPartitions("fake-table").iterator().hasNext();
            Truth.assertThat((Integer)this.fakeService.count.get()).isEqualTo((Object)2);
            this.fakeService.count.set(0);
            for (ChangeStreamRecord changeStreamRecord : client.readChangeStream(ReadChangeStreamQuery.create((String)"fake-table"))) {
            }
            Truth.assertThat((Integer)this.fakeService.count.get()).isEqualTo((Object)2);
            Truth.assertThat(this.methods).isEmpty();
        }
    }

    static class FakeService
    extends BigtableGrpc.BigtableImplBase {
        private volatile boolean returnCookie = true;
        private final AtomicInteger count = new AtomicInteger();

        FakeService() {
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            if (this.count.getAndIncrement() < 1) {
                Metadata trailers = new Metadata();
                this.maybePopulateCookie(trailers, "readRows");
                StatusRuntimeException exception = new StatusRuntimeException(Status.UNAVAILABLE, trailers);
                responseObserver.onError((Throwable)exception);
                return;
            }
            responseObserver.onNext((Object)ReadRowsResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        public void mutateRow(MutateRowRequest request, StreamObserver<MutateRowResponse> responseObserver) {
            if (this.count.getAndIncrement() < 1) {
                Metadata trailers = new Metadata();
                this.maybePopulateCookie(trailers, "mutateRow");
                StatusRuntimeException exception = new StatusRuntimeException(Status.UNAVAILABLE, trailers);
                responseObserver.onError((Throwable)exception);
                return;
            }
            responseObserver.onNext((Object)MutateRowResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        public void mutateRows(MutateRowsRequest request, StreamObserver<MutateRowsResponse> responseObserver) {
            if (this.count.getAndIncrement() < 1) {
                Metadata trailers = new Metadata();
                this.maybePopulateCookie(trailers, "mutateRows");
                StatusRuntimeException exception = new StatusRuntimeException(Status.UNAVAILABLE, trailers);
                responseObserver.onError((Throwable)exception);
                return;
            }
            responseObserver.onNext((Object)MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.getDefaultInstance()).build());
            responseObserver.onCompleted();
        }

        public void sampleRowKeys(SampleRowKeysRequest request, StreamObserver<SampleRowKeysResponse> responseObserver) {
            if (this.count.getAndIncrement() < 1) {
                Metadata trailers = new Metadata();
                this.maybePopulateCookie(trailers, "sampleRowKeys");
                StatusRuntimeException exception = new StatusRuntimeException(Status.UNAVAILABLE, trailers);
                responseObserver.onError((Throwable)exception);
                return;
            }
            responseObserver.onNext((Object)SampleRowKeysResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        public void checkAndMutateRow(CheckAndMutateRowRequest request, StreamObserver<CheckAndMutateRowResponse> responseObserver) {
            if (this.count.getAndIncrement() < 1) {
                Metadata trailers = new Metadata();
                this.maybePopulateCookie(trailers, "checkAndMutate");
                StatusRuntimeException exception = new StatusRuntimeException(Status.UNAVAILABLE, trailers);
                responseObserver.onError((Throwable)exception);
                return;
            }
            responseObserver.onNext((Object)CheckAndMutateRowResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        public void readModifyWriteRow(ReadModifyWriteRowRequest request, StreamObserver<ReadModifyWriteRowResponse> responseObserver) {
            if (this.count.getAndIncrement() < 1) {
                Metadata trailers = new Metadata();
                this.maybePopulateCookie(trailers, "readModifyWrite");
                StatusRuntimeException exception = new StatusRuntimeException(Status.UNAVAILABLE, trailers);
                responseObserver.onError((Throwable)exception);
                return;
            }
            responseObserver.onNext((Object)ReadModifyWriteRowResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        public void readChangeStream(ReadChangeStreamRequest request, StreamObserver<ReadChangeStreamResponse> responseObserver) {
            if (this.count.getAndIncrement() < 1) {
                Metadata trailers = new Metadata();
                this.maybePopulateCookie(trailers, "readChangeStream");
                responseObserver.onNext((Object)ReadChangeStreamResponse.newBuilder().setHeartbeat(ReadChangeStreamResponse.Heartbeat.newBuilder().setContinuationToken(StreamContinuationToken.newBuilder().setToken("a").build()).build()).build());
                StatusRuntimeException exception = new StatusRuntimeException(Status.UNAVAILABLE, trailers);
                responseObserver.onError((Throwable)exception);
                return;
            }
            responseObserver.onNext((Object)ReadChangeStreamResponse.newBuilder().setCloseStream(ReadChangeStreamResponse.CloseStream.getDefaultInstance()).build());
            responseObserver.onCompleted();
        }

        public void generateInitialChangeStreamPartitions(GenerateInitialChangeStreamPartitionsRequest request, StreamObserver<GenerateInitialChangeStreamPartitionsResponse> responseObserver) {
            if (this.count.getAndIncrement() < 1) {
                Metadata trailers = new Metadata();
                this.maybePopulateCookie(trailers, "generateInitialChangeStreamPartitions");
                StatusRuntimeException exception = new StatusRuntimeException(Status.UNAVAILABLE, trailers);
                responseObserver.onError((Throwable)exception);
                return;
            }
            responseObserver.onNext((Object)GenerateInitialChangeStreamPartitionsResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        private void maybePopulateCookie(Metadata trailers, String label) {
            if (this.returnCookie) {
                trailers.put(ROUTING_COOKIE_1, (Object)label);
                trailers.put(ROUTING_COOKIE_2, (Object)CookiesHolderTest.testCookie);
                trailers.put(BAD_KEY, (Object)"bad-key");
            }
        }
    }
}

