/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.batching.BatcherImpl;
import com.google.api.gax.batching.BatchingException;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.FailedPreconditionException;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.InstantiatingWatchdogProvider;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.WatchdogTimeoutException;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.v2.FeatureFlags;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.PingAndWarmRequest;
import com.google.bigtable.v2.PingAndWarmResponse;
import com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.Version;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadChangeStreamQuery;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.data.v2.models.sql.Statement;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.metrics.MetricsProvider;
import com.google.cloud.bigtable.data.v2.stub.metrics.NoopMetricsProvider;
import com.google.cloud.bigtable.data.v2.stub.sql.ExecuteQueryCallable;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlServerStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Queues;
import com.google.common.io.BaseEncoding;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.StringValue;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.stub.StreamObserver;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import io.opencensus.trace.samplers.Samplers;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class EnhancedBigtableStubTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String TABLE_ID = "fake-table";
    private static final String TABLE_NAME = NameUtil.formatTableName((String)"fake-project", (String)"fake-instance", (String)"fake-table");
    private static final String APP_PROFILE_ID = "app-profile-id";
    private static final String WAIT_TIME_TABLE_ID = "test-wait-timeout";
    private static final String WAIT_TIME_QUERY = "test-wait-timeout";
    private static final Duration WATCHDOG_CHECK_DURATION = Duration.ofMillis((long)100L);
    private Server server;
    private MetadataInterceptor metadataInterceptor;
    private ContextInterceptor contextInterceptor;
    private FakeDataService fakeDataService;
    private EnhancedBigtableStubSettings defaultSettings;
    private EnhancedBigtableStub enhancedBigtableStub;

    @Before
    public void setUp() throws IOException, IllegalAccessException, InstantiationException {
        this.metadataInterceptor = new MetadataInterceptor();
        this.contextInterceptor = new ContextInterceptor();
        this.fakeDataService = (FakeDataService)((Object)Mockito.spy((Object)((Object)new FakeDataService())));
        this.server = FakeServiceBuilder.create(new BindableService[]{this.fakeDataService}).intercept(this.contextInterceptor).intercept(this.metadataInterceptor).start();
        this.defaultSettings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setAppProfileId(APP_PROFILE_ID).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create()).setMetricsProvider((MetricsProvider)NoopMetricsProvider.INSTANCE).build().getStubSettings();
        this.enhancedBigtableStub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)this.defaultSettings);
    }

    @After
    public void tearDown() {
        this.enhancedBigtableStub.close();
        this.server.shutdown();
    }

    @Test
    public void testJwtAudience() throws InterruptedException, IOException, NoSuchAlgorithmException, ExecutionException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair keyPair = keyGen.genKeyPair();
        ServiceAccountJwtAccessCredentials jwtCreds = ServiceAccountJwtAccessCredentials.newBuilder().setClientId("fake-id").setClientEmail("fake@example.com").setPrivateKey(keyPair.getPrivate()).setPrivateKeyId("fake-private-key").build();
        String expectedAudience = "http://localaudience";
        EnhancedBigtableStubSettings settings = ((EnhancedBigtableStubSettings.Builder)this.defaultSettings.toBuilder().setJwtAudienceMapping((Map)ImmutableMap.of((Object)"localhost", (Object)expectedAudience)).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)jwtCreds))).build();
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings);){
            stub.readRowCallable().futureCall((Object)Query.create((String)TABLE_ID)).get();
        }
        Metadata metadata = this.metadataInterceptor.headers.take();
        String authValue = (String)metadata.get(Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        String expectedPrefix = "Bearer ";
        Truth.assertThat((String)authValue).startsWith(expectedPrefix);
        String jwtStr = authValue.substring(expectedPrefix.length());
        JsonWebSignature parsed = JsonWebSignature.parse((JsonFactory)GsonFactory.getDefaultInstance(), (String)jwtStr);
        Truth.assertThat((Object)parsed.getPayload().getAudience()).isEqualTo((Object)expectedAudience);
    }

    @Test
    public void testBatchJwtAudience() throws InterruptedException, IOException, NoSuchAlgorithmException, ExecutionException {
        Metadata metadata;
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        KeyPair keyPair = keyGen.genKeyPair();
        ServiceAccountJwtAccessCredentials jwtCreds = ServiceAccountJwtAccessCredentials.newBuilder().setClientId("fake-id").setClientEmail("fake@example.com").setPrivateKey(keyPair.getPrivate()).setPrivateKeyId("fake-private-key").build();
        EnhancedBigtableStubSettings settings = ((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)EnhancedBigtableStubSettings.newBuilder().setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setEndpoint("batch-bigtable.googleapis.com:443")).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)jwtCreds))).setMetricsProvider((MetricsProvider)NoopMetricsProvider.INSTANCE).setTransportChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)ManagedChannelBuilder.forAddress((String)"localhost", (int)this.server.getPort()).usePlaintext().build())))).setRefreshingChannel(false).build();
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings);){
            stub.readRowCallable().futureCall((Object)Query.create((String)TABLE_ID)).get();
            metadata = this.metadataInterceptor.headers.take();
        }
        String authValue = (String)metadata.get(Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        String expectedPrefix = "Bearer ";
        Truth.assertThat((String)authValue).startsWith(expectedPrefix);
        String jwtStr = authValue.substring(expectedPrefix.length());
        JsonWebSignature parsed = JsonWebSignature.parse((JsonFactory)GsonFactory.getDefaultInstance(), (String)jwtStr);
        Truth.assertThat((Object)parsed.getPayload().getAudience()).isEqualTo((Object)"https://bigtable.googleapis.com/");
    }

    @Test
    public void testFeatureFlags() throws InterruptedException, IOException, ExecutionException {
        this.enhancedBigtableStub.readRowCallable().futureCall((Object)Query.create((String)TABLE_ID)).get();
        Metadata metadata = this.metadataInterceptor.headers.take();
        String encodedFeatureFlags = (String)metadata.get(Metadata.Key.of((String)"bigtable-features", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        FeatureFlags featureFlags = FeatureFlags.parseFrom((byte[])BaseEncoding.base64Url().decode((CharSequence)encodedFeatureFlags));
        Truth.assertThat((Boolean)featureFlags.getReverseScans()).isTrue();
        Truth.assertThat((Boolean)featureFlags.getLastScannedRowResponses()).isTrue();
    }

    @Test
    public void testPingAndWarmFeatureFlags() throws InterruptedException, IOException, ExecutionException {
        EnhancedBigtableStubSettings settings = this.defaultSettings.toBuilder().setRefreshingChannel(true).build();
        try (EnhancedBigtableStub ignored = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings);){
            Preconditions.checkState((!this.fakeDataService.pingRequests.isEmpty() ? 1 : 0) != 0, (Object)"Ping request was not sent during setup");
            Metadata metadata = this.metadataInterceptor.headers.take();
            String encodedFeatureFlags = (String)metadata.get(Metadata.Key.of((String)"bigtable-features", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            FeatureFlags featureFlags = FeatureFlags.parseFrom((byte[])BaseEncoding.base64Url().decode((CharSequence)encodedFeatureFlags));
            Truth.assertThat((Boolean)featureFlags.getReverseScans()).isTrue();
            Truth.assertThat((Boolean)featureFlags.getLastScannedRowResponses()).isTrue();
            Truth.assertThat((Boolean)featureFlags.getRoutingCookie()).isTrue();
            Truth.assertThat((Boolean)featureFlags.getRetryInfo()).isTrue();
        }
    }

    @Test
    public void testCheckAndMutateRequestResponseConversion() throws ExecutionException, InterruptedException {
        ConditionalRowMutation req = ConditionalRowMutation.create((TargetId)TableId.of((String)"my-table"), (String)"my-key").condition(Filters.FILTERS.pass()).then(Mutation.create().deleteRow());
        ApiFuture f = this.enhancedBigtableStub.checkAndMutateRowCallable().futureCall((Object)req, null);
        f.get();
        CheckAndMutateRowRequest protoReq = this.fakeDataService.checkAndMutateRowRequests.poll(1L, TimeUnit.SECONDS);
        Truth.assertThat((Object)protoReq).isEqualTo((Object)req.toProto(RequestContext.create((String)PROJECT_ID, (String)INSTANCE_ID, (String)APP_PROFILE_ID)));
        Truth.assertThat((Boolean)((Boolean)f.get())).isEqualTo((Object)true);
    }

    @Test
    public void testRMWRequestResponseConversion() throws ExecutionException, InterruptedException {
        ReadModifyWriteRow req = ReadModifyWriteRow.create((TargetId)TableId.of((String)"my-table"), (String)"my-key").append("f", "q", "v");
        ApiFuture f = this.enhancedBigtableStub.readModifyWriteRowCallable().futureCall((Object)req, null);
        f.get();
        ReadModifyWriteRowRequest protoReq = this.fakeDataService.rmwRequests.poll(1L, TimeUnit.SECONDS);
        Truth.assertThat((Object)protoReq).isEqualTo((Object)req.toProto(RequestContext.create((String)PROJECT_ID, (String)INSTANCE_ID, (String)APP_PROFILE_ID)));
        Truth.assertThat((Iterable)((Row)f.get()).getKey()).isEqualTo((Object)ByteString.copyFromUtf8((String)"my-key"));
    }

    @Test
    public void testMutateRowRequestResponseConversion() throws ExecutionException, InterruptedException {
        RowMutation req = RowMutation.create((TargetId)TableId.of((String)"my-table"), (String)"my-key").deleteRow();
        CallOptions.Key testKey = CallOptions.Key.create((String)"test-key");
        GrpcCallContext ctx = GrpcCallContext.createDefault().withCallOptions(CallOptions.DEFAULT.withOption(testKey, (Object)"callopt-value"));
        ApiFuture f = this.enhancedBigtableStub.mutateRowCallable().futureCall((Object)req, (ApiCallContext)ctx);
        f.get();
        MutateRowRequest protoReq = this.fakeDataService.mutateRowRequests.poll(1L, TimeUnit.SECONDS);
        Truth.assertThat((Object)protoReq).isEqualTo((Object)req.toProto(RequestContext.create((String)PROJECT_ID, (String)INSTANCE_ID, (String)APP_PROFILE_ID)));
        Truth.assertThat((Object)f.get()).isEqualTo(null);
    }

    @Test
    public void testMutateRowRequestParams() throws ExecutionException, InterruptedException {
        RowMutation req = RowMutation.create((TargetId)TableId.of((String)TABLE_ID), (String)"my-key").deleteRow();
        ApiFuture f = this.enhancedBigtableStub.mutateRowCallable().futureCall((Object)req, null);
        f.get();
        Metadata reqMetadata = this.metadataInterceptor.headers.poll(1L, TimeUnit.SECONDS);
        String reqParams = (String)reqMetadata.get(Metadata.Key.of((String)"x-goog-request-params", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        Truth.assertThat((String)reqParams).contains((CharSequence)("table_name=" + TABLE_NAME.replace("/", "%2F")));
        Truth.assertThat((String)reqParams).contains((CharSequence)String.format("app_profile_id=%s", APP_PROFILE_ID));
        Truth.assertThat((Iterable)reqMetadata.keys()).contains((Object)"bigtable-client-attempt-epoch-usec");
        Truth.assertThat((Object)f.get()).isEqualTo(null);
    }

    @Test
    public void testMutateRowErrorPropagation() {
        AtomicInteger invocationCount = new AtomicInteger();
        ((FakeDataService)((Object)Mockito.doAnswer(invocationOnMock -> {
            StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
            if (invocationCount.getAndIncrement() == 0) {
                observer.onError((Throwable)Status.UNAVAILABLE.asRuntimeException());
            } else {
                observer.onError((Throwable)Status.FAILED_PRECONDITION.asRuntimeException());
            }
            return null;
        }).when((Object)this.fakeDataService))).mutateRow((MutateRowRequest)Mockito.any(), (StreamObserver<MutateRowResponse>)((StreamObserver)Mockito.any(StreamObserver.class)));
        RowMutation req = RowMutation.create((TargetId)TableId.of((String)TABLE_ID), (String)"my-key").deleteRow();
        ApiFuture f = this.enhancedBigtableStub.mutateRowCallable().futureCall((Object)req, null);
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> f.get());
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(FailedPreconditionException.class);
        Truth.assertThat((Integer)invocationCount.get()).isEqualTo((Object)2);
    }

    @Test
    public void testCreateReadRowsCallable() throws InterruptedException {
        ServerStreamingCallable streamingCallable = this.enhancedBigtableStub.createReadRowsCallable((RowAdapter)new DefaultRowAdapter());
        Query request = Query.create((String)"table-id").rowKey("row-key");
        streamingCallable.call((Object)request).iterator().next();
        ReadRowsRequest expected = request.toProto(RequestContext.create((String)PROJECT_ID, (String)INSTANCE_ID, (String)APP_PROFILE_ID));
        Truth.assertThat((Object)this.fakeDataService.popLastRequest()).isEqualTo((Object)expected);
    }

    @Test
    public void testCreateReadRowsRawCallable() throws InterruptedException {
        ServerStreamingCallable callable = this.enhancedBigtableStub.createReadRowsRawCallable((RowAdapter)new DefaultRowAdapter());
        ReadRowsRequest expectedRequest = ReadRowsRequest.newBuilder().setTableName(TABLE_NAME).setAppProfileId("app-profile-1").setRows(RowSet.newBuilder().addRowKeys(ByteString.copyFromUtf8((String)"test-row-key"))).build();
        callable.call((Object)expectedRequest).iterator().next();
        Truth.assertThat((Object)this.fakeDataService.popLastRequest()).isEqualTo((Object)expectedRequest);
        ReadRowsRequest expectedRequest2 = ReadRowsRequest.newBuilder().setTableName(TABLE_NAME).setAppProfileId("app-profile-2").build();
        callable.call((Object)expectedRequest2).iterator().next();
        Truth.assertThat((Object)this.fakeDataService.popLastRequest()).isEqualTo((Object)expectedRequest2);
    }

    @Test
    public void testChannelPrimerConfigured() throws IOException {
        EnhancedBigtableStubSettings settings = this.defaultSettings.toBuilder().setRefreshingChannel(true).build();
        try (EnhancedBigtableStub ignored = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings);){
            Truth.assertThat(this.fakeDataService.pingRequests).hasSize(1);
        }
    }

    @Test
    public void testUserAgent() throws InterruptedException {
        ServerStreamingCallable streamingCallable = this.enhancedBigtableStub.createReadRowsCallable((RowAdapter)new DefaultRowAdapter());
        Query request = Query.create((String)"table-id").rowKey("row-key");
        streamingCallable.call((Object)request).iterator().next();
        Truth.assertThat(this.metadataInterceptor.headers).hasSize(1);
        Metadata metadata = this.metadataInterceptor.headers.take();
        Truth.assertThat((String)((String)metadata.get(Metadata.Key.of((String)"user-agent", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)))).containsMatch("bigtable-java/\\d+\\.\\d+\\.\\d+(?:-SNAPSHOT)?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpanAttributes() throws InterruptedException {
        final ArrayBlockingQueue spans = new ArrayBlockingQueue(100);
        String handlerName = "stub-test-exporter";
        Tracing.getExportComponent().getSpanExporter().registerHandler(handlerName, new SpanExporter.Handler(){

            public void export(Collection<SpanData> collection) {
                spans.addAll(collection);
            }
        });
        SpanData foundSpanData = null;
        try {
            try (Scope ignored = Tracing.getTracer().spanBuilder("fake-parent-span").setSampler(Samplers.alwaysSample()).startScopedSpan();){
                this.enhancedBigtableStub.readRowCallable().call((Object)Query.create((String)"table-id").rowKey("row-key"));
            }
            for (int i = 0; i < 100; ++i) {
                SpanData spanData = (SpanData)spans.poll(10L, TimeUnit.SECONDS);
                if (!"Bigtable.ReadRow".equals(spanData.getName())) continue;
                foundSpanData = spanData;
                break;
            }
        }
        finally {
            Tracing.getExportComponent().getSpanExporter().unregisterHandler(handlerName);
        }
        Truth.assertThat(foundSpanData).isNotNull();
        Truth.assertThat((Map)foundSpanData.getAttributes().getAttributeMap()).containsEntry((Object)"gapic", (Object)AttributeValue.stringAttributeValue((String)Version.VERSION));
        Truth.assertThat((Map)foundSpanData.getAttributes().getAttributeMap()).containsEntry((Object)"grpc", (Object)AttributeValue.stringAttributeValue((String)GrpcUtil.getGrpcBuildVersion().getImplementationVersion()));
        Truth.assertThat((Map)foundSpanData.getAttributes().getAttributeMap()).containsEntry((Object)"gax", (Object)AttributeValue.stringAttributeValue((String)GaxGrpcProperties.getGaxGrpcVersion()));
    }

    @Test
    public void testBulkMutationFlowControllerConfigured() throws Exception {
        EnhancedBigtableStub stub2;
        BigtableDataSettings.Builder settings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId("my-project").setInstanceId("my-instance").setCredentialsProvider(this.defaultSettings.getCredentialsProvider()).enableBatchMutationLatencyBasedThrottling(10L);
        settings.stubSettings().bulkMutateRowsSettings().setBatchingSettings(BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(50L)).setRequestByteThreshold(Long.valueOf(500L)).setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf(100L)).setMaxOutstandingRequestBytes(Long.valueOf(1000L)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).build()).build()).build();
        try (EnhancedBigtableStub stub1 = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.build().getStubSettings());){
            stub2 = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.build().getStubSettings());
            try {
                BatcherImpl batcher2;
                try (BatcherImpl batcher1 = (BatcherImpl)stub1.newMutateRowsBatcher("my-table1", null);){
                    batcher2 = (BatcherImpl)stub1.newMutateRowsBatcher("my-table2", null);
                    try {
                        Truth.assertThat((Object)batcher1.getFlowController()).isNotNull();
                        Truth.assertThat((Object)batcher1.getFlowController().getFlowControlEventStats()).isNotNull();
                        Truth.assertThat((Object)batcher1).isNotSameInstanceAs((Object)batcher2);
                        Truth.assertThat((Object)batcher1.getFlowController()).isSameInstanceAs((Object)batcher2.getFlowController());
                        Truth.assertThat((Object)batcher1.getFlowController().getFlowControlEventStats()).isSameInstanceAs((Object)batcher2.getFlowController().getFlowControlEventStats());
                        Truth.assertThat((Long)batcher1.getFlowController().getMaxElementCountLimit()).isEqualTo((Object)100L);
                        Truth.assertThat((Long)batcher1.getFlowController().getMaxRequestBytesLimit()).isEqualTo((Object)1000L);
                        Truth.assertThat((Long)batcher1.getFlowController().getCurrentElementCountLimit()).isLessThan((Comparable)Long.valueOf(100L));
                        Truth.assertThat((Long)batcher1.getFlowController().getCurrentRequestBytesLimit()).isEqualTo((Object)1000L);
                        Truth.assertThat((Long)batcher1.getFlowController().getMinElementCountLimit()).isAtLeast((Comparable)settings.stubSettings().bulkMutateRowsSettings().getBatchingSettings().getElementCountThreshold());
                        Truth.assertThat((Long)batcher1.getFlowController().getMinRequestBytesLimit()).isEqualTo((Object)1000L);
                    }
                    finally {
                        if (batcher2 != null) {
                            batcher2.close();
                        }
                    }
                }
                batcher1 = (BatcherImpl)stub1.newMutateRowsBatcher("my-table1", null);
                try {
                    batcher2 = (BatcherImpl)stub2.newMutateRowsBatcher("my-table2", null);
                    try {
                        Truth.assertThat((Object)batcher1.getFlowController()).isNotNull();
                        Truth.assertThat((Object)batcher1.getFlowController().getFlowControlEventStats()).isNotNull();
                        Truth.assertThat((Object)batcher1.getFlowController()).isNotSameInstanceAs((Object)batcher2.getFlowController());
                        Truth.assertThat((Object)batcher1.getFlowController().getFlowControlEventStats()).isNotSameInstanceAs((Object)batcher2.getFlowController().getFlowControlEventStats());
                    }
                    finally {
                        if (batcher2 != null) {
                            batcher2.close();
                        }
                    }
                }
                finally {
                    if (batcher1 != null) {
                        batcher1.close();
                    }
                }
            }
            finally {
                if (stub2 != null) {
                    stub2.close();
                }
            }
        }
        stub1 = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.build().getStubSettings());
        try {
            stub2 = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.disableBatchMutationLatencyBasedThrottling().build().getStubSettings());
            try (BatcherImpl batcher = (BatcherImpl)stub2.newMutateRowsBatcher("my-table", null);){
                Truth.assertThat((Long)batcher.getFlowController().getMaxElementCountLimit()).isEqualTo((Object)100L);
                Truth.assertThat((Long)batcher.getFlowController().getCurrentElementCountLimit()).isEqualTo((Object)100L);
                Truth.assertThat((Long)batcher.getFlowController().getMinElementCountLimit()).isEqualTo((Object)100L);
            }
            finally {
                if (stub2 != null) {
                    stub2.close();
                }
            }
        }
        finally {
            if (stub1 != null) {
                stub1.close();
            }
        }
    }

    @Test
    public void testCallContextPropagatedInMutationBatcher() throws IOException, InterruptedException, ExecutionException {
        EnhancedBigtableStubSettings settings = this.defaultSettings.toBuilder().setRefreshingChannel(true).setPrimedTableIds(new String[]{"table1", "table2"}).build();
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings);){
            this.contextInterceptor.contexts.clear();
            GrpcCallContext clientCtx = GrpcCallContext.createDefault().withTimeout(Duration.ofMinutes((long)10L));
            try (Batcher batcher = stub.newMutateRowsBatcher("table1", clientCtx);){
                batcher.add((Object)RowMutationEntry.create((String)"key").deleteRow()).get();
            }
            Context serverCtx = (Context)this.contextInterceptor.contexts.poll();
            Truth.assertThat((Object)serverCtx).isNotNull();
            Truth.assertThat((Comparable)serverCtx.getDeadline()).isAtLeast((Comparable)Deadline.after((long)8L, (TimeUnit)TimeUnit.MINUTES));
        }
    }

    @Test
    public void testCallContextPropagatedInReadBatcher() throws IOException, InterruptedException, ExecutionException {
        EnhancedBigtableStubSettings settings = this.defaultSettings.toBuilder().setRefreshingChannel(true).setPrimedTableIds(new String[]{"table1", "table2"}).build();
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings);){
            this.contextInterceptor.contexts.clear();
            GrpcCallContext clientCtx = GrpcCallContext.createDefault().withTimeout(Duration.ofMinutes((long)10L));
            try (Batcher batcher = stub.newBulkReadRowsBatcher(Query.create((String)"table1"), clientCtx);){
                batcher.add((Object)ByteString.copyFromUtf8((String)"key")).get();
            }
            Context serverCtx = (Context)this.contextInterceptor.contexts.poll();
            Truth.assertThat((Object)serverCtx).isNotNull();
            Truth.assertThat((Comparable)serverCtx.getDeadline()).isAtLeast((Comparable)Deadline.after((long)8L, (TimeUnit)TimeUnit.MINUTES));
        }
    }

    @Test
    public void testBulkMutationFlowControlFeatureFlagIsSet() throws Exception {
        BulkMutation bulkMutation = BulkMutation.create((String)"my-table").add(RowMutationEntry.create((String)"row-key").setCell("cf", "q", "value"));
        EnhancedBigtableStubSettings.Builder settings = this.defaultSettings.toBuilder();
        settings.bulkMutateRowsSettings().setServerInitiatedFlowControl(true);
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.build());){
            stub.bulkMutateRowsCallable().call((Object)bulkMutation);
        }
        Truth.assertThat(this.metadataInterceptor.headers).hasSize(1);
        Metadata metadata = this.metadataInterceptor.headers.take();
        String encodedFlags = (String)metadata.get(Metadata.Key.of((String)"bigtable-features", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        byte[] decodedFlags = Base64.getDecoder().decode(encodedFlags);
        FeatureFlags featureFlags = FeatureFlags.parseFrom((byte[])decodedFlags);
        Truth.assertThat((Boolean)featureFlags.getMutateRowsRateLimit()).isTrue();
        Truth.assertThat((Boolean)featureFlags.getMutateRowsRateLimit2()).isTrue();
    }

    @Test
    public void testBulkMutationFlowControlFeatureFlagIsNotSet() throws Exception {
        BulkMutation bulkMutation = BulkMutation.create((String)"my-table").add(RowMutationEntry.create((String)"row-key").setCell("cf", "q", "value"));
        EnhancedBigtableStubSettings.Builder settings = this.defaultSettings.toBuilder();
        settings.bulkMutateRowsSettings().setServerInitiatedFlowControl(false);
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.build());){
            stub.bulkMutateRowsCallable().call((Object)bulkMutation);
        }
        Truth.assertThat(this.metadataInterceptor.headers).hasSize(1);
        Metadata metadata = this.metadataInterceptor.headers.take();
        String encodedFlags = (String)metadata.get(Metadata.Key.of((String)"bigtable-features", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
        byte[] decodedFlags = Base64.getDecoder().decode(encodedFlags);
        FeatureFlags featureFlags = FeatureFlags.parseFrom((byte[])decodedFlags);
        Truth.assertThat((Boolean)featureFlags.getMutateRowsRateLimit()).isFalse();
        Truth.assertThat((Boolean)featureFlags.getMutateRowsRateLimit2()).isFalse();
    }

    @Test
    public void testWaitTimeoutIsSet() throws Exception {
        EnhancedBigtableStubSettings.Builder settings = this.defaultSettings.toBuilder();
        settings.readRowsSettings().setWaitTimeout(WATCHDOG_CHECK_DURATION.dividedBy(2L));
        settings.setStreamWatchdogProvider(InstantiatingWatchdogProvider.create().withCheckInterval(WATCHDOG_CHECK_DURATION));
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.build());){
            ServerStream results = stub.readRowsCallable().call((Object)Query.create((String)"test-wait-timeout"));
            WatchdogTimeoutException ex = (WatchdogTimeoutException)Assert.assertThrows(WatchdogTimeoutException.class, () -> results.iterator().next());
            Truth.assertThat((Throwable)ex).hasMessageThat().contains((CharSequence)"Canceled due to timeout waiting for next response");
        }
    }

    @Test
    public void testReadChangeStreamWaitTimeoutIsSet() throws Exception {
        EnhancedBigtableStubSettings.Builder settings = this.defaultSettings.toBuilder();
        settings.readChangeStreamSettings().setWaitTimeout(WATCHDOG_CHECK_DURATION.dividedBy(2L));
        settings.setStreamWatchdogProvider(InstantiatingWatchdogProvider.create().withCheckInterval(WATCHDOG_CHECK_DURATION));
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.build());){
            ServerStream results = stub.readChangeStreamCallable().call((Object)ReadChangeStreamQuery.create((String)"test-wait-timeout"));
            WatchdogTimeoutException ex = (WatchdogTimeoutException)Assert.assertThrows(WatchdogTimeoutException.class, () -> results.iterator().next());
            Truth.assertThat((Throwable)ex).hasMessageThat().contains((CharSequence)"Canceled due to timeout waiting for next response");
        }
    }

    @Test
    public void testBatchMutationsPartialFailure() {
        Batcher batcher = this.enhancedBigtableStub.newMutateRowsBatcher("table1", GrpcCallContext.createDefault());
        batcher.add((Object)RowMutationEntry.create((String)"key0").deleteRow());
        batcher.add((Object)RowMutationEntry.create((String)"key1").deleteRow());
        ((FakeDataService)((Object)Mockito.doAnswer(invocationOnMock -> {
            StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
            observer.onNext((Object)MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(com.google.rpc.Status.newBuilder().setCode(0)).build()).addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(1L).setStatus(com.google.rpc.Status.newBuilder().setCode(7).setMessage("fake partial error")).build()).build());
            observer.onCompleted();
            return null;
        }).when((Object)this.fakeDataService))).mutateRows((MutateRowsRequest)Mockito.any(MutateRowsRequest.class), (StreamObserver<MutateRowsResponse>)((StreamObserver)Mockito.any(StreamObserver.class)));
        BatchingException batchingException = (BatchingException)Assert.assertThrows(BatchingException.class, () -> batcher.close());
        Truth.assertThat((String)batchingException.getMessage()).contains((CharSequence)"Batching finished with 1 partial failures. The 1 partial failures contained 1 entries that failed with: 1 ApiException(1 PERMISSION_DENIED).");
        Truth.assertThat((String)batchingException.getMessage()).contains((CharSequence)"fake partial error");
        Truth.assertThat((String)batchingException.getMessage()).doesNotContain((CharSequence)"INTERNAL");
    }

    @Test
    public void testBatchMutationRPCErrorCode() {
        Batcher batcher = this.enhancedBigtableStub.newMutateRowsBatcher("table1", GrpcCallContext.createDefault());
        ((FakeDataService)((Object)Mockito.doAnswer(invocationOnMock -> {
            StreamObserver observer = (StreamObserver)invocationOnMock.getArgument(1);
            observer.onError((Throwable)Status.PERMISSION_DENIED.asException());
            return null;
        }).when((Object)this.fakeDataService))).mutateRows((MutateRowsRequest)Mockito.any(MutateRowsRequest.class), (StreamObserver<MutateRowsResponse>)((StreamObserver)Mockito.any(StreamObserver.class)));
        batcher.add((Object)RowMutationEntry.create((String)"key0").deleteRow());
        BatchingException batchingException = (BatchingException)Assert.assertThrows(BatchingException.class, () -> batcher.close());
        Truth.assertThat((String)batchingException.getMessage()).contains((CharSequence)"Batching finished with 1 batches failed to apply due to: 1 ApiException(1 PERMISSION_DENIED) and 0 partial failures");
    }

    @Test
    public void testCreateExecuteQueryCallable() throws InterruptedException {
        ExecuteQueryCallable streamingCallable = this.enhancedBigtableStub.createExecuteQueryCallable();
        SqlServerStream sqlServerStream = streamingCallable.call(Statement.of((String)"SELECT * FROM table"));
        ExecuteQueryRequest expectedRequest = ExecuteQueryRequest.newBuilder().setInstanceName(NameUtil.formatInstanceName((String)PROJECT_ID, (String)INSTANCE_ID)).setAppProfileId(APP_PROFILE_ID).setQuery("SELECT * FROM table").build();
        Truth.assertThat(sqlServerStream.rows().iterator().next()).isNotNull();
        Truth.assertThat((Boolean)sqlServerStream.metadataFuture().isDone()).isTrue();
        Truth.assertThat((Object)this.fakeDataService.popLastExecuteQueryRequest()).isEqualTo((Object)expectedRequest);
    }

    @Test
    public void testExecuteQueryWaitTimeoutIsSet() throws IOException {
        EnhancedBigtableStubSettings.Builder settings = this.defaultSettings.toBuilder();
        settings.executeQuerySettings().setWaitTimeout(WATCHDOG_CHECK_DURATION.dividedBy(2L));
        settings.setStreamWatchdogProvider(InstantiatingWatchdogProvider.create().withCheckInterval(WATCHDOG_CHECK_DURATION));
        EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.build());
        Iterator iterator = stub.executeQueryCallable().call(Statement.of((String)"test-wait-timeout")).rows().iterator();
        WatchdogTimeoutException e = (WatchdogTimeoutException)Assert.assertThrows(WatchdogTimeoutException.class, iterator::next);
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"Canceled due to timeout waiting for next response");
    }

    @Test
    public void testExecuteQueryWaitTimeoutWorksWithMetadataFuture() throws IOException, InterruptedException {
        EnhancedBigtableStubSettings.Builder settings = this.defaultSettings.toBuilder();
        settings.executeQuerySettings().setWaitTimeout(WATCHDOG_CHECK_DURATION.dividedBy(2L));
        settings.setStreamWatchdogProvider(InstantiatingWatchdogProvider.create().withCheckInterval(WATCHDOG_CHECK_DURATION));
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.build());){
            ApiFuture future = stub.executeQueryCallable().call(Statement.of((String)"test-wait-timeout")).metadataFuture();
            ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> future.get());
            Truth.assertThat((Throwable)e.getCause()).isInstanceOf(WatchdogTimeoutException.class);
            Truth.assertThat((String)e.getCause().getMessage()).contains((CharSequence)"Canceled due to timeout waiting for next response");
            Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"Canceled due to timeout waiting for next response");
        }
    }

    private static class MetadataInterceptor
    implements ServerInterceptor {
        final BlockingQueue<Metadata> headers = Queues.newLinkedBlockingDeque();

        private MetadataInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
            this.headers.add(metadata);
            return serverCallHandler.startCall(serverCall, metadata);
        }
    }

    private static class ContextInterceptor
    implements ServerInterceptor {
        final BlockingQueue<Context> contexts = Queues.newLinkedBlockingDeque();

        private ContextInterceptor() {
        }

        public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
            this.contexts.add(Context.current());
            return serverCallHandler.startCall(serverCall, metadata);
        }
    }

    private static class FakeDataService
    extends BigtableGrpc.BigtableImplBase {
        final BlockingQueue<ReadRowsRequest> requests = Queues.newLinkedBlockingDeque();
        final BlockingQueue<ReadChangeStreamRequest> readChangeReadStreamRequests = Queues.newLinkedBlockingDeque();
        final BlockingQueue<PingAndWarmRequest> pingRequests = Queues.newLinkedBlockingDeque();
        final BlockingQueue<ExecuteQueryRequest> executeQueryRequests = Queues.newLinkedBlockingDeque();
        final BlockingQueue<MutateRowRequest> mutateRowRequests = Queues.newLinkedBlockingDeque();
        final BlockingQueue<CheckAndMutateRowRequest> checkAndMutateRowRequests = Queues.newLinkedBlockingDeque();
        final BlockingQueue<ReadModifyWriteRowRequest> rmwRequests = Queues.newLinkedBlockingDeque();

        private FakeDataService() {
        }

        ReadRowsRequest popLastRequest() throws InterruptedException {
            return this.requests.poll(1L, TimeUnit.SECONDS);
        }

        ExecuteQueryRequest popLastExecuteQueryRequest() throws InterruptedException {
            return this.executeQueryRequests.poll(1L, TimeUnit.SECONDS);
        }

        public void mutateRow(MutateRowRequest request, StreamObserver<MutateRowResponse> responseObserver) {
            this.mutateRowRequests.add(request);
            responseObserver.onNext((Object)MutateRowResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        public void checkAndMutateRow(CheckAndMutateRowRequest request, StreamObserver<CheckAndMutateRowResponse> responseObserver) {
            this.checkAndMutateRowRequests.add(request);
            responseObserver.onNext((Object)CheckAndMutateRowResponse.newBuilder().setPredicateMatched(true).build());
            responseObserver.onCompleted();
        }

        public void readModifyWriteRow(ReadModifyWriteRowRequest request, StreamObserver<ReadModifyWriteRowResponse> responseObserver) {
            this.rmwRequests.add(request);
            responseObserver.onNext((Object)ReadModifyWriteRowResponse.newBuilder().setRow(com.google.bigtable.v2.Row.newBuilder().setKey(request.getRowKey())).build());
            responseObserver.onCompleted();
        }

        public void mutateRows(MutateRowsRequest request, StreamObserver<MutateRowsResponse> responseObserver) {
            MutateRowsResponse.Builder builder = MutateRowsResponse.newBuilder();
            for (int i = 0; i < request.getEntriesCount(); ++i) {
                builder.addEntries(MutateRowsResponse.Entry.newBuilder().setIndex((long)i).build());
            }
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            if (request.getTableName().contains("test-wait-timeout")) {
                try {
                    Thread.sleep(WATCHDOG_CHECK_DURATION.toMillis() * 2L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.requests.add(request);
            responseObserver.onNext((Object)ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setCommitRow(true).setRowKey(ByteString.copyFromUtf8((String)"a")).setFamilyName(StringValue.getDefaultInstance()).setQualifier(BytesValue.getDefaultInstance()).setValueSize(0)).build());
            responseObserver.onCompleted();
        }

        public void readChangeStream(ReadChangeStreamRequest request, StreamObserver<ReadChangeStreamResponse> responseObserver) {
            if (request.getTableName().contains("test-wait-timeout")) {
                try {
                    Thread.sleep(WATCHDOG_CHECK_DURATION.toMillis() * 2L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.readChangeReadStreamRequests.add(request);
            responseObserver.onNext((Object)ReadChangeStreamResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        public void pingAndWarm(PingAndWarmRequest request, StreamObserver<PingAndWarmResponse> responseObserver) {
            this.pingRequests.add(request);
            responseObserver.onNext((Object)PingAndWarmResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        public void executeQuery(ExecuteQueryRequest request, StreamObserver<ExecuteQueryResponse> responseObserver) {
            if (request.getQuery().contains("test-wait-timeout")) {
                try {
                    Thread.sleep(WATCHDOG_CHECK_DURATION.toMillis() * 2L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.executeQueryRequests.add(request);
            responseObserver.onNext((Object)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("foo", SqlProtoFactory.stringType())));
            responseObserver.onNext((Object)SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("test")));
        }
    }
}

