/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.RateLimitInfo;
import com.google.cloud.bigtable.data.v2.stub.RateLimitingServerStreamingCallable;
import com.google.cloud.bigtable.gaxx.testing.FakeStatusCode;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.rpc.Status;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class RateLimitingCallableTest {
    private final MutateRowsRequest request = MutateRowsRequest.newBuilder().getDefaultInstanceForType();
    private final ResponseObserver<MutateRowsResponse> responseObserver = (ResponseObserver)Mockito.mock(ResponseObserver.class);
    private final ApiCallContext context = GrpcCallContext.createDefault();
    private MockCallable innerCallable;
    RateLimitingServerStreamingCallable callableToTest;

    @Before
    public void setup() throws Exception {
        this.innerCallable = new MockCallable();
        this.callableToTest = new RateLimitingServerStreamingCallable((ServerStreamingCallable)this.innerCallable);
    }

    @Test
    public void testDefaultSettingOnInitiate() throws Exception {
        this.callableToTest.call(this.request, this.responseObserver, this.context);
        Assert.assertFalse((boolean)this.callableToTest.getLimiterEnabled());
        Truth.assertThat((Double)this.callableToTest.getCurrentRate()).isEqualTo((Object)10);
    }

    @Test
    public void testUpdateRate() throws Exception {
        this.callableToTest.call(this.request, this.responseObserver, this.context);
        this.callableToTest.setLimiterEnabled(true);
        Instant earlier = Instant.now().minus(java.time.Duration.ofHours(1L));
        this.callableToTest.getNextRateUpdateTime().set(earlier);
        double oldQps = this.callableToTest.getCurrentRate();
        double factor = 0.8;
        int periodSeconds = 10;
        RateLimitInfo info = RateLimitInfo.newBuilder().setFactor(factor).setPeriod(Duration.newBuilder().setSeconds((long)periodSeconds).build()).build();
        MutateRowsResponse response = MutateRowsResponse.newBuilder().setRateLimitInfo(info).build();
        this.innerCallable.getObserver().onResponse((Object)response);
        Thread.sleep(100L);
        double newQps = this.callableToTest.getCurrentRate();
        Truth.assertThat((Double)newQps).isWithin(0.01).of(oldQps * factor);
        this.innerCallable.getObserver().onComplete();
    }

    @Test
    public void testNoRateLimitInfoDoesNotUpdateRate() throws Exception {
        this.callableToTest.call(this.request, this.responseObserver, this.context);
        this.callableToTest.setLimiterEnabled(true);
        Instant earlier = Instant.now().minus(java.time.Duration.ofHours(1L));
        this.callableToTest.getNextRateUpdateTime().set(earlier);
        double oldQps = this.callableToTest.getCurrentRate();
        MutateRowsResponse response = MutateRowsResponse.newBuilder().build();
        this.innerCallable.getObserver().onResponse((Object)response);
        Thread.sleep(100L);
        double newQps = this.callableToTest.getCurrentRate();
        Truth.assertThat((Double)newQps).isEqualTo((Object)oldQps);
        Assert.assertFalse((boolean)this.callableToTest.getLimiterEnabled());
        this.innerCallable.getObserver().onComplete();
    }

    @Test
    public void testInvalidRateLimitInfoDoesNotUpdateRate() throws Exception {
        this.callableToTest.call(this.request, this.responseObserver, this.context);
        this.callableToTest.setLimiterEnabled(true);
        Instant earlier = Instant.now().minus(java.time.Duration.ofHours(1L));
        this.callableToTest.getNextRateUpdateTime().set(earlier);
        double oldQps = this.callableToTest.getCurrentRate();
        double factor = 0.0;
        int periodSeconds = 10;
        RateLimitInfo info = RateLimitInfo.newBuilder().setFactor(factor).setPeriod(Duration.newBuilder().setSeconds((long)periodSeconds).build()).build();
        MutateRowsResponse response = MutateRowsResponse.newBuilder().setRateLimitInfo(info).build();
        this.innerCallable.getObserver().onResponse((Object)response);
        Thread.sleep(100L);
        double newQps = this.callableToTest.getCurrentRate();
        Truth.assertThat((Double)newQps).isEqualTo((Object)oldQps);
        Assert.assertFalse((boolean)this.callableToTest.getLimiterEnabled());
        this.innerCallable.getObserver().onComplete();
    }

    @Test
    public void testMissingRateLimitInfoFactorDoesNotUpdateRate() throws Exception {
        this.callableToTest.call(this.request, this.responseObserver, this.context);
        this.callableToTest.setLimiterEnabled(true);
        Instant earlier = Instant.now().minus(java.time.Duration.ofHours(1L));
        this.callableToTest.getNextRateUpdateTime().set(earlier);
        double oldQps = this.callableToTest.getCurrentRate();
        int periodSeconds = 10;
        RateLimitInfo info = RateLimitInfo.newBuilder().setPeriod(Duration.newBuilder().setSeconds((long)periodSeconds).build()).build();
        MutateRowsResponse response = MutateRowsResponse.newBuilder().setRateLimitInfo(info).build();
        this.innerCallable.getObserver().onResponse((Object)response);
        Thread.sleep(100L);
        double newQps = this.callableToTest.getCurrentRate();
        Truth.assertThat((Double)newQps).isEqualTo((Object)oldQps);
        Assert.assertFalse((boolean)this.callableToTest.getLimiterEnabled());
        this.innerCallable.getObserver().onComplete();
    }

    @Test
    public void testNoUpdateBeforeAllowedTime() throws Exception {
        this.callableToTest.call(this.request, this.responseObserver, this.context);
        this.callableToTest.setLimiterEnabled(true);
        Instant later = Instant.now().plus(java.time.Duration.ofHours(1L));
        this.callableToTest.getNextRateUpdateTime().set(later);
        double oldQps = this.callableToTest.getCurrentRate();
        double factor = 0.3;
        int periodSeconds = 10;
        RateLimitInfo info = RateLimitInfo.newBuilder().setFactor(factor).setPeriod(Duration.newBuilder().setSeconds((long)periodSeconds).build()).build();
        MutateRowsResponse response = MutateRowsResponse.newBuilder().setRateLimitInfo(info).build();
        this.innerCallable.getObserver().onResponse((Object)response);
        Thread.sleep(100L);
        double newQps = this.callableToTest.getCurrentRate();
        Truth.assertThat((Double)newQps).isEqualTo((Object)oldQps);
        Assert.assertTrue((boolean)this.callableToTest.getLimiterEnabled());
        this.innerCallable.getObserver().onComplete();
    }

    @Test
    public void testDoesNotDisableBeforeAllowedTime() throws Exception {
        this.callableToTest.call(this.request, this.responseObserver, this.context);
        this.callableToTest.setLimiterEnabled(true);
        Instant later = Instant.now().plus(java.time.Duration.ofHours(1L));
        this.callableToTest.getNextRateUpdateTime().set(later);
        double oldQps = this.callableToTest.getCurrentRate();
        MutateRowsResponse response = MutateRowsResponse.newBuilder().build();
        this.innerCallable.getObserver().onResponse((Object)response);
        Thread.sleep(100L);
        double newQps = this.callableToTest.getCurrentRate();
        Truth.assertThat((Double)newQps).isEqualTo((Object)oldQps);
        Assert.assertTrue((boolean)this.callableToTest.getLimiterEnabled());
        this.innerCallable.getObserver().onComplete();
    }

    @Test
    public void testEnableWithinPeriodDoesNotUpdateRate() throws Exception {
        this.callableToTest.call(this.request, this.responseObserver, this.context);
        this.callableToTest.setRate(1.5);
        Instant later = Instant.now().plus(java.time.Duration.ofHours(1L));
        this.callableToTest.getNextRateUpdateTime().set(later);
        double oldQps = this.callableToTest.getCurrentRate();
        double factor = 0.3;
        int periodSeconds = 600;
        RateLimitInfo info = RateLimitInfo.newBuilder().setFactor(factor).setPeriod(Duration.newBuilder().setSeconds((long)periodSeconds).build()).build();
        MutateRowsResponse response = MutateRowsResponse.newBuilder().setRateLimitInfo(info).build();
        this.innerCallable.getObserver().onResponse((Object)response);
        Thread.sleep(100L);
        double newQps = this.callableToTest.getCurrentRate();
        Truth.assertThat((Double)newQps).isEqualTo((Object)oldQps);
        Assert.assertTrue((boolean)this.callableToTest.getLimiterEnabled());
        this.innerCallable.getObserver().onComplete();
    }

    @Test
    public void testErrorInfoLowerQPS() throws Exception {
        this.callableToTest.call(this.request, this.responseObserver, this.context);
        Instant earlier = Instant.now().minus(java.time.Duration.ofHours(1L));
        this.callableToTest.getNextRateUpdateTime().set(earlier);
        double oldQps = this.callableToTest.getCurrentRate();
        this.innerCallable.getObserver().onError((Throwable)new DeadlineExceededException(new Throwable(), (StatusCode)new FakeStatusCode(StatusCode.Code.DEADLINE_EXCEEDED), false));
        Thread.sleep(100L);
        double newQps = this.callableToTest.getCurrentRate();
        Truth.assertThat((Double)newQps).isWithin(0.1).of(oldQps * 0.7);
    }

    @Test
    public void testResponseIsPropagated() {
        final MutateRowsResponse expectedResponse = MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(Status.newBuilder().setCode(7))).build();
        this.innerCallable = new MockCallable(){

            @Override
            public void call(MutateRowsRequest mutateRowsRequest, ResponseObserver<MutateRowsResponse> responseObserver, ApiCallContext apiCallContext) {
                responseObserver.onResponse((Object)expectedResponse);
                responseObserver.onComplete();
            }
        };
        this.callableToTest = new RateLimitingServerStreamingCallable((ServerStreamingCallable)this.innerCallable);
        ResponseObserver mockObserver = (ResponseObserver)Mockito.mock(ResponseObserver.class);
        MutateRowsRequest req = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"k1")).addMutations(Mutation.newBuilder().setDeleteFromRow(Mutation.DeleteFromRow.getDefaultInstance()))).build();
        this.callableToTest.call(req, mockObserver, this.context);
        ((ResponseObserver)Mockito.verify((Object)mockObserver, (VerificationMode)Mockito.times((int)1))).onResponse((Object)((MutateRowsResponse)Mockito.eq((Object)expectedResponse)));
    }

    private static class MockCallable
    extends ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> {
        private ResponseObserver<MutateRowsResponse> observer;

        private MockCallable() {
        }

        public void call(MutateRowsRequest mutateRowsRequest, ResponseObserver<MutateRowsResponse> responseObserver, ApiCallContext apiCallContext) {
            this.observer = new MockResponseObserver(responseObserver);
        }

        ResponseObserver<MutateRowsResponse> getObserver() {
            return this.observer;
        }
    }

    private static class MockResponseObserver
    implements ResponseObserver<MutateRowsResponse> {
        private ResponseObserver<MutateRowsResponse> observer;

        MockResponseObserver(ResponseObserver<MutateRowsResponse> responseObserver) {
            this.observer = responseObserver;
        }

        public void onStart(StreamController streamController) {
            this.observer.onStart(streamController);
        }

        public void onResponse(MutateRowsResponse o) {
            this.observer.onResponse((Object)o);
        }

        public void onError(Throwable throwable) {
            this.observer.onError(throwable);
        }

        public void onComplete() {
            this.observer.onComplete();
        }
    }
}

