/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ErrorDetails;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnavailableException;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsRequest;
import com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsResponse;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadChangeStreamQuery;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.google.common.truth.Truth;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.rpc.RetryInfo;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RetryInfoTest {
    private static final Metadata.Key<byte[]> ERROR_DETAILS_KEY = Metadata.Key.of((String)"grpc-status-details-bin", (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
    private final Set<String> methods = new HashSet<String>();
    private FakeBigtableService service;
    private Server server;
    private BigtableDataClient client;
    private BigtableDataSettings.Builder settings;
    private AtomicInteger attemptCounter = new AtomicInteger();
    private Duration defaultDelay = Duration.newBuilder().setSeconds(2L).setNanos(0).build();

    @Before
    public void setUp() throws IOException {
        this.service = new FakeBigtableService();
        ServerInterceptor serverInterceptor = new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
                return serverCallHandler.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(serverCall){

                    public void close(Status status, Metadata trailers) {
                        if (trailers.containsKey(ERROR_DETAILS_KEY)) {
                            RetryInfoTest.this.methods.add(serverCall.getMethodDescriptor().getBareMethodName());
                        }
                        super.close(status, trailers);
                    }
                }, metadata);
            }
        };
        this.server = FakeServiceBuilder.create(new BindableService[]{this.service}).intercept(serverInterceptor).start();
        this.settings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId("fake-project").setInstanceId("fake-instance");
        this.client = BigtableDataClient.create((BigtableDataSettings)this.settings.build());
    }

    @After
    public void tearDown() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    @Test
    public void testAllMethods() {
        this.verifyRetryInfoIsUsed(() -> this.client.readRow((TargetId)TableId.of((String)"table"), "row"), true);
        this.attemptCounter.set(0);
        this.verifyRetryInfoIsUsed(() -> this.client.readRows(Query.create((TargetId)TableId.of((String)"table"))).iterator().hasNext(), true);
        this.attemptCounter.set(0);
        this.verifyRetryInfoIsUsed(() -> this.client.bulkMutateRows(BulkMutation.create((TargetId)TableId.of((String)"fake-table")).add(RowMutationEntry.create((String)"row-key-1").setCell("cf", "q", "v"))), true);
        this.attemptCounter.set(0);
        this.verifyRetryInfoIsUsed(() -> this.client.mutateRow(RowMutation.create((TargetId)TableId.of((String)"fake-table"), (String)"key").setCell("cf", "q", "v")), true);
        this.attemptCounter.set(0);
        this.verifyRetryInfoIsUsed(() -> this.client.sampleRowKeys((TargetId)TableId.of((String)"table")), true);
        this.attemptCounter.set(0);
        this.verifyRetryInfoIsUsed(() -> this.client.checkAndMutateRow(ConditionalRowMutation.create((String)"table", (String)"key").condition(Filters.FILTERS.value().regex("old-value")).then(Mutation.create().setCell("cf", "q", "v"))), true);
        this.attemptCounter.set(0);
        this.verifyRetryInfoIsUsed(() -> this.client.readModifyWriteRow(ReadModifyWriteRow.create((String)"table", (String)"row").append("cf", "q", "v")), true);
        this.attemptCounter.set(0);
        this.verifyRetryInfoIsUsed(() -> this.client.readChangeStream(ReadChangeStreamQuery.create((String)"table")).iterator().hasNext(), true);
        this.attemptCounter.set(0);
        this.verifyRetryInfoIsUsed(() -> this.client.generateInitialChangeStreamPartitions("table").iterator().hasNext(), true);
        Set expected = BigtableGrpc.getServiceDescriptor().getMethods().stream().map(MethodDescriptor::getBareMethodName).collect(Collectors.toSet());
        this.methods.add("PingAndWarm");
        this.methods.add("ExecuteQuery");
        Truth.assertThat(this.methods).containsExactlyElementsIn(expected);
    }

    @Test
    public void testReadRowNonRetryableErrorWithRetryInfo() {
        this.verifyRetryInfoIsUsed(() -> this.client.readRow("table", "row"), false);
    }

    @Test
    public void testReadRowDisableRetryInfo() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyRetryInfoCanBeDisabled(() -> newClient.readRow("table", "row"));
        }
    }

    @Test
    public void testReadRowServerNotReturningRetryInfo() {
        this.verifyNoRetryInfo(() -> this.client.readRow("table", "row"), true);
    }

    @Test
    public void testReadRowServerNotReturningRetryInfoClientDisabledHandling() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyNoRetryInfo(() -> newClient.readRow("table", "row"), true);
        }
    }

    @Test
    public void testReadRowsNonRetraybleErrorWithRetryInfo() {
        this.verifyRetryInfoIsUsed(() -> this.client.readRows(Query.create((String)"table")).iterator().hasNext(), false);
    }

    @Test
    public void testReadRowsDisableRetryInfo() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyRetryInfoCanBeDisabled(() -> newClient.readRows(Query.create((String)"table")).iterator().hasNext());
        }
    }

    @Test
    public void testReadRowsServerNotReturningRetryInfo() {
        this.verifyNoRetryInfo(() -> this.client.readRows(Query.create((String)"table")).iterator().hasNext(), true);
    }

    @Test
    public void testReadRowsServerNotReturningRetryInfoClientDisabledHandling() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyNoRetryInfo(() -> newClient.readRows(Query.create((String)"table")).iterator().hasNext(), true);
        }
    }

    @Test
    public void testMutateRowsNonRetryableErrorWithRetryInfo() {
        this.verifyRetryInfoIsUsed(() -> this.client.bulkMutateRows(BulkMutation.create((String)"fake-table").add(RowMutationEntry.create((String)"row-key-1").setCell("cf", "q", "v"))), false);
    }

    @Test
    public void testMutateRowsDisableRetryInfo() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyRetryInfoCanBeDisabled(() -> newClient.bulkMutateRows(BulkMutation.create((String)"fake-table").add(RowMutationEntry.create((String)"row-key-1").setCell("cf", "q", "v"))));
        }
    }

    @Test
    public void testMutateRowsServerNotReturningRetryInfo() {
        this.verifyNoRetryInfo(() -> this.client.bulkMutateRows(BulkMutation.create((String)"fake-table").add(RowMutationEntry.create((String)"row-key-1").setCell("cf", "q", "v"))), true);
    }

    @Test
    public void testMutateRowsServerNotReturningRetryInfoClientDisabledHandling() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyNoRetryInfo(() -> newClient.bulkMutateRows(BulkMutation.create((String)"fake-table").add(RowMutationEntry.create((String)"row-key-1").setCell("cf", "q", "v"))), true);
        }
    }

    @Test
    public void testMutateRowNonRetryableErrorWithRetryInfo() {
        this.verifyRetryInfoIsUsed(() -> this.client.mutateRow(RowMutation.create((String)"table", (String)"key").setCell("cf", "q", "v")), false);
    }

    @Test
    public void testMutateRowDisableRetryInfo() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyRetryInfoCanBeDisabled(() -> newClient.mutateRow(RowMutation.create((String)"table", (String)"key").setCell("cf", "q", "v")));
        }
    }

    @Test
    public void testMutateRowServerNotReturningRetryInfo() {
        this.verifyNoRetryInfo(() -> this.client.mutateRow(RowMutation.create((String)"table", (String)"key").setCell("cf", "q", "v")), true);
    }

    @Test
    public void testMutateRowServerNotReturningRetryInfoClientDisabledHandling() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyNoRetryInfo(() -> newClient.mutateRow(RowMutation.create((String)"table", (String)"key").setCell("cf", "q", "v")), true);
        }
    }

    @Test
    public void testSampleRowKeysNonRetryableErrorWithRetryInfo() {
        this.verifyRetryInfoIsUsed(() -> this.client.sampleRowKeys("table"), false);
    }

    @Test
    public void testSampleRowKeysDisableRetryInfo() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyRetryInfoCanBeDisabled(() -> newClient.sampleRowKeys("table"));
        }
    }

    @Test
    public void testSampleRowKeysServerNotReturningRetryInfo() {
        this.verifyNoRetryInfo(() -> this.client.sampleRowKeys("table"), true);
    }

    @Test
    public void testSampleRowKeysServerNotReturningRetryInfoClientDisabledHandling() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyNoRetryInfo(() -> newClient.sampleRowKeys("table"), true);
        }
    }

    @Test
    public void testCheckAndMutateDisableRetryInfo() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient client = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            ApiException exception = this.enqueueNonRetryableExceptionWithDelay(this.defaultDelay);
            try {
                client.checkAndMutateRow(ConditionalRowMutation.create((String)"table", (String)"key").condition(Filters.FILTERS.value().regex("old-value")).then(Mutation.create().setCell("cf", "q", "v")));
            }
            catch (ApiException e) {
                Truth.assertThat((Object)e.getStatusCode()).isEqualTo((Object)exception.getStatusCode());
            }
            Truth.assertThat((Integer)this.attemptCounter.get()).isEqualTo((Object)1);
        }
    }

    @Test
    public void testCheckAndMutateServerNotReturningRetryInfo() {
        this.verifyNoRetryInfo(() -> this.client.checkAndMutateRow(ConditionalRowMutation.create((String)"table", (String)"key").condition(Filters.FILTERS.value().regex("old-value")).then(Mutation.create().setCell("cf", "q", "v"))), false);
    }

    @Test
    public void testCheckAndMutateServerNotReturningRetryInfoClientDisabledHandling() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyNoRetryInfo(() -> newClient.checkAndMutateRow(ConditionalRowMutation.create((String)"table", (String)"key").condition(Filters.FILTERS.value().regex("old-value")).then(Mutation.create().setCell("cf", "q", "v"))), false);
        }
    }

    @Test
    public void testReadModifyWriteDisableRetryInfo() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient client = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            ApiException exception = this.enqueueNonRetryableExceptionWithDelay(this.defaultDelay);
            try {
                client.readModifyWriteRow(ReadModifyWriteRow.create((String)"table", (String)"row").append("cf", "q", "v"));
            }
            catch (ApiException e) {
                Truth.assertThat((Object)e.getStatusCode()).isEqualTo((Object)exception.getStatusCode());
            }
            Truth.assertThat((Integer)this.attemptCounter.get()).isEqualTo((Object)1);
        }
    }

    @Test
    public void testReadModifyWriteServerNotReturningRetryInfo() {
        this.verifyNoRetryInfo(() -> this.client.readModifyWriteRow(ReadModifyWriteRow.create((String)"table", (String)"row").append("cf", "q", "v")), false);
    }

    @Test
    public void testReadModifyWriteNotReturningRetryInfoClientDisabledHandling() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyNoRetryInfo(() -> newClient.readModifyWriteRow(ReadModifyWriteRow.create((String)"table", (String)"row").append("cf", "q", "v")), false);
        }
    }

    @Test
    public void testReadChangeStreamNonRetryableErrorWithRetryInfo() {
        this.verifyRetryInfoIsUsed(() -> this.client.readChangeStream(ReadChangeStreamQuery.create((String)"table")).iterator().hasNext(), false);
    }

    @Test
    public void testReadChangeStreamDisableRetryInfo() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyRetryInfoCanBeDisabled(() -> newClient.readChangeStream(ReadChangeStreamQuery.create((String)"table")).iterator().hasNext());
        }
    }

    @Test
    public void testReadChangeStreamServerNotReturningRetryInfo() {
        this.verifyNoRetryInfo(() -> this.client.readChangeStream(ReadChangeStreamQuery.create((String)"table")).iterator().hasNext(), true);
    }

    @Test
    public void testReadChangeStreamNotReturningRetryInfoClientDisabledHandling() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyNoRetryInfo(() -> newClient.readChangeStream(ReadChangeStreamQuery.create((String)"table")).iterator().hasNext(), true, Duration.newBuilder().setSeconds(5L).setNanos(0).build());
        }
    }

    @Test
    public void testGenerateInitialChangeStreamPartitionNonRetryableError() {
        this.verifyRetryInfoIsUsed(() -> this.client.generateInitialChangeStreamPartitions("table").iterator().hasNext(), false);
    }

    @Test
    public void testGenerateInitialChangeStreamPartitionDisableRetryInfo() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyRetryInfoCanBeDisabled(() -> newClient.generateInitialChangeStreamPartitions("table").iterator().hasNext());
        }
    }

    @Test
    public void testGenerateInitialChangeStreamServerNotReturningRetryInfo() {
        this.verifyNoRetryInfo(() -> this.client.generateInitialChangeStreamPartitions("table").iterator().hasNext(), true);
    }

    @Test
    public void testGenerateInitialChangeStreamServerNotReturningRetryInfoClientDisabledHandling() throws IOException {
        this.settings.stubSettings().setEnableRetryInfo(false);
        try (BigtableDataClient newClient = BigtableDataClient.create((BigtableDataSettings)this.settings.build());){
            this.verifyNoRetryInfo(() -> newClient.generateInitialChangeStreamPartitions("table").iterator().hasNext(), true);
        }
    }

    private void verifyRetryInfoIsUsed(Runnable runnable, boolean retryableError) {
        if (retryableError) {
            this.enqueueRetryableExceptionWithDelay(this.defaultDelay);
        } else {
            this.enqueueNonRetryableExceptionWithDelay(this.defaultDelay);
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        runnable.run();
        stopwatch.stop();
        Truth.assertThat((Integer)this.attemptCounter.get()).isEqualTo((Object)2);
        Truth.assertThat((Comparable)stopwatch.elapsed()).isAtLeast((Comparable)java.time.Duration.ofSeconds(this.defaultDelay.getSeconds()));
    }

    private void verifyRetryInfoCanBeDisabled(Runnable runnable) {
        this.enqueueRetryableExceptionWithDelay(this.defaultDelay);
        Stopwatch stopwatch = Stopwatch.createStarted();
        runnable.run();
        stopwatch.stop();
        Truth.assertThat((Integer)this.attemptCounter.get()).isEqualTo((Object)2);
        Truth.assertThat((Comparable)stopwatch.elapsed()).isLessThan((Comparable)java.time.Duration.ofSeconds(this.defaultDelay.getSeconds()));
        this.attemptCounter.set(0);
        ApiException expectedApiException = this.enqueueNonRetryableExceptionWithDelay(this.defaultDelay);
        ApiException actualException = (ApiException)Assert.assertThrows((String)"non retryable operations should fail", ApiException.class, runnable::run);
        if (actualException instanceof MutateRowsException) {
            Truth.assertThat((Object)((MutateRowsException.FailedMutation)((MutateRowsException)actualException).getFailedMutations().get(0)).getError().getStatusCode()).isEqualTo((Object)expectedApiException.getStatusCode());
        } else {
            Truth.assertThat((Object)actualException.getStatusCode()).isEqualTo((Object)expectedApiException.getStatusCode());
        }
        Truth.assertThat((Integer)this.attemptCounter.get()).isEqualTo((Object)1);
    }

    private void verifyNoRetryInfo(Runnable runnable, boolean operationRetryable) {
        this.verifyNoRetryInfo(runnable, operationRetryable, this.defaultDelay);
    }

    private void verifyNoRetryInfo(Runnable runnable, boolean operationRetryable, Duration delay) {
        this.enqueueRetryableExceptionNoRetryInfo();
        if (!operationRetryable) {
            Assert.assertThrows((String)"non retryable operation should fail", ApiException.class, runnable::run);
            Truth.assertThat((Integer)this.attemptCounter.get()).isEqualTo((Object)1);
        } else {
            Stopwatch stopwatch = Stopwatch.createStarted();
            runnable.run();
            stopwatch.stop();
            Truth.assertThat((Integer)this.attemptCounter.get()).isEqualTo((Object)2);
            Truth.assertThat((Comparable)stopwatch.elapsed()).isLessThan((Comparable)java.time.Duration.ofSeconds(delay.getSeconds()));
        }
        this.attemptCounter.set(0);
        ApiException expectedApiException = this.enqueueNonRetryableExceptionNoRetryInfo();
        ApiException actualApiException = (ApiException)Assert.assertThrows((String)"non retryable error should fail", ApiException.class, runnable::run);
        if (actualApiException instanceof MutateRowsException) {
            Truth.assertThat((Object)((MutateRowsException.FailedMutation)((MutateRowsException)actualApiException).getFailedMutations().get(0)).getError().getStatusCode()).isEqualTo((Object)expectedApiException.getStatusCode());
        } else {
            Truth.assertThat((Object)actualApiException.getStatusCode()).isEqualTo((Object)expectedApiException.getStatusCode());
        }
        Truth.assertThat((Integer)this.attemptCounter.get()).isEqualTo((Object)1);
    }

    private void enqueueRetryableExceptionWithDelay(Duration delay) {
        Metadata trailers = new Metadata();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(delay).build();
        ErrorDetails errorDetails = ErrorDetails.builder().setRawErrorMessages((List)ImmutableList.of((Object)Any.pack((Message)retryInfo))).build();
        byte[] status = com.google.rpc.Status.newBuilder().addDetails(Any.pack((Message)retryInfo)).build().toByteArray();
        trailers.put(ERROR_DETAILS_KEY, (Object)status);
        UnavailableException exception = new UnavailableException((Throwable)new StatusRuntimeException(Status.UNAVAILABLE, trailers), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE), true, errorDetails);
        this.service.expectations.add((Exception)exception);
    }

    private ApiException enqueueNonRetryableExceptionWithDelay(Duration delay) {
        Metadata trailers = new Metadata();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(delay).build();
        ErrorDetails errorDetails = ErrorDetails.builder().setRawErrorMessages((List)ImmutableList.of((Object)Any.pack((Message)retryInfo))).build();
        byte[] status = com.google.rpc.Status.newBuilder().addDetails(Any.pack((Message)retryInfo)).build().toByteArray();
        trailers.put(ERROR_DETAILS_KEY, (Object)status);
        InternalException exception = new InternalException((Throwable)new StatusRuntimeException(Status.INTERNAL, trailers), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false, errorDetails);
        this.service.expectations.add((Exception)exception);
        return exception;
    }

    private void enqueueRetryableExceptionNoRetryInfo() {
        UnavailableException exception = new UnavailableException((Throwable)new StatusRuntimeException(Status.UNAVAILABLE), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE), true);
        this.service.expectations.add((Exception)exception);
    }

    private ApiException enqueueNonRetryableExceptionNoRetryInfo() {
        InternalException exception = new InternalException((Throwable)new StatusRuntimeException(Status.INTERNAL), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        this.service.expectations.add((Exception)exception);
        return exception;
    }

    private class FakeBigtableService
    extends BigtableGrpc.BigtableImplBase {
        Queue<Exception> expectations = Queues.newArrayDeque();

        private FakeBigtableService() {
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            RetryInfoTest.this.attemptCounter.incrementAndGet();
            if (this.expectations.isEmpty()) {
                responseObserver.onNext((Object)ReadRowsResponse.getDefaultInstance());
                responseObserver.onCompleted();
            } else {
                Exception expectedRpc = this.expectations.poll();
                responseObserver.onError((Throwable)expectedRpc);
            }
        }

        public void mutateRow(MutateRowRequest request, StreamObserver<MutateRowResponse> responseObserver) {
            RetryInfoTest.this.attemptCounter.incrementAndGet();
            if (this.expectations.isEmpty()) {
                responseObserver.onNext((Object)MutateRowResponse.getDefaultInstance());
                responseObserver.onCompleted();
            } else {
                Exception expectedRpc = this.expectations.poll();
                responseObserver.onError((Throwable)expectedRpc);
            }
        }

        public void mutateRows(MutateRowsRequest request, StreamObserver<MutateRowsResponse> responseObserver) {
            RetryInfoTest.this.attemptCounter.incrementAndGet();
            if (this.expectations.isEmpty()) {
                MutateRowsResponse.Builder builder = MutateRowsResponse.newBuilder();
                for (int i = 0; i < request.getEntriesCount(); ++i) {
                    builder.addEntriesBuilder().setIndex((long)i);
                }
                responseObserver.onNext((Object)builder.build());
                responseObserver.onCompleted();
            } else {
                Exception expectedRpc = this.expectations.poll();
                responseObserver.onError((Throwable)expectedRpc);
            }
        }

        public void sampleRowKeys(SampleRowKeysRequest request, StreamObserver<SampleRowKeysResponse> responseObserver) {
            RetryInfoTest.this.attemptCounter.incrementAndGet();
            if (this.expectations.isEmpty()) {
                responseObserver.onNext((Object)SampleRowKeysResponse.getDefaultInstance());
                responseObserver.onCompleted();
            } else {
                Exception expectedRpc = this.expectations.poll();
                responseObserver.onError((Throwable)expectedRpc);
            }
        }

        public void checkAndMutateRow(CheckAndMutateRowRequest request, StreamObserver<CheckAndMutateRowResponse> responseObserver) {
            RetryInfoTest.this.attemptCounter.incrementAndGet();
            if (this.expectations.isEmpty()) {
                responseObserver.onNext((Object)CheckAndMutateRowResponse.getDefaultInstance());
                responseObserver.onCompleted();
            } else {
                Exception expectedRpc = this.expectations.poll();
                responseObserver.onError((Throwable)expectedRpc);
            }
        }

        public void readModifyWriteRow(ReadModifyWriteRowRequest request, StreamObserver<ReadModifyWriteRowResponse> responseObserver) {
            RetryInfoTest.this.attemptCounter.incrementAndGet();
            if (this.expectations.isEmpty()) {
                responseObserver.onNext((Object)ReadModifyWriteRowResponse.getDefaultInstance());
                responseObserver.onCompleted();
            } else {
                Exception expectedRpc = this.expectations.poll();
                responseObserver.onError((Throwable)expectedRpc);
            }
        }

        public void generateInitialChangeStreamPartitions(GenerateInitialChangeStreamPartitionsRequest request, StreamObserver<GenerateInitialChangeStreamPartitionsResponse> responseObserver) {
            RetryInfoTest.this.attemptCounter.incrementAndGet();
            if (this.expectations.isEmpty()) {
                responseObserver.onNext((Object)GenerateInitialChangeStreamPartitionsResponse.getDefaultInstance());
                responseObserver.onCompleted();
            } else {
                Exception expectedRpc = this.expectations.poll();
                responseObserver.onError((Throwable)expectedRpc);
            }
        }

        public void readChangeStream(ReadChangeStreamRequest request, StreamObserver<ReadChangeStreamResponse> responseObserver) {
            RetryInfoTest.this.attemptCounter.incrementAndGet();
            if (this.expectations.isEmpty()) {
                responseObserver.onNext((Object)ReadChangeStreamResponse.newBuilder().setCloseStream(ReadChangeStreamResponse.CloseStream.getDefaultInstance()).build());
                responseObserver.onCompleted();
            } else {
                Exception expectedRpc = this.expectations.poll();
                responseObserver.onError((Throwable)expectedRpc);
            }
        }
    }
}

