/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.PingAndWarmResponse;
import com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.Row;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.data.v2.models.Mutation;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.data.v2.stub.AutoValue_SkipTrailersTest_ServerRpc;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.cloud.bigtable.data.v2.stub.metrics.MetricsProvider;
import com.google.cloud.bigtable.data.v2.stub.metrics.NoopMetricsProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.StringValue;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerServiceDefinition;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@RunWith(value=JUnit4.class)
public class SkipTrailersTest {
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final TargetId TABLE_ID = TableId.of((String)"fake-table");
    private HackedBigtableService hackedService;
    private Server server;
    @Mock
    private ApiTracerFactory tracerFactory;
    private FakeTracer tracer = new FakeTracer();
    private BigtableDataClient client;

    @Before
    public void setUp() throws Exception {
        this.hackedService = new HackedBigtableService();
        this.server = FakeServiceBuilder.create(this.hackedService).start();
        Mockito.when((Object)this.tracerFactory.newTracer((ApiTracer)Mockito.any(), (SpanName)Mockito.any(), (ApiTracerFactory.OperationType)Mockito.any())).thenReturn((Object)this.tracer);
        BigtableDataSettings.Builder clientBuilder = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setMetricsProvider((MetricsProvider)NoopMetricsProvider.INSTANCE).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create());
        clientBuilder.stubSettings().setEnableSkipTrailers(true).setTracerFactory(this.tracerFactory);
        this.client = BigtableDataClient.create((BigtableDataSettings)clientBuilder.build());
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
        this.server.shutdown();
    }

    @Test
    public void testReadRow() throws InterruptedException, ExecutionException {
        ReadRowsResponse fakeResponse = ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"fake-key")).setFamilyName(StringValue.newBuilder().setValue("cf")).setQualifier(BytesValue.newBuilder().setValue(ByteString.copyFromUtf8((String)"q"))).setTimestampMicros(0L).setValue(ByteString.copyFromUtf8((String)"value")).setCommitRow(true)).build();
        this.test(() -> this.client.readRowAsync(TABLE_ID, "fake-key"), fakeResponse);
    }

    @Test
    public void testMutateRow() throws ExecutionException, InterruptedException {
        this.test(() -> this.client.mutateRowAsync(RowMutation.create((TargetId)TABLE_ID, (String)"fake-key")), MutateRowResponse.getDefaultInstance());
    }

    @Test
    public void testCheckAndMutateRow() throws ExecutionException, InterruptedException {
        ConditionalRowMutation req = ConditionalRowMutation.create((TargetId)TABLE_ID, (String)"fake-key").condition(Filters.FILTERS.pass()).then(Mutation.create().deleteRow());
        this.test(() -> this.client.checkAndMutateRowAsync(req), CheckAndMutateRowResponse.getDefaultInstance());
    }

    @Test
    public void testRMW() throws ExecutionException, InterruptedException {
        ReadModifyWriteRow req = ReadModifyWriteRow.create((TargetId)TABLE_ID, (String)"fake-key").append("cf", "q", "A");
        this.test(() -> this.client.readModifyWriteRowAsync(req), ReadModifyWriteRowResponse.newBuilder().setRow(Row.getDefaultInstance()).build());
    }

    private <T> void test(Supplier<ApiFuture<?>> invoker, T fakeResponse) throws InterruptedException, ExecutionException {
        int i;
        ApiFuture future = (ApiFuture)invoker.get();
        ServerRpc rpc = (ServerRpc)this.hackedService.rpcs.poll(30L, TimeUnit.SECONDS);
        Preconditions.checkNotNull((Object)rpc, (Object)"Timed out waiting for the call to be received by the mock server");
        rpc.getResponseStream().onNext(fakeResponse);
        try {
            future.get(1L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            Assert.fail((String)"timed out waiting for the trailer optimization future to resolve");
        }
        for (i = 10; i > 0; --i) {
            try {
                Truth.assertThat((Integer)this.tracer.getCallCount("operationFinishEarly")).isEqualTo((Object)1);
                break;
            }
            catch (AssertionError e) {
                if (i <= 1) {
                    throw e;
                }
                Thread.sleep(100L);
                continue;
            }
        }
        Truth.assertThat((Integer)this.tracer.getCallCount("operationSucceeded")).isEqualTo((Object)0);
        rpc.getResponseStream().onCompleted();
        for (i = 10; i > 0; --i) {
            try {
                Truth.assertThat((Integer)this.tracer.getCallCount("operationSucceeded")).isEqualTo((Object)1);
                break;
            }
            catch (AssertionError e) {
                if (i <= 1) {
                    throw e;
                }
                Thread.sleep(100L);
                continue;
            }
        }
    }

    static class FakeTracer
    extends BigtableTracer {
        ConcurrentHashMap<String, AtomicInteger> callCounts = new ConcurrentHashMap();

        FakeTracer() {
        }

        public void operationFinishEarly() {
            this.record("operationFinishEarly");
        }

        public void operationSucceeded() {
            this.record("operationSucceeded");
        }

        private void record(String op) {
            this.callCounts.computeIfAbsent(op, ignored -> new AtomicInteger()).getAndIncrement();
        }

        private int getCallCount(String op) {
            return Optional.ofNullable(this.callCounts.get(op)).map(AtomicInteger::get).orElse(0);
        }
    }

    class HackedBigtableService
    implements BindableService {
        private final LinkedBlockingDeque<ServerRpc<?, ?>> rpcs = new LinkedBlockingDeque();

        HackedBigtableService() {
        }

        public ServerServiceDefinition bindService() {
            ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((String)"google.bigtable.v2.Bigtable").addMethod(BigtableGrpc.getPingAndWarmMethod(), ServerCalls.asyncUnaryCall((ignored, observer) -> {
                observer.onNext((Object)PingAndWarmResponse.getDefaultInstance());
                observer.onCompleted();
            })).addMethod(BigtableGrpc.getReadRowsMethod(), ServerCalls.asyncServerStreamingCall((req, observer) -> this.rpcs.add(ServerRpc.create(req, observer))));
            ImmutableList unaryDescriptors = ImmutableList.of((Object)BigtableGrpc.getMutateRowMethod(), (Object)BigtableGrpc.getCheckAndMutateRowMethod(), (Object)BigtableGrpc.getReadModifyWriteRowMethod());
            for (MethodDescriptor desc : unaryDescriptors) {
                builder.addMethod(desc.toBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).build(), ServerCalls.asyncServerStreamingCall((req, observer) -> this.rpcs.add(ServerRpc.create(req, observer))));
            }
            return builder.build();
        }
    }

    @AutoValue
    static abstract class ServerRpc<ReqT, RespT> {
        ServerRpc() {
        }

        abstract ReqT getRequest();

        abstract StreamObserver<RespT> getResponseStream();

        static <ReqT, RespT> ServerRpc<ReqT, RespT> create(ReqT req, StreamObserver<RespT> resp) {
            return new AutoValue_SkipTrailersTest_ServerRpc<ReqT, RespT>(req, resp);
        }
    }
}

