/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.changestream;

import com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.StreamContinuationToken;
import com.google.bigtable.v2.StreamPartition;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecordAdapter;
import com.google.cloud.bigtable.data.v2.models.CloseStream;
import com.google.cloud.bigtable.data.v2.models.DefaultChangeStreamRecordAdapter;
import com.google.cloud.bigtable.data.v2.models.Heartbeat;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.stub.changestream.ChangeStreamRecordMergingCallable;
import com.google.cloud.bigtable.gaxx.testing.FakeStreamingApi;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ChangeStreamRecordMergingCallableTest {
    @Test
    public void heartbeatTest() {
        RowRange rowRange = RowRange.newBuilder().getDefaultInstanceForType();
        ReadChangeStreamResponse.Heartbeat heartbeatProto = ReadChangeStreamResponse.Heartbeat.newBuilder().setEstimatedLowWatermark(Timestamp.newBuilder().setSeconds(1000L).build()).setContinuationToken(StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(rowRange)).setToken("random-token").build()).build();
        ReadChangeStreamResponse response = ReadChangeStreamResponse.newBuilder().setHeartbeat(heartbeatProto).build();
        FakeStreamingApi.ServerStreamingStashCallable inner = new FakeStreamingApi.ServerStreamingStashCallable(Collections.singletonList(response));
        ChangeStreamRecordMergingCallable mergingCallable = new ChangeStreamRecordMergingCallable(inner, (ChangeStreamRecordAdapter)new DefaultChangeStreamRecordAdapter());
        List results = (List)mergingCallable.all().call((Object)ReadChangeStreamRequest.getDefaultInstance());
        Truth.assertThat((Integer)results.size()).isEqualTo((Object)1);
        ChangeStreamRecord record = (ChangeStreamRecord)results.get(0);
        Assert.assertTrue((boolean)(record instanceof Heartbeat));
        Heartbeat heartbeat = (Heartbeat)record;
        Truth.assertThat((Object)heartbeat.getChangeStreamContinuationToken().getPartition()).isEqualTo((Object)Range.ByteStringRange.create((ByteString)rowRange.getStartKeyClosed(), (ByteString)rowRange.getEndKeyOpen()));
        Truth.assertThat((String)heartbeat.getChangeStreamContinuationToken().getToken()).isEqualTo((Object)heartbeatProto.getContinuationToken().getToken());
        Truth.assertThat((Comparable)heartbeat.getEstimatedLowWatermark()).isEqualTo((Object)org.threeten.bp.Instant.ofEpochSecond((long)heartbeatProto.getEstimatedLowWatermark().getSeconds(), (long)heartbeatProto.getEstimatedLowWatermark().getNanos()));
        Truth.assertThat((Comparable)heartbeat.getEstimatedLowWatermarkTime()).isEqualTo((Object)Instant.ofEpochSecond(heartbeatProto.getEstimatedLowWatermark().getSeconds(), heartbeatProto.getEstimatedLowWatermark().getNanos()));
    }

    @Test
    public void closeStreamTest() {
        RowRange rowRange = RowRange.newBuilder().setStartKeyClosed(ByteString.copyFromUtf8((String)"")).setEndKeyOpen(ByteString.copyFromUtf8((String)"")).build();
        StreamContinuationToken streamContinuationToken = StreamContinuationToken.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(rowRange).build()).setToken("random-token").build();
        ReadChangeStreamResponse.CloseStream closeStreamProto = ReadChangeStreamResponse.CloseStream.newBuilder().addContinuationTokens(streamContinuationToken).addNewPartitions(StreamPartition.newBuilder().setRowRange(rowRange)).setStatus(Status.newBuilder().setCode(11)).build();
        ReadChangeStreamResponse response = ReadChangeStreamResponse.newBuilder().setCloseStream(closeStreamProto).build();
        FakeStreamingApi.ServerStreamingStashCallable inner = new FakeStreamingApi.ServerStreamingStashCallable(Collections.singletonList(response));
        ChangeStreamRecordMergingCallable mergingCallable = new ChangeStreamRecordMergingCallable(inner, (ChangeStreamRecordAdapter)new DefaultChangeStreamRecordAdapter());
        List results = (List)mergingCallable.all().call((Object)ReadChangeStreamRequest.getDefaultInstance());
        Truth.assertThat((Integer)results.size()).isEqualTo((Object)1);
        ChangeStreamRecord record = (ChangeStreamRecord)results.get(0);
        Assert.assertTrue((boolean)(record instanceof CloseStream));
        CloseStream closeStream = (CloseStream)record;
        Truth.assertThat((Object)closeStream.getStatus().toProto()).isEqualTo((Object)closeStreamProto.getStatus());
        Truth.assertThat((Integer)closeStream.getChangeStreamContinuationTokens().size()).isEqualTo((Object)1);
        ChangeStreamContinuationToken changeStreamContinuationToken = (ChangeStreamContinuationToken)closeStream.getChangeStreamContinuationTokens().get(0);
        Truth.assertThat((Object)changeStreamContinuationToken.getPartition()).isEqualTo((Object)Range.ByteStringRange.create((ByteString)rowRange.getStartKeyClosed(), (ByteString)rowRange.getEndKeyOpen()));
        Truth.assertThat((String)changeStreamContinuationToken.getToken()).isEqualTo((Object)streamContinuationToken.getToken());
        Truth.assertThat((Integer)closeStream.getNewPartitions().size()).isEqualTo((Object)1);
        Truth.assertThat(closeStream.getNewPartitions().get(0)).isEqualTo((Object)Range.ByteStringRange.create((ByteString)rowRange.getStartKeyClosed(), (ByteString)rowRange.getEndKeyOpen()));
    }
}

