/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.changestream;

import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamMutation;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.cloud.bigtable.data.v2.models.DefaultChangeStreamRecordAdapter;
import com.google.cloud.bigtable.data.v2.stub.changestream.ChangeStreamStateMachine;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ChangeStreamStateMachineTest {
    ChangeStreamStateMachine<ChangeStreamRecord> changeStreamStateMachine;

    private ReadChangeStreamResponse.DataChange createDataChangeWithDeleteFamilyMods(int numDeleteFamilyMod) {
        ReadChangeStreamResponse.DataChange.Builder dataChangeBuilder = ReadChangeStreamResponse.DataChange.newBuilder().setType(ReadChangeStreamResponse.DataChange.Type.USER).setSourceClusterId("fake-source-cluster-id").setRowKey(ByteString.copyFromUtf8((String)"key")).setCommitTimestamp(Timestamp.newBuilder().setSeconds(100L).build()).setTiebreaker(100);
        for (int i = 0; i < numDeleteFamilyMod; ++i) {
            Mutation deleteFromFamily = Mutation.newBuilder().setDeleteFromFamily(Mutation.DeleteFromFamily.newBuilder().setFamilyName("fake-family-" + i).build()).build();
            dataChangeBuilder.addChunks(ReadChangeStreamResponse.MutationChunk.newBuilder().setMutation(deleteFromFamily));
        }
        dataChangeBuilder.setDone(true);
        dataChangeBuilder.setEstimatedLowWatermark(Timestamp.newBuilder().setSeconds(1L).build());
        dataChangeBuilder.setToken("fake-token");
        return dataChangeBuilder.build();
    }

    @Before
    public void setUp() throws Exception {
        this.changeStreamStateMachine = new ChangeStreamStateMachine(new DefaultChangeStreamRecordAdapter().createChangeStreamRecordBuilder());
    }

    @Test
    public void testErrorHandlingStats() {
        ReadChangeStreamResponse.DataChange dataChange = ReadChangeStreamResponse.DataChange.newBuilder().build();
        ChangeStreamStateMachine.InvalidInputException actualError = null;
        try {
            this.changeStreamStateMachine.handleDataChange(dataChange);
        }
        catch (ChangeStreamStateMachine.InvalidInputException e) {
            actualError = e;
        }
        Truth.assertThat((Throwable)actualError).hasMessageThat().containsMatch("AWAITING_NEW_STREAM_RECORD: First data change missing rowKey");
        Truth.assertThat((Throwable)actualError).hasMessageThat().contains((CharSequence)"numHeartbeats: 0");
        Truth.assertThat((Throwable)actualError).hasMessageThat().contains((CharSequence)"numCloseStreams: 0");
        Truth.assertThat((Throwable)actualError).hasMessageThat().contains((CharSequence)"numDataChanges: 1");
        Truth.assertThat((Throwable)actualError).hasMessageThat().contains((CharSequence)"numNonCellMods: 0");
        Truth.assertThat((Throwable)actualError).hasMessageThat().contains((CharSequence)"numCellChunks: 0");
        Truth.assertThat((Throwable)actualError).hasMessageThat().contains((CharSequence)"actualTotalSizeOfChunkedSetCell: 0");
    }

    @Test
    public void testNoStackOverflowForManyMods() {
        ReadChangeStreamResponse.DataChange dataChange = this.createDataChangeWithDeleteFamilyMods(500000);
        this.changeStreamStateMachine.handleDataChange(dataChange);
        ChangeStreamRecord result = (ChangeStreamRecord)this.changeStreamStateMachine.consumeChangeStreamRecord();
        Truth.assertThat((Boolean)(result instanceof ChangeStreamMutation));
    }
}

