/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.changestream;

import com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsRequest;
import com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsResponse;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.StreamPartition;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.stub.changestream.GenerateInitialChangeStreamPartitionsUserCallable;
import com.google.cloud.bigtable.gaxx.testing.FakeStreamingApi;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GenerateInitialChangeStreamPartitionsUserCallableTest {
    private final RequestContext requestContext = RequestContext.create((String)"my-project", (String)"my-instance", (String)"my-profile");

    @Test
    public void requestIsCorrect() {
        FakeStreamingApi.ServerStreamingStashCallable inner = new FakeStreamingApi.ServerStreamingStashCallable(Lists.newArrayList());
        GenerateInitialChangeStreamPartitionsUserCallable generateInitialChangeStreamPartitionsUserCallable = new GenerateInitialChangeStreamPartitionsUserCallable(inner, this.requestContext);
        generateInitialChangeStreamPartitionsUserCallable.all().call((Object)"my-table");
        Truth.assertThat(inner.getActualRequest()).isEqualTo((Object)GenerateInitialChangeStreamPartitionsRequest.newBuilder().setTableName(NameUtil.formatTableName((String)this.requestContext.getProjectId(), (String)this.requestContext.getInstanceId(), (String)"my-table")).setAppProfileId(this.requestContext.getAppProfileId()).build());
    }

    @Test
    public void responseIsConverted() {
        FakeStreamingApi.ServerStreamingStashCallable inner = new FakeStreamingApi.ServerStreamingStashCallable(Lists.newArrayList((Object[])new GenerateInitialChangeStreamPartitionsResponse[]{GenerateInitialChangeStreamPartitionsResponse.newBuilder().setPartition(StreamPartition.newBuilder().setRowRange(RowRange.newBuilder().getDefaultInstanceForType()).build()).build()}));
        GenerateInitialChangeStreamPartitionsUserCallable generateInitialChangeStreamPartitionsUserCallable = new GenerateInitialChangeStreamPartitionsUserCallable(inner, this.requestContext);
        List results = (List)generateInitialChangeStreamPartitionsUserCallable.all().call((Object)"my-table");
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{Range.ByteStringRange.create((String)"", (String)"")});
    }
}

