/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.changestream;

import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.ReadChangeStreamQuery;
import com.google.cloud.bigtable.data.v2.stub.changestream.ReadChangeStreamUserCallable;
import com.google.cloud.bigtable.gaxx.testing.FakeStreamingApi;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;
import org.threeten.bp.Instant;

@RunWith(value=JUnit4.class)
public class ReadChangeStreamUserCallableTest {
    private static final RequestContext REQUEST_CONTEXT = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");

    @Test
    public void testRequestIsConverted() {
        FakeStreamingApi.ServerStreamingStashCallable innerCallable = new FakeStreamingApi.ServerStreamingStashCallable();
        ReadChangeStreamUserCallable callable = new ReadChangeStreamUserCallable(innerCallable, REQUEST_CONTEXT);
        ReadChangeStreamQuery query = ReadChangeStreamQuery.create((String)"fake-table").streamPartition("begin", "end").startTime(Instant.ofEpochSecond((long)0L, (long)1000L)).endTime(Instant.ofEpochSecond((long)0L, (long)2000L)).heartbeatDuration(Duration.ofSeconds((long)1L));
        callable.call((Object)query);
        Truth.assertThat(innerCallable.getActualRequest()).isEqualTo((Object)query.toProto(REQUEST_CONTEXT));
    }
}

