/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.Distribution;
import com.google.api.MonitoredResource;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableCloudMonitoringExporter;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.stub.MetricServiceStub;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.Empty;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

public class BigtableCloudMonitoringExporterTest {
    private static final String projectId = "fake-project";
    private static final String instanceId = "fake-instance";
    private static final String appProfileId = "default";
    private static final String tableId = "fake-table";
    private static final String zone = "us-east-1";
    private static final String cluster = "cluster-1";
    private static final String clientName = "fake-client-name";
    private static final String taskId = "fake-task-id";
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private MetricServiceStub mockMetricServiceStub;
    private MetricServiceClient fakeMetricServiceClient;
    private BigtableCloudMonitoringExporter exporter;
    private Attributes attributes;
    private Resource resource;
    private InstrumentationScopeInfo scope;

    @Before
    public void setUp() {
        this.fakeMetricServiceClient = new FakeMetricServiceClient(this.mockMetricServiceStub);
        this.exporter = new BigtableCloudMonitoringExporter(this.fakeMetricServiceClient, Suppliers.ofInstance(null), taskId);
        this.attributes = Attributes.builder().put(BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY, (Object)projectId).put(BuiltinMetricsConstants.INSTANCE_ID_KEY, (Object)instanceId).put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)tableId).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)cluster).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)zone).put(BuiltinMetricsConstants.APP_PROFILE_KEY, (Object)appProfileId).build();
        this.resource = Resource.create((Attributes)Attributes.empty());
        this.scope = InstrumentationScopeInfo.create((String)"bigtable.googleapis.com/internal/client/");
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testExportingSumData() {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(CreateTimeSeriesRequest.class);
        UnaryCallable mockCallable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        Mockito.when((Object)this.mockMetricServiceStub.createServiceTimeSeriesCallable()).thenReturn((Object)mockCallable);
        ApiFuture future = ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        Mockito.when((Object)mockCallable.futureCall((Object)((CreateTimeSeriesRequest)argumentCaptor.capture()))).thenReturn((Object)future);
        long fakeValue = 11L;
        long startEpoch = 10L;
        long endEpoch = 15L;
        LongPointData longPointData = ImmutableLongPointData.create((long)startEpoch, (long)endEpoch, (Attributes)this.attributes, (long)fakeValue);
        MetricData longData = ImmutableMetricData.createLongSum((Resource)this.resource, (InstrumentationScopeInfo)this.scope, (String)"bigtable.googleapis.com/internal/client/retry_count", (String)"description", (String)"1", (SumData)ImmutableSumData.create((boolean)true, (AggregationTemporality)AggregationTemporality.CUMULATIVE, (Collection)ImmutableList.of((Object)longPointData)));
        this.exporter.export(Arrays.asList(longData));
        CreateTimeSeriesRequest request = (CreateTimeSeriesRequest)argumentCaptor.getValue();
        Truth.assertThat((Iterable)request.getTimeSeriesList()).hasSize(1);
        TimeSeries timeSeries = (TimeSeries)request.getTimeSeriesList().get(0);
        Truth.assertThat((Map)timeSeries.getResource().getLabelsMap()).containsExactly((Object)BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY.getKey(), (Object)projectId, new Object[]{BuiltinMetricsConstants.INSTANCE_ID_KEY.getKey(), instanceId, BuiltinMetricsConstants.TABLE_ID_KEY.getKey(), tableId, BuiltinMetricsConstants.CLUSTER_ID_KEY.getKey(), cluster, BuiltinMetricsConstants.ZONE_ID_KEY.getKey(), zone});
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).hasSize(2);
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).containsAtLeast((Object)BuiltinMetricsConstants.APP_PROFILE_KEY.getKey(), (Object)appProfileId, new Object[]{BuiltinMetricsConstants.CLIENT_UID_KEY.getKey(), taskId});
        Truth.assertThat((Long)timeSeries.getPoints(0).getValue().getInt64Value()).isEqualTo((Object)fakeValue);
        Truth.assertThat((Integer)timeSeries.getPoints(0).getInterval().getStartTime().getNanos()).isEqualTo((Object)startEpoch);
        Truth.assertThat((Integer)timeSeries.getPoints(0).getInterval().getEndTime().getNanos()).isEqualTo((Object)endEpoch);
    }

    @Test
    public void testExportingHistogramData() {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(CreateTimeSeriesRequest.class);
        UnaryCallable mockCallable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        Mockito.when((Object)this.mockMetricServiceStub.createServiceTimeSeriesCallable()).thenReturn((Object)mockCallable);
        ApiFuture future = ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        Mockito.when((Object)mockCallable.futureCall((Object)((CreateTimeSeriesRequest)argumentCaptor.capture()))).thenReturn((Object)future);
        long startEpoch = 10L;
        long endEpoch = 15L;
        ImmutableHistogramPointData histogramPointData = ImmutableHistogramPointData.create((long)startEpoch, (long)endEpoch, (Attributes)this.attributes, (double)3.0, (boolean)true, (double)1.0, (boolean)true, (double)2.0, Arrays.asList(1.0), Arrays.asList(1L, 2L));
        MetricData histogramData = ImmutableMetricData.createDoubleHistogram((Resource)this.resource, (InstrumentationScopeInfo)this.scope, (String)"bigtable.googleapis.com/internal/client/operation_latencies", (String)"description", (String)"ms", (HistogramData)ImmutableHistogramData.create((AggregationTemporality)AggregationTemporality.CUMULATIVE, (Collection)ImmutableList.of((Object)histogramPointData)));
        this.exporter.export(Arrays.asList(histogramData));
        CreateTimeSeriesRequest request = (CreateTimeSeriesRequest)argumentCaptor.getValue();
        Truth.assertThat((Iterable)request.getTimeSeriesList()).hasSize(1);
        TimeSeries timeSeries = (TimeSeries)request.getTimeSeriesList().get(0);
        Truth.assertThat((Map)timeSeries.getResource().getLabelsMap()).containsExactly((Object)BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY.getKey(), (Object)projectId, new Object[]{BuiltinMetricsConstants.INSTANCE_ID_KEY.getKey(), instanceId, BuiltinMetricsConstants.TABLE_ID_KEY.getKey(), tableId, BuiltinMetricsConstants.CLUSTER_ID_KEY.getKey(), cluster, BuiltinMetricsConstants.ZONE_ID_KEY.getKey(), zone});
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).hasSize(2);
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).containsAtLeast((Object)BuiltinMetricsConstants.APP_PROFILE_KEY.getKey(), (Object)appProfileId, new Object[]{BuiltinMetricsConstants.CLIENT_UID_KEY.getKey(), taskId});
        Distribution distribution = timeSeries.getPoints(0).getValue().getDistributionValue();
        Truth.assertThat((Long)distribution.getCount()).isEqualTo((Object)3);
        Truth.assertThat((Integer)timeSeries.getPoints(0).getInterval().getStartTime().getNanos()).isEqualTo((Object)startEpoch);
        Truth.assertThat((Integer)timeSeries.getPoints(0).getInterval().getEndTime().getNanos()).isEqualTo((Object)endEpoch);
    }

    @Test
    public void testExportingSumDataInBatches() {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(CreateTimeSeriesRequest.class);
        UnaryCallable mockCallable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        Mockito.when((Object)this.mockMetricServiceStub.createServiceTimeSeriesCallable()).thenReturn((Object)mockCallable);
        ApiFuture future = ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        Mockito.when((Object)mockCallable.futureCall((Object)((CreateTimeSeriesRequest)argumentCaptor.capture()))).thenReturn((Object)future);
        long startEpoch = 10L;
        long endEpoch = 15L;
        ArrayList<MetricData> toExport = new ArrayList<MetricData>();
        for (int i = 0; i < 250; ++i) {
            Attributes testAttributes = Attributes.builder().put(BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY, (Object)projectId).put(BuiltinMetricsConstants.INSTANCE_ID_KEY, (Object)instanceId).put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)(tableId + i)).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)cluster).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)zone).put(BuiltinMetricsConstants.APP_PROFILE_KEY, (Object)appProfileId).build();
            LongPointData longPointData = ImmutableLongPointData.create((long)startEpoch, (long)endEpoch, (Attributes)testAttributes, (long)i);
            MetricData longData = ImmutableMetricData.createLongSum((Resource)this.resource, (InstrumentationScopeInfo)this.scope, (String)"bigtable.googleapis.com/internal/client/retry_count", (String)"description", (String)"1", (SumData)ImmutableSumData.create((boolean)true, (AggregationTemporality)AggregationTemporality.CUMULATIVE, (Collection)ImmutableList.of((Object)longPointData)));
            toExport.add(longData);
        }
        this.exporter.export(toExport);
        Truth.assertThat((Iterable)argumentCaptor.getAllValues()).hasSize(2);
        CreateTimeSeriesRequest firstRequest = (CreateTimeSeriesRequest)argumentCaptor.getAllValues().get(0);
        CreateTimeSeriesRequest secondRequest = (CreateTimeSeriesRequest)argumentCaptor.getAllValues().get(1);
        Truth.assertThat((Iterable)firstRequest.getTimeSeriesList()).hasSize(200);
        Truth.assertThat((Iterable)secondRequest.getTimeSeriesList()).hasSize(50);
        for (int i = 0; i < 250; ++i) {
            TimeSeries timeSeries = i < 200 ? (TimeSeries)firstRequest.getTimeSeriesList().get(i) : (TimeSeries)secondRequest.getTimeSeriesList().get(i - 200);
            Truth.assertThat((Map)timeSeries.getResource().getLabelsMap()).containsExactly((Object)BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY.getKey(), (Object)projectId, new Object[]{BuiltinMetricsConstants.INSTANCE_ID_KEY.getKey(), instanceId, BuiltinMetricsConstants.TABLE_ID_KEY.getKey(), tableId + i, BuiltinMetricsConstants.CLUSTER_ID_KEY.getKey(), cluster, BuiltinMetricsConstants.ZONE_ID_KEY.getKey(), zone});
            Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).hasSize(2);
            Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).containsAtLeast((Object)BuiltinMetricsConstants.APP_PROFILE_KEY.getKey(), (Object)appProfileId, new Object[]{BuiltinMetricsConstants.CLIENT_UID_KEY.getKey(), taskId});
            Truth.assertThat((Long)timeSeries.getPoints(0).getValue().getInt64Value()).isEqualTo((Object)i);
            Truth.assertThat((Integer)timeSeries.getPoints(0).getInterval().getStartTime().getNanos()).isEqualTo((Object)startEpoch);
            Truth.assertThat((Integer)timeSeries.getPoints(0).getInterval().getEndTime().getNanos()).isEqualTo((Object)endEpoch);
        }
    }

    @Test
    public void testTimeSeriesForMetricWithGceOrGkeResource() {
        String gceProjectId = "fake-gce-project";
        BigtableCloudMonitoringExporter exporter = new BigtableCloudMonitoringExporter(this.fakeMetricServiceClient, Suppliers.ofInstance((Object)MonitoredResource.newBuilder().setType("gce-instance").putLabels("some-gce-key", "some-gce-value").putLabels("project_id", gceProjectId).build()), taskId);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(CreateTimeSeriesRequest.class);
        UnaryCallable mockCallable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        Mockito.when((Object)this.mockMetricServiceStub.createServiceTimeSeriesCallable()).thenReturn((Object)mockCallable);
        ApiFuture future = ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        Mockito.when((Object)mockCallable.futureCall((Object)((CreateTimeSeriesRequest)argumentCaptor.capture()))).thenReturn((Object)future);
        long startEpoch = 10L;
        long endEpoch = 15L;
        ImmutableHistogramPointData histogramPointData = ImmutableHistogramPointData.create((long)startEpoch, (long)endEpoch, (Attributes)Attributes.of((AttributeKey)BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY, (Object)projectId, (AttributeKey)BuiltinMetricsConstants.INSTANCE_ID_KEY, (Object)instanceId, (AttributeKey)BuiltinMetricsConstants.APP_PROFILE_KEY, (Object)appProfileId, (AttributeKey)BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)clientName), (double)3.0, (boolean)true, (double)1.0, (boolean)true, (double)2.0, Arrays.asList(1.0), Arrays.asList(1L, 2L));
        MetricData histogramData = ImmutableMetricData.createDoubleHistogram((Resource)this.resource, (InstrumentationScopeInfo)this.scope, (String)"bigtable.googleapis.com/internal/client/per_connection_error_count", (String)"description", (String)"ms", (HistogramData)ImmutableHistogramData.create((AggregationTemporality)AggregationTemporality.CUMULATIVE, (Collection)ImmutableList.of((Object)histogramPointData)));
        exporter.export(Arrays.asList(histogramData));
        CreateTimeSeriesRequest request = (CreateTimeSeriesRequest)argumentCaptor.getValue();
        Truth.assertThat((String)request.getName()).isEqualTo((Object)("projects/" + gceProjectId));
        Truth.assertThat((Iterable)request.getTimeSeriesList()).hasSize(1);
        TimeSeries timeSeries = (TimeSeries)request.getTimeSeriesList().get(0);
        Truth.assertThat((Map)timeSeries.getResource().getLabelsMap()).containsExactly((Object)"some-gce-key", (Object)"some-gce-value", new Object[]{"project_id", gceProjectId});
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).hasSize(5);
        Truth.assertThat((Map)timeSeries.getMetric().getLabelsMap()).containsAtLeast((Object)BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY.getKey(), (Object)projectId, new Object[]{BuiltinMetricsConstants.INSTANCE_ID_KEY.getKey(), instanceId, BuiltinMetricsConstants.APP_PROFILE_KEY.getKey(), appProfileId, BuiltinMetricsConstants.CLIENT_NAME_KEY.getKey(), clientName, BuiltinMetricsConstants.CLIENT_UID_KEY.getKey(), taskId});
    }

    @Test
    public void testExportingToMultipleProjects() {
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(CreateTimeSeriesRequest.class);
        UnaryCallable mockCallable = (UnaryCallable)Mockito.mock(UnaryCallable.class);
        Mockito.when((Object)this.mockMetricServiceStub.createServiceTimeSeriesCallable()).thenReturn((Object)mockCallable);
        ApiFuture future = ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        Mockito.when((Object)mockCallable.futureCall((Object)((CreateTimeSeriesRequest)ArgumentMatchers.any()))).thenReturn((Object)future);
        long startEpoch = 10L;
        long endEpoch = 15L;
        ImmutableHistogramPointData histogramPointData1 = ImmutableHistogramPointData.create((long)startEpoch, (long)endEpoch, (Attributes)this.attributes, (double)3.0, (boolean)true, (double)1.0, (boolean)true, (double)2.0, Arrays.asList(1.0), Arrays.asList(1L, 2L));
        MetricData histogramData1 = ImmutableMetricData.createDoubleHistogram((Resource)this.resource, (InstrumentationScopeInfo)this.scope, (String)"bigtable.googleapis.com/internal/client/operation_latencies", (String)"description", (String)"ms", (HistogramData)ImmutableHistogramData.create((AggregationTemporality)AggregationTemporality.CUMULATIVE, (Collection)ImmutableList.of((Object)histogramPointData1)));
        ImmutableHistogramPointData histogramPointData2 = ImmutableHistogramPointData.create((long)startEpoch, (long)endEpoch, (Attributes)this.attributes.toBuilder().put(BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY, (Object)"another-project").build(), (double)50.0, (boolean)true, (double)5.0, (boolean)true, (double)30.0, Arrays.asList(1.0), Arrays.asList(5L, 10L));
        MetricData histogramData2 = ImmutableMetricData.createDoubleHistogram((Resource)this.resource, (InstrumentationScopeInfo)this.scope, (String)"bigtable.googleapis.com/internal/client/operation_latencies", (String)"description", (String)"ms", (HistogramData)ImmutableHistogramData.create((AggregationTemporality)AggregationTemporality.CUMULATIVE, (Collection)ImmutableList.of((Object)histogramPointData2)));
        this.exporter.export(Arrays.asList(histogramData1, histogramData2));
        ((UnaryCallable)Mockito.verify((Object)mockCallable, (VerificationMode)Mockito.times((int)2))).futureCall((Object)((CreateTimeSeriesRequest)argumentCaptor.capture()));
        List allValues = argumentCaptor.getAllValues();
        Truth.assertThat((Iterable)allValues).hasSize(2);
        ArrayList labelsMap = new ArrayList();
        ArrayList counts = new ArrayList();
        allValues.forEach(value -> {
            labelsMap.add(((TimeSeries)value.getTimeSeriesList().get(0)).getResource().getLabelsMap());
            counts.add(((TimeSeries)value.getTimeSeriesList().get(0)).getPoints(0).getValue().getDistributionValue().getCount());
        });
        Truth.assertThat(labelsMap).containsExactly(new Object[]{ImmutableMap.of((Object)BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY.getKey(), (Object)projectId, (Object)BuiltinMetricsConstants.INSTANCE_ID_KEY.getKey(), (Object)instanceId, (Object)BuiltinMetricsConstants.TABLE_ID_KEY.getKey(), (Object)tableId, (Object)BuiltinMetricsConstants.CLUSTER_ID_KEY.getKey(), (Object)cluster, (Object)BuiltinMetricsConstants.ZONE_ID_KEY.getKey(), (Object)zone), ImmutableMap.of((Object)BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY.getKey(), (Object)"another-project", (Object)BuiltinMetricsConstants.INSTANCE_ID_KEY.getKey(), (Object)instanceId, (Object)BuiltinMetricsConstants.TABLE_ID_KEY.getKey(), (Object)tableId, (Object)BuiltinMetricsConstants.CLUSTER_ID_KEY.getKey(), (Object)cluster, (Object)BuiltinMetricsConstants.ZONE_ID_KEY.getKey(), (Object)zone)});
        Truth.assertThat(counts).containsExactly(new Object[]{3L, 15L});
    }

    private static class FakeMetricServiceClient
    extends MetricServiceClient {
        protected FakeMetricServiceClient(MetricServiceStub stub) {
            super(stub);
        }
    }
}

