/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.InternalApi;
import com.google.common.truth.Correspondence;
import com.google.common.truth.Truth;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricReader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;

@InternalApi
public class BuiltinMetricsTestUtils {
    private static final Correspondence<MetricData, String> METRIC_DATA_BY_NAME = Correspondence.transforming(MetricData::getName, (String)"MetricData name");

    private BuiltinMetricsTestUtils() {
    }

    public static MetricData getMetricData(InMemoryMetricReader reader, String metricName) {
        String fullMetricName = "bigtable.googleapis.com/internal/client/" + metricName;
        Collection<Object> allMetricData = Collections.emptyList();
        for (int attemptsLeft = 10; attemptsLeft > 0; --attemptsLeft) {
            allMetricData = reader.collectAllMetrics();
            List matchingMetadata = allMetricData.stream().filter(md -> METRIC_DATA_BY_NAME.compare(md, (Object)fullMetricName)).collect(Collectors.toList());
            Truth.assertWithMessage((String)"Found multiple MetricData with the same name: %s, in: %s", (Object[])new Object[]{fullMetricName, matchingMetadata}).that(Integer.valueOf(matchingMetadata.size())).isAtMost((Comparable)Integer.valueOf(1));
            if (!matchingMetadata.isEmpty()) {
                return (MetricData)matchingMetadata.get(0);
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(interruptedException);
            }
        }
        Truth.assertThat(allMetricData).comparingElementsUsing(METRIC_DATA_BY_NAME).contains((Object)fullMetricName);
        throw new IllegalStateException("MetricData was missing then appeared, this should never happen");
    }

    public static long getAggregatedValue(MetricData metricData, Attributes attributes) {
        switch (metricData.getType()) {
            case HISTOGRAM: {
                HistogramPointData hd = (HistogramPointData)metricData.getHistogramData().getPoints().stream().filter(pd -> pd.getAttributes().equals(attributes)).collect(Collectors.toList()).get(0);
                return (long)hd.getSum() / hd.getCount();
            }
            case LONG_SUM: {
                LongPointData ld = (LongPointData)metricData.getLongSumData().getPoints().stream().filter(pd -> pd.getAttributes().equals(attributes)).collect(Collectors.toList()).get(0);
                return ld.getValue();
            }
        }
        return 0L;
    }

    public static Timestamp getStartTimeSeconds(MetricData metricData, Attributes attributes) {
        switch (metricData.getType()) {
            case HISTOGRAM: {
                HistogramPointData hd = (HistogramPointData)metricData.getHistogramData().getPoints().stream().filter(pd -> pd.getAttributes().equals(attributes)).collect(Collectors.toList()).get(0);
                return Timestamps.fromNanos((long)hd.getStartEpochNanos());
            }
            case LONG_SUM: {
                LongPointData ld = (LongPointData)metricData.getLongSumData().getPoints().stream().filter(pd -> pd.getAttributes().equals(attributes)).collect(Collectors.toList()).get(0);
                return Timestamps.fromNanos((long)ld.getStartEpochNanos());
            }
        }
        return Timestamp.getDefaultInstance();
    }

    public static void verifyAttributes(MetricData metricData, Attributes attributes) {
        switch (metricData.getType()) {
            case HISTOGRAM: {
                List hd = metricData.getHistogramData().getPoints().stream().filter(pd -> pd.getAttributes().equals(attributes)).collect(Collectors.toList());
                Truth.assertThat(hd).isNotEmpty();
                break;
            }
            case LONG_SUM: {
                List ld = metricData.getLongSumData().getPoints().stream().filter(pd -> pd.getAttributes().equals(attributes)).collect(Collectors.toList());
                Truth.assertThat(ld).isNotEmpty();
                break;
            }
            default: {
                Assert.fail((String)"Unexpected type");
            }
        }
    }
}

