/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.client.util.Lists;
import com.google.api.core.ApiFunction;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.batching.BatchingException;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.ResponseParams;
import com.google.cloud.bigtable.Version;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.models.AuthorizedViewId;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.models.TableId;
import com.google.cloud.bigtable.data.v2.models.TargetId;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsTestUtils;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsTracerFactory;
import com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Range;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.StringValue;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCall;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.ProxiedSocketAddress;
import io.grpc.ProxyDetector;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricReader;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@RunWith(value=JUnit4.class)
public class BuiltinMetricsTracerTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String APP_PROFILE_ID = "default";
    private static final String TABLE = "fake-table";
    private static final String BAD_TABLE_ID = "non-exist-table";
    private static final String FIRST_RESPONSE_TABLE_ID = "first-response";
    private static final String ZONE = "us-west-1";
    private static final String CLUSTER = "cluster-0";
    private static final long FAKE_SERVER_TIMING = 50L;
    private static final long SERVER_LATENCY = 100L;
    private static final long APPLICATION_LATENCY = 200L;
    private static final long SLEEP_VARIABILITY = 15L;
    private static final String CLIENT_NAME = "java-bigtable/" + Version.VERSION;
    private static final long CHANNEL_BLOCKING_LATENCY = 200L;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    private final FakeService fakeService = new FakeService();
    private Server server;
    private EnhancedBigtableStub stub;
    private int batchElementCount = 2;
    private Attributes baseAttributes;
    private InMemoryMetricReader metricReader;

    @Before
    public void setUp() throws Exception {
        this.metricReader = InMemoryMetricReader.create();
        this.baseAttributes = Attributes.builder().put(BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY, (Object)PROJECT_ID).put(BuiltinMetricsConstants.INSTANCE_ID_KEY, (Object)INSTANCE_ID).put(BuiltinMetricsConstants.APP_PROFILE_KEY, (Object)APP_PROFILE_ID).build();
        SdkMeterProviderBuilder meterProvider = SdkMeterProvider.builder().registerMetricReader((MetricReader)this.metricReader);
        for (Map.Entry entry : BuiltinMetricsConstants.getAllViews().entrySet()) {
            meterProvider.registerView((InstrumentSelector)entry.getKey(), (View)entry.getValue());
        }
        OpenTelemetrySdk otel = OpenTelemetrySdk.builder().setMeterProvider(meterProvider.build()).build();
        BuiltinMetricsTracerFactory facotry = BuiltinMetricsTracerFactory.create((OpenTelemetry)otel, (Attributes)this.baseAttributes);
        ServerInterceptor trailersInterceptor = new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
                return serverCallHandler.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(serverCall){

                    public void sendHeaders(Metadata headers) {
                        headers.put(Metadata.Key.of((String)"server-timing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.format("gfet4t7; dur=%d", 50L));
                        ResponseParams params = ResponseParams.newBuilder().setZoneId(BuiltinMetricsTracerTest.ZONE).setClusterId(BuiltinMetricsTracerTest.CLUSTER).build();
                        byte[] byteArray = params.toByteArray();
                        headers.put(Util.LOCATION_METADATA_KEY, (Object)byteArray);
                        super.sendHeaders(headers);
                    }
                }, metadata);
            }
        };
        this.server = FakeServiceBuilder.create(new BindableService[]{this.fakeService}).intercept(trailersInterceptor).start();
        BigtableDataSettings settings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setAppProfileId(APP_PROFILE_ID).setRefreshingChannel(false).build();
        EnhancedBigtableStubSettings.Builder stubSettingsBuilder = settings.getStubSettings().toBuilder();
        stubSettingsBuilder.mutateRowSettings().retrySettings().setInitialRetryDelayDuration(Duration.ofMillis(200L));
        stubSettingsBuilder.readRowsSettings().retrySettings().setTotalTimeoutDuration(Duration.ofMillis(9000L)).setMaxRpcTimeoutDuration(Duration.ofMillis(9000L)).setRpcTimeoutMultiplier(1.0).setInitialRpcTimeoutDuration(Duration.ofMillis(6000L)).setInitialRetryDelayDuration(Duration.ofMillis(10L)).setRetryDelayMultiplier(1.0).setMaxRetryDelayDuration(Duration.ofMillis(10L));
        stubSettingsBuilder.bulkMutateRowsSettings().setBatchingSettings(BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(this.batchElementCount)).setRequestByteThreshold(Long.valueOf(1000L)).setDelayThresholdDuration(Duration.ofHours(1L)).setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Long.valueOf((long)this.batchElementCount + 1L)).setMaxOutstandingRequestBytes(Long.valueOf(1001L)).build()).build());
        stubSettingsBuilder.setTracerFactory((ApiTracerFactory)facotry);
        InstantiatingGrpcChannelProvider.Builder channelProvider = ((InstantiatingGrpcChannelProvider)stubSettingsBuilder.getTransportChannelProvider()).toBuilder();
        ApiFunction oldConfigurator = channelProvider.getChannelConfigurator();
        channelProvider.setChannelConfigurator(builder -> {
            if (oldConfigurator != null) {
                builder = (ManagedChannelBuilder)oldConfigurator.apply(builder);
            }
            return builder.proxyDetector((ProxyDetector)new DelayProxyDetector());
        });
        stubSettingsBuilder.setTransportChannelProvider((TransportChannelProvider)channelProvider.build());
        EnhancedBigtableStubSettings stubSettings = stubSettingsBuilder.build();
        this.stub = new EnhancedBigtableStub(stubSettings, ClientContext.create((StubSettings)stubSettings));
    }

    @After
    public void tearDown() {
        this.stub.close();
        this.server.shutdown();
    }

    @Test
    public void testReadRowsOperationLatencies() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Lists.newArrayList((Iterator)this.stub.readRowsCallable().call((Object)Query.create((String)TABLE)).iterator());
        long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        Attributes expectedAttributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"OK").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").put(BuiltinMetricsConstants.STREAMING_KEY, (Object)true).put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).build();
        MetricData metricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "operation_latencies");
        long value = BuiltinMetricsTestUtils.getAggregatedValue(metricData, expectedAttributes);
        Truth.assertThat((Long)value).isIn(Range.closed((Comparable)Long.valueOf(100L), (Comparable)Long.valueOf(elapsed)));
    }

    @Test
    public void testReadRowsOperationLatenciesOnAuthorizedView() {
        String authorizedViewId = "test-authorized-view-id";
        Stopwatch stopwatch = Stopwatch.createStarted();
        Lists.newArrayList((Iterable)this.stub.readRowsCallable().call((Object)Query.create((TargetId)AuthorizedViewId.of((String)TABLE, (String)authorizedViewId))));
        long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        Attributes expectedAttributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"OK").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").put(BuiltinMetricsConstants.STREAMING_KEY, (Object)true).put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).build();
        MetricData metricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "operation_latencies");
        long value = BuiltinMetricsTestUtils.getAggregatedValue(metricData, expectedAttributes);
        Truth.assertThat((Long)value).isIn(Range.closed((Comparable)Long.valueOf(100L), (Comparable)Long.valueOf(elapsed)));
    }

    @Test
    public void testFirstResponseLatencies() {
        final Stopwatch firstResponseTimer = Stopwatch.createStarted();
        this.stub.readRowsCallable().call((Object)Query.create((String)FIRST_RESPONSE_TABLE_ID), (ResponseObserver)new ResponseObserver<Row>(){

            public void onStart(StreamController controller) {
            }

            public void onResponse(Row response) {
                if (firstResponseTimer.isRunning()) {
                    firstResponseTimer.stop();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            public void onError(Throwable t) {
            }

            public void onComplete() {
            }
        });
        Attributes expectedAttributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"OK").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)FIRST_RESPONSE_TABLE_ID).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).build();
        MetricData metricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "first_response_latencies");
        long value = BuiltinMetricsTestUtils.getAggregatedValue(metricData, expectedAttributes);
        Truth.assertThat((Long)value).isAtMost((Comparable)Long.valueOf(firstResponseTimer.elapsed(TimeUnit.MILLISECONDS)));
    }

    @Test
    public void testGfeMetrics() {
        Lists.newArrayList((Iterable)this.stub.readRowsCallable().call((Object)Query.create((String)TABLE)));
        Attributes expectedAttributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"OK").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").build();
        MetricData serverLatenciesMetricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "server_latencies");
        long serverLatencies = BuiltinMetricsTestUtils.getAggregatedValue(serverLatenciesMetricData, expectedAttributes);
        Truth.assertThat((Long)serverLatencies).isEqualTo((Object)50L);
        MetricData connectivityErrorCountMetricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "connectivity_error_count");
        Attributes expected1 = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"UNAVAILABLE").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)"global").put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)"<unspecified>").put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).build();
        Attributes expected2 = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"OK").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).build();
        BuiltinMetricsTestUtils.verifyAttributes(connectivityErrorCountMetricData, expected1);
        BuiltinMetricsTestUtils.verifyAttributes(connectivityErrorCountMetricData, expected2);
        Truth.assertThat((Long)BuiltinMetricsTestUtils.getAggregatedValue(connectivityErrorCountMetricData, expected1)).isEqualTo((Object)1);
        Truth.assertThat((Long)BuiltinMetricsTestUtils.getAggregatedValue(connectivityErrorCountMetricData, expected2)).isEqualTo((Object)0);
    }

    @Test
    public void testReadRowsApplicationLatencyWithAutoFlowControl() throws Exception {
        final SettableApiFuture future = SettableApiFuture.create();
        final AtomicInteger counter = new AtomicInteger(0);
        this.stub.readRowsCallable().call((Object)Query.create((String)TABLE), (ResponseObserver)new ResponseObserver<Row>(){

            public void onStart(StreamController streamController) {
            }

            public void onResponse(Row row) {
                try {
                    counter.getAndIncrement();
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            public void onError(Throwable throwable) {
                future.setException(throwable);
            }

            public void onComplete() {
                future.set(null);
            }
        });
        future.get();
        Truth.assertThat((Integer)counter.get()).isEqualTo((Object)this.fakeService.getResponseCounter().get());
        MetricData applicationLatency = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "application_latencies");
        Attributes expectedAttributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").build();
        long value = BuiltinMetricsTestUtils.getAggregatedValue(applicationLatency, expectedAttributes);
        Truth.assertThat((Long)value).isAtLeast((Comparable)Long.valueOf(185L * (long)counter.get()));
        MetricData operationLatency = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "operation_latencies");
        long operationLatencyValue = BuiltinMetricsTestUtils.getAggregatedValue(operationLatency, expectedAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"OK").put(BuiltinMetricsConstants.STREAMING_KEY, (Object)true).build());
        Truth.assertThat((Long)value).isAtMost((Comparable)Long.valueOf(operationLatencyValue - 100L));
    }

    @Test
    public void testReadRowsApplicationLatencyWithManualFlowControl() throws Exception {
        int counter = 0;
        Iterator rows = this.stub.readRowsCallable().call((Object)Query.create((String)TABLE)).iterator();
        while (rows.hasNext()) {
            ++counter;
            Thread.sleep(200L);
            rows.next();
        }
        MetricData applicationLatency = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "application_latencies");
        Attributes expectedAttributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").build();
        long value = BuiltinMetricsTestUtils.getAggregatedValue(applicationLatency, expectedAttributes);
        Truth.assertThat((Integer)counter).isEqualTo((Object)this.fakeService.getResponseCounter().get());
        Truth.assertThat((Long)value).isAtLeast((Comparable)Long.valueOf(200L * (long)(counter - 1) - 100L));
        MetricData operationLatency = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "operation_latencies");
        long operationLatencyValue = BuiltinMetricsTestUtils.getAggregatedValue(operationLatency, expectedAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"OK").put(BuiltinMetricsConstants.STREAMING_KEY, (Object)true).build());
        Truth.assertThat((Long)value).isAtMost((Comparable)Long.valueOf(operationLatencyValue - 100L));
    }

    @Test
    public void testRetryCount() throws InterruptedException {
        this.stub.mutateRowCallable().call((Object)RowMutation.create((String)TABLE, (String)"random-row").setCell("cf", "q", "value"));
        MetricData metricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "retry_count");
        Attributes expectedAttributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.MutateRow").put(BuiltinMetricsConstants.STATUS_KEY, (Object)"OK").build();
        long value = BuiltinMetricsTestUtils.getAggregatedValue(metricData, expectedAttributes);
        Truth.assertThat((Long)value).isEqualTo((Object)(this.fakeService.getAttemptCounter().get() - 1));
    }

    @Test
    public void testMutateRowAttemptsTagValues() {
        this.stub.mutateRowCallable().call((Object)RowMutation.create((String)TABLE, (String)"random-row").setCell("cf", "q", "value"));
        MetricData metricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "attempt_latencies");
        Attributes expected1 = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"UNAVAILABLE").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)"global").put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)"<unspecified>").put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.MutateRow").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).put(BuiltinMetricsConstants.STREAMING_KEY, (Object)false).build();
        Attributes expected2 = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"OK").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.MutateRow").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).put(BuiltinMetricsConstants.STREAMING_KEY, (Object)false).build();
        BuiltinMetricsTestUtils.verifyAttributes(metricData, expected1);
        BuiltinMetricsTestUtils.verifyAttributes(metricData, expected2);
    }

    @Test
    public void testMutateRowsPartialError() throws InterruptedException {
        Batcher batcher = this.stub.newMutateRowsBatcher((TargetId)TableId.of((String)TABLE), null);
        int numMutations = 6;
        for (int i = 0; i < numMutations; ++i) {
            String key = i % 2 == 0 ? "key" : "fail-key";
            batcher.add((Object)RowMutationEntry.create((String)key).setCell("f", "q", "v"));
        }
        Assert.assertThrows(BatchingException.class, () -> ((Batcher)batcher).close());
        MetricData metricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "attempt_latencies");
        Attributes expected = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"OK").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.MutateRows").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).put(BuiltinMetricsConstants.STREAMING_KEY, (Object)false).build();
        BuiltinMetricsTestUtils.verifyAttributes(metricData, expected);
    }

    @Test
    public void testMutateRowsRpcError() {
        Batcher batcher = this.stub.newMutateRowsBatcher((TargetId)TableId.of((String)BAD_TABLE_ID), null);
        int numMutations = 6;
        for (int i = 0; i < numMutations; ++i) {
            String key = i % 2 == 0 ? "key" : "fail-key";
            batcher.add((Object)RowMutationEntry.create((String)key).setCell("f", "q", "v"));
        }
        Assert.assertThrows(BatchingException.class, () -> ((Batcher)batcher).close());
        MetricData metricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "attempt_latencies");
        Attributes expected = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"NOT_FOUND").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)BAD_TABLE_ID).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)"global").put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)"<unspecified>").put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.MutateRows").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).put(BuiltinMetricsConstants.STREAMING_KEY, (Object)false).build();
        BuiltinMetricsTestUtils.verifyAttributes(metricData, expected);
    }

    @Test
    public void testReadRowsAttemptsTagValues() {
        Lists.newArrayList((Iterator)this.stub.readRowsCallable().call((Object)Query.create((String)TABLE)).iterator());
        MetricData metricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "attempt_latencies");
        Attributes expected1 = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"UNAVAILABLE").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)"global").put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)"<unspecified>").put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).put(BuiltinMetricsConstants.STREAMING_KEY, (Object)true).build();
        Attributes expected2 = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"OK").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).put(BuiltinMetricsConstants.STREAMING_KEY, (Object)true).build();
        BuiltinMetricsTestUtils.verifyAttributes(metricData, expected1);
        BuiltinMetricsTestUtils.verifyAttributes(metricData, expected2);
    }

    @Test
    public void testBatchBlockingLatencies() throws InterruptedException {
        try (Batcher batcher = this.stub.newMutateRowsBatcher(TABLE, null);){
            for (int i = 0; i < 6; ++i) {
                batcher.add((Object)RowMutationEntry.create((String)"key").setCell("f", "q", "v"));
            }
            batcher.close();
            int expectedNumRequests = 6 / this.batchElementCount;
            MetricData applicationLatency = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "throttling_latencies");
            Attributes expectedAttributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.MutateRows").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).build();
            long value = BuiltinMetricsTestUtils.getAggregatedValue(applicationLatency, expectedAttributes);
            long expected = 90L * (long)(expectedNumRequests - 1) / (long)expectedNumRequests;
            Truth.assertThat((Long)value).isAtLeast((Comparable)Long.valueOf(expected));
        }
    }

    @Test
    public void testQueuedOnChannelServerStreamLatencies() {
        this.stub.readRowsCallable().all().call((Object)Query.create((String)TABLE));
        MetricData clientLatency = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "throttling_latencies");
        Attributes attributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).build();
        long value = BuiltinMetricsTestUtils.getAggregatedValue(clientLatency, attributes);
        Truth.assertThat((Long)value).isAtLeast((Comparable)Long.valueOf(200L));
    }

    @Test
    public void testQueuedOnChannelUnaryLatencies() {
        this.stub.mutateRowCallable().call((Object)RowMutation.create((String)TABLE, (String)"a-key").setCell("f", "q", "v"));
        MetricData clientLatency = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "throttling_latencies");
        Attributes attributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.MutateRow").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).build();
        long actual = BuiltinMetricsTestUtils.getAggregatedValue(clientLatency, attributes);
        Truth.assertThat((Long)actual).isAtLeast((Comparable)Long.valueOf(200L));
    }

    @Test
    public void testPermanentFailure() {
        try {
            Lists.newArrayList((Iterator)this.stub.readRowsCallable().call((Object)Query.create((String)BAD_TABLE_ID)).iterator());
            Assert.fail((String)"Request should throw not found error");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        MetricData attemptLatency = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "attempt_latencies");
        Attributes expected = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"NOT_FOUND").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)BAD_TABLE_ID).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)"<unspecified>").put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)"global").put(BuiltinMetricsConstants.STREAMING_KEY, (Object)true).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).build();
        BuiltinMetricsTestUtils.verifyAttributes(attemptLatency, expected);
        MetricData opLatency = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "operation_latencies");
        BuiltinMetricsTestUtils.verifyAttributes(opLatency, expected);
    }

    @Test
    public void testRemainingDeadline() {
        this.stub.readRowsCallable().all().call((Object)Query.create((String)TABLE));
        MetricData deadlineMetric = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "remaining_deadline");
        Attributes retryAttributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"UNAVAILABLE").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)"global").put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)"<unspecified>").put(BuiltinMetricsConstants.STREAMING_KEY, (Object)true).put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).build();
        HistogramPointData retryHistogramPointData = (HistogramPointData)deadlineMetric.getHistogramData().getPoints().stream().filter(pd -> pd.getAttributes().equals(retryAttributes)).collect(Collectors.toList()).get(0);
        double retryRemainingDeadline = retryHistogramPointData.getSum();
        Truth.assertThat((Double)retryRemainingDeadline).isEqualTo((Object)9000);
        Attributes okAttributes = this.baseAttributes.toBuilder().put(BuiltinMetricsConstants.STATUS_KEY, (Object)"OK").put(BuiltinMetricsConstants.TABLE_ID_KEY, (Object)TABLE).put(BuiltinMetricsConstants.ZONE_ID_KEY, (Object)ZONE).put(BuiltinMetricsConstants.CLUSTER_ID_KEY, (Object)CLUSTER).put(BuiltinMetricsConstants.METHOD_KEY, (Object)"Bigtable.ReadRows").put(BuiltinMetricsConstants.STREAMING_KEY, (Object)true).put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)CLIENT_NAME).build();
        HistogramPointData okHistogramPointData = (HistogramPointData)deadlineMetric.getHistogramData().getPoints().stream().filter(pd -> pd.getAttributes().equals(okAttributes)).collect(Collectors.toList()).get(0);
        double okRemainingDeadline = okHistogramPointData.getSum();
        double expected = 8690.0;
        Truth.assertThat((Double)okRemainingDeadline).isIn(Range.closed((Comparable)Double.valueOf(expected - 500.0), (Comparable)Double.valueOf(expected + 10.0)));
    }

    private static class FakeService
    extends BigtableGrpc.BigtableImplBase {
        private final AtomicInteger attemptCounter = new AtomicInteger(0);
        private final AtomicInteger responseCounter = new AtomicInteger(0);
        private final Iterator<ReadRowsResponse> source = FakeService.createFakeResponse().listIterator();

        private FakeService() {
        }

        static List<ReadRowsResponse> createFakeResponse() {
            ArrayList<ReadRowsResponse> responses = new ArrayList<ReadRowsResponse>();
            for (int i = 0; i < 4; ++i) {
                responses.add(ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setRowKey(ByteString.copyFromUtf8((String)("fake-key-" + i))).setFamilyName(StringValue.of((String)"cf")).setQualifier(BytesValue.newBuilder().setValue(ByteString.copyFromUtf8((String)"q"))).setTimestampMicros(1000L).setValue(ByteString.copyFromUtf8((String)String.join((CharSequence)"", Collections.nCopies(0x100000, "A")))).setCommitRow(true)).build());
            }
            return responses;
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            if (request.getTableName().contains(BuiltinMetricsTracerTest.FIRST_RESPONSE_TABLE_ID)) {
                responseObserver.onNext((Object)this.source.next());
                responseObserver.onNext((Object)this.source.next());
                responseObserver.onCompleted();
                return;
            }
            if (request.getTableName().contains(BuiltinMetricsTracerTest.BAD_TABLE_ID)) {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.NOT_FOUND));
                return;
            }
            AtomicBoolean done = new AtomicBoolean();
            ServerCallStreamObserver target = (ServerCallStreamObserver)responseObserver;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.attemptCounter.getAndIncrement() == 0) {
                target.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
                return;
            }
            target.setOnReadyHandler(() -> {
                while (target.isReady() && this.source.hasNext()) {
                    this.responseCounter.getAndIncrement();
                    target.onNext((Object)this.source.next());
                }
                if (!this.source.hasNext() && done.compareAndSet(false, true)) {
                    target.onCompleted();
                }
            });
        }

        public void mutateRow(MutateRowRequest request, StreamObserver<MutateRowResponse> responseObserver) {
            if (this.attemptCounter.getAndIncrement() < 2) {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
                return;
            }
            responseObserver.onNext((Object)MutateRowResponse.getDefaultInstance());
            responseObserver.onCompleted();
        }

        public void mutateRows(MutateRowsRequest request, StreamObserver<MutateRowsResponse> responseObserver) {
            if (request.getTableName().contains(BuiltinMetricsTracerTest.BAD_TABLE_ID)) {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.NOT_FOUND));
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            MutateRowsResponse.Builder builder = MutateRowsResponse.newBuilder();
            for (int i = 0; i < request.getEntriesCount(); ++i) {
                if (request.getEntries(i).getRowKey().toString((Charset)Charset.availableCharsets().get("UTF-8")).startsWith("fail")) {
                    builder.addEntriesBuilder().setIndex((long)i).setStatus(com.google.rpc.Status.newBuilder().setCode(7).build());
                    continue;
                }
                builder.addEntriesBuilder().setIndex((long)i);
            }
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }

        public AtomicInteger getAttemptCounter() {
            return this.attemptCounter;
        }

        public AtomicInteger getResponseCounter() {
            return this.responseCounter;
        }
    }

    class DelayProxyDetector
    implements ProxyDetector {
        DelayProxyDetector() {
        }

        @Nullable
        public ProxiedSocketAddress proxyFor(SocketAddress socketAddress) throws IOException {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
    }
}

