/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.Version;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsTestUtils;
import com.google.cloud.bigtable.data.v2.stub.metrics.CustomOpenTelemetryMetricsProvider;
import com.google.cloud.bigtable.data.v2.stub.metrics.ErrorCountPerConnectionMetricTracker;
import com.google.cloud.bigtable.data.v2.stub.metrics.MetricsProvider;
import com.google.common.truth.Truth;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.data.HistogramPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class ErrorCountPerConnectionTest {
    private static final String SUCCESS_TABLE_NAME = "some-table";
    private static final String ERROR_TABLE_NAME = "nonexistent-table";
    private Server server;
    private final FakeService fakeService = new FakeService();
    private EnhancedBigtableStubSettings.Builder builder;
    private ArgumentCaptor<Runnable> runnableCaptor;
    private InMemoryMetricReader metricReader;
    private Attributes attributes;

    @Before
    public void setup() throws Exception {
        this.server = FakeServiceBuilder.create(new BindableService[]{this.fakeService}).start();
        ScheduledExecutorService executors = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        this.attributes = Attributes.builder().put(BuiltinMetricsConstants.BIGTABLE_PROJECT_ID_KEY, (Object)"fake-project").put(BuiltinMetricsConstants.INSTANCE_ID_KEY, (Object)"fake-instance").put(BuiltinMetricsConstants.APP_PROFILE_KEY, (Object)"").put(BuiltinMetricsConstants.CLIENT_NAME_KEY, (Object)("bigtable-java/" + Version.VERSION)).build();
        this.metricReader = InMemoryMetricReader.create();
        SdkMeterProviderBuilder meterProvider = SdkMeterProvider.builder().registerMetricReader((MetricReader)this.metricReader);
        for (Map.Entry entry : BuiltinMetricsConstants.getAllViews().entrySet()) {
            meterProvider.registerView((InstrumentSelector)entry.getKey(), (View)entry.getValue());
        }
        OpenTelemetrySdk otel = OpenTelemetrySdk.builder().setMeterProvider(meterProvider.build()).build();
        this.builder = ((EnhancedBigtableStubSettings.Builder)BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).stubSettings().setBackgroundExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)executors))).setProjectId("fake-project").setInstanceId("fake-instance").setMetricsProvider((MetricsProvider)CustomOpenTelemetryMetricsProvider.create((OpenTelemetry)otel));
        this.runnableCaptor = ArgumentCaptor.forClass(Runnable.class);
        Mockito.when(executors.scheduleAtFixedRate((Runnable)this.runnableCaptor.capture(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).then(invocation -> (ScheduledFuture)Mockito.mock(ScheduledFuture.class));
    }

    @After
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    @Test
    public void readWithOneChannel() throws Exception {
        long errorCount = 0L;
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)this.builder.build());){
            for (int i = 0; i < 20; ++i) {
                Query query;
                if (i % 3 == 0) {
                    query = Query.create((String)ERROR_TABLE_NAME);
                    ++errorCount;
                } else {
                    query = Query.create((String)SUCCESS_TABLE_NAME);
                }
                try {
                    stub.readRowsCallable().call((Object)query).iterator().hasNext();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.runInterceptorTasksAndAssertCount();
        MetricData metricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "per_connection_error_count");
        ArrayList histogramPointData = new ArrayList(metricData.getHistogramData().getPoints());
        Truth.assertThat((Integer)histogramPointData.size()).isEqualTo((Object)1);
        HistogramPointData point = (HistogramPointData)histogramPointData.get(0);
        int index = this.findDataPointIndex(point.getBoundaries(), errorCount);
        Truth.assertThat((Long)((Long)point.getCounts().get(index))).isEqualTo((Object)1);
    }

    @Test
    public void readWithTwoChannels() throws Exception {
        EnhancedBigtableStubSettings.Builder builderWithTwoChannels = (EnhancedBigtableStubSettings.Builder)this.builder.setTransportChannelProvider((TransportChannelProvider)((InstantiatingGrpcChannelProvider)this.builder.getTransportChannelProvider()).toBuilder().setChannelPoolSettings(ChannelPoolSettings.staticallySized((int)2)).build());
        long totalErrorCount = 0L;
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)builderWithTwoChannels.build());){
            for (int i = 0; i < 20; ++i) {
                try {
                    if (i < 10) {
                        ++totalErrorCount;
                        stub.readRowsCallable().call((Object)Query.create((String)ERROR_TABLE_NAME)).iterator().hasNext();
                        continue;
                    }
                    stub.readRowsCallable().call((Object)Query.create((String)SUCCESS_TABLE_NAME)).iterator().hasNext();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.runInterceptorTasksAndAssertCount();
        long errorCountPerChannel = totalErrorCount / 2L;
        MetricData metricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "per_connection_error_count");
        ArrayList histogramPointData = new ArrayList(metricData.getHistogramData().getPoints());
        Truth.assertThat((Integer)histogramPointData.size()).isEqualTo((Object)1);
        HistogramPointData point = (HistogramPointData)histogramPointData.get(0);
        int index = this.findDataPointIndex(point.getBoundaries(), errorCountPerChannel);
        Truth.assertThat((Long)((Long)point.getCounts().get(index))).isEqualTo((Object)2);
    }

    @Test
    public void readOverTwoPeriods() throws Exception {
        long errorCount1 = 0L;
        long errorCount2 = 0L;
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)this.builder.build());){
            Query query;
            int i;
            for (i = 0; i < 20; ++i) {
                if (i % 3 == 0) {
                    query = Query.create((String)ERROR_TABLE_NAME);
                    ++errorCount1;
                } else {
                    query = Query.create((String)SUCCESS_TABLE_NAME);
                }
                try {
                    stub.readRowsCallable().call((Object)query).iterator().hasNext();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.runInterceptorTasksAndAssertCount();
            for (i = 0; i < 20; ++i) {
                if (i % 3 == 0) {
                    query = Query.create((String)SUCCESS_TABLE_NAME);
                } else {
                    query = Query.create((String)ERROR_TABLE_NAME);
                    ++errorCount2;
                }
                try {
                    stub.readRowsCallable().call((Object)query).iterator().hasNext();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.runInterceptorTasksAndAssertCount();
        MetricData metricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "per_connection_error_count");
        ArrayList histogramPointData = new ArrayList(metricData.getHistogramData().getPoints());
        Truth.assertThat((Integer)histogramPointData.size()).isEqualTo((Object)1);
        HistogramPointData point = (HistogramPointData)histogramPointData.get(0);
        int index1 = this.findDataPointIndex(point.getBoundaries(), errorCount1);
        int index2 = this.findDataPointIndex(point.getBoundaries(), errorCount2);
        Truth.assertThat((Long)((Long)point.getCounts().get(index1))).isEqualTo((Object)1);
        Truth.assertThat((Long)((Long)point.getCounts().get(index2))).isEqualTo((Object)1);
    }

    @Test
    public void noFailedRequests() throws Exception {
        try (EnhancedBigtableStub stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)this.builder.build());){
            for (int i = 0; i < 20; ++i) {
                try {
                    stub.readRowsCallable().call((Object)Query.create((String)SUCCESS_TABLE_NAME)).iterator().hasNext();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.runInterceptorTasksAndAssertCount();
        MetricData metricData = BuiltinMetricsTestUtils.getMetricData(this.metricReader, "per_connection_error_count");
        long value = BuiltinMetricsTestUtils.getAggregatedValue(metricData, this.attributes);
        Truth.assertThat((Long)value).isEqualTo((Object)0);
    }

    private void runInterceptorTasksAndAssertCount() {
        int actualNumOfTasks = 0;
        for (Runnable runnable : this.runnableCaptor.getAllValues()) {
            if (!(runnable instanceof ErrorCountPerConnectionMetricTracker)) continue;
            runnable.run();
            ++actualNumOfTasks;
        }
        Truth.assertThat((Integer)actualNumOfTasks).isEqualTo((Object)1);
    }

    private int findDataPointIndex(List<Double> boundaries, long dataPoint) {
        int index;
        for (index = 0; index < boundaries.size() && !(boundaries.get(index) >= (double)dataPoint); ++index) {
        }
        return index;
    }

    static class FakeService
    extends BigtableGrpc.BigtableImplBase {
        FakeService() {
        }

        public void readRows(ReadRowsRequest request, StreamObserver<ReadRowsResponse> responseObserver) {
            if (request.getTableName().contains(ErrorCountPerConnectionTest.SUCCESS_TABLE_NAME)) {
                responseObserver.onNext((Object)ReadRowsResponse.getDefaultInstance());
                responseObserver.onCompleted();
            } else {
                StatusRuntimeException exception = new StatusRuntimeException(Status.INTERNAL);
                responseObserver.onError((Throwable)exception);
            }
        }
    }
}

