/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.gax.batching.Batcher;
import com.google.api.gax.batching.BatcherImpl;
import com.google.api.gax.batching.BatchingDescriptor;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.data.v2.stub.BigtableClientContext;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcViewConstants;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcViews;
import com.google.cloud.bigtable.data.v2.stub.metrics.SimpleStatsComponent;
import com.google.cloud.bigtable.data.v2.stub.metrics.StatsTestUtils;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsBatchingDescriptor;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.StringValue;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.opencensus.stats.StatsComponent;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.stats.ViewManager;
import io.opencensus.tags.TagKey;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.stubbing.Answer;

@RunWith(value=JUnit4.class)
public class MetricsTracerTest {
    private static final String PROJECT_ID = "fake-project";
    private static final String INSTANCE_ID = "fake-instance";
    private static final String APP_PROFILE_ID = "default";
    private static final String TABLE_ID = "fake-table";
    private static final long SLEEP_VARIABILITY = 15L;
    private static final ReadRowsResponse DEFAULT_READ_ROWS_RESPONSES = ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"fake-key")).setFamilyName(StringValue.of((String)"cf")).setQualifier(BytesValue.newBuilder().setValue(ByteString.copyFromUtf8((String)"q"))).setTimestampMicros(1000L).setValue(ByteString.copyFromUtf8((String)"value")).setCommitRow(true)).build();
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    private Server server;
    @Mock(answer=Answers.CALLS_REAL_METHODS)
    private BigtableGrpc.BigtableImplBase mockService;
    private final StatsComponent localStats = new SimpleStatsComponent();
    private EnhancedBigtableStub stub;
    private BigtableDataSettings settings;

    @Before
    public void setUp() throws Exception {
        this.server = FakeServiceBuilder.create(new BindableService[]{this.mockService}).start();
        RpcViews.registerBigtableClientViews((ViewManager)this.localStats.getViewManager());
        this.settings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).setAppProfileId(APP_PROFILE_ID).build();
        BigtableClientContext bigtableClientContext = EnhancedBigtableStub.createBigtableClientContext((EnhancedBigtableStubSettings)this.settings.getStubSettings());
        ClientContext clientContext = bigtableClientContext.getClientContext().toBuilder().setTracerFactory(EnhancedBigtableStub.createBigtableTracerFactory((EnhancedBigtableStubSettings)this.settings.getStubSettings(), (Tagger)Tags.getTagger(), (StatsRecorder)this.localStats.getStatsRecorder(), null)).build();
        this.stub = new EnhancedBigtableStub(this.settings.getStubSettings(), clientContext);
    }

    @After
    public void tearDown() {
        this.stub.close();
        this.server.shutdown();
    }

    @Test
    public void testReadRowsLatency() throws InterruptedException {
        long sleepTime = 50L;
        ((BigtableGrpc.BigtableImplBase)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                StreamObserver observer = (StreamObserver)invocation.getArguments()[1];
                Thread.sleep(50L);
                observer.onNext((Object)DEFAULT_READ_ROWS_RESPONSES);
                observer.onCompleted();
                return null;
            }
        }).when((Object)this.mockService)).readRows((ReadRowsRequest)ArgumentMatchers.any(ReadRowsRequest.class), (StreamObserver)ArgumentMatchers.any());
        Stopwatch stopwatch = Stopwatch.createStarted();
        Lists.newArrayList((Iterable)this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID)));
        long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        long opLatency = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_OP_LATENCY_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.ReadRows"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)opLatency).isIn(Range.closed((Comparable)Long.valueOf(50L), (Comparable)Long.valueOf(elapsed)));
    }

    @Test
    public void testReadRowsOpCount() throws InterruptedException {
        ((BigtableGrpc.BigtableImplBase)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) {
                StreamObserver observer = (StreamObserver)invocation.getArguments()[1];
                observer.onNext((Object)DEFAULT_READ_ROWS_RESPONSES);
                observer.onCompleted();
                return null;
            }
        }).when((Object)this.mockService)).readRows((ReadRowsRequest)ArgumentMatchers.any(ReadRowsRequest.class), (StreamObserver)ArgumentMatchers.any());
        Lists.newArrayList((Iterable)this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID)));
        Lists.newArrayList((Iterable)this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID)));
        long opLatency = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_COMPLETED_OP_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.ReadRows"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)opLatency).isEqualTo((Object)2);
    }

    @Test
    public void testReadRowsFirstRow() throws InterruptedException {
        long beforeSleep = 50L;
        long afterSleep = 50L;
        SettableFuture gotFirstRow = SettableFuture.create();
        ExecutorService executor = Executors.newCachedThreadPool();
        ((BigtableGrpc.BigtableImplBase)Mockito.doAnswer(invocation -> {
            StreamObserver observer = (StreamObserver)invocation.getArgument(1);
            executor.submit(() -> {
                Thread.sleep(50L);
                observer.onNext((Object)DEFAULT_READ_ROWS_RESPONSES);
                gotFirstRow.get();
                Thread.sleep(50L);
                observer.onCompleted();
                return null;
            });
            return null;
        }).when((Object)this.mockService)).readRows((ReadRowsRequest)ArgumentMatchers.any(ReadRowsRequest.class), (StreamObserver)ArgumentMatchers.any());
        Stopwatch stopwatch = Stopwatch.createStarted();
        Iterator it = this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID)).iterator();
        it.next();
        gotFirstRow.set(null);
        while (it.hasNext()) {
            it.next();
        }
        long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        executor.shutdown();
        long firstRowLatency = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_READ_ROWS_FIRST_ROW_LATENCY_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of(), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)firstRowLatency).isIn(Range.closed((Comparable)Long.valueOf(35L), (Comparable)Long.valueOf(elapsed - 50L + 15L)));
    }

    @Test
    public void testReadRowsAttemptsPerOp() throws InterruptedException {
        final AtomicInteger callCount = new AtomicInteger(0);
        ((BigtableGrpc.BigtableImplBase)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) {
                StreamObserver observer = (StreamObserver)invocation.getArguments()[1];
                if (callCount.getAndIncrement() == 0) {
                    observer.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
                    return null;
                }
                observer.onNext((Object)DEFAULT_READ_ROWS_RESPONSES);
                observer.onCompleted();
                return null;
            }
        }).when((Object)this.mockService)).readRows((ReadRowsRequest)ArgumentMatchers.any(ReadRowsRequest.class), (StreamObserver)ArgumentMatchers.any());
        Lists.newArrayList((Iterable)this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID)));
        long opLatency = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_ATTEMPTS_PER_OP_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.ReadRows"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)opLatency).isEqualTo((Object)2);
    }

    @Test
    public void testReadRowsAttemptLatency() throws InterruptedException {
        long sleepTime = 50L;
        final AtomicInteger callCount = new AtomicInteger(0);
        ((BigtableGrpc.BigtableImplBase)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                StreamObserver observer = (StreamObserver)invocation.getArguments()[1];
                Thread.sleep(50L);
                if (callCount.getAndIncrement() == 0) {
                    observer.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
                    return null;
                }
                observer.onNext((Object)DEFAULT_READ_ROWS_RESPONSES);
                observer.onCompleted();
                return null;
            }
        }).when((Object)this.mockService)).readRows((ReadRowsRequest)ArgumentMatchers.any(ReadRowsRequest.class), (StreamObserver)ArgumentMatchers.any());
        Stopwatch stopwatch = Stopwatch.createStarted();
        Lists.newArrayList((Iterable)this.stub.readRowsCallable().call((Object)Query.create((String)TABLE_ID)));
        long elapsed = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        long attemptLatency = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_ATTEMPT_LATENCY_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.ReadRows"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"OK")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)attemptLatency).isIn(Range.closed((Comparable)Long.valueOf(50L), (Comparable)Long.valueOf(elapsed - 50L)));
    }

    @Test
    public void testInvalidRequest() {
        try {
            this.stub.bulkMutateRowsCallable().call((Object)BulkMutation.create((String)TABLE_ID));
            Assert.fail((String)"Invalid request should throw exception");
        }
        catch (IllegalStateException e) {
            long attemptLatency = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_ATTEMPT_LATENCY_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.MutateRows"), (Object)RpcMeasureConstants.BIGTABLE_STATUS, (Object)TagValue.create((String)"UNKNOWN")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
            Truth.assertThat((Long)attemptLatency).isAtLeast(0);
        }
    }

    @Test
    public void testBatchReadRowsThrottledTime() throws Exception {
        ((BigtableGrpc.BigtableImplBase)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) {
                StreamObserver observer = (StreamObserver)invocation.getArguments()[1];
                observer.onNext((Object)DEFAULT_READ_ROWS_RESPONSES);
                observer.onCompleted();
                return null;
            }
        }).when((Object)this.mockService)).readRows((ReadRowsRequest)ArgumentMatchers.any(ReadRowsRequest.class), (StreamObserver)ArgumentMatchers.any());
        try (Batcher batcher = this.stub.newBulkReadRowsBatcher(Query.create((String)TABLE_ID), GrpcCallContext.createDefault());){
            batcher.add((Object)ByteString.copyFromUtf8((String)"row1"));
        }
        long throttledTimeMetric = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_BATCH_THROTTLED_TIME_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.ReadRows")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)throttledTimeMetric).isEqualTo((Object)0);
    }

    @Test
    public void testBatchMutateRowsThrottledTime() throws Exception {
        FlowController flowController = (FlowController)Mockito.mock(FlowController.class);
        MutateRowsBatchingDescriptor batchingDescriptor = new MutateRowsBatchingDescriptor();
        long throttled = 50L;
        ((FlowController)Mockito.doAnswer(invocation -> {
            Thread.sleep(50L);
            return null;
        }).when((Object)flowController)).reserve(((Long)ArgumentMatchers.any(Long.class)).longValue(), ((Long)ArgumentMatchers.any(Long.class)).longValue());
        Mockito.when((Object)flowController.getMaxElementCountLimit()).thenReturn(null);
        Mockito.when((Object)flowController.getMaxRequestBytesLimit()).thenReturn(null);
        ((BigtableGrpc.BigtableImplBase)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) {
                MutateRowsRequest request = (MutateRowsRequest)invocation.getArguments()[0];
                StreamObserver observer = (StreamObserver)invocation.getArguments()[1];
                MutateRowsResponse.Builder builder = MutateRowsResponse.newBuilder();
                for (int i = 0; i < request.getEntriesCount(); ++i) {
                    builder.addEntriesBuilder().setIndex((long)i);
                }
                observer.onNext((Object)builder.build());
                observer.onCompleted();
                return null;
            }
        }).when((Object)this.mockService)).mutateRows((MutateRowsRequest)ArgumentMatchers.any(MutateRowsRequest.class), (StreamObserver)ArgumentMatchers.any());
        GrpcCallContext defaultContext = GrpcCallContext.createDefault();
        try (BatcherImpl batcher = new BatcherImpl((BatchingDescriptor)batchingDescriptor, this.stub.internalBulkMutateRowsCallable().withDefaultCallContext((ApiCallContext)defaultContext), (Object)BulkMutation.create((String)TABLE_ID), this.settings.getStubSettings().bulkMutateRowsSettings().getBatchingSettings(), Executors.newSingleThreadScheduledExecutor(), flowController, (ApiCallContext)defaultContext);){
            batcher.add((Object)RowMutationEntry.create((String)"key").deleteRow());
        }
        long throttledTimeMetric = StatsTestUtils.getAggregationValueAsLong(this.localStats, RpcViewConstants.BIGTABLE_BATCH_THROTTLED_TIME_VIEW, (ImmutableMap<TagKey, TagValue>)ImmutableMap.of((Object)RpcMeasureConstants.BIGTABLE_OP, (Object)TagValue.create((String)"Bigtable.MutateRows")), PROJECT_ID, INSTANCE_ID, APP_PROFILE_ID);
        Truth.assertThat((Long)throttledTimeMetric).isAtLeast((Comparable)Long.valueOf(50L));
    }

    private static <T> StreamObserver<T> anyObserver(Class<T> returnType) {
        return (StreamObserver)ArgumentMatchers.any(returnType);
    }
}

