/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.RetryingContext;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.UnavailableException;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsAttemptCallable;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsAttemptResult;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.rpc.Status;
import io.grpc.Status;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class MutateRowsAttemptCallableTest {
    private static final Status OK_STATUS_PROTO = Status.newBuilder().setCode(0).build();
    private static final Status TRANSIENT_ERROR_STATUS_PROTO = Status.newBuilder().setCode(14).build();
    private static final Status PERMENANT_ERROR_STATUS_PROTO = Status.newBuilder().setCode(3).build();
    private MockInnerCallable innerCallable;
    private Set<StatusCode.Code> retryCodes;
    private ApiCallContext callContext;
    private MockRetryingFuture parentFuture;
    private final RetryAlgorithm<MutateRowsRequest> mockRetryAlgorithm = (RetryAlgorithm)Mockito.mock(RetryAlgorithm.class);

    @Before
    public void setUp() {
        this.innerCallable = new MockInnerCallable();
        this.retryCodes = ImmutableSet.of((Object)StatusCode.Code.DEADLINE_EXCEEDED, (Object)StatusCode.Code.UNAVAILABLE);
        this.callContext = GrpcCallContext.createDefault();
        this.parentFuture = new MockRetryingFuture();
        Mockito.when((Object)this.mockRetryAlgorithm.shouldRetry((RetryingContext)Mockito.any(), (Throwable)Mockito.any(), (Object)((MutateRowsRequest)Mockito.any()), (TimedAttemptSettings)Mockito.any())).thenAnswer(input -> {
            Throwable throwable = (Throwable)input.getArgument(1);
            return ((ApiException)throwable).isRetryable();
        });
    }

    @Test
    public void singleEntrySuccessTest() throws Exception {
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.getDefaultInstance()).build();
        this.innerCallable.response.add(MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(OK_STATUS_PROTO)).build());
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)this.innerCallable, request, this.callContext, this.retryCodes, this.mockRetryAlgorithm);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        MutateRowsAttemptResult result = (MutateRowsAttemptResult)this.parentFuture.attemptFuture.get();
        Truth.assertThat((Object)result).isNotNull();
        Truth.assertThat((Iterable)result.getFailedMutations()).hasSize(0);
        Truth.assertThat((Boolean)result.getIsRetryable()).isFalse();
        Truth.assertThat((Object)this.innerCallable.lastRequest).isEqualTo((Object)request);
    }

    @Test
    public void missingEntry() throws Exception {
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.getDefaultInstance()).addEntries(MutateRowsRequest.Entry.getDefaultInstance()).build();
        this.innerCallable.response.add(MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L)).build());
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)this.innerCallable, request, this.callContext, this.retryCodes, this.mockRetryAlgorithm);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        MutateRowsAttemptResult result = (MutateRowsAttemptResult)this.parentFuture.attemptFuture.get();
        Truth.assertThat((Iterable)result.getFailedMutations()).hasSize(1);
        MutateRowsException.FailedMutation failedMutation = (MutateRowsException.FailedMutation)result.getFailedMutations().get(0);
        Truth.assertThat((Integer)failedMutation.getIndex()).isEqualTo((Object)1);
        Truth.assertThat((Throwable)failedMutation.getError()).hasMessageThat().contains((CharSequence)"Missing entry response for entry 1");
    }

    @Test
    public void testNoRpcTimeout() {
        this.parentFuture.timedAttemptSettings = this.parentFuture.timedAttemptSettings.toBuilder().setRpcTimeoutDuration(Duration.ZERO).build();
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.getDefaultInstance()).build();
        this.innerCallable.response.add(MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(OK_STATUS_PROTO)).build());
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)this.innerCallable, request, this.callContext, this.retryCodes, this.mockRetryAlgorithm);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        Truth.assertThat((Comparable)this.innerCallable.lastContext.getTimeout()).isNull();
    }

    @Test
    public void mixedTest() throws Exception {
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.getDefaultInstance()).addEntries(MutateRowsRequest.Entry.getDefaultInstance()).addEntries(MutateRowsRequest.Entry.getDefaultInstance()).build();
        this.innerCallable.response.add(MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(OK_STATUS_PROTO)).addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(1L).setStatus(TRANSIENT_ERROR_STATUS_PROTO)).addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(2L).setStatus(PERMENANT_ERROR_STATUS_PROTO)).build());
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)this.innerCallable, request, this.callContext, this.retryCodes, this.mockRetryAlgorithm);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        MutateRowsAttemptResult result = (MutateRowsAttemptResult)this.parentFuture.attemptFuture.get();
        List failedMutations = result.getFailedMutations();
        Truth.assertThat((Iterable)failedMutations).hasSize(2);
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(0)).getIndex()).isEqualTo((Object)1);
        Truth.assertThat((Comparable)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.UNAVAILABLE);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().isRetryable()).isTrue();
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(1)).getIndex()).isEqualTo((Object)2);
        Truth.assertThat((Comparable)((MutateRowsException.FailedMutation)failedMutations.get(1)).getError().getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INVALID_ARGUMENT);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(1)).getError().isRetryable()).isFalse();
    }

    @Test
    public void nextAttemptTest() throws Exception {
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"0-ok"))).addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"1-unavailable"))).addEntries(MutateRowsRequest.Entry.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"2-invalid"))).build();
        this.innerCallable.response.add(MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(OK_STATUS_PROTO)).addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(1L).setStatus(TRANSIENT_ERROR_STATUS_PROTO)).addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(2L).setStatus(PERMENANT_ERROR_STATUS_PROTO)).build());
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)this.innerCallable, request, this.callContext, this.retryCodes, this.mockRetryAlgorithm);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        this.innerCallable.response = Lists.newArrayList((Object[])new MutateRowsResponse[]{MutateRowsResponse.newBuilder().addEntries(MutateRowsResponse.Entry.newBuilder().setIndex(0L).setStatus(OK_STATUS_PROTO)).build()});
        attemptCallable.call();
        Truth.assertThat((Integer)this.innerCallable.lastRequest.getEntriesCount()).isEqualTo((Object)1);
        Truth.assertThat((Iterable)this.innerCallable.lastRequest.getEntries(0).getRowKey()).isEqualTo((Object)ByteString.copyFromUtf8((String)"1-unavailable"));
        MutateRowsAttemptResult result = (MutateRowsAttemptResult)this.parentFuture.attemptFuture.get();
        List failedMutations = result.getFailedMutations();
        Truth.assertThat((Iterable)failedMutations).hasSize(1);
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(0)).getIndex()).isEqualTo((Object)2);
        Truth.assertThat((Comparable)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().getStatusCode().getCode()).isEqualTo((Object)StatusCode.Code.INVALID_ARGUMENT);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().isRetryable()).isFalse();
    }

    @Test
    public void rpcRetryableError() {
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.getDefaultInstance()).addEntries(MutateRowsRequest.Entry.getDefaultInstance()).build();
        final UnavailableException rpcError = new UnavailableException("fake error", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE), true);
        UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>> innerCallable = new UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>>(){

            public ApiFuture<List<MutateRowsResponse>> futureCall(MutateRowsRequest request, ApiCallContext context) {
                return ApiFutures.immediateFailedFuture((Throwable)rpcError);
            }
        };
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)innerCallable, request, this.callContext, this.retryCodes, this.mockRetryAlgorithm);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        Throwable actualError = null;
        try {
            this.parentFuture.attemptFuture.get();
        }
        catch (Throwable t) {
            actualError = t.getCause();
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(MutateRowsException.class);
        Truth.assertThat((Boolean)((MutateRowsException)actualError).isRetryable()).isTrue();
        List failedMutations = ((MutateRowsException)actualError).getFailedMutations();
        Truth.assertThat((Iterable)failedMutations).hasSize(2);
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(0)).getIndex()).isEqualTo((Object)0);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().isRetryable()).isTrue();
        Truth.assertThat((Throwable)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().getCause()).isEqualTo((Object)rpcError);
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(1)).getIndex()).isEqualTo((Object)1);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(1)).getError().isRetryable()).isTrue();
        Truth.assertThat((Throwable)((MutateRowsException.FailedMutation)failedMutations.get(1)).getError().getCause()).isEqualTo((Object)rpcError);
    }

    @Test
    public void rpcPermanentError() {
        MutateRowsRequest request = MutateRowsRequest.newBuilder().addEntries(MutateRowsRequest.Entry.getDefaultInstance()).addEntries(MutateRowsRequest.Entry.getDefaultInstance()).build();
        final UnavailableException rpcError = new UnavailableException("fake error", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INVALID_ARGUMENT), false);
        UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>> innerCallable = new UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>>(){

            public ApiFuture<List<MutateRowsResponse>> futureCall(MutateRowsRequest request, ApiCallContext context) {
                return ApiFutures.immediateFailedFuture((Throwable)rpcError);
            }
        };
        MutateRowsAttemptCallable attemptCallable = new MutateRowsAttemptCallable((UnaryCallable)innerCallable, request, this.callContext, this.retryCodes, this.mockRetryAlgorithm);
        attemptCallable.setExternalFuture((RetryingFuture)this.parentFuture);
        attemptCallable.call();
        Throwable actualError = null;
        try {
            this.parentFuture.attemptFuture.get();
        }
        catch (Throwable t) {
            actualError = t.getCause();
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(MutateRowsException.class);
        Truth.assertThat((Boolean)((MutateRowsException)actualError).isRetryable()).isFalse();
        List failedMutations = ((MutateRowsException)actualError).getFailedMutations();
        Truth.assertThat((Iterable)failedMutations).hasSize(2);
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(0)).getIndex()).isEqualTo((Object)0);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().isRetryable()).isFalse();
        Truth.assertThat((Throwable)((MutateRowsException.FailedMutation)failedMutations.get(0)).getError().getCause()).isEqualTo((Object)rpcError);
        Truth.assertThat((Integer)((MutateRowsException.FailedMutation)failedMutations.get(1)).getIndex()).isEqualTo((Object)1);
        Truth.assertThat((Boolean)((MutateRowsException.FailedMutation)failedMutations.get(1)).getError().isRetryable()).isFalse();
        Truth.assertThat((Throwable)((MutateRowsException.FailedMutation)failedMutations.get(1)).getError().getCause()).isEqualTo((Object)rpcError);
    }

    static class MockInnerCallable
    extends UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>> {
        List<MutateRowsResponse> response = Lists.newArrayList();
        MutateRowsRequest lastRequest;
        ApiCallContext lastContext;

        MockInnerCallable() {
        }

        public ApiFuture<List<MutateRowsResponse>> futureCall(MutateRowsRequest request, ApiCallContext context) {
            this.lastRequest = request;
            this.lastContext = context;
            return ApiFutures.immediateFuture(this.response);
        }
    }

    static class MockRetryingFuture
    extends AbstractApiFuture<MutateRowsAttemptResult>
    implements RetryingFuture<MutateRowsAttemptResult> {
        ApiFuture<MutateRowsAttemptResult> attemptFuture;
        TimedAttemptSettings timedAttemptSettings;

        MockRetryingFuture() {
            this(Duration.ofSeconds(5L));
        }

        MockRetryingFuture(Duration totalTimeout) {
            this.timedAttemptSettings = TimedAttemptSettings.newBuilder().setRpcTimeoutDuration(Duration.ofSeconds(1L)).setRetryDelayDuration(Duration.ZERO).setRandomizedRetryDelayDuration(Duration.ZERO).setAttemptCount(0).setFirstAttemptStartTimeNanos(0L).setGlobalSettings(RetrySettings.newBuilder().setTotalTimeoutDuration(totalTimeout).build()).build();
        }

        public void setAttemptFuture(ApiFuture<MutateRowsAttemptResult> attemptFuture) {
            this.attemptFuture = attemptFuture;
        }

        public TimedAttemptSettings getAttemptSettings() {
            return this.timedAttemptSettings;
        }

        public Callable<MutateRowsAttemptResult> getCallable() {
            throw new UnsupportedOperationException("not used");
        }

        public ApiFuture<MutateRowsAttemptResult> peekAttemptResult() {
            throw new UnsupportedOperationException("not used");
        }

        public ApiFuture<MutateRowsAttemptResult> getAttemptResult() {
            throw new UnsupportedOperationException("not used");
        }
    }
}

