/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.google.cloud.bigtable.data.v2.stub.MutateRowsErrorConverterUnaryCallable;
import com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsAttemptResult;
import com.google.common.truth.Truth;
import io.grpc.Status;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@RunWith(value=JUnit4.class)
public class MutateRowsErrorConverterUnaryCallableTest {
    @Mock
    private UnaryCallable<BulkMutation, MutateRowsAttemptResult> innerCallable;
    @Captor
    private ArgumentCaptor<BulkMutation> innerMutation;
    private SettableApiFuture<MutateRowsAttemptResult> innerResult;
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();

    @Before
    public void setUp() {
        this.innerResult = SettableApiFuture.create();
        Mockito.when((Object)this.innerCallable.futureCall((Object)((BulkMutation)this.innerMutation.capture()), (ApiCallContext)Mockito.any())).thenReturn(this.innerResult);
    }

    @Test
    public void testSuccess() {
        MutateRowsErrorConverterUnaryCallable callable = new MutateRowsErrorConverterUnaryCallable(this.innerCallable);
        this.innerResult.set((Object)MutateRowsAttemptResult.success());
        Throwable unexpectedError = null;
        try {
            callable.call((Object)BulkMutation.create((String)"fake-table"));
        }
        catch (Throwable t) {
            unexpectedError = t;
        }
        Truth.assertThat((Throwable)unexpectedError).isNull();
    }

    @Test
    public void testPartialFailure() {
        MutateRowsErrorConverterUnaryCallable callable = new MutateRowsErrorConverterUnaryCallable(this.innerCallable);
        this.innerResult.set((Object)MutateRowsAttemptResult.create(Arrays.asList(MutateRowsException.FailedMutation.create((int)0, (ApiException)ApiExceptionFactory.createException(null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), (boolean)false))), (boolean)true));
        MutateRowsException exception = (MutateRowsException)Assert.assertThrows(MutateRowsException.class, () -> callable.call((Object)BulkMutation.create((String)"fake-table")));
        Truth.assertThat((Throwable)exception).isInstanceOf(MutateRowsException.class);
        Truth.assertThat((Boolean)exception.isRetryable()).isTrue();
    }

    @Test
    public void testRPCFailure() {
        MutateRowsErrorConverterUnaryCallable callable = new MutateRowsErrorConverterUnaryCallable(this.innerCallable);
        this.innerResult.setException((Throwable)new Exception("RPC error"));
        Exception exception = (Exception)Assert.assertThrows(Exception.class, () -> callable.call((Object)BulkMutation.create((String)"fake-table")));
        Truth.assertThat((Throwable)exception).isInstanceOf(Exception.class);
    }
}

