/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.batching.BatchEntry;
import com.google.api.gax.batching.BatchingRequestBuilder;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsBatchingDescriptor;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadRowsBatchingDescriptorTest {
    private static final RowCell ROW_CELL = RowCell.create((String)"cf", (ByteString)ByteString.copyFromUtf8((String)"qualifier"), (long)10000L, (List)ImmutableList.of((Object)"label-1", (Object)"label-2"), (ByteString)ByteString.copyFromUtf8((String)"qualifier"));
    private static final Row ROW_KEY_1_RESPONSE = Row.create((ByteString)ByteString.copyFromUtf8((String)"row-key-1"), (List)ImmutableList.of((Object)ROW_CELL));
    private static final Row ROW_KEY_2_RESPONSE = Row.create((ByteString)ByteString.copyFromUtf8((String)"row-key-2"), (List)ImmutableList.of((Object)ROW_CELL));
    private ReadRowsBatchingDescriptor underTest = new ReadRowsBatchingDescriptor();

    @Test
    public void splitResponseTest() throws Exception {
        List<BatchEntry<ByteString, Row>> batchEntries = this.createBatchEntries("row-key-1", "row-key-2");
        this.underTest.splitResponse((List)ImmutableList.of((Object)ROW_KEY_1_RESPONSE, (Object)ROW_KEY_2_RESPONSE), batchEntries);
        Truth.assertThat((Object)batchEntries.get(0).getResultFuture().get()).isEqualTo((Object)ROW_KEY_1_RESPONSE);
        Truth.assertThat((Object)batchEntries.get(1).getResultFuture().get()).isEqualTo((Object)ROW_KEY_2_RESPONSE);
    }

    @Test
    public void splitResponseWithDuplicateKeysTest() throws Exception {
        List<BatchEntry<ByteString, Row>> batchEntries = this.createBatchEntries("row-key-1", "row-key-2", "row-key-1", "row-key-1");
        this.underTest.splitResponse((List)ImmutableList.of((Object)ROW_KEY_1_RESPONSE, (Object)ROW_KEY_2_RESPONSE), batchEntries);
        Truth.assertThat((Object)batchEntries.get(0).getResultFuture().get()).isEqualTo((Object)ROW_KEY_1_RESPONSE);
        Truth.assertThat((Object)batchEntries.get(1).getResultFuture().get()).isEqualTo((Object)ROW_KEY_2_RESPONSE);
        Truth.assertThat((Object)batchEntries.get(2).getResultFuture().get()).isEqualTo((Object)ROW_KEY_1_RESPONSE);
        Truth.assertThat((Object)batchEntries.get(3).getResultFuture().get()).isEqualTo((Object)ROW_KEY_1_RESPONSE);
    }

    @Test
    public void splitResponseWithNonExistent() throws Exception {
        List<BatchEntry<ByteString, Row>> batchEntries = this.createBatchEntries("non-existent-1", "non-existent-2", "row-key-1");
        this.underTest.splitResponse((List)ImmutableList.of((Object)ROW_KEY_1_RESPONSE), batchEntries);
        Truth.assertThat((Integer)batchEntries.size()).isEqualTo((Object)3);
        Truth.assertThat((Object)batchEntries.get(0).getResultFuture().get()).isNull();
        Truth.assertThat((Object)batchEntries.get(1).getResultFuture().get()).isNull();
        Truth.assertThat((Object)batchEntries.get(2).getResultFuture().get()).isEqualTo((Object)ROW_KEY_1_RESPONSE);
    }

    @Test
    public void splitExceptionTest() {
        RuntimeException expectedException = new RuntimeException("cannot scan the table");
        List<BatchEntry<ByteString, Row>> batchEntries = this.createBatchEntries("row-key-1", "row-key-2");
        this.underTest.splitException((Throwable)expectedException, batchEntries);
        for (BatchEntry<ByteString, Row> resultEntry : batchEntries) {
            try {
                resultEntry.getResultFuture().get();
            }
            catch (Exception actualEx) {
                Truth.assertThat((Throwable)actualEx).hasCauseThat().isEqualTo((Object)expectedException);
            }
        }
    }

    @Test
    public void countBytesTest() {
        ByteString rowKey = ByteString.copyFromUtf8((String)"testRowKey");
        long len = this.underTest.countBytes(rowKey);
        Truth.assertThat((Long)len).isEqualTo((Object)rowKey.size());
    }

    @Test
    public void requestBuilderTest() {
        BatchingRequestBuilder requestBuilder = this.underTest.newRequestBuilder(Query.create((String)"table-Id"));
        requestBuilder.add((Object)ByteString.copyFromUtf8((String)"row-key-1"));
        requestBuilder.add((Object)ByteString.copyFromUtf8((String)"row-key-2"));
        Query request = (Query)requestBuilder.build();
        ReadRowsRequest readRowsRequest = request.toProto(RequestContext.create((String)"project", (String)"instance", (String)"appProfile"));
        Truth.assertThat((String)readRowsRequest.getTableName()).contains((CharSequence)"table-Id");
        Truth.assertThat((Iterable)readRowsRequest.getRows().getRowKeysList()).isEqualTo((Object)ImmutableList.of((Object)ByteString.copyFromUtf8((String)"row-key-1"), (Object)ByteString.copyFromUtf8((String)"row-key-2")));
    }

    private List<BatchEntry<ByteString, Row>> createBatchEntries(String ... rowKeys) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String rowKey : rowKeys) {
            builder.add((Object)BatchEntry.create((Object)ByteString.copyFromUtf8((String)rowKey), (SettableApiFuture)SettableApiFuture.create()));
        }
        return builder.build();
    }
}

