/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.cloud.bigtable.data.v2.stub.readrows.RowMergingCallable;
import com.google.cloud.bigtable.gaxx.testing.FakeStreamingApi;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.StringValue;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RowMergingCallableTest {
    @Test
    public void scanMarker() {
        ReadRowsResponse.Builder rrr = ReadRowsResponse.newBuilder();
        rrr.addChunksBuilder().setRowKey(ByteString.copyFromUtf8((String)"key0")).setFamilyName(StringValue.of((String)"f1")).setQualifier(BytesValue.of((ByteString)ByteString.copyFromUtf8((String)"q1"))).setCommitRow(true);
        FakeStreamingApi.ServerStreamingStashCallable inner = new FakeStreamingApi.ServerStreamingStashCallable(Lists.newArrayList((Object[])new ReadRowsResponse[]{rrr.build(), ReadRowsResponse.newBuilder().setLastScannedRowKey(ByteString.copyFromUtf8((String)"key1")).build()}));
        RowMergingCallable rowMergingCallable = new RowMergingCallable(inner, (RowAdapter)new DefaultRowAdapter());
        List results = (List)rowMergingCallable.all().call((Object)ReadRowsRequest.getDefaultInstance());
        Truth.assertThat((Iterable)results).containsExactly(new Object[]{Row.create((ByteString)ByteString.copyFromUtf8((String)"key0"), (List)Lists.newArrayList((Object[])new RowCell[]{RowCell.create((String)"f1", (ByteString)ByteString.copyFromUtf8((String)"q1"), (long)0L, (List)Lists.newArrayList(), (ByteString)ByteString.EMPTY)})), Row.create((ByteString)ByteString.copyFromUtf8((String)"key1"), (List)Lists.newArrayList())});
    }

    @Test
    public void invalidMarkerInCell() {
        FakeStreamingApi.ServerStreamingStashCallable inner = new FakeStreamingApi.ServerStreamingStashCallable(Lists.newArrayList((Object[])new ReadRowsResponse[]{ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setRowKey(ByteString.copyFromUtf8((String)"key1")).setFamilyName(StringValue.newBuilder().setValue("family")).setQualifier(BytesValue.newBuilder().setValue(ByteString.EMPTY)).setTimestampMicros(1000L).setValue(ByteString.copyFromUtf8((String)"a")).setValueSize(2)).build(), ReadRowsResponse.newBuilder().setLastScannedRowKey(ByteString.copyFromUtf8((String)"key1")).build(), ReadRowsResponse.newBuilder().addChunks(ReadRowsResponse.CellChunk.newBuilder().setValue(ByteString.copyFromUtf8((String)"b")).setValueSize(0).setCommitRow(true)).build()}));
        RowMergingCallable rowMergingCallable = new RowMergingCallable(inner, (RowAdapter)new DefaultRowAdapter());
        Throwable actualError = null;
        try {
            rowMergingCallable.all().call((Object)ReadRowsRequest.getDefaultInstance());
        }
        catch (Throwable t) {
            actualError = t;
        }
        Truth.assertThat((Throwable)actualError).isInstanceOf(IllegalStateException.class);
    }
}

