/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.UnavailableException;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.v2.ResultSetMetadata;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.FakeServiceBuilder;
import com.google.cloud.bigtable.data.v2.internal.ProtoResultSetMetadata;
import com.google.cloud.bigtable.data.v2.internal.ProtoSqlRow;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.sql.Statement;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.data.v2.stub.sql.ExecuteQueryCallContext;
import com.google.cloud.bigtable.data.v2.stub.sql.ExecuteQueryCallable;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlServerStream;
import com.google.cloud.bigtable.gaxx.testing.FakeStreamingApi;
import com.google.common.truth.Truth;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExecuteQueryCallableTest {
    private static final RequestContext REQUEST_CONTEXT = RequestContext.create((String)"fake-project", (String)"fake-instance", (String)"fake-profile");
    private Server server;
    private FakeService fakeService = new FakeService();
    private EnhancedBigtableStub stub;

    @Before
    public void setup() throws IOException {
        this.server = FakeServiceBuilder.create(new BindableService[]{this.fakeService}).start();
        BigtableDataSettings settings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId("fake-project").setInstanceId("fake-instance").build();
        this.stub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)settings.getStubSettings());
    }

    @After
    public void tearDown() {
        this.stub.close();
        this.server.shutdown();
    }

    @Test
    public void testCallContextAndServerStreamSetup() {
        ProtoSqlRow row = ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("test", SqlProtoFactory.stringType())).getMetadata()), Collections.singletonList(SqlProtoFactory.stringValue("foo")));
        FakeStreamingApi.ServerStreamingStashCallable innerCallable = new FakeStreamingApi.ServerStreamingStashCallable(Collections.singletonList(row));
        ExecuteQueryCallable callable = new ExecuteQueryCallable(innerCallable, REQUEST_CONTEXT);
        SqlServerStream stream = callable.call(Statement.of((String)"SELECT * FROM table"));
        Truth.assertThat((Object)stream.metadataFuture()).isEqualTo((Object)((ExecuteQueryCallContext)innerCallable.getActualRequest()).resultSetMetadataFuture());
        Iterator responseIterator = stream.rows().iterator();
        Truth.assertThat(responseIterator.next()).isEqualTo((Object)row);
        Truth.assertThat((Boolean)responseIterator.hasNext()).isFalse();
    }

    @Test
    public void testExecuteQueryRequestsAreNotRetried() {
        SqlServerStream stream = this.stub.executeQueryCallable().call(Statement.of((String)"SELECT * FROM table"));
        Iterator iterator = stream.rows().iterator();
        ((UnavailableException)Assert.assertThrows(UnavailableException.class, iterator::next)).getCause();
        Truth.assertThat((Integer)this.fakeService.attempts).isEqualTo((Object)1);
    }

    @Test
    public void testExecuteQueryRequestsIgnoreOverriddenMaxAttempts() throws IOException {
        BigtableDataSettings.Builder overrideSettings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId("fake-project").setInstanceId("fake-instance");
        overrideSettings.stubSettings().executeQuerySettings().setRetrySettings(RetrySettings.newBuilder().setMaxAttempts(10).build());
        try (EnhancedBigtableStub overrideStub = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)overrideSettings.build().getStubSettings());){
            SqlServerStream stream = overrideStub.executeQueryCallable().call(Statement.of((String)"SELECT * FROM table"));
            Iterator iterator = stream.rows().iterator();
            ((UnavailableException)Assert.assertThrows(UnavailableException.class, iterator::next)).getCause();
            Truth.assertThat((Integer)this.fakeService.attempts).isEqualTo((Object)1);
        }
    }

    @Test
    public void testExecuteQueryRequestsSetDefaultDeadline() {
        SqlServerStream stream = this.stub.executeQueryCallable().call(Statement.of((String)"SELECT * FROM table"));
        Iterator iterator = stream.rows().iterator();
        ((UnavailableException)Assert.assertThrows(UnavailableException.class, iterator::next)).getCause();
        Truth.assertThat((Long)this.fakeService.deadlineMillisRemaining).isLessThan((Comparable)Long.valueOf(30001L));
    }

    @Test
    public void testExecuteQueryRequestsRespectDeadline() throws IOException {
        BigtableDataSettings.Builder overrideSettings = BigtableDataSettings.newBuilderForEmulator((int)this.server.getPort()).setProjectId("fake-project").setInstanceId("fake-instance");
        overrideSettings.stubSettings().executeQuerySettings().setRetrySettings(RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(10L)).setMaxRpcTimeoutDuration(Duration.ofMillis(10L)).build());
        try (EnhancedBigtableStub overrideDeadline = EnhancedBigtableStub.create((EnhancedBigtableStubSettings)overrideSettings.build().getStubSettings());){
            SqlServerStream streamOverride = overrideDeadline.executeQueryCallable().call(Statement.of((String)"SELECT * FROM table"));
            Iterator overrideIterator = streamOverride.rows().iterator();
            ((DeadlineExceededException)Assert.assertThrows(DeadlineExceededException.class, overrideIterator::next)).getCause();
        }
    }

    private static class FakeService
    extends BigtableGrpc.BigtableImplBase {
        private int attempts = 0;
        private long deadlineMillisRemaining;

        private FakeService() {
        }

        public void executeQuery(ExecuteQueryRequest request, StreamObserver<ExecuteQueryResponse> responseObserver) {
            Deadline deadline = Context.current().getDeadline();
            this.deadlineMillisRemaining = deadline != null ? deadline.timeRemaining(TimeUnit.MILLISECONDS) : Long.MAX_VALUE;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            ++this.attempts;
            responseObserver.onNext((Object)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("test", SqlProtoFactory.stringType())));
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE));
        }
    }
}

