/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.bigtable.v2.ColumnMetadata;
import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.v2.ResultSetMetadata;
import com.google.cloud.bigtable.data.v2.internal.ProtoResultSetMetadata;
import com.google.cloud.bigtable.data.v2.stub.sql.ExecuteQueryCallContext;
import com.google.cloud.bigtable.data.v2.stub.sql.MetadataResolvingCallable;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.cloud.bigtable.gaxx.testing.FakeStreamingApi;
import com.google.cloud.bigtable.gaxx.testing.MockStreamingApi;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MetadataResolvingCallableTest {
    private static final ExecuteQueryRequest FAKE_REQUEST = ExecuteQueryRequest.newBuilder().build();
    private static final ExecuteQueryResponse METADATA = SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("foo", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bar", SqlProtoFactory.int64Type()));
    private static final ExecuteQueryResponse DATA = SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("fooVal"), SqlProtoFactory.int64Value(100L));
    MockStreamingApi.MockResponseObserver<ExecuteQueryResponse> outerObserver;
    SettableApiFuture<com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata> metadataFuture;
    MetadataResolvingCallable.MetadataObserver observer;

    @Before
    public void setUp() {
        this.metadataFuture = SettableApiFuture.create();
        this.outerObserver = new MockStreamingApi.MockResponseObserver(true);
        this.observer = new MetadataResolvingCallable.MetadataObserver(this.outerObserver, this.metadataFuture);
    }

    @Test
    public void observer_parsesMetadataSetsFutureAndPassesThroughResponses() throws ExecutionException, InterruptedException {
        FakeStreamingApi.ServerStreamingStashCallable innerCallable = new FakeStreamingApi.ServerStreamingStashCallable(Arrays.asList(METADATA, DATA));
        innerCallable.call(FAKE_REQUEST, (ResponseObserver)this.observer);
        Truth.assertThat((Boolean)this.metadataFuture.isDone()).isTrue();
        Truth.assertThat((Object)this.metadataFuture.get()).isEqualTo((Object)ProtoResultSetMetadata.fromProto((ResultSetMetadata)METADATA.getMetadata()));
        Truth.assertThat((Object)this.outerObserver.popNextResponse()).isEqualTo((Object)METADATA);
        Truth.assertThat((Object)this.outerObserver.popNextResponse()).isEqualTo((Object)DATA);
        Truth.assertThat((Boolean)this.outerObserver.isDone()).isTrue();
        Truth.assertThat((Throwable)this.outerObserver.getFinalError()).isNull();
    }

    @Test
    public void observer_invalidMetadataFailsFutureAndPassesThroughError() {
        ExecuteQueryResponse invalidMetadataResponse = SqlProtoFactory.metadata(new ColumnMetadata[0]);
        FakeStreamingApi.ServerStreamingStashCallable innerCallable = new FakeStreamingApi.ServerStreamingStashCallable(Arrays.asList(invalidMetadataResponse, DATA));
        innerCallable.call(FAKE_REQUEST, (ResponseObserver)this.observer);
        Truth.assertThat((Boolean)this.metadataFuture.isDone()).isTrue();
        Assert.assertThrows(ExecutionException.class, () -> this.metadataFuture.get());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> this.metadataFuture.get());
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(IllegalStateException.class);
        Truth.assertThat((Boolean)this.outerObserver.isDone()).isTrue();
        Truth.assertThat((Throwable)this.outerObserver.getFinalError()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void observer_invalidFirstResponseFailsFutureAndPassesThroughError() {
        FakeStreamingApi.ServerStreamingStashCallable innerCallable = new FakeStreamingApi.ServerStreamingStashCallable(Collections.singletonList(DATA));
        innerCallable.call(FAKE_REQUEST, (ResponseObserver)this.observer);
        Truth.assertThat((Boolean)this.metadataFuture.isDone()).isTrue();
        Assert.assertThrows(ExecutionException.class, () -> this.metadataFuture.get());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> this.metadataFuture.get());
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(IllegalStateException.class);
        Truth.assertThat((Boolean)this.outerObserver.isDone()).isTrue();
        Truth.assertThat((Throwable)this.outerObserver.getFinalError()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void observer_passesThroughErrorBeforeReceivingMetadata() {
        MockStreamingApi.MockServerStreamingCallable innerCallable = new MockStreamingApi.MockServerStreamingCallable();
        innerCallable.call(FAKE_REQUEST, (ResponseObserver)this.observer);
        MockStreamingApi.MockServerStreamingCall lastCall = innerCallable.popLastCall();
        MockStreamingApi.MockStreamController innerController = lastCall.getController();
        innerController.getObserver().onError((Throwable)new CancellationException("Cancelled"));
        Truth.assertThat((Boolean)this.metadataFuture.isDone()).isTrue();
        Assert.assertThrows(ExecutionException.class, () -> this.metadataFuture.get());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> this.metadataFuture.get());
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(CancellationException.class);
        Truth.assertThat((Boolean)this.outerObserver.isDone()).isTrue();
        Truth.assertThat((Throwable)this.outerObserver.getFinalError()).isInstanceOf(CancellationException.class);
    }

    @Test
    public void observer_passesThroughErrorAfterReceivingMetadata() throws ExecutionException, InterruptedException {
        MockStreamingApi.MockServerStreamingCallable innerCallable = new MockStreamingApi.MockServerStreamingCallable();
        innerCallable.call(FAKE_REQUEST, (ResponseObserver)this.observer);
        MockStreamingApi.MockServerStreamingCall lastCall = innerCallable.popLastCall();
        MockStreamingApi.MockStreamController innerController = lastCall.getController();
        innerController.getObserver().onResponse((Object)METADATA);
        innerController.getObserver().onError((Throwable)new RuntimeException("exception after metadata"));
        Truth.assertThat((Boolean)this.metadataFuture.isDone()).isTrue();
        Truth.assertThat((Object)this.metadataFuture.get()).isEqualTo((Object)ProtoResultSetMetadata.fromProto((ResultSetMetadata)METADATA.getMetadata()));
        Truth.assertThat((Object)this.outerObserver.popNextResponse()).isEqualTo((Object)METADATA);
        Truth.assertThat((Boolean)this.outerObserver.isDone()).isTrue();
        Truth.assertThat((Throwable)this.outerObserver.getFinalError()).isInstanceOf(RuntimeException.class);
    }

    @Test
    public void observer_passThroughOnStart() {
        MockStreamingApi.MockServerStreamingCallable innerCallable = new MockStreamingApi.MockServerStreamingCallable();
        innerCallable.call(FAKE_REQUEST, (ResponseObserver)this.observer);
        MockStreamingApi.MockServerStreamingCall lastCall = innerCallable.popLastCall();
        MockStreamingApi.MockStreamController innerController = lastCall.getController();
        Truth.assertThat((Object)this.outerObserver.getController()).isEqualTo(innerController);
    }

    @Test
    public void observer_onCompleteBeforeMetadata_throwsException() throws InterruptedException {
        MockStreamingApi.MockServerStreamingCallable innerCallable = new MockStreamingApi.MockServerStreamingCallable();
        innerCallable.call(FAKE_REQUEST, (ResponseObserver)this.observer);
        MockStreamingApi.MockServerStreamingCall lastCall = innerCallable.popLastCall();
        MockStreamingApi.MockStreamController innerController = lastCall.getController();
        innerController.getObserver().onComplete();
        Assert.assertThrows(ExecutionException.class, () -> this.metadataFuture.get());
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> this.metadataFuture.get());
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(IllegalStateException.class);
        Truth.assertThat((Boolean)this.outerObserver.isDone()).isTrue();
        Truth.assertThat((Throwable)this.outerObserver.getFinalError()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    public void testCallable() throws ExecutionException, InterruptedException {
        FakeStreamingApi.ServerStreamingStashCallable innerCallable = new FakeStreamingApi.ServerStreamingStashCallable(Arrays.asList(METADATA, DATA));
        MetadataResolvingCallable callable = new MetadataResolvingCallable(innerCallable);
        MockStreamingApi.MockResponseObserver outerObserver = new MockStreamingApi.MockResponseObserver(true);
        SettableApiFuture metadataFuture = SettableApiFuture.create();
        ExecuteQueryCallContext callContext = ExecuteQueryCallContext.create((ExecuteQueryRequest)FAKE_REQUEST, (SettableApiFuture)metadataFuture);
        callable.call((Object)callContext, outerObserver);
        Truth.assertThat((Boolean)metadataFuture.isDone()).isTrue();
        Truth.assertThat((Object)metadataFuture.get()).isEqualTo((Object)ProtoResultSetMetadata.fromProto((ResultSetMetadata)METADATA.getMetadata()));
        Truth.assertThat(outerObserver.popNextResponse()).isEqualTo((Object)METADATA);
        Truth.assertThat(outerObserver.popNextResponse()).isEqualTo((Object)DATA);
        Truth.assertThat((Boolean)outerObserver.isDone()).isTrue();
        Truth.assertThat((Throwable)outerObserver.getFinalError()).isNull();
    }
}

