/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.bigtable.v2.PartialResultSet;
import com.google.bigtable.v2.ProtoRows;
import com.google.bigtable.v2.ProtoRowsBatch;
import com.google.bigtable.v2.ResultSetMetadata;
import com.google.bigtable.v2.Type;
import com.google.bigtable.v2.Value;
import com.google.cloud.bigtable.data.v2.internal.ProtoResultSetMetadata;
import com.google.cloud.bigtable.data.v2.internal.ProtoSqlRow;
import com.google.cloud.bigtable.data.v2.internal.SqlRow;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.cloud.bigtable.data.v2.stub.sql.ProtoRowsMergingStateMachine;
import com.google.cloud.bigtable.data.v2.stub.sql.ProtoRowsMergingStateMachineSubject;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.util.ArrayDeque;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public final class ProtoRowsMergingStateMachineTest {

    @RunWith(value=Parameterized.class)
    public static final class ParameterizedTests {
        private final SqlType.Code typeCase;

        public ParameterizedTests(SqlType.Code typeCode) {
            this.typeCase = typeCode;
        }

        @Parameterized.Parameters
        public static SqlType.Code[] valueTypes() {
            return SqlType.Code.values();
        }

        @Test
        public void testValidateSupportsAllTypes() {
            switch (this.typeCase) {
                case STRING: {
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.string(), (Value)SqlProtoFactory.bytesValue("test")));
                    break;
                }
                case BYTES: {
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.bytes(), (Value)SqlProtoFactory.stringValue("test")));
                    break;
                }
                case INT64: {
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.int64(), (Value)SqlProtoFactory.stringValue("test")));
                    break;
                }
                case BOOL: {
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.bool(), (Value)SqlProtoFactory.stringValue("test")));
                    break;
                }
                case FLOAT32: {
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.float32(), (Value)SqlProtoFactory.stringValue("test")));
                    break;
                }
                case FLOAT64: {
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.float64(), (Value)SqlProtoFactory.stringValue("test")));
                    break;
                }
                case TIMESTAMP: {
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.timestamp(), (Value)SqlProtoFactory.stringValue("test")));
                    break;
                }
                case DATE: {
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.date(), (Value)SqlProtoFactory.stringValue("test")));
                    break;
                }
                case ARRAY: {
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.arrayOf((SqlType)SqlType.string()), (Value)SqlProtoFactory.stringValue("test")));
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.arrayOf((SqlType)SqlType.string()), (Value)SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("test"), SqlProtoFactory.bytesValue("test"))));
                    break;
                }
                case STRUCT: {
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.stringType(), SqlProtoFactory.bytesType())), (Value)SqlProtoFactory.stringValue("test")));
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.fromProto((Type)SqlProtoFactory.structType(SqlProtoFactory.stringType(), SqlProtoFactory.bytesType())), (Value)SqlProtoFactory.structValue(SqlProtoFactory.stringValue("test"), SqlProtoFactory.stringValue("test"))));
                    break;
                }
                case MAP: {
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.mapOf((SqlType)SqlType.string(), (SqlType)SqlType.string()), (Value)SqlProtoFactory.stringValue("test")));
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.mapOf((SqlType)SqlType.string(), (SqlType)SqlType.bytes()), (Value)SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key"), SqlProtoFactory.bytesValue("val")), SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key2"), SqlProtoFactory.stringValue("val2")))));
                    Assert.assertThrows(IllegalStateException.class, () -> ProtoRowsMergingStateMachine.validateValueAndType((SqlType)SqlType.mapOf((SqlType)SqlType.string(), (SqlType)SqlType.bytes()), (Value)SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key"), SqlProtoFactory.bytesValue("val")), SqlProtoFactory.structValue(SqlProtoFactory.stringValue("key2"), SqlProtoFactory.bytesValue("val2"), SqlProtoFactory.bytesValue("val3")))));
                    break;
                }
                default: {
                    Truth.assertWithMessage((String)("Unknown TypeCase " + this.typeCase.name() + " seen. Check if SerializedProtoRowsMergingStateMachine.validateValueAndType supports all types.")).fail();
                }
            }
        }
    }

    public static final class IndividualTests {
        @Test
        public void stateMachine_hasCompleteBatch_falseWhenEmpty() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).hasCompleteBatch(false);
        }

        @Test
        public void stateMachine_hasCompleteBatch_falseWhenAwaitingPartialBatch() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("foo")).getResults());
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).hasCompleteBatch(false);
        }

        @Test
        public void stateMachine_hasCompleteBatch_trueWhenAwaitingBatchConsume() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("foo")).getResults());
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("bar")).getResults());
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).hasCompleteBatch(true);
        }

        @Test
        public void stateMachine_isBatchInProgress_falseWhenEmpty() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).isBatchInProgress(false);
        }

        @Test
        public void stateMachine_isBatchInProgress_trueWhenAwaitingPartialBatch() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("foo")).getResults());
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).isBatchInProgress(true);
        }

        @Test
        public void stateMachine_isBatchInProgress_trueWhenAwaitingBatchConsume() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("foo")).getResults());
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).isBatchInProgress(true);
        }

        @Test
        public void stateMachine_consumeRow_throwsExceptionWhenColumnsArentComplete() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("b", SqlProtoFactory.stringType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("foo")).getResults());
            Assert.assertThrows(IllegalStateException.class, () -> stateMachine.populateQueue(new ArrayDeque()));
        }

        @Test
        public void stateMachine_consumeRow_throwsExceptionWhenAwaitingPartialBatch() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("foo")).getResults());
            Assert.assertThrows(IllegalStateException.class, () -> stateMachine.populateQueue(new ArrayDeque()));
        }

        @Test
        public void stateMachine_mergesPartialBatches() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("foo")).getResults());
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("bar")).getResults());
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("baz")).getResults());
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).populateQueueYields(new SqlRow[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("foo"))), ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("bar"))), ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("baz")))});
        }

        @Test
        public void stateMachine_mergesPartialBatches_withRandomChunks() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("map", SqlProtoFactory.mapType(SqlProtoFactory.stringType(), SqlProtoFactory.bytesType()))).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            Value mapVal = SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue(Strings.repeat((String)"a", (int)10)), SqlProtoFactory.bytesValue(Strings.repeat((String)"aVal", (int)100))), SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("b"), SqlProtoFactory.bytesValue(Strings.repeat((String)"bVal", (int)100))));
            ProtoRows rows = ProtoRows.newBuilder().addValues(mapVal).build();
            ByteString chunk1 = rows.toByteString().substring(0, 100);
            ByteString chunk2 = rows.toByteString().substring(100);
            stateMachine.addPartialResultSet(PartialResultSet.newBuilder().setProtoRowsBatch(ProtoRowsBatch.newBuilder().setBatchData(chunk1).build()).build());
            stateMachine.addPartialResultSet(PartialResultSet.newBuilder().setResumeToken(ByteString.copyFromUtf8((String)"token")).setProtoRowsBatch(ProtoRowsBatch.newBuilder().setBatchData(chunk2).build()).build());
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).populateQueueYields(new SqlRow[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)mapVal))});
        }

        @Test
        public void stateMachine_reconstructsRowWithMultipleColumns() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("b", SqlProtoFactory.bytesType()), SqlProtoFactory.columnMetadata("c", SqlProtoFactory.arrayType(SqlProtoFactory.stringType())), SqlProtoFactory.columnMetadata("d", SqlProtoFactory.mapType(SqlProtoFactory.stringType(), SqlProtoFactory.bytesType()))).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            Value stringVal = SqlProtoFactory.stringValue("test");
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithoutToken(stringVal).getResults());
            Value bytesVal = SqlProtoFactory.bytesValue("bytes");
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithoutToken(bytesVal).getResults());
            Value arrayVal = SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar"));
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithoutToken(arrayVal).getResults());
            Value mapVal = SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("a"), SqlProtoFactory.bytesValue("aVal")), SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("b"), SqlProtoFactory.bytesValue("bVal")));
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithToken(mapVal).getResults());
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).hasCompleteBatch(true);
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).populateQueueYields(new SqlRow[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)stringVal, (Object)bytesVal, (Object)arrayVal, (Object)mapVal))});
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).hasCompleteBatch(false);
            Assert.assertThrows(IllegalStateException.class, () -> stateMachine.populateQueue(new ArrayDeque()));
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).isBatchInProgress(false);
        }

        @Test
        public void stateMachine_throwsExceptionWhenValuesDontMatchSchema() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("b", SqlProtoFactory.bytesType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.bytesValue("test"), SqlProtoFactory.stringValue("test")).getResults());
            Assert.assertThrows(IllegalStateException.class, () -> stateMachine.populateQueue(new ArrayDeque()));
        }

        @Test
        public void stateMachine_handlesResumeTokenWithNoValues() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithToken(new Value[0]).getResults());
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).populateQueueYields((SqlRow[])new ProtoSqlRow[0]);
        }

        @Test
        public void stateMachine_handlesResumeTokenWithOpenBatch() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("test")).getResults());
            stateMachine.addPartialResultSet(SqlProtoFactory.tokenOnlyResultSet(ByteString.copyFromUtf8((String)"token")).getResults());
            ProtoRowsMergingStateMachineSubject.assertThat(stateMachine).populateQueueYields(new SqlRow[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("test")))});
        }

        @Test
        public void addPartialResultSet_throwsExceptionWhenAwaitingRowConsume() {
            com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("a", SqlProtoFactory.stringType())).getMetadata());
            ProtoRowsMergingStateMachine stateMachine = new ProtoRowsMergingStateMachine(metadata);
            stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("test")).getResults());
            Assert.assertThrows(IllegalStateException.class, () -> stateMachine.addPartialResultSet(SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("test2")).getResults()));
        }
    }
}

