/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.v2.PartialResultSet;
import com.google.bigtable.v2.ProtoRows;
import com.google.bigtable.v2.Value;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class SqlProtoFactoryTest {
    @Test
    public void serializedProtoRows_canRoundTrip() throws InvalidProtocolBufferException {
        ExecuteQueryResponse response = SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("string"), SqlProtoFactory.bytesValue("bytes"));
        PartialResultSet results = response.getResults();
        Truth.assertThat((Iterable)results.getResumeToken()).isEqualTo((Object)ByteString.copyFromUtf8((String)"test"));
        ProtoRows protoRows = ProtoRows.parseFrom((ByteString)results.getProtoRowsBatch().getBatchData());
        Truth.assertThat((Integer)protoRows.getValuesCount()).isEqualTo((Object)2);
        Truth.assertThat((String)((Value)protoRows.getValuesList().get(0)).getStringValue()).isEqualTo((Object)"string");
        Truth.assertThat((Iterable)((Value)protoRows.getValuesList().get(1)).getBytesValue()).isEqualTo((Object)ByteString.copyFromUtf8((String)"bytes"));
    }
}

