/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.bigtable.v2.ColumnMetadata;
import com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.v2.ResultSetMetadata;
import com.google.bigtable.v2.Value;
import com.google.cloud.bigtable.data.v2.internal.ProtoResultSetMetadata;
import com.google.cloud.bigtable.data.v2.internal.ProtoSqlRow;
import com.google.cloud.bigtable.data.v2.internal.SqlRowSubject;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlRowMerger;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlRowMergerSubject;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SqlRowMergerTest {
    @Test
    public void sqlRowMerger_handlesEmptyState() {
        SqlRowMerger merger = new SqlRowMerger();
        SqlRowMergerSubject.assertThat(merger).hasPartialFrame(false);
        SqlRowMergerSubject.assertThat(merger).hasFullFrame(false);
    }

    @Test
    public void sqlRowMerger_handlesMetadata() {
        SqlRowMerger merger = new SqlRowMerger();
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType()), SqlProtoFactory.columnMetadata("strArr", SqlProtoFactory.arrayType(SqlProtoFactory.stringType())), SqlProtoFactory.columnMetadata("strByteMap", SqlProtoFactory.mapType(SqlProtoFactory.stringType(), SqlProtoFactory.bytesType()))};
        merger.push(SqlProtoFactory.metadata(columns));
        SqlRowMergerSubject.assertThat(merger).hasPartialFrame(false);
        SqlRowMergerSubject.assertThat(merger).hasFullFrame(false);
    }

    @Test
    public void sqlRowMerger_rejectsMetadataOfUnrecognizedType() {
        SqlRowMerger merger = new SqlRowMerger();
        ExecuteQueryResponse unrecognizedMetadata = ExecuteQueryResponse.newBuilder().setMetadata(ResultSetMetadata.newBuilder().build()).build();
        Assert.assertThrows(IllegalStateException.class, () -> merger.push(unrecognizedMetadata));
    }

    @Test
    public void hasPartialFrame_trueWithIncompleteBatch() {
        SqlRowMerger merger = new SqlRowMerger();
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType())};
        merger.push(SqlProtoFactory.metadata(columns));
        merger.push(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("test")));
        SqlRowMergerSubject.assertThat(merger).hasPartialFrame(true);
    }

    @Test
    public void hasPartialFrame_trueWithFullRow() {
        SqlRowMerger merger = new SqlRowMerger();
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType())};
        merger.push(SqlProtoFactory.metadata(columns));
        merger.push(SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("test"), SqlProtoFactory.bytesValue("test")));
        SqlRowMergerSubject.assertThat(merger).hasPartialFrame(true);
    }

    @Test
    public void push_failsOnCompleteBatchWithIncompleteRow() {
        SqlRowMerger merger = new SqlRowMerger();
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType())};
        merger.push(SqlProtoFactory.metadata(columns));
        Assert.assertThrows(IllegalStateException.class, () -> merger.push(SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("test"))));
    }

    @Test
    public void hasFullFrame_trueWithFullRow() {
        SqlRowMerger merger = new SqlRowMerger();
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType())};
        merger.push(SqlProtoFactory.metadata(columns));
        merger.push(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("test")));
        merger.push(SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.bytesValue("test")));
        SqlRowMergerSubject.assertThat(merger).hasFullFrame(true);
    }

    @Test
    public void hasFullFrame_falseWithIncompleteBatch() {
        SqlRowMerger merger = new SqlRowMerger();
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType())};
        merger.push(SqlProtoFactory.metadata(columns));
        merger.push(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("test")));
        SqlRowMergerSubject.assertThat(merger).hasFullFrame(false);
    }

    @Test
    public void sqlRowMerger_handlesResponseStream() {
        SqlRowMerger merger = new SqlRowMerger();
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType()), SqlProtoFactory.columnMetadata("strArr", SqlProtoFactory.arrayType(SqlProtoFactory.stringType())), SqlProtoFactory.columnMetadata("strByteMap", SqlProtoFactory.mapType(SqlProtoFactory.stringType(), SqlProtoFactory.bytesType()))};
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(columns).getMetadata());
        merger.push(SqlProtoFactory.metadata(columns));
        Value[] values = new Value[]{SqlProtoFactory.stringValue("test"), SqlProtoFactory.bytesValue("bytes"), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar")), SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key"), SqlProtoFactory.bytesValue("bytes"))), SqlProtoFactory.stringValue("test2"), SqlProtoFactory.bytesValue("bytes2"), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo2"), SqlProtoFactory.stringValue("bar2")), SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key2"), SqlProtoFactory.bytesValue("bytes2"))), SqlProtoFactory.stringValue("test3"), SqlProtoFactory.bytesValue("bytes3"), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo3"), SqlProtoFactory.stringValue("bar3")), SqlProtoFactory.mapValue(SqlProtoFactory.mapElement(SqlProtoFactory.stringValue("key3"), SqlProtoFactory.bytesValue("bytes3")))};
        merger.push(SqlProtoFactory.partialResultSetWithoutToken(Arrays.copyOf(values, 5)));
        merger.push(SqlProtoFactory.partialResultSetWithToken(Arrays.copyOfRange(values, 5, 12)));
        SqlRowSubject.assertThat(merger.pop()).isEqualTo(ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.copyOf((Object[])Arrays.copyOf(values, 4))));
        SqlRowSubject.assertThat(merger.pop()).isEqualTo(ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.copyOf((Object[])Arrays.copyOfRange(values, 4, 8))));
        SqlRowSubject.assertThat(merger.pop()).isEqualTo(ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.copyOf((Object[])Arrays.copyOfRange(values, 8, 12))));
    }

    @Test
    public void addValue_failsWithoutMetadataFirst() {
        SqlRowMerger merger = new SqlRowMerger();
        Assert.assertThrows(IllegalStateException.class, () -> merger.push(SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("test"))));
    }

    @Test
    public void sqlRowMerger_handlesTokenWithOpenPartialBatch() {
        SqlRowMerger merger = new SqlRowMerger();
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType())};
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(columns).getMetadata());
        merger.push(SqlProtoFactory.metadata(columns));
        merger.push(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("test")));
        merger.push(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.bytesValue("test")));
        merger.push(SqlProtoFactory.tokenOnlyResultSet(ByteString.copyFromUtf8((String)"token")));
        SqlRowMergerSubject.assertThat(merger).hasPartialFrame(true);
        SqlRowMergerSubject.assertThat(merger).hasFullFrame(true);
        SqlRowSubject.assertThat(merger.pop()).isEqualTo(ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("test"), (Object)SqlProtoFactory.bytesValue("test"))));
    }

    @Test
    public void sqlRowMerger_handlesTokensWithNoData() {
        SqlRowMerger merger = new SqlRowMerger();
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType())};
        merger.push(SqlProtoFactory.metadata(columns));
        merger.push(SqlProtoFactory.tokenOnlyResultSet(ByteString.copyFromUtf8((String)"token1")));
        merger.push(SqlProtoFactory.tokenOnlyResultSet(ByteString.copyFromUtf8((String)"token2")));
        merger.push(SqlProtoFactory.tokenOnlyResultSet(ByteString.copyFromUtf8((String)"token3")));
        SqlRowMergerSubject.assertThat(merger).hasPartialFrame(false);
        SqlRowMergerSubject.assertThat(merger).hasFullFrame(false);
    }

    @Test
    public void sqlRowMerger_handlesLeadingTokens() {
        SqlRowMerger merger = new SqlRowMerger();
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("bytes", SqlProtoFactory.bytesType())};
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)SqlProtoFactory.metadata(columns).getMetadata());
        merger.push(SqlProtoFactory.metadata(columns));
        merger.push(SqlProtoFactory.tokenOnlyResultSet(ByteString.copyFromUtf8((String)"token1")));
        merger.push(SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("test")));
        merger.push(SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.bytesValue("test")));
        SqlRowMergerSubject.assertThat(merger).hasPartialFrame(true);
        SqlRowMergerSubject.assertThat(merger).hasFullFrame(true);
        SqlRowSubject.assertThat(merger.pop()).isEqualTo(ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, (List)ImmutableList.of((Object)SqlProtoFactory.stringValue("test"), (Object)SqlProtoFactory.bytesValue("test"))));
    }

    @Test
    public void addValue_failsOnDuplicateMetadata() {
        SqlRowMerger merger = new SqlRowMerger();
        ColumnMetadata[] columns = new ColumnMetadata[]{SqlProtoFactory.columnMetadata("str", SqlProtoFactory.stringType())};
        merger.push(SqlProtoFactory.metadata(columns));
        merger.push(SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("test")));
        Assert.assertThrows(IllegalStateException.class, () -> merger.push(SqlProtoFactory.metadata(columns)));
    }

    @Test
    public void pop_failsWhenQueueIsEmpty() {
        SqlRowMerger merger = new SqlRowMerger();
        Assert.assertThrows(NullPointerException.class, () -> ((SqlRowMerger)merger).pop());
    }
}

