/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.sql;

import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ServerStream;
import com.google.bigtable.v2.ColumnMetadata;
import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.bigtable.v2.ExecuteQueryResponse;
import com.google.bigtable.v2.ResultSetMetadata;
import com.google.bigtable.v2.Value;
import com.google.cloud.bigtable.data.v2.internal.ProtoResultSetMetadata;
import com.google.cloud.bigtable.data.v2.internal.ProtoSqlRow;
import com.google.cloud.bigtable.data.v2.stub.sql.ExecuteQueryCallContext;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlProtoFactory;
import com.google.cloud.bigtable.data.v2.stub.sql.SqlRowMergingCallable;
import com.google.cloud.bigtable.gaxx.testing.FakeStreamingApi;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SqlRowMergingCallableTest {
    @Test
    public void testMerging() {
        ExecuteQueryResponse metadataResponse = SqlProtoFactory.metadata(SqlProtoFactory.columnMetadata("stringCol", SqlProtoFactory.stringType()), SqlProtoFactory.columnMetadata("intCol", SqlProtoFactory.int64Type()), SqlProtoFactory.columnMetadata("arrayCol", SqlProtoFactory.arrayType(SqlProtoFactory.stringType())));
        FakeStreamingApi.ServerStreamingStashCallable inner = new FakeStreamingApi.ServerStreamingStashCallable(Lists.newArrayList((Object[])new ExecuteQueryResponse[]{metadataResponse, SqlProtoFactory.partialResultSetWithoutToken(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.int64Value(1L), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar"))), SqlProtoFactory.partialResultSetWithToken(SqlProtoFactory.stringValue("test"), SqlProtoFactory.int64Value(10L), SqlProtoFactory.arrayValue(new Value[0]))}));
        SqlRowMergingCallable rowMergingCallable = new SqlRowMergingCallable(inner);
        ServerStream results = rowMergingCallable.call((Object)ExecuteQueryCallContext.create((ExecuteQueryRequest)ExecuteQueryRequest.getDefaultInstance(), (SettableApiFuture)SettableApiFuture.create()));
        List resultsList = results.stream().collect(Collectors.toList());
        com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata metadata = ProtoResultSetMetadata.fromProto((ResultSetMetadata)metadataResponse.getMetadata());
        Truth.assertThat(resultsList).containsExactly(new Object[]{ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Arrays.asList(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.int64Value(1L), SqlProtoFactory.arrayValue(SqlProtoFactory.stringValue("foo"), SqlProtoFactory.stringValue("bar")))), ProtoSqlRow.create((com.google.cloud.bigtable.data.v2.models.sql.ResultSetMetadata)metadata, Arrays.asList(SqlProtoFactory.stringValue("test"), SqlProtoFactory.int64Value(10L), SqlProtoFactory.arrayValue(new Value[0])))});
    }

    @Test
    public void testError() {
        FakeStreamingApi.ServerStreamingStashCallable inner = new FakeStreamingApi.ServerStreamingStashCallable(Lists.newArrayList((Object[])new ExecuteQueryResponse[]{SqlProtoFactory.metadata(new ColumnMetadata[0])}));
        SqlRowMergingCallable rowMergingCallable = new SqlRowMergingCallable(inner);
        ServerStream results = rowMergingCallable.call((Object)ExecuteQueryCallContext.create((ExecuteQueryRequest)ExecuteQueryRequest.getDefaultInstance(), (SettableApiFuture)SettableApiFuture.create()));
        Assert.assertThrows(IllegalStateException.class, () -> results.iterator().next());
    }
}

