/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.misc_utilities;

import com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.cloud.bigtable.admin.v2.models.CreateAuthorizedViewRequest;
import com.google.cloud.bigtable.admin.v2.models.FamilySubsets;
import com.google.cloud.bigtable.admin.v2.models.SubsetView;
import com.google.cloud.bigtable.test_helpers.env.TestEnvRule;
import java.util.UUID;

public class AuthorizedViewTestHelper {
    public static String AUTHORIZED_VIEW_ROW_PREFIX = "row#";
    public static String AUTHORIZED_VIEW_COLUMN_QUALIFIER = "qualifier";

    public static AuthorizedView createTestAuthorizedView(TestEnvRule testEnvRule) {
        String tableId = testEnvRule.env().getTableId();
        String authorizedViewId = UUID.randomUUID().toString();
        CreateAuthorizedViewRequest request = CreateAuthorizedViewRequest.of((String)tableId, (String)authorizedViewId).setAuthorizedViewType((AuthorizedView.AuthorizedViewType)SubsetView.create().addRowPrefix(AUTHORIZED_VIEW_ROW_PREFIX).setFamilySubsets(testEnvRule.env().getFamilyId(), FamilySubsets.create().addQualifierPrefix(AUTHORIZED_VIEW_COLUMN_QUALIFIER))).setDeletionProtection(false);
        return testEnvRule.env().getTableAdminClient().createAuthorizedView(request);
    }
}

