/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.misc_utilities;

import com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.alts.ComputeEngineChannelBuilder;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SimpleGceRawRead {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        SimpleGceRawRead.configureLogging();
        String projectId = System.getProperty("bigtable.project", "gcloud-devel");
        String instanceId = System.getProperty("bigtable.instance", "google-cloud-bigtable");
        String tableId = System.getProperty("bigtable.table", "integration-tests");
        String endpoint = System.getProperty("bigtable.data-endpoint", "bigtable.googleapis.com");
        String tableName = String.format("projects/%s/instances/%s/tables/%s", projectId, instanceId, tableId);
        System.out.printf(">>>>>>>>> Trying to connect to: %s, to read %s%n%n%n", endpoint, tableName);
        ManagedChannel channel = ((ComputeEngineChannelBuilder)((ComputeEngineChannelBuilder)ComputeEngineChannelBuilder.forAddress((String)endpoint, (int)443).disableServiceConfigLookUp()).defaultServiceConfig(SimpleGceRawRead.newServiceConfig())).build();
        try {
            BigtableGrpc.BigtableBlockingStub stub = BigtableGrpc.newBlockingStub((Channel)channel);
            Iterator iter = stub.readRows(ReadRowsRequest.newBuilder().setTableName(tableName).setRowsLimit(1L).build());
            System.out.printf("%n%n>>>>>>>>> Success Rows Read: %d%n%n", Lists.newArrayList((Iterator)iter).size());
        }
        finally {
            channel.shutdown();
        }
    }

    private static void configureLogging() {
        Logger.getLogger("io.grpc").setLevel(Level.ALL);
        Logger.getLogger("io.grpc.netty.shaded").setLevel(Level.ALL);
        ConsoleHandler stderr = new ConsoleHandler();
        stderr.setLevel(Level.ALL);
        Logger.getLogger("").addHandler(stderr);
    }

    private static Map<String, Object> newServiceConfig() {
        ImmutableMap pickFirstStrategy = ImmutableMap.of((Object)"pick_first", (Object)ImmutableMap.of());
        ImmutableMap childPolicy = ImmutableMap.of((Object)"childPolicy", (Object)ImmutableList.of((Object)pickFirstStrategy));
        ImmutableMap grpcLbPolicy = ImmutableMap.of((Object)"grpclb", (Object)childPolicy);
        return ImmutableMap.of((Object)"loadBalancingConfig", (Object)ImmutableList.of((Object)grpcLbPolicy));
    }
}

