/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.test_helpers.env;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.test_helpers.env.AbstractTestEnv;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Grpc;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class CloudEnv
extends AbstractTestEnv {
    private static final Predicate<InetSocketAddress> DIRECT_PATH_IPV6_MATCHER = new Predicate<InetSocketAddress>(){

        public boolean apply(InetSocketAddress input) {
            return input.toString().startsWith("2001:4860:8040");
        }
    };
    private static final Predicate<InetSocketAddress> DIRECT_PATH_IPV4_MATCHER = new Predicate<InetSocketAddress>(){

        public boolean apply(InetSocketAddress input) {
            return input.toString().startsWith("34.126");
        }
    };
    private static final String DATA_ENDPOINT_PROPERTY_NAME = "bigtable.data-endpoint";
    private static final String ADMIN_ENDPOINT_PROPERTY_NAME = "bigtable.admin-endpoint";
    private static final String PROJECT_PROPERTY_NAME = "bigtable.project";
    private static final String INSTANCE_PROPERTY_NAME = "bigtable.instance";
    private static final String APP_PROFILE_PROPERTY_NAME = "bigtable.app_profile";
    private static final String TABLE_PROPERTY_NAME = "bigtable.table";
    private static final String CMEK_KMS_KEY_PROPERTY_NAME = "bigtable.kms_key_name";
    private static final String TRACING_COOKIE_PROPERTY_NAME = "bigtable.tracing_cookie";
    private final String projectId;
    private final String instanceId;
    private final String tableId;
    private final String kmsKeyName;
    private final BigtableDataSettings.Builder dataSettings;
    private final BigtableTableAdminSettings.Builder tableAdminSettings;
    private final BigtableInstanceAdminSettings.Builder instanceAdminSettings;
    @Nullable
    private final String appProfileId;
    private BigtableDataClient dataClient;
    private BigtableTableAdminClient tableAdminClient;
    private BigtableInstanceAdminClient instanceAdminClient;

    static CloudEnv fromSystemProperties() {
        return new CloudEnv(CloudEnv.getOptionalProperty(DATA_ENDPOINT_PROPERTY_NAME, ""), CloudEnv.getOptionalProperty(ADMIN_ENDPOINT_PROPERTY_NAME, ""), CloudEnv.getOptionalProperty(CMEK_KMS_KEY_PROPERTY_NAME, ""), CloudEnv.getRequiredProperty(PROJECT_PROPERTY_NAME), CloudEnv.getRequiredProperty(INSTANCE_PROPERTY_NAME), CloudEnv.getOptionalProperty(APP_PROFILE_PROPERTY_NAME), CloudEnv.getRequiredProperty(TABLE_PROPERTY_NAME), CloudEnv.getOptionalProperty(TRACING_COOKIE_PROPERTY_NAME));
    }

    private CloudEnv(@Nullable String dataEndpoint, @Nullable String adminEndpoint, @Nullable String kmsKeyName, String projectId, String instanceId, @Nullable String appProfileId, String tableId, @Nullable String tracingCookie) {
        this.projectId = projectId;
        this.instanceId = instanceId;
        this.appProfileId = appProfileId;
        this.tableId = tableId;
        this.kmsKeyName = kmsKeyName;
        this.dataSettings = BigtableDataSettings.newBuilder().setProjectId(projectId).setInstanceId(instanceId);
        if (!Strings.isNullOrEmpty((String)dataEndpoint)) {
            this.dataSettings.stubSettings().setEndpoint(dataEndpoint);
        }
        if (!Strings.isNullOrEmpty((String)appProfileId)) {
            this.dataSettings.setAppProfileId(appProfileId);
        }
        this.configureConnection((StubSettings.Builder)this.dataSettings.stubSettings());
        this.configureUserAgent(this.dataSettings.stubSettings());
        if (tracingCookie != null) {
            CloudEnv.injectTracingCookie(tracingCookie, this.dataSettings.stubSettings());
        }
        this.tableAdminSettings = BigtableTableAdminSettings.newBuilder().setProjectId(projectId).setInstanceId(instanceId);
        if (!Strings.isNullOrEmpty((String)adminEndpoint)) {
            this.tableAdminSettings.stubSettings().setEndpoint(adminEndpoint);
        }
        this.instanceAdminSettings = BigtableInstanceAdminSettings.newBuilder().setProjectId(projectId);
        if (!Strings.isNullOrEmpty((String)adminEndpoint)) {
            this.instanceAdminSettings.stubSettings().setEndpoint(adminEndpoint);
        }
    }

    private static void injectTracingCookie(String tracingCookie, EnhancedBigtableStubSettings.Builder settings) {
        HeaderProvider oldHeaderProvider = settings.getHeaderProvider();
        settings.setHeaderProvider(() -> Optional.ofNullable(oldHeaderProvider).map(p -> ImmutableMap.builder().putAll(p.getHeaders())).orElse(ImmutableMap.builder()).put((Object)"cookie", (Object)tracingCookie).build());
    }

    private void configureConnection(StubSettings.Builder stubSettings) {
        ClientInterceptor interceptor;
        switch (this.getConnectionMode()) {
            case DEFAULT: {
                return;
            }
            case REQUIRE_DIRECT_PATH: {
                interceptor = this.buildRemoteAddrInterceptor("DirectPath IPv4 or IPv6", (Predicate<InetSocketAddress>)Predicates.or(DIRECT_PATH_IPV4_MATCHER, DIRECT_PATH_IPV6_MATCHER));
                break;
            }
            case REQUIRE_DIRECT_PATH_IPV4: {
                interceptor = this.buildRemoteAddrInterceptor("DirectPath IPv4", (Predicate<InetSocketAddress>)Predicates.or((Predicate[])new Predicate[]{DIRECT_PATH_IPV4_MATCHER}));
                break;
            }
            case REQUIRE_CFE: {
                interceptor = this.buildRemoteAddrInterceptor("a CFE ip", (Predicate<InetSocketAddress>)Predicates.not((Predicate)Predicates.or(DIRECT_PATH_IPV4_MATCHER, DIRECT_PATH_IPV6_MATCHER)));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected ConnectionMode: " + (Object)((Object)this.getConnectionMode()));
            }
        }
        final AppProfileInterceptor appProfileInterceptor = this.appProfileId != null ? new AppProfileInterceptor() : null;
        InstantiatingGrpcChannelProvider.Builder channelProvider = ((InstantiatingGrpcChannelProvider)stubSettings.getTransportChannelProvider()).toBuilder();
        final ApiFunction oldConfigurator = channelProvider.getChannelConfigurator();
        ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> newConfigurator = new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

            public ManagedChannelBuilder apply(ManagedChannelBuilder builder) {
                if (oldConfigurator != null) {
                    builder = (ManagedChannelBuilder)oldConfigurator.apply((Object)builder);
                }
                builder = builder.intercept(new ClientInterceptor[]{interceptor});
                if (appProfileInterceptor != null) {
                    builder = builder.intercept(new ClientInterceptor[]{appProfileInterceptor});
                }
                return builder;
            }
        };
        channelProvider.setChannelConfigurator((ApiFunction)newConfigurator);
        stubSettings.setTransportChannelProvider((TransportChannelProvider)channelProvider.build());
    }

    private ClientInterceptor buildRemoteAddrInterceptor(final String msg, final Predicate<InetSocketAddress> predicate) {
        return new ClientInterceptor(){

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                final ClientCall clientCall = next.newCall(method, callOptions);
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(clientCall){

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                            public void onHeaders(Metadata headers) {
                                SocketAddress remoteAddr = (SocketAddress)clientCall.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
                                if (!predicate.apply((Object)((InetSocketAddress)remoteAddr))) {
                                    throw new RuntimeException(String.format("Synthetically aborting the current request because it did not adhere to the test environment's requirement . Expected %s, but ip was: %s", msg, remoteAddr));
                                }
                                super.onHeaders(headers);
                            }
                        }, headers);
                    }
                };
            }
        };
    }

    private void configureUserAgent(EnhancedBigtableStubSettings.Builder stubSettings) {
        String newUserAgent = "java-bigtable-int-test";
        Map existingHeaders = ((HeaderProvider)MoreObjects.firstNonNull((Object)stubSettings.getHeaderProvider(), (Object)FixedHeaderProvider.create((String[])new String[0]))).getHeaders();
        String existingUserAgent = (String)existingHeaders.get("user-agent");
        if (existingUserAgent != null) {
            newUserAgent = existingUserAgent + " " + newUserAgent;
        }
        HashMap<String, String> newHeaders = new HashMap<String, String>(existingHeaders);
        newHeaders.put("user-agent", newUserAgent);
        stubSettings.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create(newHeaders));
    }

    @Override
    void start() throws IOException {
        this.dataClient = BigtableDataClient.create((BigtableDataSettings)this.dataSettings.build());
        this.tableAdminClient = BigtableTableAdminClient.create((BigtableTableAdminSettings)this.tableAdminSettings.build());
        this.instanceAdminClient = BigtableInstanceAdminClient.create((BigtableInstanceAdminSettings)this.instanceAdminSettings.build());
    }

    @Override
    void stop() {
        this.dataClient.close();
        this.tableAdminClient.close();
        this.instanceAdminClient.close();
    }

    @Override
    public BigtableDataClient getDataClient() {
        return this.dataClient;
    }

    @Override
    public BigtableTableAdminClient getTableAdminClient() {
        return this.tableAdminClient;
    }

    @Override
    public BigtableTableAdminClient getTableAdminClientForInstance(String instanceId) throws IOException {
        BigtableTableAdminSettings.Builder settings = BigtableTableAdminSettings.newBuilder().setProjectId(this.tableAdminSettings.getProjectId()).setInstanceId(instanceId);
        settings.stubSettings().setEndpoint(this.tableAdminSettings.stubSettings().getEndpoint());
        return BigtableTableAdminClient.create((BigtableTableAdminSettings)settings.build());
    }

    @Override
    public BigtableInstanceAdminClient getInstanceAdminClient() {
        return this.instanceAdminClient;
    }

    @Override
    public BigtableDataSettings getDataClientSettings() {
        return this.dataSettings.build();
    }

    @Override
    public BigtableInstanceAdminSettings getInstanceAdminClientSettings() {
        try {
            return this.instanceAdminSettings.build();
        }
        catch (IOException e) {
            throw new IllegalStateException("Caught unexpected error building instance admin settings", e);
        }
    }

    @Override
    public BigtableTableAdminSettings getTableAdminSettings() {
        try {
            return this.tableAdminSettings.build();
        }
        catch (IOException e) {
            throw new IllegalStateException("Caught unexpected error building table admin settings", e);
        }
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String getTableId() {
        return this.tableId;
    }

    @Override
    public String getKmsKeyName() {
        return this.kmsKeyName;
    }

    @Nullable
    private static String getOptionalProperty(String prop) {
        return System.getProperty(prop);
    }

    private static String getOptionalProperty(String prop, String defaultValue) {
        return (String)MoreObjects.firstNonNull((Object)System.getProperty(prop), (Object)defaultValue);
    }

    private static String getRequiredProperty(String prop) {
        String value = System.getProperty(prop);
        if (value == null || value.isEmpty()) {
            throw new RuntimeException("Missing system property: " + prop);
        }
        return value;
    }

    private class AppProfileInterceptor
    implements ClientInterceptor {
        private AppProfileInterceptor() {
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(channel.newCall(methodDescriptor, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    String reqParams = (String)headers.get(Metadata.Key.of((String)"x-goog-request-params", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                    if (!reqParams.contains("app_profile_id=" + CloudEnv.this.appProfileId)) {
                        responseListener.onClose(Status.FAILED_PRECONDITION.withDescription("Integration test was configured to run with app profile: " + CloudEnv.this.appProfileId + ", but found a different app profile in the headers: " + reqParams), new Metadata());
                        return;
                    }
                    super.start(responseListener, headers);
                }
            };
        }
    }
}

