/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.AppProfile;
import com.google.bigtable.admin.v2.AppProfileName;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public final class AppProfile {
    private final com.google.bigtable.admin.v2.AppProfile proto;

    @InternalApi
    public static AppProfile fromProto(@Nonnull com.google.bigtable.admin.v2.AppProfile proto) {
        return new AppProfile(proto);
    }

    private AppProfile(@Nonnull com.google.bigtable.admin.v2.AppProfile proto) {
        Preconditions.checkNotNull((Object)proto);
        Preconditions.checkArgument((proto.hasSingleClusterRouting() || proto.hasMultiClusterRoutingUseAny() ? 1 : 0) != 0, (Object)"AppProfile must have a routing policy");
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"AppProfile must have a name");
        this.proto = proto;
    }

    public RoutingPolicy getPolicy() {
        if (this.proto.hasMultiClusterRoutingUseAny()) {
            if (this.proto.getMultiClusterRoutingUseAny().hasRowAffinity()) {
                return MultiClusterRoutingPolicy.withRowAffinity((Set<String>)ImmutableSet.copyOf((Collection)this.proto.getMultiClusterRoutingUseAny().getClusterIdsList()));
            }
            return MultiClusterRoutingPolicy.of((Set<String>)ImmutableSet.copyOf((Collection)this.proto.getMultiClusterRoutingUseAny().getClusterIdsList()));
        }
        if (this.proto.hasSingleClusterRouting()) {
            return new SingleClusterRoutingPolicy(this.proto.getSingleClusterRouting());
        }
        throw new VerifyException();
    }

    public IsolationPolicy getIsolationPolicy() {
        if (this.proto.hasStandardIsolation()) {
            return new StandardIsolationPolicy(this.proto.getStandardIsolation());
        }
        if (this.proto.hasDataBoostIsolationReadOnly()) {
            return new DataBoostIsolationReadOnlyPolicy(this.proto.getDataBoostIsolationReadOnly());
        }
        throw new IllegalStateException();
    }

    public String getId() {
        AppProfileName fullName = (AppProfileName)Verify.verifyNotNull((Object)AppProfileName.parse((String)this.proto.getName()), (String)"Name can never be null", (Object[])new Object[0]);
        return fullName.getAppProfile();
    }

    public String getInstanceId() {
        AppProfileName fullName = (AppProfileName)Verify.verifyNotNull((Object)AppProfileName.parse((String)this.proto.getName()), (String)"Name can never be null", (Object[])new Object[0]);
        return fullName.getInstance();
    }

    public String getDescription() {
        return this.proto.getDescription();
    }

    com.google.bigtable.admin.v2.AppProfile toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppProfile that = (AppProfile)o;
        return Objects.equal((Object)this.proto, (Object)that.proto);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proto});
    }

    public static class MultiClusterRoutingPolicy
    implements RoutingPolicy {
        private final AppProfile.MultiClusterRoutingUseAny proto;

        public static MultiClusterRoutingPolicy of() {
            return new MultiClusterRoutingPolicy(AppProfile.MultiClusterRoutingUseAny.getDefaultInstance());
        }

        public static MultiClusterRoutingPolicy of(String ... clusterIds) {
            return MultiClusterRoutingPolicy.of((Set<String>)ImmutableSet.copyOf((Object[])clusterIds));
        }

        public static MultiClusterRoutingPolicy of(Set<String> clusterIds) {
            return new MultiClusterRoutingPolicy(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds(clusterIds).build());
        }

        public static MultiClusterRoutingPolicy withRowAffinity() {
            return new MultiClusterRoutingPolicy(AppProfile.MultiClusterRoutingUseAny.newBuilder().setRowAffinity(AppProfile.MultiClusterRoutingUseAny.RowAffinity.getDefaultInstance()).build());
        }

        public static MultiClusterRoutingPolicy withRowAffinity(String ... clusterIds) {
            return MultiClusterRoutingPolicy.withRowAffinity((Set<String>)ImmutableSet.copyOf((Object[])clusterIds));
        }

        public static MultiClusterRoutingPolicy withRowAffinity(Set<String> clusterIds) {
            return new MultiClusterRoutingPolicy(AppProfile.MultiClusterRoutingUseAny.newBuilder().addAllClusterIds(clusterIds).setRowAffinity(AppProfile.MultiClusterRoutingUseAny.RowAffinity.getDefaultInstance()).build());
        }

        public Set<String> getClusterIds() {
            return ImmutableSet.copyOf((Collection)this.proto.getClusterIdsList());
        }

        private MultiClusterRoutingPolicy(AppProfile.MultiClusterRoutingUseAny proto) {
            this.proto = proto;
        }

        @InternalApi
        AppProfile.MultiClusterRoutingUseAny toProto() {
            return this.proto;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiClusterRoutingPolicy that = (MultiClusterRoutingPolicy)o;
            return Objects.equal((Object)this.proto, (Object)that.proto);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.proto});
        }
    }

    public static class SingleClusterRoutingPolicy
    implements RoutingPolicy {
        private final AppProfile.SingleClusterRouting proto;

        @InternalApi
        public static SingleClusterRoutingPolicy fromProto(AppProfile.SingleClusterRouting proto) {
            return new SingleClusterRoutingPolicy(proto);
        }

        public static SingleClusterRoutingPolicy of(String clusterId) {
            return SingleClusterRoutingPolicy.of(clusterId, false);
        }

        public static SingleClusterRoutingPolicy of(String clusterId, boolean allowTransactionWrites) {
            return SingleClusterRoutingPolicy.fromProto(AppProfile.SingleClusterRouting.newBuilder().setClusterId(clusterId).setAllowTransactionalWrites(allowTransactionWrites).build());
        }

        private SingleClusterRoutingPolicy(AppProfile.SingleClusterRouting proto) {
            this.proto = proto;
        }

        public String getClusterId() {
            return this.proto.getClusterId();
        }

        public boolean getAllowTransactionalWrites() {
            return this.proto.getAllowTransactionalWrites();
        }

        @InternalApi
        AppProfile.SingleClusterRouting toProto() {
            return this.proto;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleClusterRoutingPolicy that = (SingleClusterRoutingPolicy)o;
            return Objects.equal((Object)this.proto, (Object)that.proto);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.proto});
        }
    }

    public static class StandardIsolationPolicy
    implements IsolationPolicy {
        private final AppProfile.StandardIsolation proto;

        public static StandardIsolationPolicy of() {
            return new StandardIsolationPolicy(AppProfile.StandardIsolation.getDefaultInstance());
        }

        public static StandardIsolationPolicy of(Priority priority) {
            return new StandardIsolationPolicy(AppProfile.StandardIsolation.newBuilder().setPriority(priority.toProto()).build());
        }

        public Priority getPriority() {
            return Priority.fromProto(this.proto.getPriority());
        }

        private StandardIsolationPolicy(AppProfile.StandardIsolation proto) {
            this.proto = proto;
        }

        @InternalApi
        AppProfile.StandardIsolation toProto() {
            return this.proto;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StandardIsolationPolicy that = (StandardIsolationPolicy)o;
            return Objects.equal((Object)this.proto, (Object)that.proto);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.proto});
        }
    }

    public static class DataBoostIsolationReadOnlyPolicy
    implements IsolationPolicy {
        private final AppProfile.DataBoostIsolationReadOnly proto;

        DataBoostIsolationReadOnlyPolicy(AppProfile.DataBoostIsolationReadOnly proto) {
            this.proto = proto;
        }

        public static DataBoostIsolationReadOnlyPolicy of(ComputeBillingOwner billingOwner) {
            return new DataBoostIsolationReadOnlyPolicy(AppProfile.DataBoostIsolationReadOnly.newBuilder().setComputeBillingOwner(billingOwner.toProto()).build());
        }

        public ComputeBillingOwner getComputeBillingOwner() {
            return ComputeBillingOwner.fromProto(this.proto.getComputeBillingOwner());
        }

        @InternalApi
        public AppProfile.DataBoostIsolationReadOnly toProto() {
            return this.proto;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataBoostIsolationReadOnlyPolicy that = (DataBoostIsolationReadOnlyPolicy)o;
            return Objects.equal((Object)this.proto, (Object)that.proto);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.proto});
        }
    }

    public static enum ComputeBillingOwner {
        UNSPECIFIED(AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner.COMPUTE_BILLING_OWNER_UNSPECIFIED),
        HOST_PAYS(AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner.HOST_PAYS),
        UNRECOGNIZED(AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner.UNRECOGNIZED);

        private final AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner proto;

        @InternalApi
        public static ComputeBillingOwner fromProto(AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner proto) {
            Preconditions.checkNotNull((Object)proto);
            for (ComputeBillingOwner owner : ComputeBillingOwner.values()) {
                if (!owner.proto.equals((Object)proto)) continue;
                return owner;
            }
            return UNRECOGNIZED;
        }

        @InternalApi
        public AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner toProto() {
            return this.proto;
        }

        private ComputeBillingOwner(AppProfile.DataBoostIsolationReadOnly.ComputeBillingOwner proto) {
            this.proto = proto;
        }
    }

    public static enum Priority {
        LOW(AppProfile.Priority.PRIORITY_LOW),
        MEDIUM(AppProfile.Priority.PRIORITY_MEDIUM),
        HIGH(AppProfile.Priority.PRIORITY_HIGH);

        private final AppProfile.Priority proto;

        @InternalApi
        public static Priority fromProto(AppProfile.Priority proto) {
            Preconditions.checkNotNull((Object)proto);
            for (Priority priority : Priority.values()) {
                if (!priority.proto.equals((Object)proto)) continue;
                return priority;
            }
            throw new IllegalArgumentException("Unknown priority: " + proto);
        }

        private Priority(AppProfile.Priority proto) {
            this.proto = proto;
        }

        @InternalApi
        public AppProfile.Priority toProto() {
            return this.proto;
        }
    }

    public static interface IsolationPolicy {
    }

    public static interface RoutingPolicy {
    }
}

