/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.MonitoredResource;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.auth.Credentials;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableExporterUtils;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.Empty;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@InternalApi
public final class BigtableCloudMonitoringExporter
implements MetricExporter {
    private static final Logger logger = Logger.getLogger(BigtableCloudMonitoringExporter.class.getName());
    @Deprecated
    @Nullable
    private static final String MONITORING_ENDPOINT_OVERRIDE_SYS_PROP = System.getProperty("bigtable.test-monitoring-endpoint");
    private static final String APPLICATION_RESOURCE_PROJECT_ID = "project_id";
    private static final int EXPORT_BATCH_SIZE_LIMIT = 200;
    private final MetricServiceClient client;
    private final String taskId;
    private final Supplier<MonitoredResource> applicationResource;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private CompletableResultCode lastExportCode;
    private final AtomicBoolean bigtableExportFailureLogged = new AtomicBoolean(false);
    private final AtomicBoolean applicationExportFailureLogged = new AtomicBoolean(false);
    private static final ImmutableList<String> BIGTABLE_TABLE_METRICS = (ImmutableList)ImmutableSet.of((Object)"operation_latencies", (Object)"attempt_latencies", (Object)"server_latencies", (Object)"first_response_latencies", (Object)"throttling_latencies", (Object)"application_latencies", (Object[])new String[]{"retry_count", "connectivity_error_count", "remaining_deadline"}).stream().map(m -> "bigtable.googleapis.com/internal/client/" + m).collect(ImmutableList.toImmutableList());
    private static final ImmutableList<String> APPLICATION_METRICS = (ImmutableList)ImmutableSet.of((Object)"per_connection_error_count").stream().map(m -> "bigtable.googleapis.com/internal/client/" + m).collect(ImmutableList.toImmutableList());

    public static BigtableCloudMonitoringExporter create(@Nullable Credentials credentials, @Nullable String endpoint) throws IOException {
        MetricServiceSettings.Builder settingsBuilder = MetricServiceSettings.newBuilder();
        CredentialsProvider credentialsProvider = Optional.ofNullable(credentials).map(FixedCredentialsProvider::create).orElse((CredentialsProvider)NoCredentialsProvider.create());
        settingsBuilder.setCredentialsProvider(credentialsProvider);
        if (MONITORING_ENDPOINT_OVERRIDE_SYS_PROP != null) {
            logger.warning("Setting the monitoring endpoint through system variable will be removed in future versions");
            settingsBuilder.setEndpoint(MONITORING_ENDPOINT_OVERRIDE_SYS_PROP);
        }
        if (endpoint != null) {
            settingsBuilder.setEndpoint(endpoint);
        }
        Duration timeout = Duration.ofMinutes(1L);
        settingsBuilder.createServiceTimeSeriesSettings().setSimpleTimeoutNoRetriesDuration(timeout);
        return new BigtableCloudMonitoringExporter(MetricServiceClient.create((MetricServiceSettings)settingsBuilder.build()), (Supplier<MonitoredResource>)Suppliers.memoize(BigtableExporterUtils::detectResourceSafe), BigtableExporterUtils.getDefaultTaskValue());
    }

    @VisibleForTesting
    BigtableCloudMonitoringExporter(MetricServiceClient client, Supplier<MonitoredResource> applicationResource, String taskId) {
        this.client = client;
        this.taskId = taskId;
        this.applicationResource = applicationResource;
    }

    public CompletableResultCode export(Collection<MetricData> collection) {
        if (this.isShutdown.get()) {
            logger.log(Level.WARNING, "Exporter is shutting down");
            return CompletableResultCode.ofFailure();
        }
        CompletableResultCode bigtableExportCode = this.exportBigtableResourceMetrics(collection);
        CompletableResultCode applicationExportCode = this.exportApplicationResourceMetrics(collection);
        this.lastExportCode = CompletableResultCode.ofAll((Collection)ImmutableList.of((Object)applicationExportCode, (Object)bigtableExportCode));
        return this.lastExportCode;
    }

    private CompletableResultCode exportBigtableResourceMetrics(Collection<MetricData> collection) {
        Map<String, List<TimeSeries>> bigtableTimeSeries;
        List<MetricData> bigtableMetricData = collection.stream().filter(md -> BIGTABLE_TABLE_METRICS.contains((Object)md.getName())).collect(Collectors.toList());
        if (bigtableMetricData.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        try {
            bigtableTimeSeries = BigtableExporterUtils.convertToBigtableTimeSeries(bigtableMetricData, this.taskId);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to convert bigtable table metric data to cloud monitoring timeseries.", e);
            return CompletableResultCode.ofFailure();
        }
        final CompletableResultCode bigtableExportCode = new CompletableResultCode();
        bigtableTimeSeries.forEach((projectId, ts) -> {
            final ProjectName projectName = ProjectName.of((String)projectId);
            ApiFuture<List<Empty>> future = this.exportTimeSeries(projectName, (List<TimeSeries>)ts);
            ApiFutures.addCallback(future, (ApiFutureCallback)new ApiFutureCallback<List<Empty>>(){

                public void onFailure(Throwable throwable) {
                    if (BigtableCloudMonitoringExporter.this.bigtableExportFailureLogged.compareAndSet(false, true)) {
                        String msg = "createServiceTimeSeries request failed for bigtable metrics.";
                        if (throwable instanceof PermissionDeniedException) {
                            msg = msg + String.format(" Need monitoring metric writer permission on project=%s. Follow https://cloud.google.com/bigtable/docs/client-side-metrics-setup to set up permissions.", projectName.getProject());
                        }
                        logger.log(Level.WARNING, msg, throwable);
                    }
                    bigtableExportCode.fail();
                }

                public void onSuccess(List<Empty> emptyList) {
                    BigtableCloudMonitoringExporter.this.bigtableExportFailureLogged.set(false);
                    bigtableExportCode.succeed();
                }
            }, (Executor)MoreExecutors.directExecutor());
        });
        return bigtableExportCode;
    }

    private CompletableResultCode exportApplicationResourceMetrics(Collection<MetricData> collection) {
        List<TimeSeries> timeSeries;
        if (this.applicationResource.get() == null) {
            return CompletableResultCode.ofSuccess();
        }
        List<MetricData> metricData = collection.stream().filter(md -> APPLICATION_METRICS.contains((Object)md.getName())).collect(Collectors.toList());
        if (metricData.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        try {
            timeSeries = BigtableExporterUtils.convertToApplicationResourceTimeSeries(metricData, this.taskId, (MonitoredResource)this.applicationResource.get());
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to convert application metric data to cloud monitoring timeseries.", e);
            return CompletableResultCode.ofFailure();
        }
        final CompletableResultCode exportCode = new CompletableResultCode();
        try {
            final ProjectName projectName = ProjectName.of((String)((MonitoredResource)this.applicationResource.get()).getLabelsOrThrow(APPLICATION_RESOURCE_PROJECT_ID));
            ApiFuture<List<Empty>> gceOrGkeFuture = this.exportTimeSeries(projectName, timeSeries);
            ApiFutures.addCallback(gceOrGkeFuture, (ApiFutureCallback)new ApiFutureCallback<List<Empty>>(){

                public void onFailure(Throwable throwable) {
                    if (BigtableCloudMonitoringExporter.this.applicationExportFailureLogged.compareAndSet(false, true)) {
                        String msg = "createServiceTimeSeries request failed for bigtable metrics.";
                        if (throwable instanceof PermissionDeniedException) {
                            msg = msg + String.format(" Need monitoring metric writer permission on project=%s. Follow https://cloud.google.com/bigtable/docs/client-side-metrics-setup to set up permissions.", projectName.getProject());
                        }
                        logger.log(Level.WARNING, msg, throwable);
                    }
                    exportCode.fail();
                }

                public void onSuccess(List<Empty> emptyList) {
                    BigtableCloudMonitoringExporter.this.applicationExportFailureLogged.set(false);
                    exportCode.succeed();
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get projectName for application resource " + this.applicationResource);
            return CompletableResultCode.ofFailure();
        }
        return exportCode;
    }

    private ApiFuture<List<Empty>> exportTimeSeries(ProjectName projectName, List<TimeSeries> timeSeries) {
        ArrayList<ApiFuture> batchResults = new ArrayList<ApiFuture>();
        for (List batch : Iterables.partition(timeSeries, (int)200)) {
            CreateTimeSeriesRequest req = CreateTimeSeriesRequest.newBuilder().setName(projectName.toString()).addAllTimeSeries((Iterable)batch).build();
            ApiFuture f = this.client.createServiceTimeSeriesCallable().futureCall((Object)req);
            batchResults.add(f);
        }
        return ApiFutures.allAsList(batchResults);
    }

    public CompletableResultCode flush() {
        if (this.lastExportCode != null) {
            return this.lastExportCode;
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            logger.log(Level.WARNING, "shutdown is called multiple times");
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode flushResult = this.flush();
        CompletableResultCode shutdownResult = new CompletableResultCode();
        flushResult.whenComplete(() -> {
            Throwable throwable = null;
            try {
                this.client.shutdown();
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "failed to shutdown the monitoring client", e);
                throwable = e;
            }
            if (throwable != null) {
                shutdownResult.fail();
            } else {
                shutdownResult.succeed();
            }
        });
        return CompletableResultCode.ofAll(Arrays.asList(flushResult, shutdownResult));
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }
}

