/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.CreateLogicalViewRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;

public final class CreateLogicalViewRequest {
    private final String instanceId;
    private final CreateLogicalViewRequest.Builder proto;

    public static CreateLogicalViewRequest of(String instanceId, String logicalViewId) {
        return new CreateLogicalViewRequest(instanceId, logicalViewId);
    }

    private CreateLogicalViewRequest(String instanceId, String logicalViewId) {
        this.instanceId = instanceId;
        this.proto = com.google.bigtable.admin.v2.CreateLogicalViewRequest.newBuilder();
        this.proto.setLogicalViewId(logicalViewId);
    }

    public CreateLogicalViewRequest setQuery(@Nonnull String query) {
        this.proto.getLogicalViewBuilder().setQuery(query);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateLogicalViewRequest that = (CreateLogicalViewRequest)o;
        return Objects.equal((Object)this.proto.build(), (Object)that.proto.build()) && Objects.equal((Object)this.instanceId, (Object)that.instanceId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proto.build(), this.instanceId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.CreateLogicalViewRequest toProto(String projectId) {
        String name = NameUtil.formatInstanceName(projectId, this.instanceId);
        return this.proto.setParent(name).build();
    }
}

