/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.gaxx.retrying;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import com.google.api.gax.retrying.RetryingContext;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.api.gax.rpc.ApiException;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import com.google.rpc.RetryInfo;
import javax.annotation.Nullable;

@InternalApi
public class RetryInfoRetryAlgorithm<ResponseT>
extends BasicResultRetryAlgorithm<ResponseT> {
    public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, ResponseT prevResponse, TimedAttemptSettings prevSettings) {
        java.time.Duration retryDelay = RetryInfoRetryAlgorithm.extractRetryDelay(prevThrowable);
        if (retryDelay != null) {
            return prevSettings.toBuilder().setRetryDelayDuration(retryDelay).setRandomizedRetryDelayDuration(retryDelay).setAttemptCount(prevSettings.getAttemptCount() + 1).setOverallAttemptCount(prevSettings.getAttemptCount() + 1).build();
        }
        return null;
    }

    public boolean shouldRetry(Throwable previousThrowable, ResponseT previousResponse) {
        return this.shouldRetry(null, previousThrowable, previousResponse);
    }

    public boolean shouldRetry(@Nullable RetryingContext context, Throwable previousThrowable, ResponseT previousResponse) {
        if (RetryInfoRetryAlgorithm.extractRetryDelay(previousThrowable) != null) {
            return true;
        }
        if (context != null && context.getRetryableCodes() != null) {
            return previousThrowable instanceof ApiException && context.getRetryableCodes().contains(((ApiException)previousThrowable).getStatusCode().getCode());
        }
        return previousThrowable instanceof ApiException && ((ApiException)previousThrowable).isRetryable();
    }

    static java.time.Duration extractRetryDelay(@Nullable Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (!(throwable instanceof ApiException)) {
            return null;
        }
        ApiException exception = (ApiException)throwable;
        if (exception.getErrorDetails() == null) {
            return null;
        }
        if (exception.getErrorDetails().getRetryInfo() == null) {
            return null;
        }
        RetryInfo retryInfo = exception.getErrorDetails().getRetryInfo();
        return java.time.Duration.ofMillis(Durations.toMillis((Duration)retryInfo.getRetryDelay()));
    }
}

