/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.common.collect.ImmutableMap;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.opencensus.tags.TagValue;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class Util {
    static final Metadata.Key<String> ATTEMPT_HEADER_KEY = Metadata.Key.of((String)"bigtable-attempt", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    static final Metadata.Key<String> ATTEMPT_EPOCH_KEY = Metadata.Key.of((String)"bigtable-client-attempt-epoch-usec", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SERVER_TIMING_HEADER_KEY = Metadata.Key.of((String)"server-timing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Pattern SERVER_TIMING_HEADER_PATTERN = Pattern.compile(".*dur=(?<dur>\\d+)");
    private static final TagValue OK_STATUS = TagValue.create((String)StatusCode.Code.OK.toString());

    Util() {
    }

    static TagValue extractStatus(@Nullable Throwable error) {
        if (error == null) {
            return OK_STATUS;
        }
        String statusString = error instanceof CancellationException ? Status.Code.CANCELLED.toString() : (error instanceof ApiException ? ((ApiException)error).getStatusCode().getCode().toString() : (error instanceof StatusRuntimeException ? ((StatusRuntimeException)error).getStatus().getCode().toString() : (error instanceof StatusException ? ((StatusException)error).getStatus().getCode().toString() : StatusCode.Code.UNKNOWN.toString())));
        return TagValue.create((String)statusString);
    }

    static TagValue extractStatus(Future<?> future) {
        Throwable error = null;
        try {
            future.get();
        }
        catch (InterruptedException e) {
            error = e;
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            error = e.getCause();
        }
        catch (RuntimeException e) {
            error = e;
        }
        return Util.extractStatus(error);
    }

    static Map<String, List<String>> createStatsHeaders(ApiCallContext apiCallContext) {
        ImmutableMap.Builder headers = ImmutableMap.builder();
        headers.put((Object)ATTEMPT_EPOCH_KEY.name(), Arrays.asList(String.valueOf(Instant.EPOCH.until(Instant.now(), ChronoUnit.MICROS))));
        if (apiCallContext.getTracer() instanceof BigtableTracer) {
            int attemptCount = ((BigtableTracer)apiCallContext.getTracer()).getAttempt();
            headers.put((Object)ATTEMPT_HEADER_KEY.name(), Arrays.asList(String.valueOf(attemptCount)));
        }
        return headers.build();
    }

    static Long getGfeLatency(Metadata metadata) {
        String serverTiming;
        Matcher matcher;
        if (metadata != null && metadata.get(SERVER_TIMING_HEADER_KEY) != null && (matcher = SERVER_TIMING_HEADER_PATTERN.matcher(serverTiming = (String)metadata.get(SERVER_TIMING_HEADER_KEY))).find()) {
            long latency = Long.valueOf(matcher.group("dur"));
            return latency;
        }
        return null;
    }
}

