/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.bigtable.admin.v2.AppProfile;
import com.google.bigtable.admin.v2.AppProfileName;
import com.google.bigtable.admin.v2.Cluster;
import com.google.bigtable.admin.v2.ClusterName;
import com.google.bigtable.admin.v2.CreateAppProfileRequest;
import com.google.bigtable.admin.v2.CreateClusterMetadata;
import com.google.bigtable.admin.v2.CreateClusterRequest;
import com.google.bigtable.admin.v2.CreateInstanceMetadata;
import com.google.bigtable.admin.v2.CreateInstanceRequest;
import com.google.bigtable.admin.v2.CreateLogicalViewMetadata;
import com.google.bigtable.admin.v2.CreateLogicalViewRequest;
import com.google.bigtable.admin.v2.CreateMaterializedViewMetadata;
import com.google.bigtable.admin.v2.CreateMaterializedViewRequest;
import com.google.bigtable.admin.v2.DeleteAppProfileRequest;
import com.google.bigtable.admin.v2.DeleteClusterRequest;
import com.google.bigtable.admin.v2.DeleteInstanceRequest;
import com.google.bigtable.admin.v2.DeleteLogicalViewRequest;
import com.google.bigtable.admin.v2.DeleteMaterializedViewRequest;
import com.google.bigtable.admin.v2.GetAppProfileRequest;
import com.google.bigtable.admin.v2.GetClusterRequest;
import com.google.bigtable.admin.v2.GetInstanceRequest;
import com.google.bigtable.admin.v2.GetLogicalViewRequest;
import com.google.bigtable.admin.v2.GetMaterializedViewRequest;
import com.google.bigtable.admin.v2.HotTablet;
import com.google.bigtable.admin.v2.Instance;
import com.google.bigtable.admin.v2.InstanceName;
import com.google.bigtable.admin.v2.ListAppProfilesRequest;
import com.google.bigtable.admin.v2.ListAppProfilesResponse;
import com.google.bigtable.admin.v2.ListClustersRequest;
import com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.bigtable.admin.v2.ListHotTabletsRequest;
import com.google.bigtable.admin.v2.ListHotTabletsResponse;
import com.google.bigtable.admin.v2.ListInstancesRequest;
import com.google.bigtable.admin.v2.ListInstancesResponse;
import com.google.bigtable.admin.v2.ListLogicalViewsRequest;
import com.google.bigtable.admin.v2.ListLogicalViewsResponse;
import com.google.bigtable.admin.v2.ListMaterializedViewsRequest;
import com.google.bigtable.admin.v2.ListMaterializedViewsResponse;
import com.google.bigtable.admin.v2.LogicalView;
import com.google.bigtable.admin.v2.LogicalViewName;
import com.google.bigtable.admin.v2.MaterializedView;
import com.google.bigtable.admin.v2.MaterializedViewName;
import com.google.bigtable.admin.v2.PartialUpdateClusterMetadata;
import com.google.bigtable.admin.v2.PartialUpdateClusterRequest;
import com.google.bigtable.admin.v2.PartialUpdateInstanceRequest;
import com.google.bigtable.admin.v2.ProjectName;
import com.google.bigtable.admin.v2.UpdateAppProfileMetadata;
import com.google.bigtable.admin.v2.UpdateAppProfileRequest;
import com.google.bigtable.admin.v2.UpdateClusterMetadata;
import com.google.bigtable.admin.v2.UpdateInstanceMetadata;
import com.google.bigtable.admin.v2.UpdateLogicalViewMetadata;
import com.google.bigtable.admin.v2.UpdateLogicalViewRequest;
import com.google.bigtable.admin.v2.UpdateMaterializedViewMetadata;
import com.google.bigtable.admin.v2.UpdateMaterializedViewRequest;
import com.google.cloud.bigtable.admin.v2.BaseBigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStub;
import com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@InternalApi
public class BaseBigtableInstanceAdminClient
implements BackgroundResource {
    private final BaseBigtableInstanceAdminSettings settings;
    private final BigtableInstanceAdminStub stub;
    private final OperationsClient operationsClient;

    public static final BaseBigtableInstanceAdminClient create() throws IOException {
        return BaseBigtableInstanceAdminClient.create(BaseBigtableInstanceAdminSettings.newBuilder().build());
    }

    public static final BaseBigtableInstanceAdminClient create(BaseBigtableInstanceAdminSettings settings) throws IOException {
        return new BaseBigtableInstanceAdminClient(settings);
    }

    public static final BaseBigtableInstanceAdminClient create(BigtableInstanceAdminStub stub) {
        return new BaseBigtableInstanceAdminClient(stub);
    }

    protected BaseBigtableInstanceAdminClient(BaseBigtableInstanceAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BigtableInstanceAdminStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected BaseBigtableInstanceAdminClient(BigtableInstanceAdminStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final BaseBigtableInstanceAdminSettings getSettings() {
        return this.settings;
    }

    public BigtableInstanceAdminStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Instance, CreateInstanceMetadata> createInstanceAsync(ProjectName parent, String instanceId, Instance instance, Map<String, Cluster> clusters) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstanceId(instanceId).setInstance(instance).putAllClusters(clusters).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, CreateInstanceMetadata> createInstanceAsync(String parent, String instanceId, Instance instance, Map<String, Cluster> clusters) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstanceId(instanceId).setInstance(instance).putAllClusters(clusters).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, CreateInstanceMetadata> createInstanceAsync(CreateInstanceRequest request) {
        return this.createInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstanceRequest, Instance, CreateInstanceMetadata> createInstanceOperationCallable() {
        return this.stub.createInstanceOperationCallable();
    }

    public final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.stub.createInstanceCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final ListInstancesResponse listInstances(ProjectName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesResponse)this.listInstancesCallable().call((Object)request);
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance updateInstance(Instance request) {
        return (Instance)this.updateInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<Instance, Instance> updateInstanceCallable() {
        return this.stub.updateInstanceCallable();
    }

    public final OperationFuture<Instance, UpdateInstanceMetadata> partialUpdateInstanceAsync(Instance instance, FieldMask updateMask) {
        PartialUpdateInstanceRequest request = PartialUpdateInstanceRequest.newBuilder().setInstance(instance).setUpdateMask(updateMask).build();
        return this.partialUpdateInstanceAsync(request);
    }

    public final OperationFuture<Instance, UpdateInstanceMetadata> partialUpdateInstanceAsync(PartialUpdateInstanceRequest request) {
        return this.partialUpdateInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PartialUpdateInstanceRequest, Instance, UpdateInstanceMetadata> partialUpdateInstanceOperationCallable() {
        return this.stub.partialUpdateInstanceOperationCallable();
    }

    public final UnaryCallable<PartialUpdateInstanceRequest, Operation> partialUpdateInstanceCallable() {
        return this.stub.partialUpdateInstanceCallable();
    }

    public final void deleteInstance(InstanceName name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteInstance(request);
    }

    public final void deleteInstance(String name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name).build();
        this.deleteInstance(request);
    }

    public final void deleteInstance(DeleteInstanceRequest request) {
        this.deleteInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteInstanceRequest, Empty> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    public final OperationFuture<Cluster, CreateClusterMetadata> createClusterAsync(InstanceName parent, String clusterId, Cluster cluster) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setClusterId(clusterId).setCluster(cluster).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, CreateClusterMetadata> createClusterAsync(String parent, String clusterId, Cluster cluster) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent).setClusterId(clusterId).setCluster(cluster).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, CreateClusterMetadata> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateClusterRequest, Cluster, CreateClusterMetadata> createClusterOperationCallable() {
        return this.stub.createClusterOperationCallable();
    }

    public final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.stub.createClusterCallable();
    }

    public final Cluster getCluster(ClusterName name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(String name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(GetClusterRequest request) {
        return (Cluster)this.getClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.stub.getClusterCallable();
    }

    public final ListClustersResponse listClusters(InstanceName parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listClusters(request);
    }

    public final ListClustersResponse listClusters(String parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent).build();
        return this.listClusters(request);
    }

    public final ListClustersResponse listClusters(ListClustersRequest request) {
        return (ListClustersResponse)this.listClustersCallable().call((Object)request);
    }

    public final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.stub.listClustersCallable();
    }

    public final OperationFuture<Cluster, UpdateClusterMetadata> updateClusterAsync(Cluster request) {
        return this.updateClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<Cluster, Cluster, UpdateClusterMetadata> updateClusterOperationCallable() {
        return this.stub.updateClusterOperationCallable();
    }

    public final UnaryCallable<Cluster, Operation> updateClusterCallable() {
        return this.stub.updateClusterCallable();
    }

    public final OperationFuture<Cluster, PartialUpdateClusterMetadata> partialUpdateClusterAsync(Cluster cluster, FieldMask updateMask) {
        PartialUpdateClusterRequest request = PartialUpdateClusterRequest.newBuilder().setCluster(cluster).setUpdateMask(updateMask).build();
        return this.partialUpdateClusterAsync(request);
    }

    public final OperationFuture<Cluster, PartialUpdateClusterMetadata> partialUpdateClusterAsync(PartialUpdateClusterRequest request) {
        return this.partialUpdateClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PartialUpdateClusterRequest, Cluster, PartialUpdateClusterMetadata> partialUpdateClusterOperationCallable() {
        return this.stub.partialUpdateClusterOperationCallable();
    }

    public final UnaryCallable<PartialUpdateClusterRequest, Operation> partialUpdateClusterCallable() {
        return this.stub.partialUpdateClusterCallable();
    }

    public final void deleteCluster(ClusterName name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteCluster(request);
    }

    public final void deleteCluster(String name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name).build();
        this.deleteCluster(request);
    }

    public final void deleteCluster(DeleteClusterRequest request) {
        this.deleteClusterCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteClusterRequest, Empty> deleteClusterCallable() {
        return this.stub.deleteClusterCallable();
    }

    public final AppProfile createAppProfile(InstanceName parent, String appProfileId, AppProfile appProfile) {
        CreateAppProfileRequest request = CreateAppProfileRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAppProfileId(appProfileId).setAppProfile(appProfile).build();
        return this.createAppProfile(request);
    }

    public final AppProfile createAppProfile(String parent, String appProfileId, AppProfile appProfile) {
        CreateAppProfileRequest request = CreateAppProfileRequest.newBuilder().setParent(parent).setAppProfileId(appProfileId).setAppProfile(appProfile).build();
        return this.createAppProfile(request);
    }

    public final AppProfile createAppProfile(CreateAppProfileRequest request) {
        return (AppProfile)this.createAppProfileCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAppProfileRequest, AppProfile> createAppProfileCallable() {
        return this.stub.createAppProfileCallable();
    }

    public final AppProfile getAppProfile(AppProfileName name) {
        GetAppProfileRequest request = GetAppProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAppProfile(request);
    }

    public final AppProfile getAppProfile(String name) {
        GetAppProfileRequest request = GetAppProfileRequest.newBuilder().setName(name).build();
        return this.getAppProfile(request);
    }

    public final AppProfile getAppProfile(GetAppProfileRequest request) {
        return (AppProfile)this.getAppProfileCallable().call((Object)request);
    }

    public final UnaryCallable<GetAppProfileRequest, AppProfile> getAppProfileCallable() {
        return this.stub.getAppProfileCallable();
    }

    public final ListAppProfilesPagedResponse listAppProfiles(InstanceName parent) {
        ListAppProfilesRequest request = ListAppProfilesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAppProfiles(request);
    }

    public final ListAppProfilesPagedResponse listAppProfiles(String parent) {
        ListAppProfilesRequest request = ListAppProfilesRequest.newBuilder().setParent(parent).build();
        return this.listAppProfiles(request);
    }

    public final ListAppProfilesPagedResponse listAppProfiles(ListAppProfilesRequest request) {
        return (ListAppProfilesPagedResponse)((Object)this.listAppProfilesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAppProfilesRequest, ListAppProfilesPagedResponse> listAppProfilesPagedCallable() {
        return this.stub.listAppProfilesPagedCallable();
    }

    public final UnaryCallable<ListAppProfilesRequest, ListAppProfilesResponse> listAppProfilesCallable() {
        return this.stub.listAppProfilesCallable();
    }

    public final OperationFuture<AppProfile, UpdateAppProfileMetadata> updateAppProfileAsync(AppProfile appProfile, FieldMask updateMask) {
        UpdateAppProfileRequest request = UpdateAppProfileRequest.newBuilder().setAppProfile(appProfile).setUpdateMask(updateMask).build();
        return this.updateAppProfileAsync(request);
    }

    public final OperationFuture<AppProfile, UpdateAppProfileMetadata> updateAppProfileAsync(UpdateAppProfileRequest request) {
        return this.updateAppProfileOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAppProfileRequest, AppProfile, UpdateAppProfileMetadata> updateAppProfileOperationCallable() {
        return this.stub.updateAppProfileOperationCallable();
    }

    public final UnaryCallable<UpdateAppProfileRequest, Operation> updateAppProfileCallable() {
        return this.stub.updateAppProfileCallable();
    }

    public final void deleteAppProfile(AppProfileName name) {
        DeleteAppProfileRequest request = DeleteAppProfileRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAppProfile(request);
    }

    public final void deleteAppProfile(String name) {
        DeleteAppProfileRequest request = DeleteAppProfileRequest.newBuilder().setName(name).build();
        this.deleteAppProfile(request);
    }

    public final void deleteAppProfile(AppProfileName name, boolean ignoreWarnings) {
        DeleteAppProfileRequest request = DeleteAppProfileRequest.newBuilder().setName(name == null ? null : name.toString()).setIgnoreWarnings(ignoreWarnings).build();
        this.deleteAppProfile(request);
    }

    public final void deleteAppProfile(String name, boolean ignoreWarnings) {
        DeleteAppProfileRequest request = DeleteAppProfileRequest.newBuilder().setName(name).setIgnoreWarnings(ignoreWarnings).build();
        this.deleteAppProfile(request);
    }

    public final void deleteAppProfile(DeleteAppProfileRequest request) {
        this.deleteAppProfileCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAppProfileRequest, Empty> deleteAppProfileCallable() {
        return this.stub.deleteAppProfileCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final ListHotTabletsPagedResponse listHotTablets(ClusterName parent) {
        ListHotTabletsRequest request = ListHotTabletsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listHotTablets(request);
    }

    public final ListHotTabletsPagedResponse listHotTablets(String parent) {
        ListHotTabletsRequest request = ListHotTabletsRequest.newBuilder().setParent(parent).build();
        return this.listHotTablets(request);
    }

    public final ListHotTabletsPagedResponse listHotTablets(ListHotTabletsRequest request) {
        return (ListHotTabletsPagedResponse)((Object)this.listHotTabletsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHotTabletsRequest, ListHotTabletsPagedResponse> listHotTabletsPagedCallable() {
        return this.stub.listHotTabletsPagedCallable();
    }

    public final UnaryCallable<ListHotTabletsRequest, ListHotTabletsResponse> listHotTabletsCallable() {
        return this.stub.listHotTabletsCallable();
    }

    public final OperationFuture<LogicalView, CreateLogicalViewMetadata> createLogicalViewAsync(InstanceName parent, LogicalView logicalView, String logicalViewId) {
        CreateLogicalViewRequest request = CreateLogicalViewRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setLogicalView(logicalView).setLogicalViewId(logicalViewId).build();
        return this.createLogicalViewAsync(request);
    }

    public final OperationFuture<LogicalView, CreateLogicalViewMetadata> createLogicalViewAsync(String parent, LogicalView logicalView, String logicalViewId) {
        CreateLogicalViewRequest request = CreateLogicalViewRequest.newBuilder().setParent(parent).setLogicalView(logicalView).setLogicalViewId(logicalViewId).build();
        return this.createLogicalViewAsync(request);
    }

    public final OperationFuture<LogicalView, CreateLogicalViewMetadata> createLogicalViewAsync(CreateLogicalViewRequest request) {
        return this.createLogicalViewOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateLogicalViewRequest, LogicalView, CreateLogicalViewMetadata> createLogicalViewOperationCallable() {
        return this.stub.createLogicalViewOperationCallable();
    }

    public final UnaryCallable<CreateLogicalViewRequest, Operation> createLogicalViewCallable() {
        return this.stub.createLogicalViewCallable();
    }

    public final LogicalView getLogicalView(LogicalViewName name) {
        GetLogicalViewRequest request = GetLogicalViewRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLogicalView(request);
    }

    public final LogicalView getLogicalView(String name) {
        GetLogicalViewRequest request = GetLogicalViewRequest.newBuilder().setName(name).build();
        return this.getLogicalView(request);
    }

    public final LogicalView getLogicalView(GetLogicalViewRequest request) {
        return (LogicalView)this.getLogicalViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetLogicalViewRequest, LogicalView> getLogicalViewCallable() {
        return this.stub.getLogicalViewCallable();
    }

    public final ListLogicalViewsPagedResponse listLogicalViews(InstanceName parent) {
        ListLogicalViewsRequest request = ListLogicalViewsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listLogicalViews(request);
    }

    public final ListLogicalViewsPagedResponse listLogicalViews(String parent) {
        ListLogicalViewsRequest request = ListLogicalViewsRequest.newBuilder().setParent(parent).build();
        return this.listLogicalViews(request);
    }

    public final ListLogicalViewsPagedResponse listLogicalViews(ListLogicalViewsRequest request) {
        return (ListLogicalViewsPagedResponse)((Object)this.listLogicalViewsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLogicalViewsRequest, ListLogicalViewsPagedResponse> listLogicalViewsPagedCallable() {
        return this.stub.listLogicalViewsPagedCallable();
    }

    public final UnaryCallable<ListLogicalViewsRequest, ListLogicalViewsResponse> listLogicalViewsCallable() {
        return this.stub.listLogicalViewsCallable();
    }

    public final OperationFuture<LogicalView, UpdateLogicalViewMetadata> updateLogicalViewAsync(LogicalView logicalView, FieldMask updateMask) {
        UpdateLogicalViewRequest request = UpdateLogicalViewRequest.newBuilder().setLogicalView(logicalView).setUpdateMask(updateMask).build();
        return this.updateLogicalViewAsync(request);
    }

    public final OperationFuture<LogicalView, UpdateLogicalViewMetadata> updateLogicalViewAsync(UpdateLogicalViewRequest request) {
        return this.updateLogicalViewOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateLogicalViewRequest, LogicalView, UpdateLogicalViewMetadata> updateLogicalViewOperationCallable() {
        return this.stub.updateLogicalViewOperationCallable();
    }

    public final UnaryCallable<UpdateLogicalViewRequest, Operation> updateLogicalViewCallable() {
        return this.stub.updateLogicalViewCallable();
    }

    public final void deleteLogicalView(LogicalViewName name) {
        DeleteLogicalViewRequest request = DeleteLogicalViewRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteLogicalView(request);
    }

    public final void deleteLogicalView(String name) {
        DeleteLogicalViewRequest request = DeleteLogicalViewRequest.newBuilder().setName(name).build();
        this.deleteLogicalView(request);
    }

    public final void deleteLogicalView(DeleteLogicalViewRequest request) {
        this.deleteLogicalViewCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteLogicalViewRequest, Empty> deleteLogicalViewCallable() {
        return this.stub.deleteLogicalViewCallable();
    }

    public final OperationFuture<MaterializedView, CreateMaterializedViewMetadata> createMaterializedViewAsync(InstanceName parent, MaterializedView materializedView, String materializedViewId) {
        CreateMaterializedViewRequest request = CreateMaterializedViewRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMaterializedView(materializedView).setMaterializedViewId(materializedViewId).build();
        return this.createMaterializedViewAsync(request);
    }

    public final OperationFuture<MaterializedView, CreateMaterializedViewMetadata> createMaterializedViewAsync(String parent, MaterializedView materializedView, String materializedViewId) {
        CreateMaterializedViewRequest request = CreateMaterializedViewRequest.newBuilder().setParent(parent).setMaterializedView(materializedView).setMaterializedViewId(materializedViewId).build();
        return this.createMaterializedViewAsync(request);
    }

    public final OperationFuture<MaterializedView, CreateMaterializedViewMetadata> createMaterializedViewAsync(CreateMaterializedViewRequest request) {
        return this.createMaterializedViewOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMaterializedViewRequest, MaterializedView, CreateMaterializedViewMetadata> createMaterializedViewOperationCallable() {
        return this.stub.createMaterializedViewOperationCallable();
    }

    public final UnaryCallable<CreateMaterializedViewRequest, Operation> createMaterializedViewCallable() {
        return this.stub.createMaterializedViewCallable();
    }

    public final MaterializedView getMaterializedView(MaterializedViewName name) {
        GetMaterializedViewRequest request = GetMaterializedViewRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMaterializedView(request);
    }

    public final MaterializedView getMaterializedView(String name) {
        GetMaterializedViewRequest request = GetMaterializedViewRequest.newBuilder().setName(name).build();
        return this.getMaterializedView(request);
    }

    public final MaterializedView getMaterializedView(GetMaterializedViewRequest request) {
        return (MaterializedView)this.getMaterializedViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetMaterializedViewRequest, MaterializedView> getMaterializedViewCallable() {
        return this.stub.getMaterializedViewCallable();
    }

    public final ListMaterializedViewsPagedResponse listMaterializedViews(InstanceName parent) {
        ListMaterializedViewsRequest request = ListMaterializedViewsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMaterializedViews(request);
    }

    public final ListMaterializedViewsPagedResponse listMaterializedViews(String parent) {
        ListMaterializedViewsRequest request = ListMaterializedViewsRequest.newBuilder().setParent(parent).build();
        return this.listMaterializedViews(request);
    }

    public final ListMaterializedViewsPagedResponse listMaterializedViews(ListMaterializedViewsRequest request) {
        return (ListMaterializedViewsPagedResponse)((Object)this.listMaterializedViewsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMaterializedViewsRequest, ListMaterializedViewsPagedResponse> listMaterializedViewsPagedCallable() {
        return this.stub.listMaterializedViewsPagedCallable();
    }

    public final UnaryCallable<ListMaterializedViewsRequest, ListMaterializedViewsResponse> listMaterializedViewsCallable() {
        return this.stub.listMaterializedViewsCallable();
    }

    public final OperationFuture<MaterializedView, UpdateMaterializedViewMetadata> updateMaterializedViewAsync(MaterializedView materializedView, FieldMask updateMask) {
        UpdateMaterializedViewRequest request = UpdateMaterializedViewRequest.newBuilder().setMaterializedView(materializedView).setUpdateMask(updateMask).build();
        return this.updateMaterializedViewAsync(request);
    }

    public final OperationFuture<MaterializedView, UpdateMaterializedViewMetadata> updateMaterializedViewAsync(UpdateMaterializedViewRequest request) {
        return this.updateMaterializedViewOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateMaterializedViewRequest, MaterializedView, UpdateMaterializedViewMetadata> updateMaterializedViewOperationCallable() {
        return this.stub.updateMaterializedViewOperationCallable();
    }

    public final UnaryCallable<UpdateMaterializedViewRequest, Operation> updateMaterializedViewCallable() {
        return this.stub.updateMaterializedViewCallable();
    }

    public final void deleteMaterializedView(MaterializedViewName name) {
        DeleteMaterializedViewRequest request = DeleteMaterializedViewRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteMaterializedView(request);
    }

    public final void deleteMaterializedView(String name) {
        DeleteMaterializedViewRequest request = DeleteMaterializedViewRequest.newBuilder().setName(name).build();
        this.deleteMaterializedView(request);
    }

    public final void deleteMaterializedView(DeleteMaterializedViewRequest request) {
        this.deleteMaterializedViewCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteMaterializedViewRequest, Empty> deleteMaterializedViewCallable() {
        return this.stub.deleteMaterializedViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAppProfilesPagedResponse
    extends AbstractPagedListResponse<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile, ListAppProfilesPage, ListAppProfilesFixedSizeCollection> {
        public static ApiFuture<ListAppProfilesPagedResponse> createAsync(PageContext<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile> context, ApiFuture<ListAppProfilesResponse> futureResponse) {
            ApiFuture<ListAppProfilesPage> futurePage = ListAppProfilesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAppProfilesPagedResponse((ListAppProfilesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAppProfilesPagedResponse(ListAppProfilesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAppProfilesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHotTabletsPagedResponse
    extends AbstractPagedListResponse<ListHotTabletsRequest, ListHotTabletsResponse, HotTablet, ListHotTabletsPage, ListHotTabletsFixedSizeCollection> {
        public static ApiFuture<ListHotTabletsPagedResponse> createAsync(PageContext<ListHotTabletsRequest, ListHotTabletsResponse, HotTablet> context, ApiFuture<ListHotTabletsResponse> futureResponse) {
            ApiFuture<ListHotTabletsPage> futurePage = ListHotTabletsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHotTabletsPagedResponse((ListHotTabletsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHotTabletsPagedResponse(ListHotTabletsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHotTabletsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListLogicalViewsPagedResponse
    extends AbstractPagedListResponse<ListLogicalViewsRequest, ListLogicalViewsResponse, LogicalView, ListLogicalViewsPage, ListLogicalViewsFixedSizeCollection> {
        public static ApiFuture<ListLogicalViewsPagedResponse> createAsync(PageContext<ListLogicalViewsRequest, ListLogicalViewsResponse, LogicalView> context, ApiFuture<ListLogicalViewsResponse> futureResponse) {
            ApiFuture<ListLogicalViewsPage> futurePage = ListLogicalViewsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLogicalViewsPagedResponse((ListLogicalViewsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLogicalViewsPagedResponse(ListLogicalViewsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLogicalViewsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMaterializedViewsPagedResponse
    extends AbstractPagedListResponse<ListMaterializedViewsRequest, ListMaterializedViewsResponse, MaterializedView, ListMaterializedViewsPage, ListMaterializedViewsFixedSizeCollection> {
        public static ApiFuture<ListMaterializedViewsPagedResponse> createAsync(PageContext<ListMaterializedViewsRequest, ListMaterializedViewsResponse, MaterializedView> context, ApiFuture<ListMaterializedViewsResponse> futureResponse) {
            ApiFuture<ListMaterializedViewsPage> futurePage = ListMaterializedViewsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMaterializedViewsPagedResponse((ListMaterializedViewsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMaterializedViewsPagedResponse(ListMaterializedViewsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMaterializedViewsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMaterializedViewsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMaterializedViewsRequest, ListMaterializedViewsResponse, MaterializedView, ListMaterializedViewsPage, ListMaterializedViewsFixedSizeCollection> {
        private ListMaterializedViewsFixedSizeCollection(List<ListMaterializedViewsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMaterializedViewsFixedSizeCollection createEmptyCollection() {
            return new ListMaterializedViewsFixedSizeCollection(null, 0);
        }

        protected ListMaterializedViewsFixedSizeCollection createCollection(List<ListMaterializedViewsPage> pages, int collectionSize) {
            return new ListMaterializedViewsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMaterializedViewsPage
    extends AbstractPage<ListMaterializedViewsRequest, ListMaterializedViewsResponse, MaterializedView, ListMaterializedViewsPage> {
        private ListMaterializedViewsPage(PageContext<ListMaterializedViewsRequest, ListMaterializedViewsResponse, MaterializedView> context, ListMaterializedViewsResponse response) {
            super(context, (Object)response);
        }

        private static ListMaterializedViewsPage createEmptyPage() {
            return new ListMaterializedViewsPage(null, null);
        }

        protected ListMaterializedViewsPage createPage(PageContext<ListMaterializedViewsRequest, ListMaterializedViewsResponse, MaterializedView> context, ListMaterializedViewsResponse response) {
            return new ListMaterializedViewsPage(context, response);
        }

        public ApiFuture<ListMaterializedViewsPage> createPageAsync(PageContext<ListMaterializedViewsRequest, ListMaterializedViewsResponse, MaterializedView> context, ApiFuture<ListMaterializedViewsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLogicalViewsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLogicalViewsRequest, ListLogicalViewsResponse, LogicalView, ListLogicalViewsPage, ListLogicalViewsFixedSizeCollection> {
        private ListLogicalViewsFixedSizeCollection(List<ListLogicalViewsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLogicalViewsFixedSizeCollection createEmptyCollection() {
            return new ListLogicalViewsFixedSizeCollection(null, 0);
        }

        protected ListLogicalViewsFixedSizeCollection createCollection(List<ListLogicalViewsPage> pages, int collectionSize) {
            return new ListLogicalViewsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLogicalViewsPage
    extends AbstractPage<ListLogicalViewsRequest, ListLogicalViewsResponse, LogicalView, ListLogicalViewsPage> {
        private ListLogicalViewsPage(PageContext<ListLogicalViewsRequest, ListLogicalViewsResponse, LogicalView> context, ListLogicalViewsResponse response) {
            super(context, (Object)response);
        }

        private static ListLogicalViewsPage createEmptyPage() {
            return new ListLogicalViewsPage(null, null);
        }

        protected ListLogicalViewsPage createPage(PageContext<ListLogicalViewsRequest, ListLogicalViewsResponse, LogicalView> context, ListLogicalViewsResponse response) {
            return new ListLogicalViewsPage(context, response);
        }

        public ApiFuture<ListLogicalViewsPage> createPageAsync(PageContext<ListLogicalViewsRequest, ListLogicalViewsResponse, LogicalView> context, ApiFuture<ListLogicalViewsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHotTabletsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHotTabletsRequest, ListHotTabletsResponse, HotTablet, ListHotTabletsPage, ListHotTabletsFixedSizeCollection> {
        private ListHotTabletsFixedSizeCollection(List<ListHotTabletsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHotTabletsFixedSizeCollection createEmptyCollection() {
            return new ListHotTabletsFixedSizeCollection(null, 0);
        }

        protected ListHotTabletsFixedSizeCollection createCollection(List<ListHotTabletsPage> pages, int collectionSize) {
            return new ListHotTabletsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHotTabletsPage
    extends AbstractPage<ListHotTabletsRequest, ListHotTabletsResponse, HotTablet, ListHotTabletsPage> {
        private ListHotTabletsPage(PageContext<ListHotTabletsRequest, ListHotTabletsResponse, HotTablet> context, ListHotTabletsResponse response) {
            super(context, (Object)response);
        }

        private static ListHotTabletsPage createEmptyPage() {
            return new ListHotTabletsPage(null, null);
        }

        protected ListHotTabletsPage createPage(PageContext<ListHotTabletsRequest, ListHotTabletsResponse, HotTablet> context, ListHotTabletsResponse response) {
            return new ListHotTabletsPage(context, response);
        }

        public ApiFuture<ListHotTabletsPage> createPageAsync(PageContext<ListHotTabletsRequest, ListHotTabletsResponse, HotTablet> context, ApiFuture<ListHotTabletsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAppProfilesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile, ListAppProfilesPage, ListAppProfilesFixedSizeCollection> {
        private ListAppProfilesFixedSizeCollection(List<ListAppProfilesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAppProfilesFixedSizeCollection createEmptyCollection() {
            return new ListAppProfilesFixedSizeCollection(null, 0);
        }

        protected ListAppProfilesFixedSizeCollection createCollection(List<ListAppProfilesPage> pages, int collectionSize) {
            return new ListAppProfilesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAppProfilesPage
    extends AbstractPage<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile, ListAppProfilesPage> {
        private ListAppProfilesPage(PageContext<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile> context, ListAppProfilesResponse response) {
            super(context, (Object)response);
        }

        private static ListAppProfilesPage createEmptyPage() {
            return new ListAppProfilesPage(null, null);
        }

        protected ListAppProfilesPage createPage(PageContext<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile> context, ListAppProfilesResponse response) {
            return new ListAppProfilesPage(context, response);
        }

        public ApiFuture<ListAppProfilesPage> createPageAsync(PageContext<ListAppProfilesRequest, ListAppProfilesResponse, AppProfile> context, ApiFuture<ListAppProfilesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }
}

