/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.UpdateLogicalViewRequest;
import com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.cloud.bigtable.admin.v2.models.LogicalView;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.FieldMask;
import com.google.protobuf.util.FieldMaskUtil;
import javax.annotation.Nonnull;

public final class UpdateLogicalViewRequest {
    private final UpdateLogicalViewRequest.Builder requestBuilder;
    private final String instanceId;
    private final String logicalViewId;

    public static UpdateLogicalViewRequest of(@Nonnull LogicalView logicalView) {
        return new UpdateLogicalViewRequest(logicalView.getId(), logicalView.getInstanceId(), com.google.bigtable.admin.v2.UpdateLogicalViewRequest.newBuilder().setLogicalView(logicalView.toProto()));
    }

    public static UpdateLogicalViewRequest of(@Nonnull String instanceId, @Nonnull String logicalViewId) {
        return new UpdateLogicalViewRequest(logicalViewId, instanceId, com.google.bigtable.admin.v2.UpdateLogicalViewRequest.newBuilder());
    }

    private UpdateLogicalViewRequest(@Nonnull String logicalViewId, @Nonnull String instanceId, @Nonnull UpdateLogicalViewRequest.Builder requestBuilder) {
        Preconditions.checkNotNull((Object)instanceId, (Object)"instanceId must be set");
        Preconditions.checkNotNull((Object)logicalViewId, (Object)"logicalViewId must be set");
        Preconditions.checkNotNull((Object)requestBuilder, (Object)"proto builder must be set");
        this.instanceId = instanceId;
        this.logicalViewId = logicalViewId;
        this.requestBuilder = requestBuilder;
    }

    public UpdateLogicalViewRequest setQuery(String query) {
        this.requestBuilder.getLogicalViewBuilder().setQuery(query);
        this.updateFieldMask(2);
        return this;
    }

    public UpdateLogicalViewRequest setDeletionProtection(boolean deletionProtection) {
        this.requestBuilder.getLogicalViewBuilder().setDeletionProtection(deletionProtection);
        this.updateFieldMask(6);
        return this;
    }

    private void updateFieldMask(int fieldNumber) {
        FieldMask newMask = FieldMaskUtil.fromFieldNumbers(com.google.bigtable.admin.v2.LogicalView.class, (int[])new int[]{fieldNumber});
        this.requestBuilder.setUpdateMask(FieldMaskUtil.union((FieldMask)this.requestBuilder.getUpdateMask(), (FieldMask)newMask, (FieldMask[])new FieldMask[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateLogicalViewRequest that = (UpdateLogicalViewRequest)o;
        return Objects.equal((Object)this.requestBuilder.build(), (Object)that.requestBuilder.build()) && Objects.equal((Object)this.logicalViewId, (Object)that.logicalViewId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestBuilder.build(), this.logicalViewId});
    }

    @InternalApi
    public com.google.bigtable.admin.v2.UpdateLogicalViewRequest toProto(@Nonnull String projectId) {
        this.requestBuilder.getLogicalViewBuilder().setName(NameUtil.formatLogicalViewName(projectId, this.instanceId, this.logicalViewId));
        return this.requestBuilder.build();
    }
}

